/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.APSServerHandler;
import com.crystaldecisions.enterprise.ocaframework.FrameworkPropertyBag;
import com.crystaldecisions.enterprise.ocaframework.IDirectory;
import com.crystaldecisions.enterprise.ocaframework.IPropertyBag;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.PropertyIDs;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class RawSocketDirectory
implements IDirectory {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.RawSocketDirectory");

    /*
     * Loose catch block
     */
    public IPropertyBag[] find(ServerSpec spec, String uri, String propIDs, int mode) throws OCAFrameworkException {
        String iorString;
        block38: {
            String svr = spec.getAPS();
            String targetSearchName = spec.getName();
            String kind = spec.getKind();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("find(): svr=" + svr + ",target=" + targetSearchName + ",kind=" + kind + ",uri=" + uri));
            }
            iorString = null;
            String hostName = svr;
            int portNumber = 6400;
            int index = APSServerHandler.findPortIndex(svr);
            if (index != -1) {
                hostName = svr.substring(0, index);
                try {
                    portNumber = Integer.parseInt(svr.substring(index + 1));
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)("find(): svr=" + svr), (Throwable)e);
                    throw new OCAFrameworkException.InvalidCMSPort(svr, e);
                }
            }
            Socket iorSocket = null;
            try {
                InetAddress[] allAddresses = InetAddress.getAllByName(hostName);
                int nLoopbacks = 0;
                for (int i = 0; i < allAddresses.length; ++i) {
                    InetAddress inetAddress = allAddresses[i];
                    if (!inetAddress.isLoopbackAddress()) continue;
                    ++nLoopbacks;
                }
                InetAddress[] selectedAddresses = allAddresses;
                if (nLoopbacks > 0 && nLoopbacks < allAddresses.length) {
                    selectedAddresses = new InetAddress[allAddresses.length - nLoopbacks];
                    int j = 0;
                    for (int i = 0; i < allAddresses.length; ++i) {
                        InetAddress inetAddress = allAddresses[i];
                        if (inetAddress.isLoopbackAddress()) continue;
                        selectedAddresses[j] = allAddresses[i];
                        ++j;
                    }
                }
                for (int i = 0; i < selectedAddresses.length; ++i) {
                    InetAddress address = selectedAddresses[i];
                    try {
                        iorSocket = new Socket(address, portNumber);
                        break;
                    }
                    catch (ConnectException e) {
                        if (i != selectedAddresses.length - 1) continue;
                        throw e;
                    }
                }
            }
            catch (UnknownHostException e) {
                LOG.warn((Object)("find(): hostName=" + hostName + ",svr=" + svr + ",port=" + portNumber), (Throwable)e);
                int pos = hostName.indexOf(46);
                if (pos == -1) {
                    throw new OCAFrameworkException.NotFoundInDirectory(svr, e);
                }
                hostName = hostName.substring(0, pos);
                try {
                    iorSocket = new Socket(hostName, portNumber);
                }
                catch (UnknownHostException ex) {
                    LOG.warn((Object)("find(): hostName=" + hostName + ",svr=" + svr + ",port=" + portNumber), (Throwable)ex);
                    throw new OCAFrameworkException.NotFoundInDirectory(svr, ex);
                }
                catch (IOException ex) {
                    LOG.warn((Object)("find(): hostName=" + hostName + ",svr=" + svr + ",port=" + portNumber), (Throwable)ex);
                    throw new OCAFrameworkException.NotFoundInDirectory(svr, ex);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("find(): hostName=" + hostName + ",svr=" + svr + ",port=" + portNumber), (Throwable)e);
                throw new OCAFrameworkException.NotFoundInDirectory(svr, e);
            }
            DataOutputStream out = null;
            DataInputStream in = null;
            try {
                iorSocket.setSoTimeout(10000);
                out = new DataOutputStream(iorSocket.getOutputStream());
                in = new DataInputStream(iorSocket.getInputStream());
            }
            catch (IOException e) {
                LOG.warn((Object)("find(): hostName=" + hostName + ",svr=" + svr + ",port=" + portNumber), (Throwable)e);
                try {
                    iorSocket.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                throw new OCAFrameworkException.NotFoundInDirectory(svr, e);
            }
            out.write(kind.getBytes());
            out.flush();
            int inLen = in.readInt();
            if (inLen > 5120) {
                LOG.warn((Object)("find(): hostName=" + hostName + ",svr=" + svr + ",port=" + portNumber));
                throw new OCAFrameworkException.NotFoundInDirectory(svr, null);
            }
            byte[] inBytes = new byte[inLen];
            in.readFully(inBytes, 0, inLen);
            iorString = new String(inBytes);
            LOG.assertTrue(iorString.startsWith("IOR"), "find(): iorString should start with \"IOR\"");
            inBytes = null;
            inLen = in.readInt();
            inBytes = new byte[inLen];
            in.readFully(inBytes, 0, inLen);
            inBytes = null;
            Object var20_36 = null;
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                iorSocket.close();
            }
            catch (IOException e) {}
            break block38;
            {
                catch (IOException ioe) {
                    throw new OCAFrameworkException.CMSSocket(svr, ioe);
                }
            }
            catch (Throwable throwable) {
                Object var20_37 = null;
                try {
                    in.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    iorSocket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        IPropertyBag[] props = new IPropertyBag[]{new FrameworkPropertyBag()};
        ((FrameworkPropertyBag)props[0]).setProperty(PropertyIDs.SI_SERVER_IOR, iorString);
        return props;
    }
}

