/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.FrameworkPropertyBag;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgr;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Packer;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class SerializableServiceMgr
implements Externalizable {
    private Set m_servers;

    public SerializableServiceMgr() {
        this.m_servers = new HashSet();
    }

    SerializableServiceMgr(Set servers) {
        this.m_servers = servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        ArrayList<String> packed;
        ServiceMgr mgr = (ServiceMgr)ServiceMgrFactory.getServiceMgr();
        mgr.lock();
        try {
            packed = new ArrayList<String>(this.m_servers.size());
            Iterator iter = this.m_servers.iterator();
            while (iter.hasNext()) {
                PropertyBag bag = (PropertyBag)iter.next();
                WireOb3Packer packer = new WireOb3Packer();
                packed.add(packer.pack(bag, 0, 0, false));
            }
        }
        finally {
            mgr.releaseLock();
        }
        out.writeObject(packed.toArray());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object[] packed = (Object[])in.readObject();
        for (int i = 0; i < packed.length; ++i) {
            Object o = packed[i];
            WireOb3Unpacker unpacker = new WireOb3Unpacker();
            unpacker.initialize(o);
            FrameworkPropertyBag bag = new FrameworkPropertyBag();
            bag.unpack(unpacker);
            this.m_servers.add(bag);
        }
    }

    public Object readResolve() throws ObjectStreamException {
        ServiceMgr mgr = (ServiceMgr)ServiceMgrFactory.getServiceMgr();
        mgr.merge(this.m_servers);
        return mgr;
    }
}

