/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.crystaldecisions.celib.misc.ObjectUtils;
import com.crystaldecisions.celib.parser.Operator;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.FrameworkPropertyBag;
import java.util.Locale;

public class ServerSpec
implements Cloneable {
    public static final String UNSPECIFIED = "";
    public static final int DEFAULT_PORT = 6400;
    public static final int GROUP_UNSPECIFIED = 0;
    public static final int GROUP_PREFERRED = 1;
    public static final int GROUP_FORCED = 2;
    private String m_name;
    private String m_kind;
    private String m_aps;
    private String m_cluster;
    private String m_criteria;
    private Operator m_op;
    private int m_group;
    private int m_groupMode;
    private final boolean m_replaceable;
    private final boolean m_preferred;
    private PropertyBag m_additionalConfig = null;
    private String m_cookie = "";
    private String m_serviceName = "";

    public ServerSpec(String svr, String kind, String aps) {
        this.m_name = svr;
        this.m_kind = kind;
        this.m_aps = aps;
        this.m_cluster = UNSPECIFIED;
        this.m_groupMode = 0;
        this.m_replaceable = true;
        this.m_preferred = "aps".equals(kind);
        this.m_cookie = UNSPECIFIED;
    }

    public ServerSpec(String svr, String kind, String aps, String cluster) {
        this.m_name = svr;
        this.m_kind = kind;
        this.m_aps = aps;
        this.m_cluster = cluster;
        this.m_groupMode = 0;
        this.m_replaceable = true;
        this.m_preferred = "aps".equals(kind);
        this.m_cookie = UNSPECIFIED;
    }

    public ServerSpec(String svr, String kind, String aps, boolean replaceable) {
        this.m_name = svr;
        this.m_kind = kind;
        this.m_aps = aps;
        this.m_cluster = UNSPECIFIED;
        this.m_groupMode = 0;
        this.m_replaceable = replaceable;
        this.m_preferred = "aps".equals(kind);
        this.m_cookie = UNSPECIFIED;
    }

    public ServerSpec(String svr, String kind, String aps, boolean replaceable, boolean preferred) {
        this.m_name = svr;
        this.m_kind = kind;
        this.m_aps = aps;
        this.m_cluster = UNSPECIFIED;
        this.m_groupMode = 0;
        this.m_replaceable = replaceable;
        this.m_preferred = preferred;
        this.m_cookie = UNSPECIFIED;
    }

    public ServerSpec(String svr, String kind, String aps, String cluster, boolean replaceable) {
        this.m_name = svr;
        this.m_kind = kind;
        this.m_aps = aps;
        this.m_cluster = cluster;
        this.m_groupMode = 0;
        this.m_replaceable = replaceable;
        this.m_preferred = "aps".equals(kind);
        this.m_cookie = UNSPECIFIED;
    }

    public ServerSpec(String svr, String kind, String aps, String cluster, String criteria, boolean replaceable) {
        this.m_name = svr;
        this.m_kind = kind;
        this.m_aps = aps;
        this.m_cluster = cluster;
        this.m_criteria = criteria;
        this.m_groupMode = 0;
        this.m_replaceable = replaceable;
        this.m_preferred = "aps".equals(kind);
        this.m_cookie = UNSPECIFIED;
    }

    public ServerSpec(String svr, String kind, String aps, String cluster, String criteria, boolean replaceable, boolean preferred) {
        this.m_name = svr;
        this.m_kind = kind;
        this.m_aps = aps;
        this.m_cluster = cluster;
        this.m_criteria = criteria;
        this.m_groupMode = 0;
        this.m_replaceable = replaceable;
        this.m_preferred = preferred;
        this.m_cookie = UNSPECIFIED;
    }

    public ServerSpec(ServerSpec other) {
        this.m_name = other.m_name;
        this.m_kind = other.m_kind;
        this.m_aps = other.m_aps;
        this.m_cluster = other.m_cluster;
        this.m_criteria = other.m_criteria;
        this.m_replaceable = other.m_replaceable;
        this.m_group = other.m_group;
        this.m_groupMode = other.m_groupMode;
        this.m_op = other.m_op;
        this.m_preferred = other.m_preferred;
        this.m_cookie = other.m_cookie;
        this.m_serviceName = other.m_serviceName;
        if (other.m_additionalConfig != null) {
            this.m_additionalConfig = other.m_additionalConfig.copy();
        }
    }

    public PropertyBag getAdditionalConfig() {
        if (this.m_additionalConfig == null) {
            this.m_additionalConfig = new FrameworkPropertyBag();
        }
        return this.m_additionalConfig;
    }

    public String getName() {
        return this.m_name;
    }

    public String getKind() {
        return this.m_kind;
    }

    public String getAPS() {
        return this.m_aps;
    }

    public String getCluster() {
        return this.m_cluster;
    }

    public String getCriteria() {
        return this.m_criteria;
    }

    public void setCriteria(String criteria) {
        this.m_criteria = criteria;
    }

    public Operator getOperator() {
        return this.m_op;
    }

    public void setOperator(Operator op) {
        this.m_op = op;
    }

    public boolean isReplaceable() {
        return this.m_replaceable;
    }

    public int getGroup() {
        return this.m_group;
    }

    public int getGroupMode() {
        return this.m_groupMode;
    }

    public boolean isPreferred() {
        return this.m_preferred;
    }

    public void setName(String svr) {
        this.m_name = svr;
    }

    public void setKind(String kind) {
        this.m_kind = kind;
    }

    public void setAPS(String aps) {
        this.m_aps = aps;
    }

    public void setCluster(String cluster) {
        this.m_cluster = cluster;
    }

    public void setGroup(int group) {
        this.m_group = group;
    }

    public void setGroupMode(int groupMode) {
        this.m_groupMode = groupMode;
    }

    public String getCookie() {
        return this.m_cookie;
    }

    public void setCookie(String cookie) {
        this.m_cookie = cookie;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public void setServiceName(String service) {
        this.m_serviceName = service;
    }

    public String toString() {
        return "aps:" + this.m_aps + " ,cluster:" + this.m_cluster + ", kind:" + this.m_kind + ", name:" + this.m_name + ", queryString:" + this.m_criteria + ", m_replaceable:" + this.m_replaceable + ", m_serviceName:" + this.m_serviceName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServerSpec) {
            ServerSpec serverSpec = (ServerSpec)obj;
            return this.normalize(serverSpec.getAPS()).equals(this.normalize(this.getAPS())) && this.normalize(serverSpec.getCluster()).equals(this.normalize(this.getCluster())) && this.normalize(serverSpec.getName()).equals(this.normalize(this.getName())) && this.normalize(serverSpec.getKind()).equals(this.normalize(this.getKind())) && serverSpec.getGroup() == this.getGroup() && serverSpec.getGroupMode() == this.getGroupMode() && this.normalize(serverSpec.getServiceName()).equals(this.normalize(this.getServiceName())) && ObjectUtils.equals((Object)this.normalize(serverSpec.getCriteria()), (Object)this.normalize(this.getCriteria()));
        }
        return false;
    }

    private String normalize(String original) {
        return original == null ? null : original.toLowerCase(Locale.ENGLISH);
    }

    private int hashCode(String str) {
        return str == null ? 0 : this.normalize(str).hashCode();
    }

    public int hashCode() {
        return this.hashCode(this.getAPS()) + this.hashCode(this.getCluster()) + this.hashCode(this.getName()) + this.hashCode(this.getKind()) + this.getGroup() + this.getGroupMode() + this.hashCode(this.getServiceName()) + this.hashCode(this.getCriteria());
    }
}

