/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.synchronization.IRWLock;
import com.crystaldecisions.celib.synchronization.RWLock;
import com.crystaldecisions.celib.synchronization.SynchronizationException;
import com.crystaldecisions.enterprise.ocaframework.ActiveScanner;
import com.crystaldecisions.enterprise.ocaframework.EnterpriseConfig;
import com.crystaldecisions.enterprise.ocaframework.IDirectory;
import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.enterprise.ocaframework.IPropertyBag;
import com.crystaldecisions.enterprise.ocaframework.IServiceMgr;
import com.crystaldecisions.enterprise.ocaframework.ManagedSessions;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.OCIParameters;
import com.crystaldecisions.enterprise.ocaframework.PropertyIDs;
import com.crystaldecisions.enterprise.ocaframework.SSLConfig;
import com.crystaldecisions.enterprise.ocaframework.SerializableServiceMgr;
import com.crystaldecisions.enterprise.ocaframework.ServerController;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Packer;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactoryEx;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactoryExHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactoryHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactoryPackage.connection_failure;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAa.OCAAdministrator;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAa.OCAAdministratorHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.enterprise.ocaframework.idl.helper.ORBHelper;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Any;
import com.crystaldecisions.thirdparty.org.omg.CORBA.BAD_PARAM;
import com.crystaldecisions.thirdparty.org.omg.CORBA.OBJECT_NOT_EXIST;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORB;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Policy;
import com.crystaldecisions.thirdparty.org.omg.CORBA.PolicyError;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SetOverrideType;
import com.crystaldecisions.thirdparty.org.omg.CORBA.StringHolder;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import com.crystaldecisions.thirdparty.org.omg.CORBA.TRANSIENT;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class ServiceMgr
implements IServiceMgr,
Serializable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.ServiceMgr");
    private ORB m_orb;
    private Map m_serviceMap;
    private Map m_adminServiceMap;
    private ManagedSessions m_managed;
    private IRWLock m_rwlock;
    private Object m_serializable;
    private static final int UNMANAGED_SERVICE_INSANITY_LOOPS = 2;
    private ServerController m_controller;
    private static final long DEFAULT_CLEANUP_INTERVAL = 120000L;
    private OCIParameters m_ociParams;
    public static final String REQUEST_TIME_OUT_KEY = "businessobjects.enterprise.orb.request_timeout";
    private int m_requestTimeout = -1;
    private static final String DEFAULT_CLIENT_TIMEOUT = "600";
    private static final String CLIENT_MODE = "com.businessobjects.enterprise.isclientapp";
    private static boolean s_activateCleanupThread = false;

    ServiceMgr() {
        String bindName;
        String threadModel;
        LOG.debug((Object)"enter: ServiceMgr()");
        Properties props = (Properties)System.getProperties().clone();
        props.put("com.crystaldecisions.thirdparty.org.omg.CORBA.ORBClass", "com.crystaldecisions.thirdparty.com.ooc.CORBA.ORB");
        props.put("com.crystaldecisions.thirdparty.org.omg.CORBA.ORBSingletonClass", "com.crystaldecisions.thirdparty.com.ooc.CORBA.ORBSingleton");
        if (props.getProperty("ooc.iiop.numeric") == null) {
            props.put("ooc.iiop.numeric", "false");
        }
        if ((threadModel = props.getProperty("businessobjects.enterprise.orb.threadmodel")) == null) {
            threadModel = props.getProperty("crystal.enterprise.orb.threadmodel");
        }
        if (threadModel == null || "threaded".equalsIgnoreCase(threadModel)) {
            props.put("ooc.orb.conc_model", "threaded");
            String threadPoolSize = props.getProperty("businessobjects.enterprise.orb.thread_pool_size");
            if (threadPoolSize != null) {
                props.put("ooc.orb.thread_pool", threadPoolSize);
            }
        } else {
            props.put("ooc.orb.conc_model", "blocking");
        }
        String poaThreadModel = props.getProperty("ooc.orb.oa.conc_model");
        if (poaThreadModel == null) {
            props.put("ooc.orb.oa.conc_model", "thread_per_request");
        }
        props.put("ooc.orb.default_wcs", "ISO/IEC 10646-1");
        EnterpriseConfig ec = EnterpriseConfig.getEnterpriseConfig();
        if (ec.isClientMode()) {
            props.put(CLIENT_MODE, "true");
        }
        int requestPort = ec.getRequestPort();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ServiceMgr() requestPort=" + requestPort));
        }
        if (requestPort == 0) {
            int lowerPort = ec.getLowerRequestPort();
            int upperPort = ec.getUpperRequestPort();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ServiceMgr() requestLowerPort=" + lowerPort));
                LOG.debug((Object)("ServiceMgr() requestUpperPort=" + upperPort));
            }
            boolean bFound = false;
            if (lowerPort > 0 && lowerPort <= upperPort) {
                int poaPort;
                for (poaPort = lowerPort; !bFound && poaPort <= upperPort; ++poaPort) {
                    if (this.isPortInUse(poaPort)) {
                        continue;
                    }
                    bFound = true;
                    break;
                }
                if (bFound) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("ServiceMgr() set ooc.iiop.port=" + poaPort));
                    }
                    props.setProperty("ooc.iiop.port", new Integer(poaPort).toString());
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("All ports specified between lowerport" + lowerPort + " and upperport " + upperPort + " are in use"));
                }
            } else if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Specified lower port is 0 or lower port is greater than upper port");
            }
            if (!bFound) {
                if (props.getProperty("businessobjects.enterprise.orb.port") != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("ServiceMgr() set ooc.iiop.port=" + props.getProperty("businessobjects.enterprise.orb.port")));
                    }
                    props.setProperty("ooc.iiop.port", props.getProperty("businessobjects.enterprise.orb.port"));
                } else if (props.getProperty("crystal.enterprise.orb.port") != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("ServiceMgr() set ooc.iiop.port=" + props.getProperty("crystal.enterprise.orb.port")));
                    }
                    props.setProperty("ooc.iiop.port", props.getProperty("crystal.enterprise.orb.port"));
                }
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ServiceMgr() set ooc.iiop.port=" + requestPort));
            }
            props.setProperty("ooc.iiop.port", new Integer(requestPort).toString());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"ServiceMgr() set ooc.iiop.port finished");
        }
        if ((bindName = props.getProperty("businessobjects.enterprise.orb.bind")) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ServiceMgr() set ooc.iiop.bind" + bindName));
            }
            props.setProperty("ooc.iiop.bind", bindName);
            if (props.getProperty("ooc.iiop.host") == null) {
                String hostName = bindName;
                props.setProperty("ooc.iiop.host", bindName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ServiceMgr() ooc.iiop.host=" + hostName));
                }
                props.setProperty("ooc.iiop.host", hostName);
            }
        } else {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"ServiceMgr() bindName is null");
                }
                boolean noNumeric = "false".equals(props.getProperty("ooc.iiop.numeric"));
                String host = InetAddress.getLocalHost().getCanonicalHostName();
                String ip = InetAddress.getLocalHost().getHostAddress();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ServiceMgr() host=" + host + " ip=" + ip));
                    LOG.debug((Object)("ServiceMgr() noNumeric=" + noNumeric));
                }
                if (noNumeric) {
                    if (host.lastIndexOf(46) != -1 && !host.equals(ip)) {
                        props.setProperty("ooc.iiop.host", host);
                    }
                } else {
                    props.setProperty("ooc.iiop.host", ip);
                }
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"ServiceMgr() done setting ooc.iiop.host");
        }
        if (props.getProperty(REQUEST_TIME_OUT_KEY) != null) {
            this.m_requestTimeout = Integer.parseInt(props.getProperty(REQUEST_TIME_OUT_KEY));
        }
        if (props.getProperty("businessobjects.enterprise.orb.client_timeout") != null) {
            props.setProperty("ooc.orb.client_timeout", props.getProperty("businessobjects.enterprise.orb.client_timeout"));
        } else if (props.getProperty("ooc.orb.client_timeout") == null) {
            props.setProperty("ooc.orb.client_timeout", DEFAULT_CLIENT_TIMEOUT);
        }
        if (props.getProperty("businessobjects.enterprise.orb.policy.request_timeout") != null) {
            props.setProperty("ooc.orb.policy.request_timeout", props.getProperty("businessobjects.enterprise.orb.policy.request_timeout"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"ServiceMgr() before orb init");
        }
        String[] args = new String[]{};
        try {
            this.m_ociParams = new OCIParameters(props);
            this.m_orb = ORBHelper.init((String[])args, (Properties)props);
        }
        catch (Exception e) {
            LOG.fatal((Object)"Failed to initiaize ORB, program terminates! This is most likely caused by the class path or class loader problem.", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"ServiceMgr() after orb init");
            LOG.debug((Object)"ServiceMgr() before ssl init");
        }
        if (this.m_ociParams.isSSLClient() || this.m_ociParams.isSSLServer()) {
            try {
                SSLConfig sslConfig = new SSLConfig();
                sslConfig.initializeSSL(this.m_orb, this.m_ociParams, args);
            }
            catch (Exception e) {
                LOG.fatal((Object)"(ServiceMgr:455): failed to initialize SSL", (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
            catch (Error e) {
                LOG.fatal((Object)"(ServiceMgr:458): failed to initialize SSL. Error occured", (Throwable)e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"ServiceMgr() after ssl init");
        }
        this.m_serviceMap = new HashMap();
        this.m_adminServiceMap = new HashMap();
        this.m_managed = new ManagedSessions(this);
        this.m_rwlock = new RWLock();
        this.m_controller = new ServerController(this);
        this.m_serializable = new SerializableServiceMgr(this.m_controller.getAPSCache());
        LOG.debug((Object)"exit: ServiceMgr()");
    }

    void initialize() {
        Properties props = System.getProperties();
        if (!props.getProperty("businessobjects.aggressive_cleanup", "on").equalsIgnoreCase("off")) {
            long timeInterval;
            try {
                timeInterval = Long.parseLong(props.getProperty("businessobjects.aggressive_cleanup_interval", Long.toString(120000L)));
            }
            catch (NumberFormatException e) {
                timeInterval = 120000L;
            }
            try {
                Thread thread = new Thread((Runnable)new ActiveScanner(this, timeInterval), "Business Objects - Sessions Clean up");
                thread.setDaemon(true);
                thread.start();
                s_activateCleanupThread = true;
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
    }

    public void flushServer(ServerSpec spec) {
        this.m_controller.flushServer(spec);
    }

    public IManagedService getManagedService(String id, String svc, ServerSpec spec, String uri, String token, IManagedService.IHelperFactory narrower) throws OCAFrameworkException {
        spec.setServiceName(svc);
        return this.m_managed.get(id, svc, spec, uri, token, narrower);
    }

    public void removeManagedService(String id, String svc, ServerSpec spec, String uri) throws OCAFrameworkException {
        this.m_managed.remove(id, svc, spec, uri);
    }

    public ORB getORB() {
        return this.m_orb;
    }

    public OSCAFactory getOSCAFactory(String uri, ServerSpec spec) throws OCAFrameworkException {
        OSCAFactoryEx factory;
        com.crystaldecisions.thirdparty.org.omg.CORBA.Object obj = this.m_orb.string_to_object(this.getOSCAFactoryIOR(spec, uri));
        try {
            factory = OSCAFactoryExHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)obj);
        }
        catch (BAD_PARAM e) {
            factory = OSCAFactoryHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)obj);
        }
        return factory;
    }

    public String getOSCAFactoryIOR(ServerSpec spec, String uri) throws OCAFrameworkException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getOSCAFactoryIOR(): spec=" + spec + ",uri=" + uri));
        }
        return this.m_controller.getOSCAFactoryIOR(spec, uri);
    }

    public IPropertyBag[] getServerInfo(ServerSpec spec) throws OCAFrameworkException {
        String uri = "osca:iiop://;S2SDSCVRY=true";
        Set svrResults = this.m_controller.getOSCAFactoryIORInfo(spec, uri);
        IPropertyBag[] results = new IPropertyBag[svrResults.size()];
        results = svrResults.toArray(results);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getServiceNames(ServerSpec spec, String uri, boolean adminOnly) throws OCAFrameworkException {
        if (!adminOnly) {
            this.ensureServiceInfo(spec, uri);
        }
        this.ensureAdminServiceInfo(spec, uri);
        this.lock();
        try {
            String[] regular = new String[]{};
            if (!adminOnly) {
                regular = (String[])this.m_serviceMap.get(spec.getName());
                LOG.assertNotNull((Object)regular, "regular is null.");
            }
            String[] admin = (String[])this.m_adminServiceMap.get(spec.getName());
            LOG.assertNotNull((Object)admin, "admin is null.");
            String[] all = new String[regular.length + admin.length];
            System.arraycopy(regular, 0, all, 0, regular.length);
            System.arraycopy(admin, 0, all, regular.length, admin.length);
            String[] stringArray = all;
            return stringArray;
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.crystaldecisions.thirdparty.org.omg.CORBA.Object getUnmanagedService(String svc, ServerSpec spec, String uri) throws OCAFrameworkException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getUnmanagedService(): svc=" + svc + ",spec=" + spec + ",uri=" + uri));
        }
        spec.setServiceName(svc);
        com.crystaldecisions.thirdparty.org.omg.CORBA.Object stub = null;
        OSCAFactory factory = null;
        String session = spec.getKind().equals("aps") ? uri : "";
        try {
            factory = this.getOSCAFactory(uri, spec);
            if (factory != null) {
                if (factory instanceof OSCAFactoryEx) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("getUnmanagedService(): getUnmanagedServiceEx with spec=" + spec + ", svc=" + svc + ", uri=" + uri));
                    }
                    stub = this.getUnmanagedServiceEx(factory, spec, svc, uri);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("getUnmanagedService(): newService with spec=" + spec + ", svc=" + svc + ", uri=" + uri));
                    }
                    stub = factory.newService(svc, uri);
                }
            }
            if (stub == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("getUnmanagedService(): stub is null!, svc=" + svc + ",spec=" + spec + ",uri=" + uri));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"getUnmanagedService(): got valid stub");
            }
            return stub;
        }
        catch (connection_failure e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("getUnmanagedService(): svc=" + svc + ",spec=" + spec + ",uri=" + uri), (Throwable)e);
            }
            this.invalidateServer(spec, uri);
            throw new OCAFrameworkException.ServiceConnection(svc, spec.getName(), spec.getAPS(), uri, (Exception)((Object)e));
        }
        catch (SystemException se) {
            if (!this.isCORBAConnectionFailure(se)) {
                throw se;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("getUnmanagedService(): svc=" + svc + ",spec=" + spec + ",uri=" + uri), (Throwable)se);
            }
            int i = 0;
            while (i < 2) {
                ServerSpec copy = new ServerSpec(spec);
                ++i;
                this.lockModify();
                try {
                    if ("aps".equals(spec.getKind())) {
                        if ("@____BOOTSTRAPCLUSTER".equals(spec.getCluster())) {
                            this.m_controller.bootstrapAPS(copy.getAPS());
                        } else {
                            this.m_controller.buildAPSInfo(copy, uri);
                        }
                    } else {
                        this.invalidateServer(spec, uri);
                        this.validateServer(copy, uri);
                    }
                    factory = this.getOSCAFactory(uri, spec);
                }
                finally {
                    this.releaseLock();
                }
                LOG.assertNotNull((Object)factory, "factory is null.");
                try {
                    stub = null;
                    stub = factory instanceof OSCAFactoryEx ? this.getUnmanagedServiceEx(factory, spec, svc, uri) : factory.newService(svc, uri);
                    return stub;
                }
                catch (connection_failure connection_failure2) {
                    LOG.warn((Object)("getUnmanagedService(): svc=" + svc + ",spec=" + spec + ",uri=" + uri), (Throwable)connection_failure2);
                    this.invalidateServer(spec, uri);
                    throw new OCAFrameworkException.ServiceConnection(svc, spec.getName(), spec.getAPS(), uri, (Exception)((Object)connection_failure2));
                }
                catch (TRANSIENT e) {
                    LOG.warn((Object)("getUnmanagedService(): svc=" + svc + ",spec=" + spec + ",uri=" + uri), (Throwable)e);
                }
            }
            this.invalidateServer(spec, uri);
            throw new OCAFrameworkException.ServiceConnection(svc, spec.getName(), spec.getAPS(), uri, (Exception)((Object)se));
        }
    }

    private boolean isCORBAConnectionFailure(SystemException e) {
        return e instanceof TRANSIENT || e instanceof OBJECT_NOT_EXIST;
    }

    private com.crystaldecisions.thirdparty.org.omg.CORBA.Object getUnmanagedServiceEx(OSCAFactory factory, ServerSpec spec, String svc, String uri) throws connection_failure {
        StringHolder props = new StringHolder();
        OSCAFactoryEx factoryEx = (OSCAFactoryEx)factory;
        WireOb3Packer packer = new WireOb3Packer();
        PropertyBag inBag = new PropertyBag();
        String cookie = spec.getCookie();
        if (cookie != null && cookie.length() != 0) {
            inBag.addItem((Object)PropertyIDs.SI_SERVICE_ID, (Object)cookie, 0);
        }
        String packed = packer.pack(inBag, 0, 0, true);
        com.crystaldecisions.thirdparty.org.omg.CORBA.Object stub = factoryEx.newServiceEx(svc, uri, packed, props);
        WireOb3Unpacker unpacker = new WireOb3Unpacker();
        unpacker.initialize(props.value);
        PropertyBag bag = new PropertyBag();
        bag.unpack((IBagUnpacker)unpacker);
        Property cookieProp = bag.getItem((Object)PropertyIDs.SI_SERVICE_ID);
        if (cookieProp != null) {
            spec.setCookie(cookieProp.getString());
        }
        return stub;
    }

    com.crystaldecisions.thirdparty.org.omg.CORBA.Object setTimeoutPolicy(com.crystaldecisions.thirdparty.org.omg.CORBA.Object object) {
        int timeout = this.m_requestTimeout;
        return this.setTimeoutPolicy(timeout, object);
    }

    com.crystaldecisions.thirdparty.org.omg.CORBA.Object setTimeoutPolicy(int timeout, com.crystaldecisions.thirdparty.org.omg.CORBA.Object object) {
        if (timeout > 0) {
            Any timeoutAny = this.m_orb.create_any();
            timeoutAny.insert_ulong(timeout);
            Policy[] policies = new Policy[1];
            try {
                policies[0] = this.m_orb.create_policy(1330577413, timeoutAny);
                return object._set_policy_override(policies, SetOverrideType.ADD_OVERRIDE);
            }
            catch (PolicyError t) {
                LOG.warn((Object)"(setTimeoutPolicy:716): unlikely to happen", (Throwable)t);
                return object;
            }
        }
        return object;
    }

    public void expireSession(String uri, ServerSpec spec) {
        this.m_managed.expireSession(uri, spec);
    }

    public void logoffSession(String uri, ServerSpec spec) {
        this.m_managed.logoffSession(uri, spec);
    }

    public boolean isSessionExpired(String uri, ServerSpec spec) {
        return this.m_managed.isSessionExpired(uri, spec);
    }

    public void setBootstrapDirectory(IDirectory directory) {
        this.m_controller.setBootstrapDirectory(directory);
    }

    public void setDirectory(IDirectory directory) {
        this.m_controller.setDirectory(directory);
    }

    public String[] getClusterMembers(ServerSpec spec) {
        return this.m_controller.getClusterMembers(spec, false);
    }

    public String[] getActiveClusterMembers(ServerSpec spec) {
        return this.m_controller.getClusterMembers(spec, true);
    }

    public String getSSLCommandLineOptions() {
        return this.m_ociParams.getCommandLineOptions();
    }

    public int getServerCount(ServerSpec spec, boolean validOnly) {
        return this.m_controller.getServerCount(spec, validOnly);
    }

    public Object writeReplace() throws ObjectStreamException {
        return this.m_serializable;
    }

    void merge(Set servers) {
        this.m_controller.merge(servers);
    }

    void invalidateServer(ServerSpec spec, String uri) {
        this.m_controller.invalidateServer(spec, uri);
    }

    void lock() {
        try {
            this.m_rwlock.forReading();
        }
        catch (SynchronizationException e) {
            LOG.error((Object)"lock(): this should never happen", (Throwable)e);
        }
    }

    void lockModify() {
        try {
            this.m_rwlock.forWriting();
        }
        catch (SynchronizationException e) {
            LOG.error((Object)"lockModify(): this should never happen", (Throwable)e);
        }
    }

    Map ping(String aps, String[] sessionIDs) {
        return this.m_controller.ping(aps, sessionIDs);
    }

    void manageCache(boolean bRefreshCluster) {
        this.m_controller.manageCache(bRefreshCluster);
    }

    boolean isServerValid(ServerSpec spec) {
        return this.m_controller.isServerValid(spec);
    }

    void redirectServer(ServerSpec spec, String uri) throws OCAFrameworkException {
        this.m_controller.redirectServer(spec, uri);
    }

    void pulse(boolean bRefreshCluster) {
        this.m_managed.pulse(bRefreshCluster);
    }

    void releaseLock() {
        try {
            this.m_rwlock.release();
        }
        catch (SynchronizationException e) {
            LOG.error((Object)"releaseLock(): this should never happen", (Throwable)e);
        }
    }

    String validateServer(ServerSpec spec, String uri) throws OCAFrameworkException {
        return this.m_controller.validateServer(spec, uri);
    }

    void verifyServerStatus(ServerSpec spec, String uri) throws OCAFrameworkException {
        boolean invalid;
        block5: {
            if (this.m_controller.isServerFailed(spec)) {
                throw new OCAFrameworkException.CommunicationError(spec.getName(), null);
            }
            String ior = this.getOSCAFactoryIOR(spec, uri);
            com.crystaldecisions.thirdparty.org.omg.CORBA.Object val = this.m_orb.string_to_object(ior);
            val = this.setTimeoutPolicy(val);
            invalid = false;
            try {
                invalid = val._non_existent();
            }
            catch (Exception e) {
                if (!LOG.isInfoEnabled()) break block5;
                LOG.info((Object)("(verifyServerStatus:873) server properly down, spec:" + spec), (Throwable)e);
            }
        }
        if (invalid) {
            if (!this.m_controller.isServerFailed(spec)) {
                this.invalidateServer(spec, uri);
            }
            throw new OCAFrameworkException.CommunicationError(spec.getName(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkService(String svc, ServerSpec spec, String uri) throws OCAFrameworkException {
        Object[] services;
        this.ensureServiceInfo(spec, uri);
        this.lock();
        try {
            services = (String[])this.m_serviceMap.get(spec.getName());
        }
        finally {
            this.releaseLock();
        }
        return Arrays.binarySearch(services, svc) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureAdminServiceInfo(ServerSpec spec, String uri) throws OCAFrameworkException {
        Object[] adminServices = null;
        this.lock();
        try {
            adminServices = (String[])this.m_adminServiceMap.get(spec.getName());
        }
        finally {
            this.releaseLock();
        }
        if (adminServices == null) {
            OSCAFactory factory = this.getOSCAFactory(uri, spec);
            if (this.checkService("OCAAdministrator", spec, uri)) {
                this.lockModify();
                try {
                    adminServices = (String[])this.m_adminServiceMap.get(spec.getName());
                    if (adminServices == null) {
                        String serverName;
                        String session = spec.getKind().equals("aps") ? uri : (spec.getKind().equals("") ? ((serverName = spec.getName()).endsWith(".aps") ? uri : "") : "");
                        com.crystaldecisions.thirdparty.org.omg.CORBA.Object obj = factory.newService("OCAAdministrator", session);
                        LOG.assertNotNull((Object)obj, "obj is null.");
                        OCAAdministrator admin = OCAAdministratorHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)obj);
                        LOG.assertNotNull((Object)admin, "admin");
                        adminServices = admin.getServices();
                        int numServices = adminServices.length;
                        for (int i = 0; i < numServices; ++i) {
                            if (!((String)adminServices[i]).equals("APSAdmin")) continue;
                            String[] expansion = new String[numServices + 1];
                            for (int j = 0; j < numServices; ++j) {
                                expansion[j] = adminServices[j];
                            }
                            expansion[numServices] = "CMSAdmin";
                            adminServices = expansion;
                            break;
                        }
                        Arrays.sort(adminServices);
                        this.m_adminServiceMap.put(spec.getName(), adminServices);
                    }
                }
                catch (connection_failure e) {
                    throw new OCAFrameworkException.ServiceConnection("OCAAdministrator", spec.getName(), spec.getAPS(), uri, (Exception)((Object)e));
                }
                catch (oca_abuse e) {
                    throw new OCAFrameworkException.ServerError(spec.getName(), (Exception)((Object)e));
                }
                finally {
                    this.releaseLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureServiceInfo(ServerSpec spec, String uri) throws OCAFrameworkException {
        Object[] services = null;
        this.lock();
        try {
            services = (String[])this.m_serviceMap.get(spec.getName());
        }
        finally {
            this.releaseLock();
        }
        if (services == null) {
            OSCAFactory factory = this.getOSCAFactory(uri, spec);
            this.lockModify();
            try {
                services = (String[])this.m_serviceMap.get(spec.getName());
                if (services == null) {
                    services = factory.getServices();
                    Arrays.sort(services);
                    this.m_serviceMap.put(spec.getName(), services);
                }
            }
            catch (connection_failure e) {
                throw new OCAFrameworkException.ServiceListing(spec.getName(), spec.getAPS(), uri, (Exception)((Object)e));
            }
            finally {
                this.releaseLock();
            }
        }
    }

    void pingServers() {
        this.m_controller.pingServers();
    }

    void getServiceInfo(Map serviceInfoMap) {
        this.m_managed.getServiceInfo(serviceInfoMap);
    }

    private boolean isPortInUse(int port) {
        try {
            ServerSocket ss = new ServerSocket(port);
            ss.close();
            return false;
        }
        catch (Exception e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("port " + port + " in use."));
            }
            return true;
        }
    }

    static boolean isCleanupThreadActivated() {
        return s_activateCleanupThread;
    }
}

