/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.conversion.DateConversion;
import com.crystaldecisions.celib.conversion.IntegerConversion;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.URLDecoder;
import com.crystaldecisions.enterprise.ocaframework.WireOb2;

public class WireOb2Unpacker
implements IBagUnpacker,
WireOb2 {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.WireOb2Unpacker");
    private static final IBagUnpacker.IBagUnpackerFactory s_unpackerFactory = new WireOb2UnpackerFactory();
    private String m_wireob = null;
    private int m_offset;

    public void initialize(Object src) {
        LOG.assertTrue(src instanceof String, "initialize(): src should be string");
        String xrl = (String)src;
        if (xrl.length() != 0) {
            LOG.assertTrue(xrl.startsWith("2:"), "initialize(): invalid xrl," + xrl);
            this.m_wireob = xrl;
            this.m_offset = "2:".length();
        } else {
            this.m_wireob = "";
            this.m_offset = 0;
        }
    }

    public IBagUnpacker.IBagUnpackerFactory getNestedUnpackerFactory() {
        return s_unpackerFactory;
    }

    public boolean hasNext() {
        return this.m_offset < this.m_wireob.length();
    }

    public Object next() {
        String wireOb = this.m_wireob;
        if (this.hasNext()) {
            int amp;
            int flagsDelim;
            int eq = wireOb.indexOf(61, this.m_offset);
            if (eq == -1) {
                LOG.error((Object)("(next:142): must have non-empty value:" + wireOb.substring(this.m_offset)));
            }
            if ((flagsDelim = this.findEndOfValue(eq + 1)) == -1) {
                LOG.error((Object)("(next:148): there should always be 3 parts to the value:" + wireOb.substring(eq + 1)));
            }
            if (flagsDelim == (amp = wireOb.indexOf(38, flagsDelim))) {
                LOG.error((Object)("(next:154): must have \"&\":" + wireOb.substring(flagsDelim)));
            }
            if (amp == -1) {
                amp = wireOb.length();
            }
            String name = wireOb.substring(this.m_offset, eq);
            int typeAndFlags = this.unpackFlags(flagsDelim + 1, amp);
            int type = typeAndFlags & 0x3F;
            int flag = typeAndFlags & 0xFFFFFF00;
            String valueStr = wireOb.substring(eq + 1, flagsDelim);
            Object value = null;
            switch (type) {
                case 2: 
                case 3: {
                    value = IntegerConversion.parseInteger((String)valueStr);
                    if (value != null) break;
                    throw new NumberFormatException(valueStr);
                }
                case 23: {
                    value = Long.valueOf(valueStr);
                    break;
                }
                case 8: {
                    value = IntegerConversion.parseInt((String)valueStr) != 0 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 7: {
                    if ((flag & 0x10000000) != 0) {
                        value = DateConversion.convertVariantDate((double)Double.parseDouble(valueStr), null);
                        break;
                    }
                    value = Double.valueOf(valueStr);
                    break;
                }
                case 18: 
                case 27: {
                    value = URLDecoder.decode((String)valueStr);
                    break;
                }
                case 63: {
                    value = valueStr.substring(1, valueStr.length() - 1);
                }
            }
            Integer id = IDHelper.nameToID((String)name);
            this.m_offset = amp + 1;
            return new IBagUnpacker.Output(id, value, flag);
        }
        return null;
    }

    public void remove() {
    }

    private int findEndOfValue(int offset) {
        int braces = 0;
        String wireOb = this.m_wireob;
        int length = wireOb.length();
        while (offset < length) {
            char ch = wireOb.charAt(offset);
            switch (ch) {
                case '{': {
                    ++braces;
                    break;
                }
                case '}': {
                    --braces;
                    break;
                }
                case ',': {
                    if (braces != 0) break;
                    return offset;
                }
            }
            ++offset;
        }
        LOG.assertTrue(false, "findEndOfValue(): should never reach here");
        return -1;
    }

    private int unpackFlags(int offset, int end) {
        int i;
        String wireOb = this.m_wireob;
        int lsb = this.unpackBits(wireOb.charAt(end - 1));
        int msb = 0;
        for (i = 0; i < end - 1 - offset; ++i) {
            int index = offset + i;
            msb |= this.unpackBits(wireOb.charAt(index));
            msb <<= 6;
        }
        return msb << 2 + 6 * (4 - i) | lsb;
    }

    private int unpackBits(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch == '?') {
            return 10;
        }
        if (ch == '@') {
            return 11;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return ch - 65 + 12;
        }
        if (ch >= 'a' && ch <= 'z') {
            return ch - 97 + 38;
        }
        LOG.assertTrue(false, "unpackBits(): should never reach here");
        return 0;
    }

    private static class WireOb2UnpackerFactory
    implements IBagUnpacker.IBagUnpackerFactory {
        private WireOb2UnpackerFactory() {
        }

        public IBagUnpacker makeUnpacker() {
            return new WireOb2Unpacker();
        }
    }
}

