/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.conversion.DateConversion;
import com.crystaldecisions.celib.conversion.IntegerConversion;
import com.crystaldecisions.celib.conversion.LongConversion;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.SharedCharArray;
import com.crystaldecisions.celib.properties.URLDecoder;
import com.crystaldecisions.enterprise.ocaframework.WireOb2;
import com.crystaldecisions.enterprise.ocaframework.WireOb2Unpacker;
import com.crystaldecisions.enterprise.ocaframework.WireOb3;

public class WireOb3Unpacker
implements IBagUnpacker {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker");
    private IBagUnpacker m_v2Unpacker;
    private static final IBagUnpacker.IBagUnpackerFactory s_unpackerFactory = new WireOb3UnpackerFactory();
    private SharedCharArray m_scarWireOb = null;
    private int m_iOffLength = 0;
    private char[] m_cWireOb = null;
    private int m_offset;
    private static final char upb_lowercasediff = ';';
    private static final char upb_uppercasediff = '5';
    private static final char upb_numberdiff = '0';

    /*
     * Enabled aggressive block sorting
     */
    public void initialize(Object src) {
        SharedCharArray xrl;
        SharedCharArray sharedCharArray = xrl = src instanceof SharedCharArray ? (SharedCharArray)src : new SharedCharArray(src);
        if (xrl != null && xrl.getLocalLength() != 0) {
            if (xrl.startsWith(WireOb3.WIREOB3_PREFIX_CHAR)) {
                this.m_scarWireOb = xrl;
                this.m_offset = xrl.getOffset() + WireOb3.WIREOB3_PREFIX_CHAR.length;
            } else {
                if (!xrl.startsWith(WireOb2.WIREOB2_PREFIX_CHAR)) {
                    LOG.assertTrue(false, "initialize(): invalid xrl," + xrl.toString());
                    throw new AssertionError((Object)("initialize(): invalid xrl," + xrl.toString()));
                }
                this.m_v2Unpacker = new WireOb2Unpacker();
                this.m_v2Unpacker.initialize((Object)xrl.toString());
            }
        } else {
            this.m_scarWireOb = new SharedCharArray(null);
            this.m_offset = 0;
        }
        this.m_iOffLength = this.m_scarWireOb.getOffsetLength();
        this.m_cWireOb = this.m_scarWireOb.getChars();
    }

    public IBagUnpacker.IBagUnpackerFactory getNestedUnpackerFactory() {
        return s_unpackerFactory;
    }

    public boolean hasNext() {
        boolean result;
        if (this.m_v2Unpacker != null) {
            result = this.m_v2Unpacker.hasNext();
        } else {
            boolean bl = result = this.m_offset < this.m_iOffLength;
        }
        if (!result) {
            this.m_scarWireOb = null;
        }
        return result;
    }

    private int indexOf(char find, int from) {
        char[] chWireOb = this.m_cWireOb;
        int length = this.m_iOffLength;
        for (int i = from; i < length; ++i) {
            if (chWireOb[i] != find) continue;
            return i;
        }
        return -1;
    }

    public Object next() {
        if (this.m_v2Unpacker != null) {
            return this.m_v2Unpacker.next();
        }
        char[] cWireOb = this.m_cWireOb;
        if (this.hasNext()) {
            int nameDelim = this.findEndOfName(this.m_offset);
            LOG.assertTrue(nameDelim != -1, "next(): must have non-empty id");
            if (nameDelim == -1) {
                throw new AssertionError((Object)"next(): must have non-empty id");
            }
            int flagsDelim = cWireOb[nameDelim] == ',' ? nameDelim : this.findEndOfValue(nameDelim + 1);
            LOG.assertTrue(flagsDelim != -1, "next(): there should always be 3 parts to the value");
            if (flagsDelim == -1) {
                throw new AssertionError((Object)"next(): there should always be 3 parts to the value");
            }
            int amp = this.indexOf('&', flagsDelim + 1);
            LOG.assertTrue(flagsDelim != amp, "next(): must have \"&\"");
            if (flagsDelim == amp) {
                throw new AssertionError((Object)"next(): must have \"&\"");
            }
            if (amp == -1) {
                amp = this.m_iOffLength;
            }
            int typeAndFlags = this.unpackFlags(flagsDelim + 1, amp);
            int type = typeAndFlags & 0x3F;
            int flag = typeAndFlags & 0xFFFFFF00;
            Object value = null;
            if ((flag & 0x4000000) != 0x4000000) {
                switch (type) {
                    case 2: 
                    case 3: {
                        if (nameDelim != flagsDelim) {
                            value = IntegerConversion.parseInteger((char[])cWireOb, (int)(nameDelim + 1), (int)flagsDelim);
                            if (value != null) break;
                            throw new NumberFormatException(this.m_scarWireOb.substring(nameDelim + 1, flagsDelim));
                        }
                        value = IntegerConversion.getDefaultInteger((int)0);
                        break;
                    }
                    case 23: {
                        if (nameDelim != flagsDelim) {
                            value = LongConversion.parseLong((char[])cWireOb, (int)(nameDelim + 1), (int)flagsDelim, (int)10);
                            if (value != null) break;
                            throw new NumberFormatException(this.m_scarWireOb.substring(nameDelim + 1, flagsDelim));
                        }
                        value = LongConversion.getDefaultLong((long)0L);
                        break;
                    }
                    case 8: {
                        if (nameDelim != flagsDelim) {
                            value = IntegerConversion.parseInt((char[])cWireOb, (int)(nameDelim + 1), (int)flagsDelim) != 0 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        value = Boolean.FALSE;
                        break;
                    }
                    case 7: {
                        if ((flag & 0x10000000) != 0) {
                            value = DateConversion.convertVariantDate((double)Double.parseDouble(this.m_scarWireOb.substring(nameDelim + 1, flagsDelim)), null);
                            break;
                        }
                        value = Double.valueOf(this.m_scarWireOb.substring(nameDelim + 1, flagsDelim));
                        break;
                    }
                    case 6: {
                        value = Float.valueOf(this.m_scarWireOb.substring(nameDelim + 1, flagsDelim));
                        break;
                    }
                    case 18: 
                    case 27: {
                        if (nameDelim != flagsDelim) {
                            value = URLDecoder.decode((char[])cWireOb, (int)(nameDelim + 1), (int)flagsDelim);
                            break;
                        }
                        value = "";
                        break;
                    }
                    case 63: {
                        value = new SharedCharArray(this.m_scarWireOb, nameDelim + 2, flagsDelim - 1);
                    }
                }
            }
            Integer id = this.unpackID(cWireOb, this.m_offset, nameDelim);
            this.m_offset = amp + 1;
            return new IBagUnpacker.Output(id, value, flag, type);
        }
        return null;
    }

    public void remove() {
    }

    private int findEndOfName(int offset) {
        char[] cWireOb = this.m_cWireOb;
        int length = this.m_iOffLength;
        while (offset < length) {
            char ch = cWireOb[offset];
            if (ch == '=' || ch == ',') {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    private int findEndOfValue(int offset) {
        int braces = 0;
        char[] cWireOb = this.m_cWireOb;
        int length = this.m_iOffLength;
        while (offset < length) {
            char ch = cWireOb[offset];
            switch (ch) {
                case '{': {
                    ++braces;
                    break;
                }
                case '}': {
                    --braces;
                    break;
                }
                case ',': {
                    if (braces != 0) break;
                    return offset;
                }
            }
            ++offset;
        }
        LOG.assertTrue(false, "findEndOfValue(): should never reach here");
        throw new AssertionError((Object)"findEndOfValue(): should never reach here");
    }

    private int unpackFlags(int offset, int end) {
        int i;
        char[] sWireOb = this.m_cWireOb;
        int lsb = this.unpackBits(sWireOb[end - 1]);
        int msb = 0;
        for (i = 0; i < end - 1 - offset; ++i) {
            int index = offset + i;
            msb |= this.unpackBits(sWireOb[index]);
            msb <<= 6;
        }
        return msb << 2 + 6 * (4 - i) | lsb;
    }

    private int unpackBits(char ch) {
        if (ch >= 'a') {
            return ch - 59;
        }
        if (ch >= '?') {
            return ch - 53;
        }
        return ch - 48;
    }

    private int decode64(char[] chs, int offset, int end) {
        int id = 0;
        for (int i = offset; i < end; ++i) {
            char ch = chs[i];
            id <<= 6;
            id += this.unpackBits(ch);
        }
        return id;
    }

    private Integer unpackID(char[] cName, int offset, int end) {
        char prefix = cName[offset];
        switch (prefix) {
            case '_': {
                return IDHelper.nameToID((String)new String(cName, 1 + offset, end - (1 + offset)));
            }
            case '.': {
                int wired = this.decode64(cName, 1 + offset, end);
                return new Integer(IDHelper.toIndex((int)wired));
            }
            case '0': {
                int base = this.decode64(cName, 1 + offset, 2 + offset);
                int index = this.decode64(cName, 2 + offset, end);
                return new Integer(IDHelper.toArray((int)base, (int)index));
            }
        }
        int wired = this.decode64(cName, offset, end);
        return new Integer(IDHelper.toRegular((int)wired));
    }

    private static class WireOb3UnpackerFactory
    implements IBagUnpacker.IBagUnpackerFactory {
        private WireOb3UnpackerFactory() {
        }

        public IBagUnpacker makeUnpacker() {
            return new WireOb3Unpacker();
        }
    }
}

