/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.exception;

import com.crystaldecisions.celib.exception.CERuntimeException;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.Locale;

public class SDKRuntimeException
extends CERuntimeException {
    private static final String RESOURCE_ID = "com/crystaldecisions/sdk/exception/SDKRuntimeExceptionResources";
    private String[] m_messages;

    public static void checkPositive(Integer propId, int value) {
        if (value <= 0) {
            throw new UnexpectedValue(propId, value);
        }
    }

    public String[] getParams() {
        return this.m_messages;
    }

    public static void checkRange(Integer propId, double value, double lowerbound, double upperbound) {
        if (value < lowerbound || value > upperbound) {
            throw new OutOfRange(propId, value, lowerbound, upperbound);
        }
    }

    public static void checkRange(Integer propId, int value, int lowerbound, int upperbound) {
        if (value < lowerbound || value > upperbound) {
            throw new OutOfRange(propId, value, lowerbound, upperbound);
        }
    }

    protected SDKRuntimeException(String[] messages, Throwable cause) {
        super(messages, cause);
        this.m_messages = messages;
    }

    public String getDetail() {
        return this.getDetailMessage();
    }

    public String getDetailMessage(Locale locale) {
        String message = super.getDetailMessage(locale);
        return message;
    }

    public static class PublicationDocumentNotFound
    extends SDKRuntimeException {
        public PublicationDocumentNotFound(int documentID) {
            super(new String[]{String.valueOf(documentID)}, null);
        }
    }

    public static class DeprecatedMethodAccessed
    extends SDKRuntimeException {
        public DeprecatedMethodAccessed(String deprecated, String newMethod) {
            super(new String[]{deprecated, newMethod}, null);
        }
    }

    public static class InvalidOperation
    extends SDKRuntimeException {
        public InvalidOperation() {
            super(null, null);
        }
    }

    public static class SetInherited
    extends SDKRuntimeException {
        public SetInherited() {
            super(null, null);
        }
    }

    public static class UndefinedValue
    extends SDKRuntimeException {
        public UndefinedValue(int invalidValue, String interfaceName) {
            super(new String[]{Integer.toString(invalidValue), interfaceName}, null);
        }
    }

    public static class OutOfRange
    extends SDKRuntimeException {
        public OutOfRange(Integer propId, int invalidValue, int lowerBound, int upperBound) {
            super(new String[]{Integer.toString(invalidValue), PropertyIDs.idToName(propId), Integer.toString(lowerBound), Integer.toString(upperBound)}, null);
        }

        public OutOfRange(Integer propId, double invalidValue, double lowerBound, double upperBound) {
            super(new String[]{Double.toString(invalidValue), PropertyIDs.idToName(propId), Double.toString(lowerBound), Double.toString(upperBound)}, null);
        }
    }

    public static class ObjectNotFound
    extends SDKRuntimeException {
        public ObjectNotFound(int id) {
            this(id, null);
        }

        public ObjectNotFound(int id, Throwable e) {
            super(new String[]{Integer.toString(id)}, e);
        }
    }

    public static class ContradictingValues
    extends SDKRuntimeException {
        public ContradictingValues(String prop1, String propValue1, String prop2, String propValue2) {
            super(new String[]{prop1, propValue1, prop2, propValue2}, null);
        }

        public ContradictingValues(Integer propId1, String propValue1, Integer propId2, String propValue2) {
            this(PropertyIDs.idToName(propId1), propValue1, PropertyIDs.idToName(propId2), propValue2);
        }
    }

    public static class UnexpectedValue
    extends SDKRuntimeException {
        public UnexpectedValue(String property2, String value) {
            super(new String[]{property2, value}, null);
        }

        public UnexpectedValue(String property2, int value) {
            super(new String[]{property2, Integer.toString(value)}, null);
        }

        public UnexpectedValue(Integer propID, String value) {
            this(PropertyIDs.idToName(propID), value);
        }

        public UnexpectedValue(Integer propID, int value) {
            this(PropertyIDs.idToName(propID), value);
        }
    }

    public static class UnexpectedCause
    extends SDKRuntimeException {
        public UnexpectedCause(Exception cause) {
            super(new String[]{null}, cause);
        }

        public String getMessage(Locale locale) {
            Throwable e = this.getCause();
            String[] Pars = this.getParams();
            if (e != null) {
                Pars[0] = e instanceof SDKException ? ((SDKException)((Object)e)).getMessage(locale) : e.getMessage();
            }
            return super.getMessage(locale);
        }

        public String getDetailMessage(Locale locale) {
            Throwable e = this.getCause();
            String[] Pars = this.getParams();
            if (e != null) {
                Pars[0] = e instanceof SDKException ? ((SDKException)((Object)e)).getMessage(locale) : e.getMessage();
            }
            return super.getDetailMessage(locale);
        }
    }

    public static class Unexpected
    extends SDKRuntimeException {
        public Unexpected(Exception cause) {
            super(null, cause);
        }

        public Unexpected() {
            super(null, null);
        }
    }

    public static class PropertyNotFound
    extends SDKRuntimeException {
        public PropertyNotFound(String propname) {
            super(new String[]{propname}, null);
        }

        public PropertyNotFound(Integer id) {
            this(PropertyIDs.idToName(id));
        }
    }
}

