/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.exception;

import com.crystaldecisions.sdk.exception.SDKException;

public class URIParserException
extends SDKException {
    static final long serialVersionUID = 4159359357992422717L;

    protected URIParserException(String[] messageParams, Exception cause) {
        super(messageParams, cause);
    }

    protected URIParserException(String locID, String[] messageParams, Exception cause) {
        super("com/businessobjects/dsws/util/uri/exception/URIExceptionResources", locID, messageParams, cause);
    }

    protected URIParserException(String resourceID, String locID, String[] messageParams, Exception cause) {
        super(resourceID, locID, messageParams, cause);
    }

    protected String getResourceID() {
        String resourceID = ((Object)((Object)this)).getClass().getName();
        int delim = (resourceID = resourceID.replace('.', '/')).lastIndexOf(36);
        if (delim != -1) {
            resourceID = resourceID.substring(0, delim);
        }
        return resourceID + "Resources";
    }

    public static class PagingFailed
    extends URIParserException {
        static final long serialVersionUID = 6506924806416041807L;

        public PagingFailed(String description) {
            super(new String[]{description}, null);
        }

        public PagingFailed(Exception e) {
            super(new String[0], e);
        }
    }

    public static class InvalidSQLQuery
    extends URIParserException {
        static final long serialVersionUID = -7476440484170682803L;

        public InvalidSQLQuery(String sql) {
            super(new String[]{sql}, null);
        }
    }

    public static class FoundIDInCuidList
    extends URIParserException {
        static final long serialVersionUID = -7532304143020667957L;

        public FoundIDInCuidList(String uri) {
            super(new String[]{uri}, null);
        }
    }

    public static class FoundCuidInIDList
    extends URIParserException {
        static final long serialVersionUID = 8398869973151167588L;

        public FoundCuidInIDList(String uri) {
            super(new String[]{uri}, null);
        }
    }

    public static class MalformedSearchExpression
    extends URIParserException {
        static final long serialVersionUID = 5296578723818168619L;

        public MalformedSearchExpression(String expression) {
            super(new String[]{expression}, null);
        }
    }

    public static class MalformedQueryExpression
    extends URIParserException {
        static final long serialVersionUID = -8451212289928430406L;

        public MalformedQueryExpression(String uri) {
            super(new String[]{uri}, null);
        }
    }

    public static class MalformedCuidExpression
    extends URIParserException {
        static final long serialVersionUID = 7887256174810353732L;

        public MalformedCuidExpression(String uri) {
            super(new String[]{uri}, null);
        }
    }

    public static class MalformedConditional
    extends URIParserException {
        static final long serialVersionUID = -5260520210742859430L;

        public MalformedConditional(String conditional) {
            super(new String[]{conditional}, null);
        }
    }

    public static class InvalidPathNode
    extends URIParserException {
        static final long serialVersionUID = -132328956785472473L;

        public InvalidPathNode(String node) {
            super(new String[]{node}, null);
        }
    }

    public static class InvalidRootElement
    extends URIParserException {
        static final long serialVersionUID = -603204527016457247L;

        public InvalidRootElement(String root) {
            super(new String[]{root}, null);
        }
    }

    public static class InvalidURI
    extends URIParserException {
        static final long serialVersionUID = 6351554178491946715L;

        public InvalidURI(String uri) {
            super(new String[]{uri}, null);
        }
    }

    public static class InvalidProtocol
    extends URIParserException {
        static final long serialVersionUID = 6482794134324212588L;

        public InvalidProtocol(String uri) {
            super(new String[]{uri}, null);
        }
    }

    public static class CESDKException
    extends URIParserException {
        static final long serialVersionUID = 8334854000572817800L;

        public CESDKException(Exception cause) {
            super(new String[]{cause.getMessage()}, cause);
        }
    }
}

