/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.audit.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.collections.ISimpleCache;
import com.crystaldecisions.celib.collections.SimpleCache;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.audit.IAudit;
import com.crystaldecisions.sdk.occa.audit.IAuditAdmin;
import com.crystaldecisions.sdk.occa.audit.IEventObject;
import com.crystaldecisions.sdk.occa.audit.IEventObjects;
import com.crystaldecisions.sdk.occa.audit.internal.AuditEventHelper;
import com.crystaldecisions.sdk.occa.audit.internal.EventObject;
import com.crystaldecisions.sdk.occa.audit.internal.EventObjects;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStoreFactory;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.transport.internal.AbstractTransportServiceHelper;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportEntity;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportSender;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportService;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportServiceHelper;
import com.crystaldecisions.sdk.occa.transport.internal.TransportServiceFactory;
import com.crystaldecisions.sdk.occa.transport.internal.TransportUtils;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Audit
implements IAudit,
IAuditAdmin {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.audit.internal.Audit");
    private static int BATCH_SIZE = 100;
    private ISecuritySession m_session;
    private ITransportSender m_internalService;
    private String m_appID;
    private static final ITransportServiceHelper.IFactory s_helperFactory = new ITransportServiceHelper.IFactory(){

        public ITransportServiceHelper makeHelper() {
            return new AbstractTransportServiceHelper(this){
                private final /* synthetic */ 1 this$0;
                {
                    this.this$0 = this$0;
                }

                public boolean isRecoverable(String serializedException) {
                    return true;
                }
            };
        }
    };
    private static final ISimpleCache m_appAuditInfoCache = new SimpleCache(new HashMap(), 120000L);
    private static final ISimpleCache.IRefreshHelper m_appAuditInfoCacheRefresher = new ISimpleCache.IRefreshHelper(){

        public boolean isCacheOutdated(Object cached, Object[] args) {
            IInfoObject obj = (IInfoObject)cached;
            String appObjId = (String)args[1];
            try {
                return !obj.getCUID().equals(appObjId);
            }
            catch (SDKException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"Application object's CUID info isn't available", (Throwable)((Object)e));
                }
                return true;
            }
        }

        public Object refresh(Object key, Object[] args) throws SDKException {
            String strQuery;
            ISecuritySession session = (ISecuritySession)args[0];
            String appObjId = (String)args[1];
            IInternalInfoStore is = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA("", session);
            IInfoObjects objs = is.query(strQuery = "SELECT SI_CUID, SI_ENABLED_AUDIT_EVENTS, SI_SUPPORTED_AUDIT_EVENTS, SI_ENABLE_AUDIT FROM CI_APPOBJECTS WHERE SI_CUID = '" + appObjId + "'");
            if (objs.size() <= 0) {
                throw new SDKException.ObjectNotFound(appObjId);
            }
            return (IInfoObject)objs.get(0);
        }
    };

    public Audit(String srv, ISecuritySession session) throws SDKException {
        this.m_session = session;
        ITransportService transportService = (ITransportService)TransportServiceFactory.getFactory().makeOCCA(srv, session);
        if (transportService == null) {
            LOG.debug((Object)("Audit(): Failed to create transportservice.  Server: " + srv));
            throw new SDKException.ServiceNotFound("transportservice", null);
        }
        ServerSpec svrSpec = new ServerSpec("", "", this.m_session.getAPSName(), this.m_session.getClusterName(), true);
        String serviceAddress = TransportUtils.toAddress("bip", svrSpec, "AuditProxyService", null);
        this.m_internalService = transportService.getSender(serviceAddress, s_helperFactory);
        if (this.m_internalService == null) {
            LOG.debug((Object)("Audit(): Failed to get audit service. Service Address: " + serviceAddress));
            throw new SDKException.ServiceNotFound("AuditProxyService", null);
        }
    }

    private IInfoObject getApplicationObject() throws SDKException {
        if (this.m_appID == null || this.m_appID.equals("")) {
            LOG.debug((Object)"Audit(): Application Object CUID has not been set.");
            throw new SDKException.ApplicationObjectCUIDNotSet();
        }
        try {
            return (IInfoObject)m_appAuditInfoCache.get((Object)this.m_session.getClusterName(), new Object[]{this.m_session, this.m_appID}, m_appAuditInfoCacheRefresher);
        }
        catch (ISimpleCache.RefreshException e) {
            LOG.debug((Object)"Audit(): Exception when refreshing application object", (Throwable)e.getReason());
            throw (SDKException)((Object)e.getReason());
        }
    }

    private void sendMessage(String msg) throws SDKException {
        ITransportEntity entity = this.m_internalService.createEntity();
        entity.setBody(msg.getBytes());
        this.m_internalService.request(entity);
    }

    private boolean isValidLicense() throws SDKException {
        IProperties props = this.m_session.getSystemInfoProperties();
        boolean enabled = props.getBoolean(PropertyIDs.SI_ENABLE_AUDIT);
        return enabled;
    }

    private void checkAuditEnabled() throws SDKException {
        if (!this.isAuditServiceEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Audit(): Audit service is not enabled for current application. AppObject CUID= " + this.m_appID));
            }
            throw new SDKException.AuditServiceDisabled();
        }
    }

    private void auditEvents(IEventObjects objs) throws SDKException {
        int numObjs = objs.size();
        int numBatches = numObjs / BATCH_SIZE;
        int lastBatchSize = numObjs % BATCH_SIZE;
        if (lastBatchSize > 0) {
            ++numBatches;
        }
        for (int i = 0; i < numBatches; ++i) {
            int fromIndex = BATCH_SIZE * i;
            int toIndex = fromIndex + (i == numBatches - 1 ? lastBatchSize : BATCH_SIZE);
            List subList = objs.subList(fromIndex, toIndex);
            String msg = AuditEventHelper.toXRL3(subList, this.getApplicationObject().getCUID());
            this.sendMessage(msg);
        }
    }

    public void event(IEventObjects objs) throws SDKException {
        String IDList;
        this.checkAuditEnabled();
        EventObjects enabled = new EventObjects();
        EventObjects disabled = new EventObjects();
        Iterator iter = objs.iterator();
        while (iter.hasNext()) {
            EventObject eventObject = (EventObject)iter.next();
            if (!this.isEventTypeIDSupported(eventObject.getEventTypeID())) {
                LOG.debug((Object)("Audit(): Event Type ID " + eventObject.getEventTypeID() + " is not supported."));
                throw new SDKException.EventTypeNotSupported(eventObject.getEventTypeID(), this.getApplicationObject().getKind());
            }
            if (eventObject.getUserID() <= 0 || eventObject.getObjectID() <= 0 && (eventObject.getObjectCUID() == null || eventObject.getObjectCUID().length() == 0) || eventObject.getDuration() < 0) {
                LOG.debug((Object)("Audit(): EventObject may have invalid values: UserID= " + eventObject.getUserID() + " ObjectID= " + eventObject.getObjectID() + " ObjectCUID= " + eventObject.getObjectCUID() + " Duration= " + eventObject.getDuration()));
                throw new SDKException.InvalidEventValues();
            }
            if (this.isEventTypeIDEnabled(eventObject.getEventTypeID())) {
                enabled.add(eventObject);
                continue;
            }
            disabled.add(eventObject);
        }
        if (enabled.size() > 0) {
            this.auditEvents(enabled);
            if (LOG.isDebugEnabled()) {
                IDList = this.getIDList(enabled);
                LOG.debug((Object)("Audit(): These event types will be audited: " + IDList));
            }
        }
        if (disabled.size() > 0) {
            IDList = this.getIDList(disabled);
            LOG.debug((Object)("Audit(): These event types are disabled: " + IDList));
            throw new SDKException.EventTypeDisabled(IDList);
        }
    }

    private String getIDList(IEventObjects eventObjs) throws SDKException {
        if (eventObjs == null || eventObjs.size() == 0) {
            return "";
        }
        StringBuffer ids = new StringBuffer();
        Iterator iter = eventObjs.iterator();
        while (iter.hasNext()) {
            IEventObject eventObj = (IEventObject)iter.next();
            ids.append(eventObj.getEventTypeID());
            if (!iter.hasNext()) continue;
            ids.append(',');
        }
        return ids.toString();
    }

    public void forceEvent(IEventObjects objs) throws SDKException {
        this.checkAuditEnabled();
        this.auditEvents(objs);
        if (LOG.isDebugEnabled()) {
            String IDList = this.getIDList(objs);
            LOG.debug((Object)("Audit(): These event types will be audited: " + IDList));
        }
    }

    public IEventObjects createEventObjects() {
        return new EventObjects();
    }

    public Set getEnabledEventTypeIDs() throws SDKException {
        IProperties bag = this.getApplicationObject().properties().getProperties(PropertyIDs.SI_ENABLED_AUDIT_EVENTS);
        return AuditEventHelper.getEventIDs(bag);
    }

    public Set getEventTypeIDs() throws SDKException {
        IProperties bag = this.getApplicationObject().properties().getProperties(PropertyIDs.SI_SUPPORTED_AUDIT_EVENTS);
        return AuditEventHelper.getEventIDs(bag);
    }

    public boolean isAuditServiceEnabled() throws SDKException {
        return this.isValidLicense() && this.getApplicationObject().properties().getBoolean(PropertyIDs.SI_ENABLE_AUDIT);
    }

    public boolean isEventTypeIDEnabled(int eventTypeID) throws SDKException {
        Set enabledIDs = this.getEnabledEventTypeIDs();
        return enabledIDs.contains(new Integer(eventTypeID));
    }

    private boolean isEventTypeIDSupported(int eventTypeID) throws SDKException {
        Set supportedIDs = this.getEventTypeIDs();
        return supportedIDs.contains(new Integer(eventTypeID));
    }

    public void setApplicationObjCUID(String cuid) throws SDKException {
        this.m_appID = cuid;
    }
}

