/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.enadmin.internal;

import com.crystaldecisions.celib.conversion.DateConversion;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAa.OCAServiceAdmin;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.enadmin.IServerGeneralMetrics;
import com.crystaldecisions.sdk.occa.enadmin.internal.ServiceAdmin;
import java.util.Date;

public class ServerGeneralMetrics
extends ServiceAdmin
implements IServerGeneralMetrics {
    private static final String ISPROP_GEN_MACHINENAME = "ISPROP_GEN_MACHINENAME";
    private static final String ISPROP_GEN_APSNAME = "ISPROP_GEN_APSNAME";
    private static final String ISPROP_GEN_INFOSERVERNAME = "ISPROP_GEN_INFOSERVERNAME";
    private static final String ISPROP_GEN_FRIENDLYNAME = "ISPROP_GEN_FRIENDLYNAME";
    private static final String ISPROP_GEN_CURTIME = "ISPROP_GEN_CURTIME";
    private static final String ISPROP_GEN_LOCALSERVERNAME = "ISPROP_GEN_LOCALSERVERNAME";
    private static final String ISPROP_GEN_LOCALSERVERDESCRIPTION = "ISPROP_GEN_LOCALSERVERDESCRIPTION";
    private static final String ISPROP_GEN_STARTTIME = "ISPROP_GEN_STARTTIME";
    private static final String ISPROP_GEN_MACH_OSNAME = "ISPROP_GEN_MACH_OSNAME";
    private static final String ISPROP_GEN_MACH_OSTYPE = "ISPROP_GEN_MACH_OSTYPE";
    private static final String ISPROP_GEN_MACH_PROCESSERNAME = "ISPROP_GEN_MACH_PROCESSERNAME";
    private static final String ISPROP_GEN_MACH_CUPQUANTITY = "ISPROP_GEN_MACH_CUPQUANTITY";
    private static final String ISPROP_GEN_MACH_MEMORYSIZE = "ISPROP_GEN_MACH_MEMORYSIZE";
    private static final String ISPROP_GEN_DETAILMACHINEINFO = "ISPROP_GEN_DETAILMACHINEINFO";
    private static final String ISPROP_GEN_DISKSPACE_TOTAL = "ISPROP_GEN_DISKSPACE_TOTAL";
    private static final String ISPROP_GEN_DISKSPACE_USED = "ISPROP_GEN_DISKSPACE_USED";
    private static final String ISPROP_GEN_DISABLED = "ISPROP_GEN_DISABLED";
    private static final String ISPROP_GEN_VERSION = "ISPROP_GEN_VERSION";

    public ServerGeneralMetrics(OCAServiceAdmin admin, PropertyBag metricsBag) {
        super(admin, metricsBag);
    }

    public String getVersion() throws SDKException {
        return super.getMetric(ISPROP_GEN_VERSION).toString();
    }

    public String getOperatingSystem() throws SDKException {
        return super.getMetric(ISPROP_GEN_MACH_OSNAME).toString();
    }

    public String getCPU() throws SDKException {
        return super.getMetric(ISPROP_GEN_MACH_PROCESSERNAME).toString();
    }

    public int getCPUCount() throws SDKException {
        return super.getIntMetric(ISPROP_GEN_MACH_CUPQUANTITY);
    }

    public long getMemory() throws SDKException {
        Double size = new Double(super.getDoubleMetric(ISPROP_GEN_MACH_MEMORYSIZE));
        return size.longValue();
    }

    public double getDiskSpaceTotal() throws SDKException {
        return super.getDoubleMetric(ISPROP_GEN_DISKSPACE_TOTAL);
    }

    public double getDiskSpaceAvailable() throws SDKException {
        double size = super.getDoubleMetric(ISPROP_GEN_DISKSPACE_USED);
        return this.getDiskSpaceTotal() - size;
    }

    public Date getStartTime() throws SDKException {
        Double d = new Double(super.getDoubleMetric(ISPROP_GEN_STARTTIME));
        return DateConversion.convertVariantDate((double)d, null);
    }

    public Date getCurrentTime() throws SDKException {
        Double d = new Double(super.getDoubleMetric(ISPROP_GEN_CURTIME));
        return DateConversion.convertVariantDate((double)d, null);
    }
}

