/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.enadmin.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.common.IConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.IConfigProperty;
import com.businessobjects.sdk.plugin.desktop.common.IConfiguredService;
import com.businessobjects.sdk.plugin.desktop.common.IConfiguredServices;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.internal.Metrics;
import com.businessobjects.sdk.plugin.desktop.service.IService;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.AnyObject;
import com.crystaldecisions.enterprise.ocaframework.WireUnpacker;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAa.OCAServiceAdmin;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.property;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.enadmin.internal.IServiceAdmin;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.plugin.desktop.server.IServer;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Any;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ServiceAdmin
implements IServiceAdmin {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.enadmin.internal.ServiceAdmin");
    private String m_name = "";
    protected OCAServiceAdmin m_ocaServiceAdmin = null;
    private Map m_metrics;
    private IServer m_server = null;
    private PropertyBag m_properties;
    private String[] m_metricNames;
    private String[] m_propNames;
    private IInternalInfoStore m_infoStore = null;

    ServiceAdmin() {
    }

    ServiceAdmin(OCAServiceAdmin admin, PropertyBag metrics) {
        this.m_ocaServiceAdmin = admin;
        LOG.assertNotNull((Object)metrics, "metrics bag is null.");
        if (metrics != null) {
            this.m_name = metrics.getString((Object)PropertyIDs.SI_NAME);
            this.m_metrics = new Metrics(metrics.getPropertyBag((Object)PropertyIDs.SI_METRICS)).getMap();
        }
    }

    public String getName() throws SDKException {
        if (this.m_name != null) {
            return this.m_name;
        }
        if (this.m_ocaServiceAdmin != null) {
            try {
                this.m_name = this.m_ocaServiceAdmin.getName();
                return this.m_name;
            }
            catch (oca_abuse e) {
                LOG.info((Object)"A problem occurred on server while getting name from the service admin", (Throwable)e);
                throw SDKException.map(e);
            }
            catch (SystemException e) {
                LOG.info((Object)"A problem occurred while getting name from the service admin", (Throwable)e);
                throw new SDKException.ServiceAdminError((Exception)((Object)e));
            }
        }
        return "";
    }

    public String[] getMetricNames() throws SDKException {
        if (this.m_metricNames == null) {
            if (this.m_metrics != null) {
                this.m_metricNames = this.m_metrics.keySet().toArray(new String[this.m_metrics.size()]);
            } else if (this.m_ocaServiceAdmin != null) {
                try {
                    this.m_metricNames = this.m_ocaServiceAdmin.getAvailableMetrics();
                }
                catch (oca_abuse e) {
                    LOG.info((Object)"A problem occurred on server while getting available metrics from the service admin", (Throwable)e);
                    throw SDKException.map(e);
                }
                catch (SystemException e) {
                    LOG.info((Object)"A problem occurred while getting available metrics from the service admin", (Throwable)e);
                    throw new SDKException.ServiceAdminError((Exception)((Object)e));
                }
            }
        }
        return this.m_metricNames;
    }

    public Object getMetric(String name) throws SDKException {
        Object obj = null;
        if (this.m_metrics != null) {
            Object val = this.m_metrics.get(name);
            obj = val instanceof IProperty ? ((IProperty)val).getValue() : (Object)val;
        }
        if (obj == null && this.m_ocaServiceAdmin != null) {
            try {
                Any any = this.m_ocaServiceAdmin.getMetric(name);
                AnyObject any2Ob = new AnyObject(any);
                obj = any2Ob.toObject();
            }
            catch (oca_abuse e) {
                LOG.info((Object)("A problem occurred on server while getting metric " + name + " from the service admin"), (Throwable)e);
                throw SDKException.map(e);
            }
            catch (SystemException e) {
                LOG.info((Object)("A problem occurred while getting metric " + name + " from the service admin"), (Throwable)e);
                throw new SDKException.ServiceAdminError((Exception)((Object)e));
            }
        }
        return obj;
    }

    public Object[] getMetrics(String[] names) throws SDKException {
        Object[] objects = null;
        objects = new Object[names.length];
        if (this.m_metrics != null) {
            for (int i = 0; i < names.length; ++i) {
                objects[i] = ((IProperty)this.m_metrics.get(names[i])).getValue();
            }
        } else if (this.m_ocaServiceAdmin != null) {
            try {
                property[] props = this.m_ocaServiceAdmin.getNVMetrics(names);
                objects = new Object[props.length];
                for (int i = 0; i < props.length; ++i) {
                    AnyObject any2Ob = new AnyObject(props[i].value);
                    objects[i] = any2Ob.toObject();
                }
            }
            catch (oca_abuse e) {
                LOG.info((Object)"A problem occurred on server while getting metrics from the service admin", (Throwable)e);
                throw SDKException.map(e);
            }
            catch (SystemException e) {
                LOG.info((Object)"A problem occurred while getting metrics from the service admin", (Throwable)e);
                throw new SDKException.ServiceAdminError((Exception)((Object)e));
            }
        }
        return objects;
    }

    public String[] getServerPropertyNames() throws SDKException {
        if (this.m_propNames == null) {
            this.ensureProperties();
            Set ids = this.m_properties.keySet();
            this.m_propNames = new String[ids.size()];
            int i = 0;
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                Integer id = (Integer)iterator.next();
                this.m_propNames[i] = IDHelper.idToName((Integer)id);
                ++i;
            }
        }
        return this.m_propNames;
    }

    public Object getServerProperty(Integer propID) throws SDKException {
        this.ensureProperties();
        Property prop = this.m_properties.getItem((Object)propID);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    public Object getServerProperty(String name, IConfigProperties configProps) throws SDKException {
        IConfigProperty prop = configProps.getProp(name);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    public Object[] getServerProperties(Integer[] ids) throws SDKException {
        Object[] objects = new Object[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            Integer propid = ids[i];
            objects[i] = this.getServerProperty(propid);
        }
        return objects;
    }

    public void setServerProperty(String name, Object value, IConfigProperties configProps) throws SDKException {
        IConfigProperty prop = configProps.getProp(name);
        if (prop == null) {
            prop = configProps.addProp(name);
        }
        prop.setValue(value);
    }

    public void setSSOServerProperty(String key1, String key2, Object value, IConfigProperties configProps) throws SDKException {
        IConfigProperty prop = configProps.getProp(key1);
        if (prop == null) {
            throw new SDKException.InvalidOperation();
        }
        ConfigProperties cps = (ConfigProperties)prop.getValue();
        IConfigProperty prop2 = cps.getProp(key2);
        prop2.setValue(value);
    }

    public void setServerProperty(Integer propID, Object value) throws SDKException {
        throw new SDKException.InvalidOperation();
    }

    public void setServerProperty(Integer propID, boolean value) throws SDKException {
        throw new SDKException.InvalidOperation();
    }

    public void setServerProperites(Integer[] propIDs, Object[] values) throws SDKException {
        throw new SDKException.InvalidOperation();
    }

    public void commit() throws SDKException {
        LOG.info((Object)("Saving all changes to server with SI_ID = " + this.m_server.getID()));
        this.m_server.save();
    }

    public String[] getServerAdminBlobNames() throws SDKException {
        String[] propNames = null;
        try {
            propNames = this.m_ocaServiceAdmin.getAvailableParamObjs();
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on server while getting available parameter objects from the service admin", (Throwable)e);
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while getting available parameter objects from the service admin", (Throwable)e);
            throw new SDKException.ServiceAdminError((Exception)((Object)e));
        }
        return propNames;
    }

    public void setServerObject(IServer serverObj) {
        this.m_server = serverObj;
    }

    public IServer getServerObject() {
        return this.m_server;
    }

    public void setInfoStore(IInternalInfoStore infoStore) {
        this.m_infoStore = infoStore;
    }

    public IService getServiceObject(String serviceCUID) throws SDKException {
        if (this.m_infoStore != null) {
            IInfoObjects serviceObjs = this.m_infoStore.query("select * from ci_systemobjects where (si_kind='Service' and si_CUID = '" + serviceCUID + "')");
            IService service = (IService)serviceObjs.get(0);
            return service;
        }
        return null;
    }

    public IConfigProperties getConfigProperties(IServer serverObj, String serviceCUID) throws SDKException {
        this.setServerObject(serverObj);
        IConfiguredServices configuredServices = serverObj.getHostedServices();
        Set idSet = configuredServices.getConfiguredServiceIDs();
        Iterator idIter = idSet.iterator();
        while (idIter.hasNext()) {
            Integer id = (Integer)idIter.next();
            IConfiguredService svc = configuredServices.get(id);
            if (!svc.getCUID().equals(serviceCUID)) continue;
            return svc.getConfigProps();
        }
        LOG.error((Object)"A problem occured while trying to obtain the configuration properties for this service");
        throw new SDKException.MissingEdge(serviceCUID, serverObj.getCUID());
    }

    public Object getServerAdminBlob(String name) throws SDKException {
        com.crystaldecisions.thirdparty.org.omg.CORBA.Object ob = null;
        try {
            ob = this.m_ocaServiceAdmin.getParamObj(name);
        }
        catch (oca_abuse e) {
            LOG.info((Object)("A problem occurred on server while getting parameter object " + name + " from the service admin"), (Throwable)e);
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)("A problem occurred while getting parameter object " + name + " from the service admin"), (Throwable)e);
            throw new SDKException.ServiceAdminError((Exception)((Object)e));
        }
        return ob;
    }

    int getIntProp(Integer key) throws SDKException {
        int i = 0;
        Integer o = (Integer)this.getServerProperty(key);
        if (o != null) {
            i = o;
        }
        return i;
    }

    protected int getIntProp(String name, IConfigProperties configProps) throws SDKException {
        int i = 0;
        Integer o = (Integer)this.getServerProperty(name, configProps);
        if (o != null) {
            i = o;
        }
        return i;
    }

    int getIntSSOProp(String key1, String key2, IConfigProperties configProps) throws SDKException {
        ConfigProperties bag;
        IConfigProperty cp;
        Object vo;
        int i = 0;
        Object o = this.getServerProperty(key1, configProps);
        if (o != null && o instanceof ConfigProperties && (vo = (cp = (bag = (ConfigProperties)o).getProp(key2)).getValue()) instanceof Integer) {
            Integer ivo = (Integer)vo;
            i = ivo;
        }
        return i;
    }

    int getIntMetric(String key) throws SDKException {
        Object val = this.getMetric(key);
        if (val != null) {
            return Integer.parseInt(val.toString());
        }
        return 0;
    }

    long getLongProp(Integer key) throws SDKException {
        long l = 0L;
        Long o = (Long)this.getServerProperty(key);
        if (o != null) {
            l = o;
        }
        return l;
    }

    long getLongMetric(String key) throws SDKException {
        Object val = this.getMetric(key);
        if (val != null) {
            return Long.parseLong(val.toString());
        }
        return 0L;
    }

    boolean getBoolProp(Integer key) throws SDKException {
        boolean b = false;
        Object o = this.getServerProperty(key);
        if (o == null) {
            return b;
        }
        if (o instanceof Boolean) {
            b = (Boolean)o;
        } else if (o instanceof String) {
            Boolean bObj = new Boolean((String)o);
            b = bObj;
        }
        return b;
    }

    boolean getBoolProp(String name, IConfigProperties configProps) throws SDKException {
        boolean b = false;
        Object o = this.getServerProperty(name, configProps);
        if (o == null) {
            return b;
        }
        if (o instanceof Boolean) {
            b = (Boolean)o;
        } else if (o instanceof String) {
            Boolean bObj = new Boolean((String)o);
            b = bObj;
        } else if (o instanceof Integer) {
            if ((Integer)o == 1) {
                return true;
            }
            return b;
        }
        return b;
    }

    boolean getBoolMetric(String key) throws SDKException {
        boolean b = false;
        Object o = this.getMetric(key);
        if (o == null) {
            return b;
        }
        if (o instanceof Boolean) {
            b = (Boolean)o;
        } else if (o instanceof String) {
            Boolean bObj = new Boolean((String)o);
            b = bObj;
        }
        return b;
    }

    double getDoubleProp(Integer key) throws SDKException {
        double d = 0.0;
        Double o = (Double)this.getServerProperty(key);
        if (o != null) {
            d = o;
        }
        return d;
    }

    double getDoubleMetric(String key) throws SDKException {
        Object val = this.getMetric(key);
        if (val != null) {
            return Double.parseDouble(val.toString());
        }
        return 0.0;
    }

    private void ensureProperties() throws SDKException {
        if (this.m_properties == null) {
            this.m_properties = new SDKPropertyBag();
            try {
                String[] names = this.m_ocaServiceAdmin.getAvailableParameters();
                if (names.length != 0) {
                    property[] props = this.m_ocaServiceAdmin.getNVParams(names);
                    WireUnpacker unpacker = new WireUnpacker();
                    unpacker.initialize(props);
                    this.m_properties.unpack((IBagUnpacker)unpacker);
                }
            }
            catch (oca_abuse oca_abuse2) {
                LOG.info((Object)"A problem occurred on server while getting parameters from the service admin", (Throwable)oca_abuse2);
                throw SDKException.map(oca_abuse2);
            }
            catch (SystemException e) {
                LOG.info((Object)"A problem occurred while getting parameters from the service admin", (Throwable)e);
                throw new SDKException.ServiceAdminError((Exception)((Object)e));
            }
        }
    }
}

