/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.filerepository.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class BoundFile
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final Object s_machineID;
    private Object m_machineID = s_machineID;
    private final String m_path;
    private transient File m_file;
    private long m_size;

    public BoundFile(String path) {
        this.m_path = path;
        this.m_file = new File(path);
    }

    public String getPath() {
        return this.m_path;
    }

    public long getSize() {
        if (this.m_file == null) {
            return this.m_size;
        }
        return this.m_file.length();
    }

    public File getFile() throws SDKException {
        if (this.m_file == null) {
            throw new SDKException.FileNotFound(this.m_path);
        }
        return this.m_file;
    }

    public boolean isLocal() {
        return this.m_machineID == s_machineID;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.m_file != null) {
            this.m_size = this.m_file.length();
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (s_machineID.equals(this.m_machineID)) {
            this.m_file = new File(this.m_path);
            this.m_machineID = s_machineID;
        }
    }

    static {
        Object machineID = null;
        try {
            InetAddress host = InetAddress.getLocalHost();
            if (!host.isAnyLocalAddress()) {
                machineID = host;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (machineID == null) {
            machineID = "localhost";
        }
        s_machineID = machineID;
    }
}

