/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.filerepository.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAfs.FileStoreOperations;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileTx;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;

class CopyFileTx
implements IFileTx {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.filerepository.internal.CopyFileTx");
    private FileStoreOperations m_store;
    private String m_source;
    private String m_destPath;
    private boolean m_replace;
    private boolean m_notCommitted;

    CopyFileTx(FileStoreOperations store, String srcPath, String destPath, boolean replace) {
        this.m_store = store;
        this.m_source = srcPath;
        this.m_destPath = destPath;
        this.m_notCommitted = true;
        this.m_replace = replace;
    }

    public Object getSource() {
        return this.m_source;
    }

    public Object getDestination() {
        return this.m_destPath;
    }

    public Object commit() throws SDKException {
        if (this.m_notCommitted) {
            try {
                this.m_store.copy(this.m_source, this.m_destPath, this.m_replace);
                this.m_notCommitted = false;
            }
            catch (oca_abuse abuse) {
                LOG.info((Object)"A problem occurred on the server", (Throwable)abuse);
                throw SDKException.map(abuse);
            }
            catch (SystemException e) {
                LOG.info((Object)("Can't copy file from " + this.m_source + " to " + this.m_destPath), (Throwable)e);
                throw new SDKException.FileCopyError(this.m_source, this.m_destPath, (Exception)((Object)e));
            }
        }
        if (this.m_destPath.charAt(this.m_destPath.length() - 1) == '/') {
            int delim = this.m_source.lastIndexOf(47);
            if (delim != -1) {
                String fileName = this.m_source.substring(delim + 1);
                return this.m_destPath + fileName;
            }
            return this.m_destPath + this.m_source;
        }
        return this.m_destPath;
    }

    public void destroy() throws SDKException {
        this.m_notCommitted = false;
    }
}

