/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.filerepository.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.CaseInsensComparator;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.AbstractSmartServerHandler;
import com.crystaldecisions.enterprise.ocaframework.IDirectory;
import com.crystaldecisions.enterprise.ocaframework.IPropertyBag;
import com.crystaldecisions.enterprise.ocaframework.IServerHandler;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.PropertyIDs;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactoryHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactoryPackage.connection_failure;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORB;
import com.crystaldecisions.thirdparty.org.omg.CORBA.TRANSIENT;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FRSHandler
extends AbstractSmartServerHandler
implements IServerHandler {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.filerepository.internal.FRSHandler");
    private static final Integer FRS_TIMESTAMP = PropertyIDs.define("FRS_TIMESTAMP");
    private static final Integer SI_SERVER_DESCRIPTOR = PropertyIDs.define("SI_SERVER_DESCRIPTOR");
    private static final Integer PINGER = PropertyIDs.define("PINGER");
    private static final String s_queryIDsString = IDHelper.toQueryString((Integer[])new Integer[]{PropertyIDs.SI_NAME, PropertyIDs.SI_SERVER_IS_ALIVE, PropertyIDs.SI_SERVER_IOR, SI_SERVER_DESCRIPTOR, PropertyIDs.SI_DISABLED});
    private static final Long ZERO_LONG = new Long(0L);
    private static final Integer FRS_TYPE = PropertyIDs.define("FRS_TYPE");
    private static final Integer INPUT_FRS = new Integer(1);
    private static final Integer OUTPUT_FRS = new Integer(2);
    private static final Integer UNKNOWN_FRS = new Integer(0);

    FRSHandler() {
        super(new Integer[]{APS_NAME, PropertyIDs.SI_CLUSTER_NAME, SERVER_NAME}, new Comparator[]{new CaseInsensComparator(), new CaseInsensComparator(), new CaseInsensComparator()});
        this.m_queryIDsString = s_queryIDsString;
        this.m_queryIDsString = this.m_queryIDsString + ", SI_HOSTED_SERVICES";
    }

    public Set queryServer(ServerSpec spec, boolean validOnly) {
        String name = spec.getName();
        String cluster = spec.getCluster();
        String aps = spec.getAPS();
        HashMap<Integer, String> svrQuery = new HashMap<Integer, String>();
        if (!"".equalsIgnoreCase(name)) {
            svrQuery.put(SERVER_NAME, name);
        }
        svrQuery.put(APS_NAME, aps);
        svrQuery.put(PropertyIDs.SI_CLUSTER_NAME, cluster);
        Set svrResults = this.query(svrQuery);
        if (validOnly) {
            this.filterServers(svrResults, SERVER_VALID, 0, VALID);
        }
        return svrResults;
    }

    public Set queryCluster(ServerSpec spec, boolean validOnly) {
        IPropertyBag bag;
        Set servers;
        String name = spec.getName();
        String type = this.getServerType(name);
        ServerSpec copy = new ServerSpec(spec);
        copy.setName("");
        int desiredFrsType = UNKNOWN_FRS;
        String lcType = type.toLowerCase();
        if (lcType.equals("input")) {
            desiredFrsType = INPUT_FRS;
        } else if (lcType.equals("output")) {
            desiredFrsType = OUTPUT_FRS;
        } else if (desiredFrsType == UNKNOWN_FRS) {
            servers = this.queryServer(copy, false);
            Iterator it = servers.iterator();
            while (it.hasNext()) {
                bag = (IPropertyBag)it.next();
                String testName = bag.getString(PropertyIDs.SI_NAME);
                if (!name.equals(testName)) continue;
                desiredFrsType = bag.getInt(FRS_TYPE);
            }
        }
        servers = this.queryServer(copy, validOnly);
        Iterator iter = servers.iterator();
        while (iter.hasNext()) {
            bag = (IPropertyBag)iter.next();
            int thisFrsType = bag.getInt(FRS_TYPE);
            if (thisFrsType == desiredFrsType) continue;
            iter.remove();
        }
        return servers;
    }

    private String getServerType(String name) {
        int index = name.indexOf(46);
        if (index != -1) {
            return name.substring(0, index);
        }
        return name;
    }

    public IPropertyBag selectServer(Collection svrResults) {
        long min = Long.MAX_VALUE;
        IPropertyBag selectedServer = null;
        Iterator iter = svrResults.iterator();
        while (iter.hasNext()) {
            IPropertyBag server = (IPropertyBag)iter.next();
            if (server.getLong(FRS_TIMESTAMP) >= min) continue;
            selectedServer = server;
            min = server.getLong(FRS_TIMESTAMP);
        }
        return selectedServer;
    }

    public void buildServerInfo(ServerSpec spec, String uri, IDirectory directory) throws OCAFrameworkException {
        IPropertyBag[] found = directory.find(spec, uri, this.m_queryIDsString, 0);
        this.addServerInfo(found, spec.getAPS(), spec.getCluster());
    }

    public void buildClusterInfo(ServerSpec spec, String uri, IDirectory directory) throws OCAFrameworkException {
        ServerSpec copy = new ServerSpec(spec);
        String name = copy.getName();
        String aps = copy.getAPS();
        String cluster = copy.getCluster();
        if (!"".equalsIgnoreCase(name)) {
            copy.setName("");
        }
        IPropertyBag[] found = directory.find(copy, uri, this.m_queryIDsString, 1);
        this.addServerInfo(found, aps, cluster);
    }

    private void addServerInfo(IPropertyBag[] found, String aps, String cluster) throws OCAFrameworkException {
        Long now = new Long(System.currentTimeMillis());
        for (int i = 0; i < found.length; ++i) {
            Long timeStamp;
            IPropertyBag bag = found[i];
            bag.setProperty((Object)APS_NAME, aps);
            bag.setProperty((Object)PropertyIDs.SI_CLUSTER_NAME, cluster);
            bag.setProperty((Object)SERVER_TIMESTAMP, now);
            bag.setProperty((Object)PropertyIDs.SI_SERVER_KIND, "fileserver");
            bag.setProperty((Object)SERVER_NAME, bag.getString(PropertyIDs.SI_NAME));
            if (bag.getInt(PropertyIDs.SI_SERVER_IS_ALIVE) == 1 && !bag.getBoolean(PropertyIDs.SI_DISABLED)) {
                bag.setProperty((Object)SERVER_VALID, this.checkServerAliveness(bag));
            } else {
                bag.setProperty((Object)SERVER_VALID, INVALID);
            }
            ServerSpec serverSpec = new ServerSpec(bag.getString(SERVER_NAME), bag.getString(PropertyIDs.SI_SERVER_KIND), aps, cluster);
            PropertyBag hostedServices = (PropertyBag)bag.getBag(PropertyIDs.SI_HOSTED_SERVICES);
            if (hostedServices != null) {
                PropertyArrayHelper serviceArray = new PropertyArrayHelper(hostedServices, PropertyIDs.SI_TOTAL);
                Iterator iter = serviceArray.iterator();
                while (iter.hasNext()) {
                    PropertyBag serviceBag = (PropertyBag)iter.next();
                    String cuid = serviceBag.getString((Object)SI_CUID);
                    Integer frsType = UNKNOWN_FRS;
                    if (cuid != null && cuid.length() > 0) {
                        if (cuid.equals("AS_dBBbeTzhHsHnTq8C1Zr8")) {
                            frsType = INPUT_FRS;
                        } else if (cuid.equals("Ab398Kjs_91JgsTdTWDUWQc")) {
                            frsType = OUTPUT_FRS;
                        }
                    } else {
                        String serviceName = this.getServiceName(serverSpec, new Integer(serviceBag.getInt((Object)PropertyIDs.SI_ID)));
                        if (serviceName != null) {
                            String lcName = serviceName.toLowerCase();
                            if (lcName.startsWith("input")) {
                                frsType = INPUT_FRS;
                            } else if (lcName.startsWith("output")) {
                                frsType = OUTPUT_FRS;
                            }
                        }
                    }
                    bag.setProperty((Object)FRS_TYPE, frsType);
                }
            }
            String serverDescriptor = bag.getString(SI_SERVER_DESCRIPTOR);
            try {
                String ior = bag.getString(PropertyIDs.SI_SERVER_IOR);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("addServerInfo(): ior=" + ior));
                }
                if (ior == null) continue;
                if (bag.getInt(SERVER_VALID) == VALID.intValue()) {
                    ORB orb = ServiceMgrFactory.getServiceMgr().getORB();
                    OSCAFactory f = OSCAFactoryHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)orb.string_to_object(ior));
                    com.crystaldecisions.thirdparty.org.omg.CORBA.Object pingstub = f.newService("Pinger", "osca:iiop://;BYPASSSEC=true");
                    String pingior = orb.object_to_string(pingstub);
                    bag.setProperty((Object)PINGER, pingior);
                }
            }
            catch (connection_failure connection_failure2) {
                LOG.warn((Object)("addServerInfo(): serverName=" + bag.getString(SERVER_NAME) + ",ior=" + bag.getString(PropertyIDs.SI_SERVER_IOR)), (Throwable)connection_failure2);
            }
            catch (TRANSIENT e) {
                LOG.warn((Object)("addServerInfo(): serverName=" + bag.getString(SERVER_NAME) + ",ior=" + bag.getString(PropertyIDs.SI_SERVER_IOR)), (Throwable)e);
            }
            int delim = serverDescriptor.lastIndexOf(46);
            try {
                timeStamp = Long.valueOf(serverDescriptor.substring(delim + 1));
            }
            catch (NumberFormatException e) {
                timeStamp = ZERO_LONG;
            }
            bag.setProperty((Object)FRS_TIMESTAMP, timeStamp);
            this.clearServerInfo(new ServerSpec(bag.getString(SERVER_NAME), "fileserver", aps, cluster));
            this.addServer(bag);
        }
    }

    private String getPatternSearchName(String rawName) {
        char[] chs = rawName.toCharArray();
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i] != '.') continue;
            chs[i] = 37;
            return new String(chs, 0, i + 1);
        }
        return rawName;
    }

    public Set getPingerIORs(String aps) {
        HashMap<Integer, String> frsQuery = new HashMap<Integer, String>();
        frsQuery.put(APS_NAME, aps);
        frsQuery.put(PropertyIDs.SI_SERVER_KIND, "fileserver");
        Set frs = this.query(frsQuery);
        HashSet<String> pingeriors = new HashSet<String>();
        Iterator frsIter = frs.iterator();
        PropertyBag bag = null;
        while (frsIter.hasNext()) {
            bag = (PropertyBag)frsIter.next();
            String frsPingior = bag.getString((Object)PINGER);
            pingeriors.add(frsPingior);
        }
        return pingeriors;
    }
}

