/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.filerepository.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.exception.SILibException;
import com.crystaldecisions.celib.uri.FrsURL;
import com.crystaldecisions.celib.uri.OcaURI;
import com.crystaldecisions.enterprise.ocaframework.AbstractStubHelper;
import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.enterprise.ocaframework.IProxyHandler;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.PropertyIDs;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAfs.FileProp;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAfs.FileStoreExHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAfs.FileStoreExOperations;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAfs.FileStoreOperations;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAfs.Int64sWire;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqWriter;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.occa.filerepository.internal.CopyFileTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.FileEntry;
import com.crystaldecisions.sdk.occa.filerepository.internal.FileRepositoryObject;
import com.crystaldecisions.sdk.occa.filerepository.internal.FileTxHelper;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileEntry;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileRepository;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileRepositoryObject;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.IPutStreamTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.PutFileTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.PutStreamTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.RemoveFileTx;
import com.crystaldecisions.sdk.occa.filerepository.internal._FileStoreExProxy;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.thirdparty.org.omg.CORBA.StringHolder;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;

class FileRepository
implements IFileRepository {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.filerepository.internal.FileRepository");
    private String m_name;
    private FileStoreExOperations m_fileStore;
    private IProxyHandler m_handler;
    private String m_sessionUri;
    static final char FRS_PATH_SEPARATOR = '/';

    FileRepository(String svr, ISecuritySession session) throws SDKException {
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("FileRepository(): server=" + svr + ", aps=" + session.getAPSName() + ",cluster=" + session.getClusterName()));
            }
            this.m_handler = ServiceMgrFactory.getServiceMgr().getManagedService("NO_ID", "FileStoreV2", new ServerSpec(svr, "fileserver", session.getAPSName(), session.getClusterName()), session.getUserURI(), session.getLogonToken(), new IManagedService.IHelperFactory(){

                public IManagedService.IStubHelper makeHelper() {
                    return new AbstractStubHelper(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Object narrow(com.crystaldecisions.thirdparty.org.omg.CORBA.Object object) {
                            return FileStoreExHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)object);
                        }

                        public void release(Object object) {
                            ((FileStoreExOperations)object).free();
                        }
                    };
                }
            });
            OcaURI ocaURI = null;
            try {
                ocaURI = new OcaURI(session.getUserURI());
            }
            catch (SILibException e) {
                LOG.warn((Object)("(FileRepository:107): format error? uri=" + session.getUserURI()), (Throwable)e);
                throw new AssertionError((Object)e);
            }
            this.m_sessionUri = ocaURI.getProperties().getString((Object)PropertyIDs.SESSIONID);
            LOG.assertNotNull((Object)this.m_handler, "m_handler is null.");
            this.m_fileStore = new _FileStoreExProxy(this.m_handler);
            this.m_name = this.m_fileStore.getLogicalName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("FileRepository(): Logical name=" + this.m_name));
            }
        }
        catch (OCAFrameworkException e) {
            LOG.warn((Object)("FileRepository(): Failed to get service, server=" + svr + ", aps=" + session.getAPSName() + ",cluster=" + session.getClusterName()), (Throwable)((Object)e));
            throw SDKException.map(e);
        }
        catch (oca_abuse e) {
            LOG.warn((Object)("FileRepository(): failed to get logical name, server=" + svr + ", aps=" + session.getAPSName() + ",cluster=" + session.getClusterName()), (Throwable)e);
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.warn((Object)("FileRepository(): failed to get logical name, server=" + svr + ", aps=" + session.getAPSName() + ",cluster=" + session.getClusterName()), (Throwable)e);
            throw new SDKException.GenericFileStoreError((Exception)((Object)e));
        }
    }

    public String getName() {
        return this.m_name;
    }

    public int getCount() throws SDKException {
        LOG.assertNotNull((Object)this.m_fileStore, "m_fileStore is null.");
        try {
            return this.m_fileStore.counts();
        }
        catch (oca_abuse e) {
            throw SDKException.map(e);
        }
    }

    public long getTotalSize() throws SDKException {
        LOG.assertNotNull((Object)this.m_fileStore, "m_fileStore is null.");
        try {
            Int64sWire s = this.m_fileStore.bytes();
            long nBytes = s.MS;
            nBytes <<= 32;
            return nBytes |= (long)s.LS;
        }
        catch (oca_abuse e) {
            throw SDKException.map(e);
        }
    }

    public IFileEntry[] listing(String filter) throws SDKException {
        LOG.assertNotNull((Object)this.m_fileStore, "m_fileStore is null.");
        try {
            FileProp[] fileProperties = this.m_fileStore.listing(filter);
            if (fileProperties != null && fileProperties.length > 0) {
                IFileEntry[] fileEntries = new FileEntry[fileProperties.length];
                for (int i = 0; i < fileProperties.length; ++i) {
                    fileEntries[i] = new FileEntry(fileProperties[i].m_filename, fileProperties[i].m_attr, fileProperties[i].m_size);
                }
                return fileEntries;
            }
            return null;
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on the server", (Throwable)e);
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)("A problem occurred while getting a list of files in the file repository that match the filter " + filter), (Throwable)e);
            throw new SDKException.GenericFileStoreError((Exception)((Object)e));
        }
    }

    public boolean exists(String fileurl) throws SDKException {
        try {
            return this.m_fileStore.exists(fileurl);
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on the server", (Throwable)e);
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)("A problem occurred while checking if " + fileurl + " exists."), (Throwable)e);
            throw new SDKException.GenericFileStoreError((Exception)((Object)e));
        }
    }

    public IFileRepositoryObject get(String fileurl) throws SDKException {
        FileRepositoryObject fileOb = new FileRepositoryObject(this.m_fileStore, fileurl, 1, this.m_sessionUri);
        return fileOb;
    }

    public IFileRepositoryObject checkout(String fileurl) throws SDKException {
        FileRepositoryObject fileOb = new FileRepositoryObject(this.m_fileStore, fileurl, 3, this.m_sessionUri);
        return fileOb;
    }

    public IFileTx put(String filename, String destPath) throws SDKException {
        FileSeqWriter writer = null;
        try {
            LOG.assertTrue(destPath != null && destPath.length() > 0, "Assertion failed");
            File file = new File(filename);
            if (!file.canRead() || file.isDirectory()) {
                throw new SDKException.InvalidArg(filename);
            }
            if (this.isDirectory(destPath)) {
                destPath = destPath + file.getName();
            }
            StringHolder uri = new StringHolder();
            writer = this.m_fileStore.put(destPath, (double)file.length(), uri);
            LOG.assertNotNull((Object)writer, "writer is null.");
            writer = FileTxHelper.setWriterPolicies(writer);
            String ret = uri.value;
            return new PutFileTx(writer, filename, file, ret, this.m_sessionUri);
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on server while writing a file", (Throwable)e);
            if (writer != null) {
                FileTxHelper.releaseTx(writer);
            }
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while writing a file", (Throwable)e);
            if (writer != null) {
                FileTxHelper.releaseTx(writer);
            }
            throw new SDKException.FileWrite(filename, (Exception)((Object)e));
        }
    }

    private IPutStreamTx putStreamHelper(InputStream stream, long size, String destFilePath) throws SDKException {
        FileSeqWriter writer = null;
        try {
            LOG.assertTrue(destFilePath != null && destFilePath.length() > 0, "Assertion failed");
            if (!this.isFile(destFilePath)) {
                throw new SDKException.InvalidArg(destFilePath);
            }
            StringHolder uri = new StringHolder();
            writer = this.m_fileStore.put(destFilePath, (double)size, uri);
            LOG.assertNotNull((Object)writer, "writer is null.");
            writer = FileTxHelper.setWriterPolicies(writer);
            String ret = uri.value;
            if (stream == null) {
                stream = new ByteArrayInputStream(new byte[0]);
            }
            return new PutStreamTx(writer, stream, ret, this.m_sessionUri);
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on server while writing a stream", (Throwable)e);
            if (writer != null) {
                FileTxHelper.releaseTx(writer);
            }
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while writing a stream", (Throwable)e);
            if (writer != null) {
                FileTxHelper.releaseTx(writer);
            }
            throw new SDKException.StreamWrite((Exception)((Object)e));
        }
    }

    public IPutStreamTx put(byte[] stream, String destFilePath) throws SDKException {
        return this.putStreamHelper(new ByteArrayInputStream(stream), stream.length, destFilePath);
    }

    public IPutStreamTx put(long size, String destFilePath) throws SDKException {
        return this.putStreamHelper(null, size, destFilePath);
    }

    public IPutStreamTx put(long size, InputStream stream, String destFilePath) throws SDKException {
        return this.putStreamHelper(stream, 0L, destFilePath);
    }

    public IPutStreamTx putUnique(long size, InputStream stream, String destFolderPath, String prefix, String ext) throws SDKException {
        return this.putUniqueStreamHelper(stream, size, destFolderPath, prefix, ext);
    }

    public IFileTx putUnique(String filename, String destFolderPath, String prefix, String ext) throws SDKException {
        FileSeqWriter writer = null;
        try {
            LOG.assertTrue(destFolderPath != null && destFolderPath.length() > 0, "Assertion failed");
            File file = new File(filename);
            if (!file.canRead() || file.isDirectory()) {
                throw new SDKException.InvalidArg(filename);
            }
            if (this.isFile(destFolderPath)) {
                throw new SDKException.InvalidArg(destFolderPath);
            }
            if (prefix == null) {
                prefix = "";
            }
            if (ext == null) {
                String lastname = file.getName();
                int index = lastname.lastIndexOf(".");
                ext = index == -1 ? "" : lastname.substring(index);
            }
            long fileSize = file.length();
            StringHolder uri = new StringHolder();
            writer = this.m_fileStore.putUnique(destFolderPath, prefix, ext, (double)fileSize, uri);
            LOG.assertNotNull((Object)writer, "writer is null.");
            writer = FileTxHelper.setWriterPolicies(writer);
            String ret = uri.value;
            return new PutFileTx(writer, filename, file, ret, this.m_sessionUri);
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on the server while writing a file", (Throwable)e);
            if (writer != null) {
                FileTxHelper.releaseTx(writer);
            }
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while writing a file", (Throwable)e);
            if (writer != null) {
                FileTxHelper.releaseTx(writer);
            }
            throw new SDKException.FileWrite(filename, (Exception)((Object)e));
        }
    }

    private IPutStreamTx putUniqueStreamHelper(InputStream stream, long size, String destFolderPath, String prefix, String ext) throws SDKException {
        FileSeqWriter writer = null;
        try {
            LOG.assertTrue(destFolderPath != null && destFolderPath.length() > 0, "Assertion failed");
            if (this.isFile(destFolderPath)) {
                throw new SDKException.InvalidArg(destFolderPath);
            }
            if (prefix == null) {
                prefix = "";
            }
            if (ext == null) {
                ext = "";
            }
            StringHolder uri = new StringHolder();
            writer = this.m_fileStore.putUnique(destFolderPath, prefix, ext, (double)size, uri);
            LOG.assertNotNull((Object)writer, "writer is null.");
            writer = FileTxHelper.setWriterPolicies(writer);
            String ret = uri.value;
            if (stream == null) {
                stream = new ByteArrayInputStream(new byte[0]);
            }
            return new PutStreamTx(writer, stream, ret, this.m_sessionUri);
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on server while writing a stream", (Throwable)e);
            if (writer != null) {
                FileTxHelper.releaseTx(writer);
            }
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while writing a stream", (Throwable)e);
            if (writer != null) {
                FileTxHelper.releaseTx(writer);
            }
            throw new SDKException.StreamWrite((Exception)((Object)e));
        }
    }

    public IFileTx putUnique(byte[] stream, String destFolderPath, String prefix, String ext) throws SDKException {
        return this.putUniqueStreamHelper(new ByteArrayInputStream(stream), stream.length, destFolderPath, prefix, ext);
    }

    public IPutStreamTx putUnique(long size, String destFolderPath, String prefix, String ext) throws SDKException {
        return this.putUniqueStreamHelper(null, size, destFolderPath, prefix, ext);
    }

    public IFileTx remove(String fileurl) throws SDKException {
        return new RemoveFileTx((FileStoreOperations)this.m_fileStore, fileurl);
    }

    public IFileTx copy(String srcFrsPath, String destPath, boolean bReplace) throws SDKException {
        try {
            FrsURL srcURL = new FrsURL(srcFrsPath);
            return new CopyFileTx((FileStoreOperations)this.m_fileStore, srcURL.getFilePath(), destPath, bReplace);
        }
        catch (SILibException e) {
            throw new SDKException.URIFormat(srcFrsPath, (Exception)((Object)e));
        }
    }

    public void download(Collection frPathColl, String localFolder) throws SDKException {
        File localDir = new File(localFolder);
        if (!localDir.isDirectory()) {
            throw new SDKException.InvalidArg(localFolder);
        }
        String localDirName = localDir.getPath() + File.separator;
        Iterator iter = frPathColl.iterator();
        while (iter.hasNext()) {
            String frPath = (String)iter.next();
            if (!this.exists(frPath)) continue;
            IFileRepositoryObject fileObj = this.get(frPath);
            String fileName = frPath.substring(frPath.lastIndexOf(47) + 1);
            IFileTx transaction = fileObj.download(localDirName + fileName);
            transaction.commit();
        }
    }

    public void upload(Collection localPathColl, String frDestFolder) throws SDKException {
        if (!this.isDirectory(frDestFolder)) {
            throw new SDKException.InvalidArg(frDestFolder);
        }
        Iterator iter = localPathColl.iterator();
        while (iter.hasNext()) {
            String localPath = (String)iter.next();
            this.put(localPath, frDestFolder);
        }
    }

    private boolean isLocal() throws SDKException {
        try {
            String host = this.m_fileStore.getLocalHostname();
            String localhost = InetAddress.getLocalHost().getHostAddress();
            return host.compareToIgnoreCase(localhost) == 0;
        }
        catch (UnknownHostException e) {
            throw new SDKException.Unexpected(e);
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on the server", (Throwable)e);
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while getting local host name for file repository", (Throwable)e);
            throw new SDKException.GenericFileStoreError((Exception)((Object)e));
        }
    }

    private boolean isDirectory(String destFolderPath) {
        return destFolderPath.charAt(destFolderPath.length() - 1) == '/';
    }

    private boolean isFile(String destFolderPath) {
        return !this.isDirectory(destFolderPath);
    }

    private String getSimplePath(String path) {
        if (path.indexOf(58) == -1) {
            return path;
        }
        FrsURL frsURL = null;
        try {
            frsURL = new FrsURL(path);
        }
        catch (SILibException e) {
            throw new SDKRuntimeException.UnexpectedCause((Exception)((Object)e));
        }
        return frsURL.getFilePath();
    }
}

