/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.filerepository.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.exception.SILibException;
import com.crystaldecisions.celib.uri.FrsURL;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAfs.FileStoreExOperations;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAfs.FileStoreOperations;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAfs.Int64sWire;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqReader;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqWriter;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.filerepository.internal.CopyFileTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.FileTxHelper;
import com.crystaldecisions.sdk.occa.filerepository.internal.GetFileTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.GetOutputStreamTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.GetStreamTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileRepositoryObject;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.IGetStreamTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.IPutStreamTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.IStreamingSupport;
import com.crystaldecisions.sdk.occa.filerepository.internal.PutFileTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.PutStreamTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.RemoveFileTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.StreamingSupport;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

class FileRepositoryObject
implements IFileRepositoryObject {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.filerepository.internal.FileRepositoryObject");
    public static final int CE_FR_READ = 1;
    public static final int CE_FR_WRITE = 2;
    private static final int UNDEF = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private String m_rootPath = null;
    private String m_localFilePath = "";
    private String m_frsPath = "";
    private FileStoreExOperations m_fileStore = null;
    private int m_fileMode = 1;
    private int m_isDir;
    private long m_fileSize;
    private String m_sessionUri;

    FileRepositoryObject(FileStoreExOperations fileStore, String uri, int mode, String sessionUri) {
        this.m_fileStore = fileStore;
        this.m_fileMode = mode;
        this.m_frsPath = uri;
        this.m_sessionUri = sessionUri;
        this.m_isDir = -1;
        this.m_fileSize = -1L;
    }

    public String getURL() {
        return this.m_frsPath;
    }

    public boolean isDirectory() throws SDKException {
        if (this.m_isDir == -1) {
            LOG.assertNotNull((Object)this.m_fileStore, "m_fileStore is null.");
            try {
                this.m_isDir = this.m_fileStore.isDir(this.m_frsPath) ? 1 : 0;
            }
            catch (oca_abuse e) {
                LOG.info((Object)("A problem occurred on server while checking if " + this.m_frsPath + " is a directory"), (Throwable)e);
                throw SDKException.map(e);
            }
            catch (SystemException e) {
                LOG.info((Object)("A problem occurred while checking if " + this.m_frsPath + " is a directory"), (Throwable)e);
                throw new SDKException.GenericFileStoreError((Exception)((Object)e));
            }
        }
        return this.m_isDir == 1;
    }

    public boolean isReadable() throws SDKException {
        return (this.m_fileMode & 1) != 0;
    }

    public boolean isWritable() throws SDKException {
        return (this.m_fileMode & 2) != 0;
    }

    public long getSize() throws SDKException {
        if (this.m_fileSize == -1L) {
            try {
                if (this.m_fileStore != null) {
                    Int64sWire s = this.m_fileStore.size(this.m_frsPath);
                    this.m_fileSize = (long)s.LS & 0x80000000L;
                    this.m_fileSize |= (long)s.LS & Integer.MAX_VALUE;
                    this.m_fileSize |= (long)s.MS << 32;
                }
            }
            catch (oca_abuse e) {
                LOG.info((Object)("A problem occurred on server while getting size for " + this.m_frsPath), (Throwable)e);
                throw SDKException.map(e);
            }
            catch (SystemException e) {
                LOG.info((Object)("A problem occurred while getting size for " + this.m_frsPath), (Throwable)e);
                throw new SDKException.GenericFileStoreError((Exception)((Object)e));
            }
        }
        return this.m_fileSize;
    }

    public String getRootPath() throws SDKException {
        if (this.m_rootPath == null) {
            try {
                if (this.m_fileStore != null) {
                    this.m_rootPath = this.m_fileStore.getRootPath();
                }
            }
            catch (oca_abuse e) {
                LOG.info((Object)"A problem occurred on server while getting root path", (Throwable)e);
                throw SDKException.map(e);
            }
            catch (SystemException e) {
                LOG.info((Object)"A problem occurred while getting root path", (Throwable)e);
                throw new SDKException.GenericFileStoreError((Exception)((Object)e));
            }
        }
        return this.m_rootPath;
    }

    public String getRemoteFilePath() throws SDKException {
        String rootPath = this.getRootPath();
        FrsURL frsURL = null;
        try {
            frsURL = new FrsURL(this.m_frsPath);
        }
        catch (SILibException e) {
            throw new SDKException.URIFormat(this.m_frsPath, (Exception)((Object)e));
        }
        return rootPath + frsURL.getFilePath();
    }

    public String getLocalFilePath() throws SDKException {
        return this.m_localFilePath;
    }

    public IFileTx download(String filename) throws SDKException {
        File file = new File(filename);
        if (file.isDirectory()) {
            throw new SDKException.InvalidArg(filename);
        }
        FileSeqReader reader = null;
        try {
            reader = this.m_fileStore.get(this.m_frsPath);
            reader = FileTxHelper.setReaderPolicies(reader);
            this.m_localFilePath = filename;
            return new GetFileTx(reader, this.m_frsPath, file);
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on server while reading a stream", (Throwable)e);
            if (reader != null) {
                FileTxHelper.releaseTx(reader);
            }
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while reading a stream", (Throwable)e);
            if (reader != null) {
                FileTxHelper.releaseTx(reader);
            }
            throw new SDKException.StreamRead((Exception)((Object)e));
        }
    }

    public IFileTx download(byte[] stream) throws SDKException {
        FileSeqReader reader = null;
        try {
            reader = this.m_fileStore.get(this.m_frsPath);
            reader = FileTxHelper.setReaderPolicies(reader);
            return new GetStreamTx(reader, this.m_frsPath, stream);
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on server while reading a stream", (Throwable)e);
            if (reader != null) {
                FileTxHelper.releaseTx(reader);
            }
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while reading a stream", (Throwable)e);
            if (reader != null) {
                FileTxHelper.releaseTx(reader);
            }
            throw new SDKException.StreamRead((Exception)((Object)e));
        }
    }

    public IGetStreamTx download(OutputStream stream) throws SDKException {
        FileSeqReader reader = null;
        try {
            reader = this.m_fileStore.get(this.m_frsPath);
            reader = FileTxHelper.setReaderPolicies(reader);
            return new GetOutputStreamTx(reader, this.m_frsPath, stream);
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on server while reading a stream", (Throwable)e);
            if (reader != null) {
                FileTxHelper.releaseTx(reader);
            }
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while reading a stream", (Throwable)e);
            if (reader != null) {
                FileTxHelper.releaseTx(reader);
            }
            throw new SDKException.StreamRead((Exception)((Object)e));
        }
    }

    public IFileTx overwrite(String filename) throws SDKException {
        if (!this.isWritable()) {
            throw new SDKException.InvalidOperation();
        }
        LOG.assertNotNull((Object)filename, "filename is null.");
        File file = new File(filename);
        if (!file.canRead() || file.isDirectory()) {
            throw new SDKException.InvalidArg(filename);
        }
        FileSeqWriter writer = null;
        try {
            writer = this.m_fileStore.checkout(this.m_frsPath, (double)file.length());
            writer = FileTxHelper.setWriterPolicies(writer);
            this.m_fileSize = -1L;
            return new PutFileTx(writer, filename, file, this.m_frsPath, this.m_sessionUri);
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on server while writing a stream", (Throwable)e);
            if (writer != null) {
                FileTxHelper.releaseTx(writer);
            }
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while writing a stream", (Throwable)e);
            if (writer != null) {
                FileTxHelper.releaseTx(writer);
            }
            throw new SDKException.StreamWrite((Exception)((Object)e));
        }
    }

    public IPutStreamTx overwrite(InputStream stream, long size) throws SDKException {
        if (!this.isWritable()) {
            throw new SDKException.InvalidOperation();
        }
        FileSeqWriter writer = null;
        try {
            writer = this.m_fileStore.checkout(this.m_frsPath, (double)size);
            writer = FileTxHelper.setWriterPolicies(writer);
            this.m_fileSize = -1L;
            return new PutStreamTx(writer, stream, this.m_frsPath, this.m_sessionUri);
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on server while writing a stream", (Throwable)e);
            if (writer != null) {
                FileTxHelper.releaseTx(writer);
            }
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while writing a stream", (Throwable)e);
            if (writer != null) {
                FileTxHelper.releaseTx(writer);
            }
            throw new SDKException.StreamWrite((Exception)((Object)e));
        }
    }

    public IFileTx overwrite(byte[] stream) throws SDKException {
        return this.overwrite(new ByteArrayInputStream(stream), stream.length);
    }

    public IFileTx overwrite(long size) throws SDKException {
        return this.overwrite(new ByteArrayInputStream(new byte[0]), size);
    }

    public IFileTx remove() throws SDKException {
        return new RemoveFileTx((FileStoreOperations)this.m_fileStore, this.m_frsPath);
    }

    public IFileTx copy(String destPath) throws SDKException {
        try {
            FrsURL url = new FrsURL(this.m_frsPath);
            String path = url.getFilePath();
            return new CopyFileTx((FileStoreOperations)this.m_fileStore, path, destPath, false);
        }
        catch (SILibException e) {
            throw new SDKException.URIFormat(this.m_frsPath, (Exception)((Object)e));
        }
    }

    public IStreamingSupport getStreamingSupport(int chunkSize) throws SDKException {
        try {
            FileSeqReader reader = this.m_fileStore.get(this.m_frsPath);
            reader = FileTxHelper.setReaderPolicies(reader);
            if (chunkSize > 0) {
                reader.setPartialMaxLength((short)chunkSize);
            }
            return new StreamingSupport(reader, this);
        }
        catch (oca_abuse oca_abuse2) {
            LOG.info((Object)"A problem occurred on server while getting a file reader", (Throwable)oca_abuse2);
            throw SDKException.map(oca_abuse2);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while getting a file reader", (Throwable)e);
            throw new SDKException.FileReaderError((Exception)((Object)e));
        }
    }

    public IFileTx append(String filename) throws SDKException {
        if (!this.isWritable()) {
            throw new SDKException.InvalidOperation();
        }
        LOG.assertNotNull((Object)filename, "filename is null.");
        File file = new File(filename);
        if (!file.canRead() || file.isDirectory()) {
            throw new SDKException.InvalidArg(filename);
        }
        FileSeqWriter writer = null;
        try {
            writer = this.m_fileStore.checkoutForAppend(this.m_frsPath, (double)file.length());
            writer = FileTxHelper.setWriterPolicies(writer);
            this.m_fileSize = -1L;
            return new PutFileTx(writer, filename, file, this.m_frsPath, this.m_sessionUri);
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on server while writing a file", (Throwable)e);
            if (writer != null) {
                FileTxHelper.releaseTx(writer);
            }
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while writing a file", (Throwable)e);
            if (writer != null) {
                FileTxHelper.releaseTx(writer);
            }
            throw new SDKException.FileWrite(filename, (Exception)((Object)e));
        }
    }

    public IFileTx append(byte[] stream) throws SDKException {
        return this.append(new ByteArrayInputStream(stream), stream.length);
    }

    public IPutStreamTx append(InputStream stream, long size) throws SDKException {
        if (!this.isWritable()) {
            throw new SDKException.InvalidOperation();
        }
        FileSeqWriter writer = null;
        try {
            writer = this.m_fileStore.checkoutForAppend(this.m_frsPath, (double)size);
            writer = FileTxHelper.setWriterPolicies(writer);
            this.m_fileSize = -1L;
            return new PutStreamTx(writer, stream, this.m_frsPath, this.m_sessionUri);
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on server while writing a file", (Throwable)e);
            if (writer != null) {
                FileTxHelper.releaseTx(writer);
            }
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while writing a file", (Throwable)e);
            if (writer != null) {
                FileTxHelper.releaseTx(writer);
            }
            throw new SDKException.StreamWrite((Exception)((Object)e));
        }
    }
}

