/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.filerepository.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqReader;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqReaderHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqWriter;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqWriterHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Any;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORB;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Policy;
import com.crystaldecisions.thirdparty.org.omg.CORBA.PolicyError;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SetOverrideType;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class FileTxHelper {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.filerepository.internal.FileTxHelper");
    private static final int partialSize = 65536;
    private static final int MAX_NUM_RETRIES = 5;
    private static final int FILETX_DEFAULT_TIMEOUT = 90;
    private static final String FILETX_REQUEST_TIMEOUT_PROPERTY = "bobj.filetx.timeout";

    FileTxHelper() {
    }

    static FileSeqReader setReaderPolicies(FileSeqReader reader) throws SDKException {
        LOG.assertNotNull((Object)reader, "reader is null.");
        try {
            ORB orb = ServiceMgrFactory.getServiceMgr().getORB();
            Any boolAny = orb.create_any();
            boolAny.insert_boolean(true);
            Any timeoutAny = orb.create_any();
            int reqTimeout = Integer.getInteger(FILETX_REQUEST_TIMEOUT_PROPERTY, 90);
            timeoutAny.insert_ulong(reqTimeout * 1000);
            Policy[] policies = new Policy[]{orb.create_policy(1330577411, boolAny), orb.create_policy(1330577413, timeoutAny)};
            com.crystaldecisions.thirdparty.org.omg.CORBA.Object newObj = reader._set_policy_override(policies, SetOverrideType.ADD_OVERRIDE);
            if (newObj != null) {
                return FileSeqReaderHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)newObj);
            }
            return null;
        }
        catch (PolicyError e) {
            LOG.info((Object)"A problem occurred while setting reader policies", (Throwable)e);
            throw new SDKException.FileReaderError((Exception)((Object)e));
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while setting reader policies", (Throwable)e);
            throw new SDKException.FileReaderError((Exception)((Object)e));
        }
    }

    static FileSeqWriter setWriterPolicies(FileSeqWriter writer) throws SDKException {
        LOG.assertNotNull((Object)writer, "writer is null.");
        try {
            ORB orb = ServiceMgrFactory.getServiceMgr().getORB();
            Any boolAny = orb.create_any();
            boolAny.insert_boolean(true);
            Any timeoutAny = orb.create_any();
            int reqTimeout = Integer.getInteger(FILETX_REQUEST_TIMEOUT_PROPERTY, 90);
            timeoutAny.insert_ulong(reqTimeout * 1000);
            Policy[] policies = new Policy[]{orb.create_policy(1330577411, boolAny), orb.create_policy(1330577413, timeoutAny)};
            com.crystaldecisions.thirdparty.org.omg.CORBA.Object newObj = writer._set_policy_override(policies, SetOverrideType.ADD_OVERRIDE);
            if (newObj != null) {
                return FileSeqWriterHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)newObj);
            }
            return null;
        }
        catch (PolicyError e) {
            LOG.info((Object)"A problem occurred while setting writer policies", (Throwable)e);
            throw new SDKException.FileWriterError((Exception)((Object)e));
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while setting writer policies", (Throwable)e);
            throw new SDKException.FileWriterError((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putFile(File txFile, FileSeqWriter writer) throws SDKException, IOException {
        try {
            InputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(txFile), 65536);
                byte[] bs = new byte[65536];
                int byteRead = 0;
                while ((byteRead = in.read(bs)) != -1) {
                    if (byteRead < bs.length) {
                        byte[] lastBS = new byte[byteRead];
                        System.arraycopy(bs, 0, lastBS, 0, byteRead);
                        writer.putContent(lastBS);
                        continue;
                    }
                    writer.putContent(bs);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on server while writing a file", (Throwable)e);
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while writing a file", (Throwable)e);
            throw new SDKException.FileWrite(txFile.getName(), (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getFile(File txFile, FileSeqReader reader) throws SDKException, IOException {
        try {
            if (txFile.exists() && txFile.length() > 0L) {
                txFile.delete();
            }
            OutputStream out = null;
            try {
                out = new BufferedOutputStream(new FileOutputStream(txFile), 65536);
                while (!reader.eof()) {
                    byte[] bs = reader.getContentImmediate();
                    out.write(bs);
                }
                out.flush();
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on server while reading a file", (Throwable)e);
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while reading a file", (Throwable)e);
            throw new SDKException.FileRead(txFile.getName(), (Exception)((Object)e));
        }
    }

    static void putStream(byte[] stream, FileSeqWriter writer) throws SDKException {
        FileTxHelper.putStream(stream, 0, stream.length, writer);
    }

    static void putStream(byte[] stream, int offset, int length, FileSeqWriter writer) throws SDKException {
        if (stream == null) {
            return;
        }
        if (length == 0) {
            return;
        }
        if (offset < 0 || length < 0 || offset > stream.length || stream.length - offset < length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        try {
            if (length < 65536) {
                if (offset == 0 && length == stream.length) {
                    writer.putContent(stream);
                } else {
                    byte[] buf = new byte[length];
                    System.arraycopy(stream, offset, buf, 0, length);
                    writer.putContent(buf);
                }
            } else {
                byte[] bs = new byte[65536];
                int copySize = 0;
                for (int byteRemaining = length; byteRemaining > 0; byteRemaining -= copySize) {
                    if (byteRemaining < 65536) {
                        copySize = byteRemaining;
                        bs = new byte[copySize];
                    } else {
                        copySize = 65536;
                    }
                    System.arraycopy(stream, offset, bs, 0, copySize);
                    writer.putContent(bs);
                    offset += copySize;
                }
            }
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on server while writing a stream", (Throwable)e);
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while writing a stream", (Throwable)e);
            throw new SDKException.StreamWrite((Exception)((Object)e));
        }
    }

    static long putStream(InputStream stream, FileSeqWriter writer) throws SDKException, IOException {
        try {
            int read;
            byte[] bs = new byte[65536];
            long size = 0L;
            while ((read = stream.read(bs)) != -1) {
                byte[] tmp;
                size += (long)read;
                if (read == 65536) {
                    tmp = bs;
                } else {
                    tmp = new byte[read];
                    System.arraycopy(bs, 0, tmp, 0, read);
                }
                writer.putContent(tmp);
            }
            return size;
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on server while writing a stream", (Throwable)e);
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while writing a stream", (Throwable)e);
            throw new SDKException.StreamWrite((Exception)((Object)e));
        }
    }

    static void getStream(byte[] stream, FileSeqReader reader) throws SDKException {
        LOG.assertTrue(stream != null && stream.length > 0, "Assertion failed");
        try {
            int offset = 0;
            while (!reader.eof()) {
                byte[] bs = reader.getContentImmediate();
                if (stream.length - offset < bs.length) {
                    throw new SDKException.StreamRead();
                }
                System.arraycopy(bs, 0, stream, offset, bs.length);
                offset += bs.length;
            }
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on server while reading a stream", (Throwable)e);
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while reading a stream", (Throwable)e);
            throw new SDKException.StreamRead((Exception)((Object)e));
        }
    }

    static long getStream(OutputStream stream, FileSeqReader reader) throws SDKException, IOException {
        try {
            long size = 0L;
            while (!reader.eof()) {
                byte[] bs = reader.getContentImmediate();
                if (bs == null) continue;
                stream.write(bs);
                size += (long)bs.length;
            }
            return size;
        }
        catch (oca_abuse e) {
            LOG.info((Object)"A problem occurred on server while reading a stream", (Throwable)e);
            throw SDKException.map(e);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while reading a stream", (Throwable)e);
            throw new SDKException.StreamRead((Exception)((Object)e));
        }
    }

    static byte[] getStream(FileSeqReader reader) throws SDKException {
        try {
            return reader.getContentImmediate();
        }
        catch (oca_abuse oca_abuse2) {
            LOG.info((Object)"A problem occurred on server while reading a stream", (Throwable)oca_abuse2);
            throw SDKException.map(oca_abuse2);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while reading a stream", (Throwable)e);
            throw new SDKException.StreamRead((Exception)((Object)e));
        }
    }

    static void seekStream(long num, FileSeqReader reader) throws SDKException {
        try {
            if (num > Integer.MAX_VALUE) {
                LOG.error((Object)"Unsupported seek location! The current SDK only supports seeking on files that are less than 2147483647 bytes in size.");
                throw new SDKException.InvalidArg(num);
            }
            int iNum = (int)num;
            reader.seek(iNum);
        }
        catch (oca_abuse oca_abuse2) {
            LOG.info((Object)"A problem occurred on server while seeking a stream", (Throwable)oca_abuse2);
            throw SDKException.map(oca_abuse2);
        }
        catch (SystemException e) {
            LOG.info((Object)"A problem occurred while seeking a stream", (Throwable)e);
            throw new SDKException.StreamSeekError((Exception)((Object)e));
        }
    }

    static void cleanupTx(FileSeqWriter writer) throws SDKException {
        int numRetries = 0;
        SDKException exception = null;
        while (numRetries++ < 5) {
            try {
                writer.flush();
                break;
            }
            catch (oca_abuse e) {
                LOG.info((Object)("A problem occurred on server while cleaning up file writer. Retry #" + numRetries), (Throwable)e);
                if (numRetries != 5) continue;
                exception = SDKException.map(e);
            }
            catch (SystemException e) {
                LOG.info((Object)("A problem occurred while cleaning up file writer. Retry #" + numRetries), (Throwable)e);
                if (numRetries != 5) continue;
                exception = new SDKException.FileWriterError((Exception)((Object)e));
            }
        }
        try {
            FileTxHelper.releaseTx(writer);
        }
        catch (SDKException sdkEx) {
            if (exception != null) {
                throw exception;
            }
            throw sdkEx;
        }
    }

    static void cleanupTx(FileSeqReader reader) throws SDKException {
        int numRetries = 0;
        SDKException exception = null;
        while (numRetries++ < 5) {
            try {
                reader.free();
                break;
            }
            catch (oca_abuse e) {
                LOG.info((Object)("A problem occurred on server while cleaning up file reader. Retry #" + numRetries), (Throwable)e);
                if (numRetries != 5) continue;
                exception = SDKException.map(e);
            }
            catch (SystemException e) {
                LOG.info((Object)("A problem occurred while cleaning up file reader. Retry #" + numRetries), (Throwable)e);
                if (numRetries != 5) continue;
                exception = new SDKException.FileReaderError((Exception)((Object)e));
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    static void releaseTx(FileSeqWriter writer) throws SDKException {
        int numRetries = 0;
        SDKException exception = null;
        while (numRetries++ < 5) {
            try {
                writer.free();
                break;
            }
            catch (oca_abuse e) {
                LOG.info((Object)("A problem occurred on server while releasing file writer. Retry #" + numRetries), (Throwable)e);
                if (numRetries != 5) continue;
                exception = SDKException.map(e);
            }
            catch (SystemException e) {
                LOG.info((Object)("A problem occurred while releasing file writer. Retry #" + numRetries), (Throwable)e);
                if (numRetries != 5) continue;
                exception = new SDKException.FileWriterError((Exception)((Object)e));
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    static void releaseTx(FileSeqReader reader) throws SDKException {
        int numRetries = 0;
        SDKException exception = null;
        while (numRetries++ < 5) {
            try {
                reader.free();
                break;
            }
            catch (oca_abuse e) {
                LOG.info((Object)("A problem occurred on server while releasing file reader. Retry #" + numRetries), (Throwable)e);
                if (numRetries != 5) continue;
                exception = SDKException.map(e);
            }
            catch (SystemException e) {
                LOG.info((Object)("A problem occurred while releasing file reader. Retry #" + numRetries), (Throwable)e);
                if (numRetries != 5) continue;
                exception = new SDKException.FileReaderError((Exception)((Object)e));
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

