/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.filerepository.internal;

import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqReader;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.filerepository.internal.FileTxHelper;
import com.crystaldecisions.sdk.occa.filerepository.internal.IGetStreamTx;
import java.io.IOException;
import java.io.OutputStream;

class GetOutputStreamTx
implements IGetStreamTx {
    private FileSeqReader m_reader;
    private OutputStream m_stream;
    private String m_name;
    private long m_size;
    private boolean m_notCommitted;

    GetOutputStreamTx(FileSeqReader reader, String frsPath, OutputStream stream) {
        this.m_reader = reader;
        this.m_stream = stream;
        this.m_name = frsPath;
        this.m_notCommitted = true;
    }

    public Object getSource() {
        return this.m_name;
    }

    public Object getDestination() {
        return this.m_stream;
    }

    public Object commit() throws SDKException {
        if (this.m_notCommitted) {
            try {
                this.m_size = FileTxHelper.getStream(this.m_stream, this.m_reader);
            }
            catch (IOException e) {
                throw new SDKException.FileRead(this.m_name, e);
            }
            FileTxHelper.cleanupTx(this.m_reader);
            OutputStream stream = this.m_stream;
            this.m_stream = null;
            this.m_reader = null;
            this.m_notCommitted = false;
            return stream;
        }
        return null;
    }

    public long getSize() {
        return this.m_size;
    }

    public void destroy() throws SDKException {
        if (this.m_reader != null) {
            FileTxHelper.releaseTx(this.m_reader);
            this.m_reader = null;
            this.m_stream = null;
            this.m_notCommitted = false;
        }
    }
}

