/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.filerepository.internal;

import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqReader;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.filerepository.internal.FileTxHelper;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileTx;

class GetStreamTx
implements IFileTx {
    private FileSeqReader m_reader;
    private byte[] m_stream;
    private String m_name;
    private boolean m_notCommitted;

    GetStreamTx(FileSeqReader reader, String frsPath, byte[] stream) {
        this.m_reader = reader;
        this.m_stream = stream;
        this.m_name = frsPath;
        this.m_notCommitted = true;
    }

    public Object getSource() {
        return this.m_name;
    }

    public Object getDestination() {
        return this.m_stream;
    }

    public Object commit() throws SDKException {
        if (this.m_notCommitted) {
            FileTxHelper.getStream(this.m_stream, this.m_reader);
            FileTxHelper.cleanupTx(this.m_reader);
            byte[] stream = this.m_stream;
            this.m_stream = null;
            this.m_reader = null;
            this.m_notCommitted = false;
            return stream;
        }
        return null;
    }

    public void destroy() throws SDKException {
        if (this.m_reader != null) {
            FileTxHelper.releaseTx(this.m_reader);
            this.m_reader = null;
            this.m_stream = null;
            this.m_notCommitted = false;
        }
    }
}

