/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.filerepository.internal;

import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqWriter;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqWriterEx;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqWriterExHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqWriterHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.filerepository.internal.BoundFile;
import com.crystaldecisions.sdk.occa.filerepository.internal.FileTxHelper;
import com.crystaldecisions.sdk.occa.filerepository.internal.IPutFileTx;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORB;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Object;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

class PutFileTx
implements IPutFileTx,
Externalizable {
    private String m_srcPath;
    private String m_destPath;
    private FileSeqWriter m_writer;
    private BoundFile m_file;
    private boolean m_notCommitted;

    public PutFileTx() {
    }

    PutFileTx(FileSeqWriter writer, String srcPath, File file, String destPath, String sessionUri) throws oca_abuse {
        this.m_file = new BoundFile(file.getPath());
        this.m_writer = writer;
        this.m_srcPath = srcPath;
        this.m_notCommitted = true;
        this.m_destPath = destPath;
        FileSeqWriterEx writerEx = FileSeqWriterExHelper.narrow((Object)writer);
        writerEx.registerSession(sessionUri);
    }

    public java.lang.Object getSource() {
        return this.m_srcPath;
    }

    public java.lang.Object getDestination() {
        return this.m_destPath;
    }

    public java.lang.Object commit() throws SDKException {
        if (this.m_notCommitted) {
            this.uploadContent();
            FileTxHelper.cleanupTx(this.m_writer);
            this.m_writer = null;
            this.m_notCommitted = false;
        }
        return this.m_destPath;
    }

    public void destroy() throws SDKException {
        if (this.m_writer != null) {
            FileTxHelper.releaseTx(this.m_writer);
            this.m_writer = null;
            this.m_file = null;
            this.m_notCommitted = false;
        }
    }

    public void uploadContent() throws SDKException {
        if (this.m_file != null) {
            try {
                FileTxHelper.putFile(this.m_file.getFile(), this.m_writer);
                this.m_file = null;
            }
            catch (IOException e) {
                throw new SDKException.FileWrite(this.m_destPath, e);
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_srcPath);
        out.writeObject(this.m_destPath);
        out.writeObject(this.m_file);
        ORB orb = ServiceMgrFactory.getServiceMgr().getORB();
        out.writeObject(orb.object_to_string((Object)this.m_writer));
        out.writeBoolean(this.m_notCommitted);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_srcPath = (String)in.readObject();
        this.m_destPath = (String)in.readObject();
        this.m_file = (BoundFile)in.readObject();
        String writerStr = (String)in.readObject();
        ORB orb = ServiceMgrFactory.getServiceMgr().getORB();
        this.m_writer = FileSeqWriterHelper.narrow((Object)orb.string_to_object(writerStr));
        this.m_notCommitted = in.readBoolean();
    }
}

