/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.filerepository.internal;

import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqWriter;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqWriterEx;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqWriterExHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqWriterHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.filerepository.internal.FileTxHelper;
import com.crystaldecisions.sdk.occa.filerepository.internal.IPutStreamTx;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORB;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Object;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;

class PutStreamTx
implements IPutStreamTx,
Externalizable {
    private String m_destPath;
    private FileSeqWriter m_writer;
    private InputStream m_stream;
    private boolean m_notCommitted;
    private long m_size;

    public PutStreamTx() {
    }

    PutStreamTx(FileSeqWriter writer, InputStream stream, String destPath, String sessionUri) throws oca_abuse {
        this.m_writer = writer;
        this.m_stream = stream;
        this.m_notCommitted = true;
        this.m_destPath = destPath;
        this.m_size = 0L;
        FileSeqWriterEx writerEx = FileSeqWriterExHelper.narrow((Object)writer);
        writerEx.registerSession(sessionUri);
    }

    public java.lang.Object getSource() {
        return this.m_stream;
    }

    public java.lang.Object getDestination() {
        return this.m_destPath;
    }

    public void putContent(byte[] stream) throws SDKException {
        if (stream != null) {
            FileTxHelper.putStream(stream, this.m_writer);
            this.m_size += (long)stream.length;
        }
    }

    public void putContent(byte[] stream, int off, int len) throws SDKException {
        if (stream != null) {
            FileTxHelper.putStream(stream, off, len, this.m_writer);
            this.m_size += (long)len;
        }
    }

    public long putContent(InputStream stream) throws SDKException {
        try {
            long size = FileTxHelper.putStream(stream, this.m_writer);
            this.m_size += size;
            return size;
        }
        catch (IOException e) {
            throw new SDKException.FileWrite(this.m_destPath, e);
        }
    }

    public java.lang.Object commit() throws SDKException {
        if (this.m_notCommitted) {
            this.uploadContent();
            FileTxHelper.cleanupTx(this.m_writer);
            this.m_writer = null;
            this.m_notCommitted = false;
        }
        return this.m_destPath;
    }

    public long getSize() {
        return this.m_size;
    }

    public void destroy() throws SDKException {
        if (this.m_writer != null) {
            FileTxHelper.releaseTx(this.m_writer);
            this.m_writer = null;
            this.m_notCommitted = false;
            this.m_stream = null;
        }
    }

    public void uploadContent() throws SDKException {
        if (this.m_stream != null) {
            try {
                this.m_size += FileTxHelper.putStream(this.m_stream, this.m_writer);
                this.m_stream = null;
            }
            catch (IOException e) {
                throw new SDKException.FileWrite(this.m_destPath, e);
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_destPath);
        ORB orb = ServiceMgrFactory.getServiceMgr().getORB();
        out.writeObject(orb.object_to_string((Object)this.m_writer));
        out.writeBoolean(this.m_notCommitted);
        out.writeLong(this.m_size);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_destPath = (String)in.readObject();
        String writerStr = (String)in.readObject();
        ORB orb = ServiceMgrFactory.getServiceMgr().getORB();
        this.m_writer = FileSeqWriterHelper.narrow((Object)orb.string_to_object(writerStr));
        this.m_notCommitted = in.readBoolean();
        this.m_size = in.readLong();
        this.m_stream = null;
    }

    public String serialize() {
        if (this.m_writer == null) {
            return null;
        }
        ORB orb = ServiceMgrFactory.getServiceMgr().getORB();
        return orb.object_to_string((Object)this.m_writer);
    }
}

