/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.filerepository.internal;

import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAftp.FileSeqReader;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.filerepository.internal.FileTxHelper;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileRepositoryObject;
import com.crystaldecisions.sdk.occa.filerepository.internal.IStreamingSupport;

public class StreamingSupport
implements IStreamingSupport {
    private FileSeqReader m_reader;
    private long m_count;
    private IFileRepositoryObject m_frsObject;

    public StreamingSupport(FileSeqReader reader, IFileRepositoryObject frsObject) {
        this.m_reader = reader;
        this.m_frsObject = frsObject;
        this.m_count = 0L;
    }

    public boolean hasNext() throws SDKException {
        long total = this.m_frsObject.getSize();
        return total - this.m_count > 0L;
    }

    public byte[] next() throws SDKException {
        if (this.hasNext()) {
            byte[] stream = FileTxHelper.getStream(this.m_reader);
            this.m_count += (long)stream.length;
            return stream;
        }
        throw new SDKException.EndOfFile();
    }

    public void close() throws SDKException {
        if (this.m_reader != null) {
            FileTxHelper.cleanupTx(this.m_reader);
            this.m_reader = null;
        }
    }

    public long getSize() throws SDKException {
        return this.m_frsObject.getSize();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    public long skip(long num) throws SDKException {
        if (this.hasNext()) {
            long nextPosition = this.m_count + num;
            if (nextPosition > this.m_frsObject.getSize()) {
                throw new SDKException.EndOfFile();
            }
            FileTxHelper.seekStream(nextPosition, this.m_reader);
            this.m_count = nextPosition;
            return nextPosition;
        }
        throw new SDKException.EndOfFile();
    }
}

