/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore;

import com.crystaldecisions.sdk.occa.infostore.IRightIDBase;
import com.crystaldecisions.sdk.occa.infostore.RightsSortCriterion;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSortHelper;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RightsSortCriteria
extends AbstractList
implements List {
    private List m_criteria = new ArrayList();
    private Locale m_locale;
    private ISortHelper m_helper;
    private static ISortHelper s_defaultSortHelper = new AbstractSortHelper(){};
    private Map m_criteriaIndexMap = new HashMap();

    public RightsSortCriteria() {
        this.m_helper = s_defaultSortHelper;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setHelper(ISortHelper helper) {
        this.m_helper = helper;
    }

    public ISortHelper getHelper() {
        return this.m_helper;
    }

    public RightsSortCriterion add(int sortIndex, int sortType) {
        RightsSortCriterion newCriterion = new RightsSortCriterion(sortIndex, sortType);
        this.m_criteria.add(newCriterion);
        this.m_criteriaIndexMap.put(new Integer(sortIndex), newCriterion);
        return newCriterion;
    }

    public RightsSortCriterion getBySortIndex(int sortIndex) {
        return (RightsSortCriterion)this.m_criteriaIndexMap.get(new Integer(sortIndex));
    }

    public RightsSortCriterion removeBySortIndex(int sortIndex) {
        RightsSortCriterion entry = (RightsSortCriterion)this.m_criteriaIndexMap.get(new Integer(sortIndex));
        if (entry != null) {
            this.m_criteria.remove(entry);
        }
        return entry;
    }

    public Object get(int index) {
        return this.m_criteria.get(index);
    }

    public int size() {
        return this.m_criteria.size();
    }

    public Object remove(int index) {
        RightsSortCriterion entry = (RightsSortCriterion)this.m_criteria.get(index);
        if (entry != null) {
            this.m_criteriaIndexMap.remove(new Integer(entry.getSortIndex()));
        }
        return this.m_criteria.remove(index);
    }

    public String toString() {
        String ret = "";
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ret = ret + iter.next() + ";";
        }
        return ret;
    }

    public static interface ISortHelper {
        public int sort(IRightIDBase var1, IRightIDBase var2, RightsSortCriterion var3, Locale var4);
    }
}

