/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.misc.ObjectUtils;
import com.crystaldecisions.sdk.occa.infostore.IEffectiveRight;
import com.crystaldecisions.sdk.occa.infostore.IExplicitRight;
import com.crystaldecisions.sdk.occa.infostore.IRightBase;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRightIDBase;
import com.crystaldecisions.sdk.occa.infostore.IRightsView;
import com.crystaldecisions.sdk.occa.infostore.RightsFilterCriteria;
import com.crystaldecisions.sdk.occa.infostore.RightsFilterCriterion;
import com.crystaldecisions.sdk.occa.security.internal.SecurityValidator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;

public abstract class AbstractFilterHelper
implements RightsFilterCriteria.IFilterHelper {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.AbstractFilterHelper");

    public boolean filter(IRightIDBase right, RightsFilterCriterion criterion, Locale locale) {
        boolean isEqualOp;
        int index = criterion.getFilterIndex();
        int operator = criterion.getOperator();
        Object value = criterion.getValue();
        boolean bl = isEqualOp = operator == 0 || operator == 2;
        if (isEqualOp || operator == 1 || operator == 3) {
            boolean isEquals = AbstractFilterHelper.matches(right, index, value, locale);
            return isEqualOp == isEquals;
        }
        return false;
    }

    public boolean isUnspecifiedRightsIncludeTypeSpecific() {
        return false;
    }

    private static boolean matches(IRightIDBase right, int index, Object value, Locale locale) {
        IRightID rightInfo = null;
        if (right instanceof IRightID) {
            rightInfo = (IRightID)right;
        }
        IRightBase specifiedRight = null;
        if (right instanceof IRightBase) {
            specifiedRight = (IRightBase)right;
        }
        boolean isEquals = false;
        switch (index) {
            case 1: {
                isEquals = AbstractFilterHelper.matches(new Integer(right.getBaseID()), value);
                break;
            }
            case 0: {
                isEquals = AbstractFilterHelper.matches(new Integer(right.getID()), value);
                break;
            }
            case 3: {
                isEquals = AbstractFilterHelper.matches(new Boolean(right.isOwner()), value);
                break;
            }
            case 2: {
                isEquals = AbstractFilterHelper.matchPluginType(right.getRightPluginType(), right.getRightPluginKind(), value);
                break;
            }
            case 6: 
            case 9: {
                isEquals = AbstractFilterHelper.matchIRightID(rightInfo, index, value, locale);
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                isEquals = AbstractFilterHelper.matchIRightBase(specifiedRight, index, value, locale);
                break;
            }
            case 7: {
                if (specifiedRight != null) {
                    isEquals = AbstractFilterHelper.matchIRightBase(specifiedRight, index, value, locale);
                    break;
                }
                if (rightInfo == null) break;
                isEquals = AbstractFilterHelper.matches(IRightsView.RightState.UNSPECIFIED, value);
                break;
            }
            case 8: {
                if (rightInfo != null) {
                    isEquals = AbstractFilterHelper.matchIRightID(rightInfo, index, value, locale);
                    break;
                }
                isEquals = AbstractFilterHelper.matchIRightBase(specifiedRight, index, value, locale);
                break;
            }
            default: {
                isEquals = false;
            }
        }
        return isEquals;
    }

    private static boolean matches(Object lValue, Object rValue) {
        Collection collection;
        if (ObjectUtils.equals((Object)lValue, (Object)rValue)) {
            return true;
        }
        return rValue instanceof Collection && (collection = (Collection)rValue).contains(lValue);
    }

    private static boolean matchesIgnoreCase(String lValue, Object rValue) {
        if (rValue instanceof String) {
            return ObjectUtils.equalsIgnoreCase((String)lValue, (String)((String)rValue));
        }
        if (rValue instanceof Collection) {
            Collection collection = (Collection)rValue;
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (!AbstractFilterHelper.matchesIgnoreCase(lValue, iter.next())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean matchPluginType(int type, String kind, Object rType) {
        if (rType instanceof Integer) {
            return type == (Integer)rType;
        }
        if (rType instanceof String) {
            boolean specificType;
            boolean bl = specificType = type > 0;
            if (specificType != AbstractFilterHelper.isSpecificType(rType)) {
                return false;
            }
            if (!specificType) {
                return true;
            }
            return ObjectUtils.equalsIgnoreCase((String)kind, (String)((String)rType));
        }
        if (rType instanceof Collection) {
            Iterator iter = ((Collection)rType).iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (!AbstractFilterHelper.matchPluginType(type, kind, next)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSpecificType(Object type) {
        return !SecurityValidator.isEmptyType(type) && (!(type instanceof String) || !"Any".equalsIgnoreCase((String)type));
    }

    private static boolean matchIRightBase(IRightBase right, int index, Object value, Locale locale) {
        if (right == null) {
            return value == null;
        }
        boolean isEquals = false;
        switch (index) {
            case 5: {
                isEquals = AbstractFilterHelper.matchPluginType(right.getApplicableType(), right.getApplicableKind(), value);
                break;
            }
            case 8: {
                isEquals = AbstractFilterHelper.matchesIgnoreCase(right.getDescription(locale), value);
                break;
            }
            case 4: {
                isEquals = AbstractFilterHelper.matchesIgnoreCase(right.getScope(), value);
                break;
            }
            case 7: {
                isEquals = AbstractFilterHelper.matches(AbstractFilterHelper.getRightState(right), value);
                break;
            }
            case 10: {
                isEquals = AbstractFilterHelper.matches(new Boolean(AbstractFilterHelper.isInherited(right)), value);
                break;
            }
            default: {
                isEquals = false;
            }
        }
        return isEquals;
    }

    private static boolean matchIRightID(IRightID right, int index, Object value, Locale locale) {
        if (right == null) {
            return value == null;
        }
        boolean isEquals = false;
        switch (index) {
            case 6: {
                isEquals = AbstractFilterHelper.matchesIgnoreCase(right.getCollection(locale), value);
                break;
            }
            case 9: {
                isEquals = AbstractFilterHelper.matchesIgnoreCase(right.getCategory(locale), value);
                break;
            }
            case 8: {
                isEquals = AbstractFilterHelper.matchesIgnoreCase(right.getDescription(locale), value);
            }
        }
        return isEquals;
    }

    static boolean isInherited(IRightBase right) {
        if (right instanceof IExplicitRight) {
            return false;
        }
        if (right instanceof IEffectiveRight) {
            IEffectiveRight right_ef = (IEffectiveRight)right;
            if (right.isSpecified() && !right_ef.isInherited()) {
                return false;
            }
        }
        return true;
    }

    static Integer getRightState(IRightBase right) {
        Integer state = IRightsView.RightState.UNSPECIFIED;
        if (right.isSpecified()) {
            state = right.isGranted() ? IRightsView.RightState.GRANTED : IRightsView.RightState.DENIED;
        }
        return state;
    }
}

