/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.RightDescriptor;
import com.crystaldecisions.sdk.occa.infostore.RightIDDescriptor;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRightID;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecUpdateEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.RightID;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.SecurityValidator;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Locale;

abstract class AbstractRight2
extends RightID {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.AbstractRight2");
    protected boolean m_dirty;
    protected boolean m_exists;
    protected String m_objType;
    protected String m_rightScope;
    protected List m_sources;
    private int m_applicableType = -1;
    private Object m_catType;
    protected AbstractSecEventListener m_loadListener;

    protected AbstractRight2() {
    }

    public AbstractRight2(int id, String description, String category, int collection, IPluginMgr pluginMgr, ISecEventListener eventListener) {
        this(id, description, category, collection, "", "", null, pluginMgr, eventListener);
    }

    public AbstractRight2(int id, String description, String category, int collection, String objType, String rightScope, List sources, IPluginMgr pluginMgr, ISecEventListener eventListener) {
        super(id, description, category, collection);
        this.m_objType = objType;
        this.m_sources = sources;
        this.m_rightScope = rightScope;
        this.m_exists = true;
        this.setPluginMgr(pluginMgr);
        this.makeListener(eventListener);
        if (description != null && !description.equals("")) {
            this.m_loadListener.setLoaded(0);
        }
    }

    protected void makeListener(ISecEventListener eventListener) {
        this.m_loadListener = new AbstractSecEventListener(){

            public void update(ISecUpdateEvent event) throws SDKException {
                IRightID[] knownRights;
                int eventId;
                if (event != null && (eventId = event.getType()) == 0 && (knownRights = event.getKnownRights()) != null && knownRights.length > 0) {
                    for (int i = 0; i < knownRights.length; ++i) {
                        IRightID knownRight = knownRights[i];
                        if (!(knownRight instanceof IPersistRightID) || knownRight.getID() != AbstractRight2.this.getID()) continue;
                        IPersistRightID persistID = (IPersistRightID)knownRight;
                        AbstractRight2.this.setDescriptionID(persistID.getDescriptionID());
                        break;
                    }
                }
            }
        };
        this.m_loadListener.setParent(eventListener);
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public boolean isSpecified() {
        return this.m_exists;
    }

    public void setSpeficied(boolean specified) {
        this.m_exists = specified;
    }

    public List getSources() {
        return this.m_sources;
    }

    public String getObjectType() {
        return this.m_objType;
    }

    public String getApplicableKind() {
        return this.m_objType;
    }

    public int getApplicableType() {
        if (this.m_applicableType < 0) {
            try {
                this.m_applicableType = SecurityValidator.getRightTypeID(this.getPluginMgr(), this.m_objType);
            }
            catch (SDKException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("AbstractRight2.getApplicableType: failed to get applicable type from kind " + this.m_objType), (Throwable)((Object)e));
                }
                this.m_applicableType = 0;
            }
        }
        return this.m_applicableType;
    }

    public String getScope() {
        return this.m_rightScope;
    }

    protected RightDescriptor getRightDescriptor() {
        return new RightDescriptor(this.getBaseID(), this.getRightPluginKind(), this.isOwner(), this.m_rightScope, this.m_objType);
    }

    protected RightIDDescriptor getRightID() {
        return new RightIDDescriptor(this.getBaseID(), this.getRightPluginKind(), this.isOwner());
    }

    void initFromSerialization(ISecEventListener parentListener) {
        if (this.m_loadListener == null) {
            this.makeListener(parentListener);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.m_dirty);
        out.writeObject(this.m_rightScope);
        out.writeObject(this.m_objType);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.m_dirty = in.readBoolean();
        this.m_rightScope = (String)in.readObject();
        this.m_objType = (String)in.readObject();
    }

    protected void update(AbstractRight2 right) {
        this.m_rightScope = right.getScope();
        this.m_objType = right.getObjectType();
    }

    protected void serializeHelper(PropertyBag bag) {
        super.serializeHelper(bag);
        bag.addItem((Object)PropertyIDs.SI_TYPE, (Object)this.m_objType, 0);
        bag.addItem((Object)PropertyIDs.SI_SCOPE, (Object)this.m_rightScope, 0);
    }

    abstract void saveRights(ISecRightsAdmin var1, int var2, int var3) throws SDKException;

    public String getDescription(Locale locale) {
        String description;
        block5: {
            AbstractSecEventListener.ensureDelayedLoad(0, this.m_loadListener);
            description = null;
            String descID = this.getDescriptionID();
            if (descID != null && descID.length() != 0) {
                try {
                    IPluginInfo info;
                    Object type = this.getCategoryType();
                    if (AbstractRight2.isSpecificType(type) && (info = this.getPluginMgr().getPluginInfo(type)) != null && (description = info.getStringDescription(descID, locale)) != null) {
                        return description;
                    }
                }
                catch (SDKException e) {
                    if (!LOG.isWarnEnabled()) break block5;
                    LOG.warn((Object)("AbstractRight2 getDescription: Couldn't get plugininfo for " + this.getCategoryType()));
                }
            }
        }
        if (description != null) {
            return description;
        }
        return super.getDescription(locale);
    }

    public String getDescriptionID() {
        AbstractSecEventListener.ensureDelayedLoad(0, this.m_loadListener);
        return super.getDescriptionID();
    }

    public String getCategory(Locale locale) {
        return super.getCategory(locale, this.getCategoryType());
    }

    public int getCollectionID() {
        return super.getCollectionID(this.getCategoryType());
    }

    public String getCollection(Locale locale) {
        return super.getCollection(locale, this.getCategoryType());
    }

    Object getCategoryType() {
        if (this.m_catType == null) {
            this.m_catType = this.getApplicableKind();
            if (this.getRightPluginType() > 0) {
                this.m_catType = new Integer(this.getRightPluginType());
            }
        }
        return this.m_catType;
    }
}

