/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.IBagPacker;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.IPropertyChangeListener;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.stringhandler.StringHandler;
import com.crystaldecisions.celib.stringhandler.StringHandlerFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.info_wire_ob3;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.exception.internal.ServerMsgResourcesBundle;
import com.crystaldecisions.sdk.occa.infostore.IFiles;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.IProcessingInfo;
import com.crystaldecisions.sdk.occa.infostore.ISchedulable;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo2;
import com.crystaldecisions.sdk.occa.infostore.ISortDimension;
import com.crystaldecisions.sdk.occa.infostore.ISupportJobServer;
import com.crystaldecisions.sdk.occa.infostore.SearchPattern;
import com.crystaldecisions.sdk.occa.infostore.SortType;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSendableObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRights;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStoreFactory;
import com.crystaldecisions.sdk.occa.infostore.internal.ProcessingInfo;
import com.crystaldecisions.sdk.occa.infostore.internal.QuerySettings;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractSchedulableObject
extends AbstractSendableObject
implements ISchedulable,
IInfoObject,
IPersistInfoObject,
IPersistRights,
ISupportJobServer {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.AbstractSchedulableObject");
    private ProcessingInfo m_processingInfo;
    private static final StringHandler s_encryptor = StringHandlerFactory.getDefaultStringHandler();

    protected AbstractSchedulableObject() {
        IPropertyChangeListener jobListener = new IPropertyChangeListener(){

            public void propertyChange(Property p) {
                AbstractSchedulableObject.this.setFlag(524288);
                AbstractSchedulableObject.this.getRootBag().getItem(PropertyIDs.SI_PROCESSINFO).propertyChange(p);
            }
        };
        this.m_processingInfo = new ProcessingInfo((SDKPropertyBag)this.getRootBag().addPropertyBag(PropertyIDs.SI_PROCESSINFO, jobListener).getPropertyBag());
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        IBagUnpacker unpacker = this.getUnpacker();
        unpacker.initialize((Object)"");
        this.m_processingInfo.merge(unpacker);
        this.m_processingInfo.setStringHandler(s_encryptor);
    }

    public void useAsDelegate(IInternalInfoObject obj) {
        super.useAsDelegate(obj);
        IProcessingInfo processingInfo = obj.getProcessingInfo();
        if (processingInfo != null) {
            this.m_processingInfo = (ProcessingInfo)processingInfo;
        }
    }

    public void cleanupChanges() {
        super.cleanupChanges();
        this.m_processingInfo.cleanupChanges();
        this.clearFlag(0x800000);
    }

    public void unpack(ISecuritySession session, IInfoObjects collection, info_wire_ob3 obj) {
        super.unpack(session, collection, obj);
        IBagUnpacker unpacker = this.getUnpacker();
        unpacker.initialize((Object)obj.processingInfo);
        this.m_processingInfo.unpack(unpacker);
        this.m_processingInfo.setStringHandler(s_encryptor);
    }

    public void merge(info_wire_ob3 wireObj) {
        super.merge(wireObj);
        IBagUnpacker unpacker = this.getUnpacker();
        unpacker.initialize((Object)wireObj.processingInfo);
        this.m_processingInfo.merge(unpacker);
    }

    public IProcessingInfo getProcessingInfo() {
        return this.m_processingInfo;
    }

    public String getGUID() throws SDKException {
        return super.getGUID();
    }

    public String getCUID() throws SDKException {
        return super.getCUID();
    }

    public String getRUID() throws SDKException {
        return super.getRUID();
    }

    private void prepareCommit() throws SDKException {
        if (!this.isNew() && this.m_processingInfo.isDirty()) {
            this.setFlag(0x800000);
        }
        this.checkFilesBag();
        LOG.debug((Object)"exit: prepareCommit()");
    }

    private void prepareSchedule() {
        this.checkFilesBag();
        this.m_processingInfo.touchAll();
        LOG.debug((Object)"exit: prepareSchedule()");
    }

    private void checkFilesBag() {
        IProperty filesProp = this.properties().getProperty(PropertyIDs.SI_FILES);
        if (filesProp != null) {
            if (this.isNew()) {
                LOG.info((Object)"checkFilesBag(): new object, copying SI_FILES");
                if (this.m_processingInfo.properties().getProperty(PropertyIDs.SI_FILES) == null) {
                    this.m_processingInfo.properties().setProperty((Object)PropertyIDs.SI_FILES, ((PropertyBag)filesProp.getValue()).copy());
                }
            } else {
                Object value = filesProp.getValue();
                if (value instanceof PropertyBag && ((PropertyBag)value).isDirty()) {
                    LOG.info((Object)"checkFilesBag(): SI_FILES is dirty, copying");
                    this.m_processingInfo.properties().setProperty((Object)PropertyIDs.SI_FILES, ((PropertyBag)filesProp.getValue()).copy());
                }
            }
        }
        LOG.debug((Object)"exit: checkFilesBag()");
    }

    public void copy(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, IInfoObject source, int mode) throws SDKException {
        super.copy(session, collection, id, source, mode);
    }

    public void delete() {
        super.delete();
    }

    public void setInstanceOperationFlag() {
        super.setInstanceOperationFlag();
    }

    public void saveRights2(ISecRightsAdmin rightsAdmin) throws SDKException {
        super.saveRights2(rightsAdmin);
    }

    public String getDescription() {
        return super.getDescription();
    }

    public void setDescription(String desc) {
        super.setDescription(desc);
    }

    public int getID() {
        return super.getID();
    }

    public boolean isInstance() {
        return super.isInstance();
    }

    public int getParentID() {
        return super.getParentID();
    }

    public Integer[] propertyIDs() {
        return super.propertyIDs();
    }

    public IProperties properties() {
        return super.properties();
    }

    public ISecurityInfo getSecurityInfo() {
        return super.getSecurityInfo();
    }

    public String getTitle() {
        return super.getTitle();
    }

    public void setTitle(String title) {
        super.setTitle(title);
    }

    public IFiles getFiles() throws SDKException {
        return super.getFiles();
    }

    public String getProgID() throws SDKException {
        return super.getProgID();
    }

    public String getParentCUID() throws SDKException {
        return super.getParentCUID();
    }

    public boolean isDeepCopySupported() {
        return super.isDeepCopySupported();
    }

    public void setParentID(int parentId) {
        super.setParentID(parentId);
    }

    public void update(ISecuritySession session, IInfoObject source) throws SDKException {
        super.update(session, source);
    }

    protected Set getCorporateCategories() throws SDKException {
        return super.getCorporateCategories();
    }

    protected Set getPersonalCategories() throws SDKException {
        return super.getPersonalCategories();
    }

    public IInfoObjectEventListener getInfoObjectEventListener(int type) {
        final IInfoObjectEventListener superListener = super.getInfoObjectEventListener(type);
        if (type == 2) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    AbstractSchedulableObject.this.prepareCommit();
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        if (type == 3) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    AbstractSchedulableObject.this.prepareSchedule();
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        return superListener;
    }

    public IInfoObjects getInstances() throws SDKException {
        return this.getInstances(1, null, null);
    }

    public IInfoObjects getInstances(int propertySet, SearchPattern searchPattern, SortType sortType) throws SDKException {
        if (propertySet != 7 && propertySet != 1 && propertySet != 4 && propertySet != 2) {
            throw new SDKException.InvalidArg("propertySet");
        }
        SearchPattern mySearch = new SearchPattern(searchPattern);
        mySearch.setParentID(this.getID());
        SortType mySort = new SortType(sortType);
        if (!mySort.contains(ISortDimension.UPDATE_TS_ASC) && !mySort.contains(ISortDimension.UPDATE_TS_DESC)) {
            mySort.addSortDimension(ISortDimension.UPDATE_TS_DESC);
        }
        String whereClause = QuerySettings.generateWhereClause(mySearch);
        whereClause = whereClause + " AND (SI_INSTANCE = 1)";
        IInternalInfoStore infoStore = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA(this.getSession().getAPSName(), this.getSession());
        QuerySettings query = new QuerySettings(infoStore, "CI_INFOOBJECTS,CI_APPOBJECTS,CI_SYSTEMOBJECTS", QuerySettings.ToFields(propertySet), whereClause, QuerySettings.getOrderClause(mySort));
        return query.executeQuery();
    }

    public IInfoObject getLatestInstance() throws SDKException {
        return this.getLatestInstance(1, null);
    }

    public IInfoObject getLatestInstance(int propertySet, SearchPattern searchPattern) throws SDKException {
        if (propertySet != 7 && propertySet != 1 && propertySet != 4 && propertySet != 2) {
            throw new SDKException.InvalidArg("propertySet");
        }
        SearchPattern mySearch = new SearchPattern(searchPattern);
        mySearch.setParentID(this.getID());
        SortType mySort = new SortType();
        mySort.addSortDimension(ISortDimension.UPDATE_TS_DESC);
        String sort = QuerySettings.getOrderClause(mySort);
        IInternalInfoStore infoStore = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA(this.getSession().getAPSName(), this.getSession());
        QuerySettings query = new QuerySettings(infoStore, "CI_INFOOBJECTS, CI_APPOBJECTS, CI_SYSTEMOBJECTS", QuerySettings.ToFields(propertySet), QuerySettings.generateWhereClause(mySearch), sort, 1);
        IInfoObjects objs = query.executeQuery();
        if (objs.size() == 0) {
            return null;
        }
        return (IInfoObject)objs.get(0);
    }

    public void schedule() throws SDKException {
        IInternalInfoStore infoStore = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA(this.getSession().getAPSName(), this.getSession());
        IInfoObjects objs = infoStore.newInfoObjectCollection();
        ((InfoObjects)objs).add(this);
        infoStore.schedule(objs);
    }

    public String formatJobServerError(Locale locale, IProperties errorBag) {
        String errorMsg;
        IProperty substStrings;
        boolean foundID;
        IProperty resourceID = errorBag.getProperty(PropertyIDs.SI_RESOURCE_ID);
        if (resourceID == null) {
            throw new SDKRuntimeException.PropertyNotFound(PropertyIDs.SI_RESOURCE_ID);
        }
        String id = resourceID.getValue().toString();
        String pattern = ServerMsgResourcesBundle.getString(id, locale);
        boolean bl = foundID = pattern != null;
        if (!foundID) {
            pattern = ServerMsgResourcesBundle.getMissingResourcePattern(locale);
        }
        if ((substStrings = errorBag.getProperty(PropertyIDs.SI_SUBST_STRINGS)) == null) {
            errorMsg = foundID ? pattern : MessageFormat.format(pattern, id, "");
        } else {
            Object value = substStrings.getValue();
            if (value instanceof PropertyBag) {
                PropertyArrayHelper substArray = new PropertyArrayHelper((PropertyBag)value, PropertyIDs.SI_TOTAL);
                Object[] argArray = new Object[substArray.size()];
                Iterator e = substArray.iterator();
                int i = 0;
                while (e.hasNext()) {
                    Object nextArg = e.next();
                    argArray[i] = nextArg instanceof IProperties ? this.formatJobServerError(locale, (IProperties)nextArg) : nextArg;
                    ++i;
                }
                errorMsg = foundID ? MessageFormat.format(pattern, argArray) : MessageFormat.format(pattern, id, AbstractSchedulableObject.concatenateStrings(argArray));
            } else {
                errorMsg = foundID ? MessageFormat.format(pattern, value.toString()) : MessageFormat.format(pattern, id, value.toString());
            }
        }
        return errorMsg;
    }

    public void setCommitLevel(int cl) throws SDKException {
        super.setCommitLevel(cl);
    }

    public int getCommitLevel() {
        return super.getCommitLevel();
    }

    private static String concatenateStrings(Object[] strings) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < strings.length; ++i) {
            Object string = strings[i];
            buf.append(string.toString());
        }
        return buf.toString();
    }

    public void initFromSerialization(ISecuritySession session, String packedRootProps, String packedSerProps, IFiles files, ISecurityInfo securityInfo, ISecurityInfo2 securityInfo2) throws SDKException {
        super.initFromSerialization(session, packedRootProps, packedSerProps, files, securityInfo, securityInfo2);
        PropertyBag mainBag = ((Property)this.m_rootBag.get(PropertyIDs.SI_MAINBAG)).getPropertyBag();
        SDKPropertyBag processingBag = (SDKPropertyBag)mainBag.getPropertyBag((Object)PropertyIDs.SI_PROCESSINFO);
        if (processingBag != null) {
            IBagPacker packer = this.getPacker();
            char[] packedProcessInfo = packer.packToChar((PropertyBag)processingBag, 0, 0, false, 0, 0);
            IBagUnpacker unpacker = this.getUnpacker();
            unpacker.initialize((Object)packedProcessInfo);
            this.m_processingInfo.unpack(unpacker);
            mainBag.removeLocal((Object)PropertyIDs.SI_PROCESSINFO);
        }
        this.m_processingInfo.setStringHandler(s_encryptor);
    }
}

