/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecLoadEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecUpdateEvent;

abstract class AbstractSecEventListener
implements ISecEventListener {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecEventListener");
    private ISecEventListener m_parentEventListener;
    private boolean[] m_loaded = new boolean[2];
    protected static ISecLoadEvent[] s_loadEvents = new ISecLoadEvent[2];

    protected AbstractSecEventListener() {
        this.m_loaded[1] = false;
        this.m_loaded[0] = false;
    }

    public void setParent(ISecEventListener parentEventListener) {
        this.m_parentEventListener = parentEventListener;
    }

    public ISecUpdateEvent load(ISecLoadEvent event) throws SDKException {
        ISecUpdateEvent updateEvent = null;
        if (this.m_parentEventListener != null) {
            updateEvent = this.m_parentEventListener.load(event);
        }
        if (updateEvent != null && !this.isLoaded(event.getType())) {
            this.update(updateEvent);
            this.setLoaded(event.getType());
        }
        return updateEvent;
    }

    public void update(ISecUpdateEvent event) throws SDKException {
    }

    protected boolean isLoaded(int type) {
        if (type >= 0 && type < this.m_loaded.length) {
            return this.m_loaded[type];
        }
        return false;
    }

    protected void setLoaded(int type) {
        if (type >= 0 && type < this.m_loaded.length) {
            this.m_loaded[type] = true;
        }
    }

    static void ensureDelayedLoad(int type, ISecEventListener eventListener) {
        block2: {
            try {
                eventListener.load(s_loadEvents[type]);
            }
            catch (SDKException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)("Failed to load security info " + type), (Throwable)((Object)e));
            }
        }
    }

    static {
        AbstractSecEventListener.s_loadEvents[1] = new ISecLoadEvent(){

            public int getType() {
                return 1;
            }
        };
        AbstractSecEventListener.s_loadEvents[0] = new ISecLoadEvent(){

            public int getType() {
                return 0;
            }
        };
    }
}

