/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.IBagPacker;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.IPropertyChangeListener;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.info_wire_ob3;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.occa.infostore.CePropertyID;
import com.crystaldecisions.sdk.occa.infostore.IDeliverToInboxPrincipals;
import com.crystaldecisions.sdk.occa.infostore.IDestination;
import com.crystaldecisions.sdk.occa.infostore.IDestinations;
import com.crystaldecisions.sdk.occa.infostore.IFiles;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.ISchedulingInfo;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo2;
import com.crystaldecisions.sdk.occa.infostore.ISendable;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.DeliverToInboxPrincipals;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRights;
import com.crystaldecisions.sdk.occa.infostore.internal.ISendableInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.SchedulingInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.pluginmgr.internal.PluginMgrFactory;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.IRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import java.util.Set;

public abstract class AbstractSendableObject
extends InfoObject
implements IInfoObject,
IPersistInfoObject,
ISendableInfoObject,
IPersistRights,
ISendable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.AbstractSendableObject");
    private SchedulingInfo m_schedulingInfo;

    protected AbstractSendableObject() {
        IPropertyChangeListener jobListener = new IPropertyChangeListener(){

            public void propertyChange(Property p) {
                AbstractSendableObject.this.setFlag(524288);
                AbstractSendableObject.this.getRootBag().getItem(PropertyIDs.SI_SCHEDULEINFO).propertyChange(p);
            }
        };
        this.m_schedulingInfo = new SchedulingInfo((SDKPropertyBag)this.getRootBag().addPropertyBag(PropertyIDs.SI_SCHEDULEINFO, jobListener).getPropertyBag());
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.m_schedulingInfo.initialize(this, session, true);
    }

    public void cleanupChanges() {
        super.cleanupChanges();
        this.m_schedulingInfo.cleanupChanges();
        this.clearFlag(0x800000);
    }

    public void unpack(ISecuritySession session, IInfoObjects collection, info_wire_ob3 obj) {
        super.unpack(session, collection, obj);
        IBagUnpacker unpacker = this.getUnpacker();
        unpacker.initialize((Object)obj.scheduleInfo);
        this.m_schedulingInfo.unpack(unpacker, this, session);
    }

    public void useAsDelegate(IInternalInfoObject obj) {
        super.useAsDelegate(obj);
        ISchedulingInfo scheInfo = obj.getSchedulingInfo();
        if (scheInfo != null) {
            this.m_schedulingInfo = (SchedulingInfo)scheInfo;
        }
    }

    public void merge(info_wire_ob3 wireObj) {
        super.merge(wireObj);
        IBagUnpacker unpacker = this.getUnpacker();
        unpacker.initialize((Object)wireObj.scheduleInfo);
        this.m_schedulingInfo.merge(unpacker);
    }

    public ISchedulingInfo getSchedulingInfo() {
        return this.m_schedulingInfo;
    }

    public String getGUID() throws SDKException {
        return super.getGUID();
    }

    public String getCUID() throws SDKException {
        return super.getCUID();
    }

    public String getRUID() throws SDKException {
        return super.getRUID();
    }

    private void prepareCommit() throws SDKException {
        if (!this.isNew() && this.m_schedulingInfo.isDirty()) {
            this.setFlag(0x800000);
        }
        this.m_schedulingInfo.prepareCommit();
        LOG.debug((Object)"exit: prepareCommit()");
    }

    private void prepareSchedule() throws SDKException {
        this.m_schedulingInfo.prepareSchedule();
        LOG.debug((Object)"exit: prepareSchedule()");
    }

    private void prepareSendTo() throws SDKException {
        this.m_schedulingInfo.prepareSendTo();
        if (!AbstractSendableObject.isDestinationSupported(this, this.getSession())) {
            throw new SDKException.InvalidOperation();
        }
        this.setProperty((Object)CePropertyID.SI_PROGID_MACHINE, "CrystalEnterprise.Destination");
        this.setParentID(49);
    }

    private void prepareDeliveryToInbox() throws SDKException {
        this.setParentID(60);
        LOG.debug((Object)"exit: prepareDeliveryToInbox()");
    }

    public static boolean isDestinationSupported(IInfoObject infoObject, ISecuritySession session) throws SDKException {
        ISendableInfoObject persistInfoObject = (ISendableInfoObject)((Object)infoObject);
        if (!persistInfoObject.isUnmanagedDestinationSupported()) {
            IDestination dest = null;
            ISchedulingInfo sinfo = infoObject.getSchedulingInfo();
            try {
                dest = sinfo.getDestination();
            }
            catch (SDKRuntimeException.DeprecatedMethodAccessed e) {
                IDestinations dests = infoObject.getSchedulingInfo().getDestinations();
                int size = dests.size();
                if (size > 0) {
                    dest = (IDestination)dests.get(0);
                }
                return false;
            }
            if (!AbstractSendableObject.isSMTPLinkDestination(dest)) {
                String progID = dest.getName();
                IPluginMgr mgr = (IPluginMgr)PluginMgrFactory.getFactory().makeOCCA("", session);
                IPluginInfo info = mgr.getPluginInfo(progID);
                if (!info.isManagedDestination()) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isUnmanagedDestinationSupported() {
        return false;
    }

    private static boolean isSMTPLinkDestination(IDestination dest) {
        String destProgID = dest.getName();
        if ("CrystalEnterprise.Smtp".equalsIgnoreCase(destProgID)) {
            IProperties destProperties = dest.properties();
            if (destProperties != null) {
                IProperties scheduleOptions;
                IProperty isAttachmentEnabledProp;
                IProperty scheduleOptionsProp = destProperties.getProperty(PropertyIDs.SI_DEST_SCHEDULEOPTIONS);
                if (scheduleOptionsProp == null) {
                    scheduleOptionsProp = destProperties.add(PropertyIDs.SI_DEST_SCHEDULEOPTIONS, null, 0x8000000);
                }
                if ((isAttachmentEnabledProp = (scheduleOptions = (IProperties)scheduleOptionsProp.getValue()).getProperty(PropertyIDs.SI_SMTP_ENABLEATTACHMENTS)) != null && isAttachmentEnabledProp.getValue() != null) {
                    Boolean isAttachmentEnabled = (Boolean)isAttachmentEnabledProp.getValue();
                    if (isAttachmentEnabled.booleanValue()) {
                        isAttachmentEnabledProp.setValue(Boolean.FALSE);
                    }
                } else {
                    scheduleOptions.add(PropertyIDs.SI_SMTP_ENABLEATTACHMENTS, Boolean.FALSE, 0);
                }
            }
            return true;
        }
        return false;
    }

    public void copy(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, IInfoObject source, int mode) throws SDKException {
        super.copy(session, collection, id, source, mode);
    }

    public void delete() {
        super.delete();
    }

    public void setInstanceOperationFlag() {
        super.setInstanceOperationFlag();
    }

    public void saveRights(IRightsAdmin rightsAdmin) throws SDKException {
        super.saveRights(rightsAdmin);
    }

    public void saveRights2(ISecRightsAdmin rightsAdmin) throws SDKException {
        super.saveRights2(rightsAdmin);
    }

    public String getDescription() {
        return super.getDescription();
    }

    public void setDescription(String desc) {
        super.setDescription(desc);
    }

    public int getID() {
        return super.getID();
    }

    public boolean isInstance() {
        return super.isInstance();
    }

    public int getParentID() {
        return super.getParentID();
    }

    public Integer[] propertyIDs() {
        return super.propertyIDs();
    }

    public IProperties properties() {
        return super.properties();
    }

    public ISecurityInfo getSecurityInfo() {
        return super.getSecurityInfo();
    }

    public String getTitle() {
        return super.getTitle();
    }

    public void setTitle(String title) {
        super.setTitle(title);
    }

    public IFiles getFiles() throws SDKException {
        return super.getFiles();
    }

    public String getProgID() throws SDKException {
        return super.getProgID();
    }

    public String getParentCUID() throws SDKException {
        return super.getParentCUID();
    }

    public boolean isDeepCopySupported() {
        return super.isDeepCopySupported();
    }

    public void setParentID(int parentId) {
        super.setParentID(parentId);
    }

    public void update(ISecuritySession session, IInfoObject source) throws SDKException {
        super.update(session, source);
    }

    protected Set getCorporateCategories() throws SDKException {
        return super.getCorporateCategories();
    }

    protected Set getPersonalCategories() throws SDKException {
        return super.getPersonalCategories();
    }

    public IInfoObjectEventListener getInfoObjectEventListener(int type) {
        final IInfoObjectEventListener superListener = super.getInfoObjectEventListener(type);
        if (type == 2) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    AbstractSendableObject.this.prepareCommit();
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        if (type == 3) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    AbstractSendableObject.this.prepareSchedule();
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        if (type == 7) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    AbstractSendableObject.this.prepareSendTo();
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        if (type == 10) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    AbstractSendableObject.this.prepareDeliveryToInbox();
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        return superListener;
    }

    public IDestination getSendToDestination() throws SDKException {
        AbstractSendableObject.checkSendable(this, null);
        ISchedulingInfo sinfo = this.getSchedulingInfo();
        IDestination dest = null;
        try {
            dest = sinfo.getDestination();
        }
        catch (SDKRuntimeException.DeprecatedMethodAccessed e) {
            IDestinations dests = sinfo.getDestinations();
            int size = dests.size();
            dest = size > 0 ? (IDestination)dests.get(0) : dests.add("");
        }
        return dest;
    }

    public void initFromSerialization(ISecuritySession session, String packedRootProps, String packedSerProps, IFiles files, ISecurityInfo securityInfo, ISecurityInfo2 securityInfo2) throws SDKException {
        super.initFromSerialization(session, packedRootProps, packedSerProps, files, securityInfo, securityInfo2);
        PropertyBag mainBag = ((Property)this.m_rootBag.get(PropertyIDs.SI_MAINBAG)).getPropertyBag();
        PropertyBag scheduleInfo = mainBag.getPropertyBag((Object)PropertyIDs.SI_SCHEDULEINFO);
        if (scheduleInfo != null) {
            IBagPacker packer = this.getPacker();
            char[] packedScheduleInfo = packer.packToChar(scheduleInfo, 0, 0, false, 0, 0);
            IBagUnpacker unpacker = this.getUnpacker();
            unpacker.initialize((Object)packedScheduleInfo);
            this.m_schedulingInfo.unpack(unpacker, this, session);
            mainBag.removeLocal((Object)PropertyIDs.SI_SCHEDULEINFO);
        } else {
            this.m_schedulingInfo.initialize(this, session, false);
        }
    }

    public IDeliverToInboxPrincipals getDeliverToInboxPrincipals() throws SDKException {
        PropertyBag deliveryToInboxPrinsBag = (PropertyBag)this.properties().getProperties(PropertyIDs.SI_DELIVER_TO_PRINCIPALS, true);
        if (deliveryToInboxPrinsBag == null) {
            deliveryToInboxPrinsBag = (PropertyBag)this.properties().add(PropertyIDs.SI_DELIVER_TO_PRINCIPALS, null, 0x8000000).getValue();
        }
        return new DeliverToInboxPrincipals(deliveryToInboxPrinsBag);
    }
}

