/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.celib.misc.ObjectUtils;
import com.crystaldecisions.sdk.occa.infostore.IRightBase;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRightIDBase;
import com.crystaldecisions.sdk.occa.infostore.RightsSortCriteria;
import com.crystaldecisions.sdk.occa.infostore.RightsSortCriterion;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractFilterHelper;
import java.util.Locale;

public abstract class AbstractSortHelper
implements RightsSortCriteria.ISortHelper {
    public int sort(IRightIDBase r1, IRightIDBase r2, RightsSortCriterion criterion, Locale locale) {
        int result = 0;
        int index = criterion.getSortIndex();
        IRightID rightInfo1 = null;
        IRightID rightInfo2 = null;
        if (r1 instanceof IRightID) {
            rightInfo1 = (IRightID)r1;
        }
        if (r2 instanceof IRightID) {
            rightInfo2 = (IRightID)r2;
        }
        IRightBase specifiedRight1 = null;
        IRightBase specifiedRight2 = null;
        if (r1 instanceof IRightBase) {
            specifiedRight1 = (IRightBase)r1;
        }
        if (r2 instanceof IRightBase) {
            specifiedRight2 = (IRightBase)r2;
        }
        switch (index) {
            case 1: {
                int id1 = r1.getBaseID();
                int id2 = r2.getBaseID();
                result = id1 < id2 ? -1 : (id1 == id2 ? 0 : 1);
                break;
            }
            case 0: {
                int id1 = r1.getID();
                int id2 = r2.getID();
                result = id1 < id2 ? -1 : (id1 == id2 ? 0 : 1);
                break;
            }
            case 3: {
                boolean owner1 = r1.isOwner();
                boolean owner2 = r2.isOwner();
                result = owner1 == owner2 ? 0 : (owner1 ? -1 : 1);
                break;
            }
            case 2: {
                int id1 = r1.getRightPluginType();
                int id2 = r2.getRightPluginType();
                result = id1 < id2 ? -1 : (id1 == id2 ? 0 : 1);
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                result = this.compare(specifiedRight1, specifiedRight2, index, locale);
                break;
            }
            case 6: 
            case 9: {
                result = this.compare(rightInfo1, rightInfo2, index, locale);
                break;
            }
            case 7: {
                if (specifiedRight1 != null || specifiedRight2 != null) {
                    result = this.compare(specifiedRight1, specifiedRight2, index, locale);
                    break;
                }
                return 0;
            }
            case 8: {
                result = rightInfo1 != null && rightInfo2 != null ? this.compare(rightInfo1, rightInfo2, index, locale) : this.compare(specifiedRight1, specifiedRight2, index, locale);
            }
        }
        if (criterion.getSortType() == 1) {
            result = -result;
        }
        return result;
    }

    private int compare(IRightBase r1, IRightBase r2, int index, Locale locale) {
        if (r1 == r2) {
            return 0;
        }
        if (r1 == null) {
            return -1;
        }
        if (r2 == null) {
            return 1;
        }
        int result = 0;
        switch (index) {
            case 5: {
                result = ObjectUtils.compareToIgnoreCase((String)r1.getObjectType(), (String)r2.getObjectType());
                break;
            }
            case 8: {
                result = ObjectUtils.compareToIgnoreCase((String)r1.getDescription(locale), (String)r2.getDescription(locale));
                break;
            }
            case 4: {
                result = ObjectUtils.compareToIgnoreCase((String)r1.getScope(), (String)r2.getScope());
                break;
            }
            case 7: {
                result = ObjectUtils.compareTo((Object)AbstractFilterHelper.getRightState(r1), (Object)AbstractFilterHelper.getRightState(r2));
                break;
            }
            case 10: {
                int inherit1 = this.getInheritance(r1);
                int inherit2 = this.getInheritance(r2);
                result = inherit1 < inherit2 ? -1 : (inherit1 == inherit2 ? 0 : 1);
            }
        }
        return result;
    }

    private int compare(IRightID r1, IRightID r2, int index, Locale locale) {
        if (r1 == r2) {
            return 0;
        }
        if (r1 == null) {
            return -1;
        }
        if (r2 == null) {
            return 1;
        }
        int result = 0;
        switch (index) {
            case 6: {
                result = ObjectUtils.compareToIgnoreCase((String)r1.getCollection(locale), (String)r2.getCollection(locale));
                break;
            }
            case 9: {
                result = ObjectUtils.compareToIgnoreCase((String)r1.getCategory(locale), (String)r2.getCategory(locale));
                break;
            }
            case 8: {
                result = ObjectUtils.compareToIgnoreCase((String)r1.getDescription(locale), (String)r2.getDescription(locale));
            }
        }
        return result;
    }

    private int getInheritance(IRightBase right) {
        return AbstractFilterHelper.isInherited(right) ? 1 : 0;
    }
}

