/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IBatchSecurityItem;
import com.crystaldecisions.sdk.occa.infostore.IBatchSecurityItems;
import com.crystaldecisions.sdk.occa.infostore.internal.BatchSecurityItem;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.pluginmgr.internal.PluginMgrFactory;
import com.crystaldecisions.sdk.occa.security.ISecCacheController;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.SecurityIDs;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

class BatchSecurityItems
extends AbstractList
implements IBatchSecurityItems {
    private List m_items;
    private static final String This_TYPE = "";
    private ISecuritySession m_session;
    private IPluginMgr m_pluginMgr;

    public Object get(int index) {
        return this.m_items.get(index);
    }

    public int size() {
        return this.m_items.size();
    }

    public Object remove(int index) {
        return this.m_items.remove(index);
    }

    BatchSecurityItems(ISecuritySession session) throws SDKException {
        this.m_session = session;
        this.m_pluginMgr = (IPluginMgr)PluginMgrFactory.getFactory().makeOCCA(This_TYPE, this.m_session);
        this.m_items = new ArrayList();
    }

    public IBatchSecurityItem add(int objID, int rightID) throws SDKException {
        BatchSecurityItem item = new BatchSecurityItem(This_TYPE, objID, rightID);
        this.m_items.add(item);
        return item;
    }

    public IBatchSecurityItem add(int objID, int rightID, String kind) throws SDKException {
        IPluginInfo info = this.m_pluginMgr.getPluginInfo(kind);
        BatchSecurityItem item = new BatchSecurityItem(info.getKind(), objID, rightID);
        this.m_items.add(item);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetch() throws SDKException {
        ISecCacheController cache;
        ISecCacheController iSecCacheController = cache = this.m_session.getSecurityInfoMgr().getSecCache();
        synchronized (iSecCacheController) {
            cache.batch(true);
            try {
                for (int i = 0; i < this.m_items.size(); ++i) {
                    IBatchSecurityItem item = (IBatchSecurityItem)this.m_items.get(i);
                    String kind = item.getKind();
                    int rightID = item.getRightID();
                    if (kind != null && kind.length() > 0) {
                        IPluginInfo pluginInfo = this.m_pluginMgr.getPluginInfo(kind);
                        short type = pluginInfo.getType();
                        rightID = SecurityIDs.getAuthenticRightID(rightID, type);
                    }
                    cache.cacheRight(rightID, This_TYPE, item.getObjectID());
                }
                cache.commit();
            }
            catch (SDKException e) {
                cache.rollback();
                throw e;
            }
            catch (Throwable e) {
                cache.rollback();
                SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
                throw sdke;
            }
        }
    }
}

