/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoStorePackage.BatchError;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoStorePackage.BatchErrorHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKServerException;
import com.crystaldecisions.sdk.occa.infostore.ICommitResultInfo;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoStoreException;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Any;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public abstract class CommitResultInfo
implements ICommitResultInfo {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.CommitResultInfo");
    private int m_objID = 0;
    private Set m_objIDs = new HashSet();
    private int m_errCode = 0;
    private String m_cmsMessage = "";
    SDKException m_sdke = null;

    public CommitResultInfo(oca_abuse abuse) {
        Any supplErrInfo = abuse.supplErrInfo;
        BatchError batchInfo = null;
        if (supplErrInfo != null) {
            batchInfo = BatchErrorHelper.extract((Any)supplErrInfo);
            this.m_objID = batchInfo.failedItems[0];
            this.m_objIDs.add(new Integer(this.m_objID));
        }
        this.m_sdke = InfoStoreException.map(abuse);
        this.m_errCode = this.m_sdke.getExceptionCode();
        this.m_cmsMessage = abuse.details;
    }

    public CommitResultInfo(SDKException sdke) {
        if (sdke instanceof SDKException.CommitError) {
            if (sdke.getCause() instanceof SDKException) {
                this.m_sdke = (SDKException)((Object)sdke.getCause());
                Throwable throwable = this.m_sdke.getCause();
                if (throwable instanceof oca_abuse) {
                    oca_abuse abuse = (oca_abuse)throwable;
                    this.m_sdke = SDKServerException.map(abuse);
                    this.m_errCode = this.m_sdke.getExceptionCode();
                }
            } else {
                this.m_sdke = sdke;
            }
            this.m_objID = ((SDKException.CommitError)sdke).getFailedID();
            Set failedIDs = ((SDKException.CommitError)sdke).getFailedIDs();
            if (failedIDs != null) {
                this.m_objIDs = failedIDs;
            } else {
                this.m_objIDs.add(new Integer(this.m_objID));
            }
        } else {
            this.m_sdke = sdke;
            this.m_errCode = sdke.getExceptionCode();
        }
    }

    public int getID() {
        return this.m_objID;
    }

    public Set getIDs() {
        return this.m_objIDs;
    }

    public String getCMSMessage() {
        return this.m_cmsMessage;
    }

    public String getLocalizedMessage(Locale locale) {
        return this.m_sdke.getMessage(locale);
    }

    public int getExceptionCode() {
        return this.m_errCode;
    }
}

