/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.occa.infostore.IDestination;
import com.crystaldecisions.sdk.occa.infostore.IDestinationFormats;
import com.crystaldecisions.sdk.occa.infostore.IDestinationPlugin;
import com.crystaldecisions.sdk.occa.infostore.IDestinationPluginArtifactFormats;
import com.crystaldecisions.sdk.occa.infostore.IDestinationStaticDocuments;
import com.crystaldecisions.sdk.occa.infostore.internal.DestinationFormats;
import com.crystaldecisions.sdk.occa.infostore.internal.DestinationPluginArtifactFormats;
import com.crystaldecisions.sdk.occa.infostore.internal.DestinationStaticDocuments;
import com.crystaldecisions.sdk.occa.infostore.internal.SchedulingInfo;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;

class Destination
implements IDestination {
    static final Integer SI_PROGID = PropertyIDs.SI_PROGID;
    private PropertyBag m_Bag;
    private SchedulingInfo m_scheduingInfo;
    private IDestinationFormats m_destFormats;
    private IDestinationPluginArtifactFormats m_destPluginFormats;
    private IDestinationStaticDocuments m_destStaticDocs;

    public Destination(PropertyBag bag, SchedulingInfo schedulingInfo) {
        this.m_Bag = bag;
        this.m_scheduingInfo = schedulingInfo;
    }

    public String getName() {
        return this.m_Bag.getString((Object)SI_PROGID);
    }

    public void setName(String sVal) {
        this.m_Bag.addItem((Object)SI_PROGID, (Object)sVal, 0);
    }

    public boolean isDeliverPerUser() {
        return this.m_Bag.getBoolean((Object)PropertyIDs.SI_DELIVER_PER_USER);
    }

    public void setDeliverPerUser(boolean perUser) {
        this.m_Bag.setProperty((Object)PropertyIDs.SI_DELIVER_PER_USER, perUser);
    }

    public IDestinationFormats getDestinationFormats() {
        if (this.m_destFormats == null) {
            PropertyBag destFormatsBag = this.m_Bag.getPropertyBag((Object)PropertyIDs.SI_DESTINATION_FORMATS);
            if (destFormatsBag == null) {
                destFormatsBag = ((PropertyBag)this.properties()).addArray((Object)PropertyIDs.SI_DESTINATION_FORMATS).getPropertyBag();
            }
            this.m_destFormats = new DestinationFormats(destFormatsBag);
        }
        return this.m_destFormats;
    }

    public IDestinationPluginArtifactFormats getDestinationPluginArtifactFormats() {
        if (this.m_destPluginFormats == null) {
            PropertyBag destPluginFormatsBag = this.m_Bag.getPropertyBag((Object)PropertyIDs.SI_DESTINATION_PLUGIN_FORMATS);
            if (destPluginFormatsBag == null) {
                destPluginFormatsBag = ((PropertyBag)this.properties()).addArray((Object)PropertyIDs.SI_DESTINATION_PLUGIN_FORMATS).getPropertyBag();
            }
            this.m_destPluginFormats = new DestinationPluginArtifactFormats(destPluginFormatsBag);
        }
        return this.m_destPluginFormats;
    }

    public IDestinationStaticDocuments getDestinationStaticDocuments() {
        if (this.m_destStaticDocs == null) {
            PropertyBag destStaticDocsBag = this.m_Bag.getPropertyBag((Object)PropertyIDs.SI_DESTINATION_STATIC_DOCUMENTS);
            if (destStaticDocsBag == null) {
                destStaticDocsBag = ((PropertyBag)this.properties()).addArray((Object)PropertyIDs.SI_DESTINATION_STATIC_DOCUMENTS).getPropertyBag();
            }
            this.m_destStaticDocs = new DestinationStaticDocuments(destStaticDocsBag);
        }
        return this.m_destStaticDocs;
    }

    public boolean isSystemDefaultOptionsUsed() {
        PropertyBag schedOptions = this.m_Bag.getPropertyBag((Object)PropertyIDs.SI_DEST_SCHEDULEOPTIONS);
        return schedOptions == null || schedOptions.size() <= 0;
    }

    public IProperties properties() {
        return (IProperties)this.m_Bag;
    }

    public void copyToPlugin(IDestinationPlugin plugin) throws SDKException {
        IProperties inputProps = this.properties();
        IProperties outputProps = plugin.properties();
        IProperty inputProgId = inputProps.getProperty(SI_PROGID);
        if (inputProgId != null) {
            String iString = (String)inputProgId.getValue();
            if (iString == null || iString.length() == 0) {
                throw new SDKRuntimeException.UnexpectedValue(SI_PROGID, iString);
            }
            IProperty outputProgId = outputProps.getProperty(SI_PROGID);
            if (outputProgId == null) {
                throw new SDKRuntimeException.PropertyNotFound(SI_PROGID);
            }
            String oString = (String)outputProgId.getValue();
            if (!iString.equalsIgnoreCase(oString)) {
                throw new SDKException.UnexpectedValue(SI_PROGID, (Object)oString);
            }
        } else {
            throw new SDKRuntimeException.PropertyNotFound(SI_PROGID);
        }
        IProperty schedOptions = inputProps.getProperty(PropertyIDs.SI_DEST_SCHEDULEOPTIONS);
        if (schedOptions != null) {
            outputProps.setProperty((Object)PropertyIDs.SI_DEST_SCHEDULEOPTIONS, ((PropertyBag)schedOptions.getValue()).copy());
        } else {
            outputProps.remove(PropertyIDs.SI_DEST_SCHEDULEOPTIONS);
        }
    }

    public void setFromPlugin(IDestinationPlugin plugin) throws SDKException {
        IProperties inputProps = plugin.properties();
        IProperties outputProps = this.properties();
        IProperty inputProgId = inputProps.getProperty(SI_PROGID);
        if (inputProgId == null) {
            throw new SDKException.PropertyNotFound(SI_PROGID);
        }
        outputProps.setProperty((Object)SI_PROGID, inputProgId.getValue());
        IProperty schedOptions = inputProps.getProperty(PropertyIDs.SI_DEST_SCHEDULEOPTIONS);
        if (schedOptions != null) {
            outputProps.setProperty((Object)PropertyIDs.SI_DEST_SCHEDULEOPTIONS, ((PropertyBag)schedOptions.getValue()).copy());
        } else {
            outputProps.remove(PropertyIDs.SI_DEST_SCHEDULEOPTIONS);
        }
    }

    public boolean isCleanup() throws SDKException {
        return this.m_scheduingInfo.isCleanup();
    }

    public void setCleanup(boolean cleanup) throws SDKException {
        this.m_scheduingInfo.setCleanup(cleanup);
    }

    public void clear() {
        this.m_Bag.remove((Object)PropertyIDs.SI_DEST_SCHEDULEOPTIONS);
        this.m_Bag.addItem((Object)PropertyIDs.SI_DEST_SCHEDULEOPTIONS, null, 0x8000000);
    }

    void initialize() {
        if (this.m_Bag.get((Object)PropertyIDs.SI_DEST_SCHEDULEOPTIONS) == null) {
            this.m_Bag.addItem((Object)PropertyIDs.SI_DEST_SCHEDULEOPTIONS, null, 0x8000000);
        }
    }
}

