/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IEffectiveLimit;
import com.crystaldecisions.sdk.occa.infostore.IEffectiveLimits;
import com.crystaldecisions.sdk.occa.infostore.IPluginBasedRightIDs;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.ISecurityLimitAdmin;
import com.crystaldecisions.sdk.occa.infostore.RightIDDescriptor;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractRight2;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecuritySet;
import com.crystaldecisions.sdk.occa.infostore.internal.EffectiveLimit;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRightID;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecUpdateEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.PluginBasedRightIDs;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import java.util.Iterator;
import java.util.Map;

class EffectiveLimits
extends AbstractSecuritySet
implements IEffectiveLimits {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.EffectiveLimits");

    public EffectiveLimits() {
    }

    public EffectiveLimits(ISecuritySession session, IRightID[] knownLimits, int objID, int principalID, ISecEventListener listener) {
        super(session, knownLimits, objID, principalID, listener);
    }

    public IEffectiveLimit get(RightIDDescriptor limit) {
        try {
            return (IEffectiveLimit)((Object)this.getValue(new Integer(this.getRealRightID(limit.id, limit.kind, false))));
        }
        catch (SDKException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("EffectiveLimits.get - error getting the limit(" + limit.id + "," + limit.kind + ")"), (Throwable)((Object)e));
            }
            return null;
        }
    }

    public Iterator iterator() {
        return super.iterator();
    }

    public int size() {
        return super.size();
    }

    protected Object createRemovedEntry(Object right) {
        return null;
    }

    protected Object getKey(Object right) {
        IEffectiveLimit right2 = (IEffectiveLimit)right;
        return new Integer(right2.getID());
    }

    protected void update(Object delta) {
    }

    void importLimit(ISecurityLimitAdmin limit) {
        AbstractRight2 ar;
        IPersistRightID persistID = (IPersistRightID)this.findRightByID(limit.getID());
        String description = "";
        String category = "";
        int collection = 0;
        if (persistID != null) {
            description = persistID.getDescriptionID();
            category = persistID.getCategoryID();
            collection = persistID.getCollectionID();
        }
        if ((ar = (AbstractRight2)this.getValue(this.getKey(limit))) == null || !ar.isDirty()) {
            EffectiveLimit rightCP = new EffectiveLimit(limit, description, category, collection, this.m_pluginMgr, (ISecEventListener)this.m_loadListener);
            this.importValue(rightCP);
        }
    }

    protected Map getKnownRights(ISecUpdateEvent event) throws SDKException {
        IPluginBasedRightIDs rights = event.getKnownRightsByPlugin();
        if (rights != null) {
            return ((PluginBasedRightIDs)rights).getUniqueLimits();
        }
        return null;
    }

    protected Map getKnownRightsByPlugin(ISecUpdateEvent event) throws SDKException {
        IPluginBasedRightIDs rights = event.getKnownRightsByPlugin();
        if (rights != null) {
            return rights.getPluginLimits();
        }
        return null;
    }
}

