/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IEffectiveLimits;
import com.crystaldecisions.sdk.occa.infostore.IEffectivePrincipal;
import com.crystaldecisions.sdk.occa.infostore.IEffectiveRights;
import com.crystaldecisions.sdk.occa.infostore.IEffectiveRoles;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRoleID;
import com.crystaldecisions.sdk.occa.infostore.ISecurityLimitAdmin;
import com.crystaldecisions.sdk.occa.infostore.ISecurityPrincipal;
import com.crystaldecisions.sdk.occa.infostore.ISecurityRightAdmin;
import com.crystaldecisions.sdk.occa.infostore.ISecurityRoleAdmin;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractPrincipalBase;
import com.crystaldecisions.sdk.occa.infostore.internal.EffectiveLimits;
import com.crystaldecisions.sdk.occa.infostore.internal.EffectiveRights;
import com.crystaldecisions.sdk.occa.infostore.internal.EffectiveRoles;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecEventListener;
import com.crystaldecisions.sdk.occa.security.ISecCacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.ISecurityInfoResult;
import com.crystaldecisions.sdk.occa.security.ISecurityResult;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;

class EffectivePrincipal
extends AbstractPrincipalBase
implements IEffectivePrincipal {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.EffectivePrincipal");
    private boolean m_isAdvanced;
    private boolean m_isInherited;

    public EffectivePrincipal() {
    }

    public EffectivePrincipal(int id, String name, IRightID[] knownRights, IRightID[] knownLimits, IRoleID[] knownRoles, ISecuritySession session, int objID, ISecEventListener eventListener) {
        super(id, name, objID, eventListener);
        this.m_rights = new EffectiveRights(session, knownRights, objID, this.m_id, this.m_loadListener);
        this.m_limits = new EffectiveLimits(session, knownLimits, objID, this.m_id, this.m_loadListener);
        this.m_roles = new EffectiveRoles(session, knownRoles, this.m_loadListener);
        this.m_isAdvanced = false;
        if (knownRights != null && knownLimits != null && knownRoles != null) {
            this.m_loadListener.setLoaded(0);
        }
    }

    public IEffectiveRights getRights() {
        return (IEffectiveRights)((Object)this.m_rights);
    }

    public IEffectiveLimits getLimits() {
        return (IEffectiveLimits)((Object)this.m_limits);
    }

    public IEffectiveRoles getRoles() {
        return (IEffectiveRoles)((Object)this.m_roles);
    }

    public boolean isAdvanced() {
        return this.m_isAdvanced;
    }

    public boolean isInherited() {
        return this.m_isInherited;
    }

    public void importSecurityInfo(ISecurityPrincipal principal) throws SDKException {
        ISecurityRoleAdmin[] rolesID;
        ISecurityLimitAdmin[] limitsID;
        ISecurityRightAdmin[] rightsID = principal.getRights();
        if (rightsID != null) {
            for (int i = 0; i < rightsID.length; ++i) {
                ISecurityRightAdmin right = rightsID[i];
                ((EffectiveRights)this.m_rights).importRight(right);
            }
        }
        if ((limitsID = principal.getLimits()) != null) {
            for (int i = 0; i < limitsID.length; ++i) {
                ISecurityLimitAdmin limit = limitsID[i];
                ((EffectiveLimits)this.m_limits).importLimit(limit);
            }
        }
        if ((rolesID = principal.getRoles()) != null) {
            for (int i = 0; i < rolesID.length; ++i) {
                ISecurityRoleAdmin role = rolesID[i];
                ((EffectiveRoles)this.m_roles).importRole(role);
            }
        }
        this.m_isInheritFolders = principal.isInheritFolders();
        this.m_isInheritGroups = principal.isInheritGroups();
        this.m_isAdvanced = principal.isAdvanced();
        this.m_isInherited = principal.isInherited();
    }

    void loadSecurityInfo(ISecCacheControllerAdmin cacheAdmin, ISecRightsAdmin rightsAdmin, int objectID, boolean isUseCache) throws SDKException {
        ISecurityInfoResult infoResult;
        ISecurityResult result;
        try {
            cacheAdmin.batch(isUseCache);
            cacheAdmin.cacheSecurityInfo(objectID, this.getID());
            cacheAdmin.commit();
            result = rightsAdmin.getSecurityInfo(objectID, this.getID());
        }
        catch (SDKException e) {
            cacheAdmin.rollback();
            throw e;
        }
        catch (Throwable e) {
            cacheAdmin.rollback();
            SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
            throw sdke;
        }
        if (result != null && result.getStatus() == 0 && (infoResult = (ISecurityInfoResult)result.getResult()) != null) {
            ISecurityPrincipal principal;
            ISecurityPrincipal iSecurityPrincipal = principal = infoResult instanceof ISecurityPrincipal ? (ISecurityPrincipal)((Object)infoResult) : null;
            if (principal != null) {
                this.m_name = principal.getName();
            }
            this.importSecurityInfo(new ISecurityPrincipal(){

                public int getID() {
                    return EffectivePrincipal.this.m_id;
                }

                public String getName() {
                    return EffectivePrincipal.this.m_name;
                }

                public boolean isInheritFolders() {
                    if (principal != null) {
                        return principal.isInheritFolders();
                    }
                    return true;
                }

                public boolean isInheritGroups() {
                    if (principal != null) {
                        return principal.isInheritGroups();
                    }
                    return true;
                }

                public ISecurityRightAdmin[] getRights() {
                    return infoResult.getRights();
                }

                public ISecurityLimitAdmin[] getLimits() {
                    return infoResult.getLimits();
                }

                public ISecurityRoleAdmin[] getRoles() {
                    return infoResult.getRoles();
                }

                public boolean isInherited() {
                    if (principal != null) {
                        return principal.isInherited();
                    }
                    return true;
                }

                public boolean isAdvanced() {
                    if (principal != null) {
                        return principal.isAdvanced();
                    }
                    return false;
                }
            });
        }
    }
}

