/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IEffectiveRight;
import com.crystaldecisions.sdk.occa.infostore.IEffectiveRights;
import com.crystaldecisions.sdk.occa.infostore.IPluginBasedRightIDs;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRightsView;
import com.crystaldecisions.sdk.occa.infostore.ISecurityRightAdmin;
import com.crystaldecisions.sdk.occa.infostore.RightDescriptor;
import com.crystaldecisions.sdk.occa.infostore.RightIDDescriptor;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractRight;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecuritySet;
import com.crystaldecisions.sdk.occa.infostore.internal.EffectiveRight;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRightID;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecUpdateEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.PluginBasedRightIDs;
import com.crystaldecisions.sdk.occa.infostore.internal.RightKey;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import java.util.Iterator;
import java.util.Map;

class EffectiveRights
extends AbstractSecuritySet
implements IEffectiveRights,
IRightsView {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.EffectiveRights");

    public EffectiveRights() {
    }

    public EffectiveRights(ISecuritySession session, IRightID[] knownRights, int objID, int principalID, ISecEventListener listener) {
        super(session, knownRights, objID, principalID, listener);
    }

    public IEffectiveRight get(RightDescriptor right) {
        return (IEffectiveRight)this.getRight(right);
    }

    public IEffectiveRight get(RightIDDescriptor right) {
        try {
            return (IEffectiveRight)((Object)this.getValue(new Integer(this.getRealRightID(right.id, right.kind, false))));
        }
        catch (SDKException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("EffectiveLimits.get - error getting the limit(" + right.id + "," + right.kind + ")"), (Throwable)((Object)e));
            }
            return null;
        }
    }

    public Iterator iterator() {
        return super.iterator();
    }

    public int size() {
        return super.size();
    }

    public void addHidden(AbstractRight right) {
        this.addValue(right);
    }

    public void importRight(ISecurityRightAdmin right) {
        IEffectiveRight ar = (IEffectiveRight)this.getRight(right.getRightDescriptor());
        if (ar == null) {
            IRightID rightID = this.findRightByID(right.getID());
            String description = "";
            String category = "";
            int collection = 0;
            if (rightID != null) {
                IPersistRightID persistID = (IPersistRightID)rightID;
                description = persistID.getDescriptionID();
                category = persistID.getCategoryID();
                collection = persistID.getCollectionID();
            }
            EffectiveRight newRight = new EffectiveRight(right, description, category, collection, right.getSources(), this.m_pluginMgr, this.m_loadListener);
            this.importValue(newRight);
        }
    }

    protected Object createRemovedEntry(Object right) {
        return null;
    }

    protected Object getKey(Object right) {
        IEffectiveRight right2 = (IEffectiveRight)right;
        return new RightKey(right2.getID(), right2.getScope(), right2.getObjectType());
    }

    protected void update(Object delta) {
    }

    protected Object makeUnspecifiedRight(IPersistRightID persistID) {
        EffectiveRight unspecifiedRight = new EffectiveRight(persistID.getID(), persistID.getDescriptionID(), persistID.getCategoryID(), persistID.getCollectionID(), "", "", true, this.m_pluginMgr, (ISecEventListener)this.m_loadListener);
        unspecifiedRight.setSpeficied(false);
        return unspecifiedRight;
    }

    protected Object makeUnspecifiedRight(IPersistRightID persistID, String applicableKind, String scope) {
        EffectiveRight unspecifiedRight = new EffectiveRight(persistID.getID(), persistID.getDescriptionID(), persistID.getCategoryID(), persistID.getCollectionID(), applicableKind, scope, true, this.m_pluginMgr, (ISecEventListener)this.m_loadListener);
        unspecifiedRight.setSpeficied(false);
        return unspecifiedRight;
    }

    protected Map getKnownRights(ISecUpdateEvent event) throws SDKException {
        IPluginBasedRightIDs rights = event.getKnownRightsByPlugin();
        if (rights != null) {
            return ((PluginBasedRightIDs)rights).getUniqueRights();
        }
        return null;
    }

    protected Map getKnownRightsByPlugin(ISecUpdateEvent event) throws SDKException {
        IPluginBasedRightIDs rights = event.getKnownRightsByPlugin();
        if (rights != null) {
            return rights.getPluginRights();
        }
        return null;
    }
}

