/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IExplicitLimits;
import com.crystaldecisions.sdk.occa.infostore.IExplicitPrincipal;
import com.crystaldecisions.sdk.occa.infostore.IExplicitRights;
import com.crystaldecisions.sdk.occa.infostore.IExplicitRoles;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRoleID;
import com.crystaldecisions.sdk.occa.infostore.ISecurityLimitAdmin;
import com.crystaldecisions.sdk.occa.infostore.ISecurityPrincipal;
import com.crystaldecisions.sdk.occa.infostore.ISecurityRightAdmin;
import com.crystaldecisions.sdk.occa.infostore.ISecurityRoleAdmin;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractPrincipalBase;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractRight2;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ExplicitLimits;
import com.crystaldecisions.sdk.occa.infostore.internal.ExplicitRights;
import com.crystaldecisions.sdk.occa.infostore.internal.ExplicitRole;
import com.crystaldecisions.sdk.occa.infostore.internal.ExplicitRoles;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecEventListener;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;

class ExplicitPrincipal
extends AbstractPrincipalBase
implements IExplicitPrincipal,
Externalizable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.ExplicitPrincipal");
    boolean m_isNOFUpdated;
    boolean m_isNOGUpdated;

    public ExplicitPrincipal() {
    }

    public ExplicitPrincipal(int id, String name, IRightID[] knownRights, IRightID[] knownLimits, IRoleID[] knownRoles, ISecuritySession session, int objID, ISecEventListener eventListener) {
        super(id, name, objID, eventListener);
        this.m_rights = new ExplicitRights(session, knownRights, objID, this.m_id, this.m_loadListener);
        this.m_limits = new ExplicitLimits(session, knownLimits, objID, this.m_id, this.m_loadListener);
        this.m_roles = new ExplicitRoles(session, knownRoles, this.m_loadListener);
        if (knownRights != null && knownLimits != null && knownRoles != null) {
            this.m_loadListener.setLoaded(0);
        }
    }

    public IExplicitRights getRights() {
        return (IExplicitRights)((Object)this.m_rights);
    }

    public IExplicitLimits getLimits() {
        return (IExplicitLimits)((Object)this.m_limits);
    }

    public IExplicitRoles getRoles() {
        return (IExplicitRoles)((Object)this.m_roles);
    }

    public void setInheritGroups(boolean inherit) {
        if (this.m_isInheritGroups != inherit) {
            this.m_isInheritGroups = inherit;
            this.m_isNOGUpdated = true;
        }
    }

    public void setInheritFolders(boolean inherit) {
        if (this.m_isInheritFolders != inherit) {
            this.m_isInheritFolders = inherit;
            this.m_isNOFUpdated = true;
        }
    }

    public void importSecurityInfo(ISecurityPrincipal principal) throws SDKException {
        ISecurityRoleAdmin[] rolesID;
        ISecurityLimitAdmin[] limitsID;
        ISecurityRightAdmin[] rightsID = principal.getRights();
        if (rightsID != null) {
            for (int i = 0; i < rightsID.length; ++i) {
                ISecurityRightAdmin right = rightsID[i];
                ((ExplicitRights)this.m_rights).importExplicitRight(right);
            }
        }
        if ((limitsID = principal.getLimits()) != null) {
            for (int i = 0; i < limitsID.length; ++i) {
                ISecurityLimitAdmin limit = limitsID[i];
                ((ExplicitLimits)this.m_limits).importExplicitLimit(limit);
            }
        }
        if ((rolesID = principal.getRoles()) != null) {
            for (int i = 0; i < rolesID.length; ++i) {
                ISecurityRoleAdmin role = rolesID[i];
                ((ExplicitRoles)this.m_roles).importRole(role);
            }
        }
        if (!this.m_isNOFUpdated) {
            this.m_isInheritFolders = principal.isInheritFolders();
        }
        if (!this.m_isNOGUpdated) {
            this.m_isInheritGroups = principal.isInheritGroups();
        }
    }

    public void saveRights(ISecRightsAdmin rightsAdmin, int objectID) throws SDKException {
        if (this.m_isNOFUpdated) {
            rightsAdmin.setInheritFoldersForPrincipal(objectID, this.m_id, this.m_isInheritFolders);
        }
        if (this.m_isNOGUpdated) {
            rightsAdmin.setInheritGroupsForPrincipal(objectID, this.m_id, this.m_isInheritGroups);
        }
        this.m_rights.saveRights(rightsAdmin, objectID, this.m_id);
        this.m_limits.saveRights(rightsAdmin, objectID, this.m_id);
        this.m_roles.saveRights(rightsAdmin, objectID, this.m_id);
    }

    void setRemoved() {
        super.setRemoved();
        this.setInheritFolders(true);
        this.setInheritGroups(true);
    }

    public boolean isDirty() {
        AbstractRight2 ar;
        if (this.m_isNOFUpdated) {
            return true;
        }
        if (this.m_isNOGUpdated) {
            return true;
        }
        if (this.m_rights.isPendingRemoval()) {
            return true;
        }
        if (this.m_limits.isPendingRemoval()) {
            return true;
        }
        if (!this.m_roles.m_removed.isEmpty()) {
            return true;
        }
        Iterator iter = this.m_rights.iterator();
        while (iter.hasNext()) {
            ar = (AbstractRight2)iter.next();
            if (!ar.isDirty()) continue;
            return true;
        }
        iter = this.m_limits.iterator();
        while (iter.hasNext()) {
            ar = (AbstractRight2)iter.next();
            if (!ar.isDirty()) continue;
            return true;
        }
        iter = this.m_roles.iterator();
        while (iter.hasNext()) {
            ExplicitRole er = (ExplicitRole)iter.next();
            if (!er.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.m_id);
        out.writeObject(this.m_name);
        out.writeObject(this.m_rights);
        out.writeObject(this.m_limits);
        out.writeObject(this.m_roles);
        out.writeBoolean(this.m_isInheritFolders);
        out.writeBoolean(this.m_isInheritGroups);
        out.writeBoolean(this.m_isNOFUpdated);
        out.writeBoolean(this.m_isNOGUpdated);
    }

    void initFromSerialization(ISecEventListener parentListener, IInfoObject object) {
        if (this.m_loadListener == null) {
            this.makeListener(parentListener);
        }
        this.m_objID = object.getID();
        ISecuritySession session = ((IInternalInfoObject)object).getSession();
        if (this.m_rights != null) {
            this.m_rights.initFromSerialization(this.m_loadListener, this.m_objID, this.m_id, session);
        }
        if (this.m_limits != null) {
            this.m_limits.initFromSerialization(this.m_loadListener, this.m_objID, this.m_id, session);
        }
        if (this.m_roles != null) {
            this.m_roles.initFromSerialization(this.m_loadListener);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_id = in.readInt();
        this.m_name = (String)in.readObject();
        this.m_rights = (ExplicitRights)in.readObject();
        this.m_limits = (ExplicitLimits)in.readObject();
        this.m_roles = (ExplicitRoles)in.readObject();
        this.m_isInheritFolders = in.readBoolean();
        this.m_isInheritGroups = in.readBoolean();
        this.m_isNOFUpdated = in.readBoolean();
        this.m_isNOGUpdated = in.readBoolean();
    }

    public void serializeHelper(PropertyBag bag) {
        bag.addItem((Object)PropertyIDs.SI_ID, (Object)new Integer(this.m_id), 0);
        bag.addItem((Object)PropertyIDs.SI_ISINHERITFOLDERS, (Object)new Boolean(this.m_isInheritFolders), 0);
        bag.addItem((Object)PropertyIDs.SI_ISINHERITGROUPS, (Object)new Boolean(this.m_isInheritGroups), 0);
        PropertyBag rightsBag = bag.addItem((Object)PropertyIDs.SI_RIGHTS, null, 0x8000000).getPropertyBag();
        PropertyArrayHelper rightsHelper = new PropertyArrayHelper(rightsBag, PropertyIDs.SI_TOTAL);
        ((ExplicitRights)this.m_rights).serializeHelper(rightsHelper);
        PropertyBag limitsBag = bag.addItem((Object)PropertyIDs.SI_LIMITS, null, 0x8000000).getPropertyBag();
        PropertyArrayHelper limitsHelper = new PropertyArrayHelper(limitsBag, PropertyIDs.SI_TOTAL);
        ((ExplicitLimits)this.m_limits).serializeHelper(limitsHelper);
        PropertyBag rolesBag = bag.addItem((Object)PropertyIDs.SI_ROLES, null, 0x8000000).getPropertyBag();
        PropertyArrayHelper rolesHelper = new PropertyArrayHelper(rolesBag, PropertyIDs.SI_TOTAL);
        ((ExplicitRoles)this.m_roles).serializeHelper(rolesHelper);
    }

    public boolean isInheritGroups() {
        AbstractSecEventListener.ensureDelayedLoad(1, this.m_loadListener);
        return super.isInheritGroups();
    }

    public boolean isInheritFolders() {
        AbstractSecEventListener.ensureDelayedLoad(1, this.m_loadListener);
        return super.isInheritFolders();
    }
}

