/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IExplicitPrincipal;
import com.crystaldecisions.sdk.occa.infostore.IExplicitPrincipals;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRoleID;
import com.crystaldecisions.sdk.occa.infostore.ISecurityPrincipal;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractPrincipalBase;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractPrincipalsBase;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ExplicitPrincipal;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecEventListener;
import com.crystaldecisions.sdk.occa.security.ISecCacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.ISecurityResult;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ExplicitPrincipals
extends AbstractPrincipalsBase
implements IExplicitPrincipals,
Externalizable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.ExplicitPrincipals");
    private Map m_removed;
    private boolean m_isLoaded;
    private boolean m_bPrincipal0Updated;
    private boolean m_isNew;

    public ExplicitPrincipals() {
    }

    public ExplicitPrincipals(IRightID[] knownRights, IRightID[] knownLimits, IRoleID[] knownRoles, ISecuritySession session, int objID, boolean isNew, ISecEventListener eventListener) {
        super(knownRights, knownLimits, knownRoles, session, objID, eventListener);
        this.m_removed = new HashMap();
        this.m_isLoaded = false;
        this.m_bPrincipal0Updated = false;
        this.m_isNew = isNew;
    }

    public IExplicitPrincipal add(int id) {
        Integer key = new Integer(id);
        ExplicitPrincipal op = (ExplicitPrincipal)this.m_principals.get(key);
        if (op == null) {
            op = new ExplicitPrincipal(id, "", this.m_knownRights, this.m_knownLimits, this.m_knownRoles, this.m_session, this.m_objID, this.m_loadListener);
            this.m_principals.put(new Integer(id), op);
            op.setInheritGroups(true);
            op.setInheritFolders(true);
        }
        return op;
    }

    public IExplicitPrincipal get(int id) {
        AbstractSecEventListener.ensureDelayedLoad(1, this.m_loadListener);
        return (IExplicitPrincipal)((Object)super.getPrincipal(id));
    }

    public void remove(int id) {
        Integer key = new Integer(id);
        this.m_principals.remove(key);
        this.m_removed.put(key, null);
    }

    public void setGlobalInheritFolders(boolean inheritFolders) {
        this.m_bGlobalFolderInheritance = inheritFolders;
        this.m_bPrincipal0Updated = true;
    }

    AbstractPrincipalBase newPrincipal(int id, String name) {
        return new ExplicitPrincipal(id, name, this.m_knownRights, this.m_knownLimits, this.m_knownRoles, this.m_session, this.m_objID, this.m_loadListener);
    }

    ISecurityResult queryPrincipals(ISecCacheControllerAdmin cacheAdmin, ISecRightsAdmin rightsAdmin, int objectID, boolean isUseCache) throws SDKException {
        if (this.m_isNew) {
            return null;
        }
        try {
            if (!this.m_isLoaded) {
                cacheAdmin.batch(isUseCache);
                cacheAdmin.cacheExplicitPrincipals(objectID);
                cacheAdmin.commit();
                this.m_isLoaded = true;
            }
        }
        catch (SDKException e) {
            cacheAdmin.rollback();
            throw e;
        }
        catch (Throwable e) {
            cacheAdmin.rollback();
            SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
            throw sdke;
        }
        return rightsAdmin.getExplicitPrincipals(objectID);
    }

    public boolean isGlobalInheritFolders() {
        AbstractSecEventListener.ensureDelayedLoad(1, this.m_loadListener);
        return super.isGlobalInheritFolders();
    }

    public Iterator iterator() {
        AbstractSecEventListener.ensureDelayedLoad(1, this.m_loadListener);
        return super.iterator();
    }

    public int size() {
        AbstractSecEventListener.ensureDelayedLoad(1, this.m_loadListener);
        return super.size();
    }

    void saveRights(ISecRightsAdmin dest, int objectID) throws SDKException {
        Object next;
        Iterator<Object> iter = this.m_removed.keySet().iterator();
        while (iter.hasNext()) {
            next = (Integer)iter.next();
            dest.removeRights((Integer)next, objectID);
            dest.removeLimits((Integer)next, objectID);
            dest.removeRoles((Integer)next, objectID);
        }
        iter = this.m_principals.values().iterator();
        while (iter.hasNext()) {
            next = iter.next();
            ExplicitPrincipal principal = (ExplicitPrincipal)next;
            principal.saveRights(dest, objectID);
        }
        if (this.m_bPrincipal0Updated) {
            dest.setGlobalFolderInheritance(objectID, this.m_bGlobalFolderInheritance);
        }
    }

    protected void importPrincipal(ISecurityPrincipal principal) throws SDKException {
        boolean isUpdated;
        boolean bl = isUpdated = principal.getID() == 0 && this.m_bPrincipal0Updated || this.m_removed.containsKey(new Integer(principal.getID()));
        if (!isUpdated) {
            super.importPrincipal(principal);
        }
    }

    protected boolean isLoaded() {
        return this.m_isLoaded;
    }

    public boolean isDirty() {
        if (this.m_removed.size() > 0) {
            return true;
        }
        if (this.m_bPrincipal0Updated) {
            return true;
        }
        Iterator iter = this.m_principals.values().iterator();
        while (iter.hasNext()) {
            if (!((ExplicitPrincipal)iter.next()).isDirty()) continue;
            return true;
        }
        return false;
    }

    void initFromSerialization(ISecEventListener parentListener, IInfoObject object) {
        if (this.m_loadListener == null) {
            this.makeListener(parentListener);
        }
        this.m_session = ((IInternalInfoObject)object).getSession();
        this.m_objID = object.getID();
        if (this.m_principals != null) {
            Iterator iter = this.m_principals.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                ExplicitPrincipal principal = (ExplicitPrincipal)entry.getValue();
                principal.initFromSerialization(this.m_loadListener, object);
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_principals);
        out.writeObject(new HashSet(this.m_removed.keySet()));
        out.writeBoolean(this.m_bPrincipal0Updated);
        out.writeBoolean(this.m_bGlobalFolderInheritance);
        out.writeBoolean(this.m_isNew);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_principals = (Map)in.readObject();
        Set removed = (Set)in.readObject();
        this.m_removed = new HashMap(removed == null ? 0 : removed.size());
        Iterator iter = removed.iterator();
        while (iter.hasNext()) {
            Integer removedPrinc = (Integer)iter.next();
            this.m_removed.put(removedPrinc, null);
        }
        this.m_bPrincipal0Updated = in.readBoolean();
        this.m_bGlobalFolderInheritance = in.readBoolean();
        this.m_isLoaded = false;
        this.m_isNew = in.readBoolean();
    }

    public void serializeHelper(PropertyBag bag) {
        bag.addItem((Object)PropertyIDs.SI_GLOBALFOLDERINHERITANCE, (Object)new Boolean(this.m_bGlobalFolderInheritance), 0);
        PropertyBag principalsPropBag = bag.addPropertyBag((Object)PropertyIDs.SI_PRINCIPALS, null).getPropertyBag();
        PropertyArrayHelper arrayhelper = new PropertyArrayHelper(principalsPropBag, PropertyIDs.SI_TOTAL);
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            ExplicitPrincipal principal = (ExplicitPrincipal)itr.next();
            PropertyBag principalbag = arrayhelper.add(null, 0x8000000).getPropertyBag();
            principal.serializeHelper(principalbag);
        }
    }
}

