/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IExplicitRole;
import com.crystaldecisions.sdk.occa.infostore.IExplicitRoles;
import com.crystaldecisions.sdk.occa.infostore.IRoleID;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractRoleSet;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ExplicitRole;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.RoleID;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityRole;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import java.util.Iterator;
import java.util.Map;

public class ExplicitRoles
extends AbstractRoleSet
implements IExplicitRoles {
    public ExplicitRoles() {
    }

    public ExplicitRoles(ISecuritySession session, IRoleID[] knownRoles, ISecEventListener eventListener) {
        super(session, knownRoles, eventListener);
    }

    public IExplicitRole add(int id) throws SDKException {
        IExplicitRole role = (IExplicitRole)((Object)this.getValue(new Integer(id)));
        if (role == null) {
            IRoleID persistRole = this.findRoleByID(id);
            String title = "";
            String cuid = "";
            String desc = "";
            if (persistRole != null) {
                title = persistRole.getTitle();
                cuid = persistRole.getCUID();
                desc = persistRole.getDescription();
            }
            ExplicitRole newRole = new ExplicitRole(id, title, cuid, desc, this.m_loadListener);
            newRole.m_dirty = true;
            this.addValue(newRole);
            return newRole;
        }
        return role;
    }

    public IExplicitRole addNew(int id) throws SDKException {
        IExplicitRole role = (IExplicitRole)((Object)this.getValue(new Integer(id)));
        if (role == null) {
            ExplicitRole newRole = new ExplicitRole(id, "", "", "", this.m_loadListener);
            newRole.m_dirty = true;
            this.addValue(newRole);
            return newRole;
        }
        return role;
    }

    public IExplicitRole get(int id) {
        AbstractSecEventListener.ensureDelayedLoad(1, this.m_loadListener);
        return (IExplicitRole)((Object)this.getValue(new Integer(id)));
    }

    public Iterator iterator() {
        AbstractSecEventListener.ensureDelayedLoad(1, this.m_loadListener);
        return super.iterator();
    }

    public void remove(int id) {
        super.removeValue(new Integer(id), new RemovedRole(id), false);
    }

    public int size() {
        AbstractSecEventListener.ensureDelayedLoad(1, this.m_loadListener);
        return super.size();
    }

    protected Object getKey(Object right) {
        RoleID rightId = (RoleID)right;
        return new Integer(rightId.getID());
    }

    protected Object createRemovedEntry(Object role) {
        SecurityRole secRole = (SecurityRole)role;
        return new RemovedRole(secRole.getID());
    }

    protected void update(Object delta) {
        SecurityRole deltaRole = (SecurityRole)delta;
        int id = deltaRole.getID();
        SecurityRole role = (SecurityRole)this.getValue(new Integer(id));
        if (role == null) {
            IRoleID roleID = this.findRoleByID(id);
            String title = "";
            String cuid = "";
            String desc = "";
            if (roleID != null) {
                title = roleID.getTitle();
                cuid = roleID.getCUID();
                desc = roleID.getDescription();
            }
            ExplicitRole newRole = new ExplicitRole(id, title, cuid, desc, this.m_loadListener);
            newRole.m_dirty = true;
            this.addValue(newRole);
        }
    }

    void importRole(IExplicitRole role) throws SDKException {
        Integer key;
        SecurityRole ar;
        String title = "";
        String cuid = "";
        String desc = "";
        IRoleID persistRole = this.findRoleByID(role.getID());
        if (persistRole != null) {
            title = persistRole.getTitle();
            cuid = persistRole.getCUID();
            desc = persistRole.getDescription();
        }
        if ((ar = (SecurityRole)this.getValue(key = new Integer(role.getID()))) == null) {
            ar = (SecurityRole)this.m_removed.get(key);
        }
        if (ar == null || !ar.isDirty()) {
            ExplicitRole roleCP = new ExplicitRole(role.getID(), title, cuid, desc, this.m_loadListener);
            this.importValue(roleCP);
        }
    }

    void saveRights(ISecRightsAdmin rightsAdmin, int objectID, int principalID) throws SDKException {
        SecurityRole pr;
        Iterator iter = this.m_removed.values().iterator();
        while (iter.hasNext()) {
            pr = (RemovedRole)iter.next();
            ((RemovedRole)pr).saveRights(rightsAdmin, objectID, principalID);
        }
        iter = this.m_values.values().iterator();
        while (iter.hasNext()) {
            pr = (SecurityRole)iter.next();
            pr.saveRights(rightsAdmin, objectID, principalID);
        }
    }

    public void serializeHelper(PropertyArrayHelper arrayhelper) {
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            SecurityRole role = (SecurityRole)itr.next();
            PropertyBag bag = arrayhelper.add(null, 0x8000000).getPropertyBag();
            role.serializeHelper(bag);
        }
    }

    void initFromSerialization(ISecEventListener parentListener) {
        super.initFromSerialization(parentListener);
        Iterator iter = this.m_removed.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getValue() != null) continue;
            Integer key = (Integer)entry.getKey();
            entry.setValue(new RemovedRole(key));
        }
    }

    static class RemovedRole
    extends SecurityRole {
        public RemovedRole() {
        }

        public RemovedRole(int id) {
            super(id, "", "", "", null);
            this.m_dirty = true;
        }

        protected boolean isRemoved() {
            return true;
        }

        void saveRights(ISecRightsAdmin rightsAdmin, int objectID, int principalID) throws SDKException {
            rightsAdmin.removeRole(this.m_id, principalID, objectID);
        }
    }
}

