/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IStreamingDownloadFile;
import java.io.IOException;
import java.io.InputStream;

public class FRSInputStream
extends InputStream {
    private static final byte[] BUF = new byte[0];
    private IStreamingDownloadFile m_streamingSupport;
    private byte[] m_buf = BUF;
    private int m_pos;
    private boolean m_closed;

    public FRSInputStream(IStreamingDownloadFile streamingSupport) {
        this.m_streamingSupport = streamingSupport;
        this.m_closed = false;
    }

    public int read() throws IOException {
        if (this.m_pos >= this.m_buf.length && !this.fetch()) {
            return -1;
        }
        return this.m_buf[this.m_pos++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        return this.readBytes(b, off, len);
    }

    private int readBytes(byte[] b, int off, int len) throws IOException {
        int first = this.read();
        if (first == -1) {
            return -1;
        }
        b[off] = (byte)first;
        ++off;
        int readBytes = 1;
        while (readBytes < len) {
            int leftBytes = len - readBytes;
            int shouldReadBytes = leftBytes > this.available() ? this.available() : leftBytes;
            System.arraycopy(this.m_buf, this.m_pos, b, off, shouldReadBytes);
            off += shouldReadBytes;
            this.m_pos += shouldReadBytes;
            if ((readBytes += shouldReadBytes) >= len || this.fetch()) continue;
            break;
        }
        return readBytes;
    }

    private boolean fetch() throws IOException {
        try {
            if (this.m_closed) {
                return false;
            }
            this.m_pos = 0;
            if (this.m_streamingSupport.hasNextChunk()) {
                this.m_buf = this.m_streamingSupport.nextChunk();
                return true;
            }
            this.m_buf = BUF;
            return false;
        }
        catch (SDKException e) {
            throw new IOException(e.getMessage());
        }
    }

    public int available() throws IOException {
        return this.m_buf.length - this.m_pos;
    }

    public void close() throws IOException {
        try {
            this.m_streamingSupport.closeFile();
            this.m_buf = BUF;
            this.m_pos = 0;
            this.m_closed = true;
        }
        catch (SDKException sDKException) {
            // empty catch block
        }
    }
}

