/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.conversion.IntegerConversion;
import com.crystaldecisions.celib.exception.SILibException;
import com.crystaldecisions.celib.io.FileCleaner;
import com.crystaldecisions.celib.properties.IBagPacker;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.IPropertyChangeListener;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.stringhandler.StringHandler;
import com.crystaldecisions.celib.stringhandler.StringHandlerFactory;
import com.crystaldecisions.celib.uri.FrsURL;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Packer;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.info_wire_ob3;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.CePropertyID;
import com.crystaldecisions.sdk.occa.infostore.ICategoryContent;
import com.crystaldecisions.sdk.occa.infostore.IExplicitLimit;
import com.crystaldecisions.sdk.occa.infostore.IExplicitLimits;
import com.crystaldecisions.sdk.occa.infostore.IExplicitPrincipal;
import com.crystaldecisions.sdk.occa.infostore.IExplicitPrincipals;
import com.crystaldecisions.sdk.occa.infostore.IExplicitRight;
import com.crystaldecisions.sdk.occa.infostore.IExplicitRights;
import com.crystaldecisions.sdk.occa.infostore.IExplicitRole;
import com.crystaldecisions.sdk.occa.infostore.IExplicitRoles;
import com.crystaldecisions.sdk.occa.infostore.IFiles;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.ILocalFile;
import com.crystaldecisions.sdk.occa.infostore.ILockInfo;
import com.crystaldecisions.sdk.occa.infostore.IProcessingInfo;
import com.crystaldecisions.sdk.occa.infostore.IRemoteFile;
import com.crystaldecisions.sdk.occa.infostore.ISchedulingInfo;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo2;
import com.crystaldecisions.sdk.occa.infostore.RightDescriptor;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ExplicitPrincipals;
import com.crystaldecisions.sdk.occa.infostore.internal.ExplicitRoles;
import com.crystaldecisions.sdk.occa.infostore.internal.Files;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStoreFactory;
import com.crystaldecisions.sdk.occa.infostore.internal.LockInfo;
import com.crystaldecisions.sdk.occa.infostore.internal.ObjectPrincipals;
import com.crystaldecisions.sdk.occa.infostore.internal.ObjectRelatives;
import com.crystaldecisions.sdk.occa.infostore.internal.ProcessingInfo;
import com.crystaldecisions.sdk.occa.infostore.internal.QuerySettings;
import com.crystaldecisions.sdk.occa.infostore.internal.SchedulingInfo;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityInfo;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityInfo2;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityInfoException;
import com.crystaldecisions.sdk.occa.infostore.internal.SerializableInfoObject;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.pluginmgr.internal.PluginMgrFactory;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.IRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occamgr.internal.OCCAMgrFactory;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

class InfoObject
implements Serializable,
IInternalInfoObject {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.InfoObject");
    private static final String INPUT_FRS_FRIENDLY_NAME = "Input";
    private static final String OUTPUT_FRS_FRIENDLY_NAME = "Output";
    private static final int LEVEL = 256;
    public static final String DESTINATION = "CrystalEnterprise.Destination";
    private static final int INSTANCE_MASK = 32768;
    private static final int OBTYPE_MASK = 65535;
    private static final StringHandler s_encryptor = StringHandlerFactory.getDefaultStringHandler();
    private static final Integer SI_DELTA_METAINFO = PropertyIDs.SI_DELTA_METAINFO;
    private static final Integer SI_DELTA_FILEOPS = PropertyIDs.SI_DELTA_FILEOPS;
    private static final Integer SI_BASE_LAST_PROPSET = PropertyIDs.SI_BASE_LAST_PROPSET;
    private static final Integer SI_BASE_ISNEW = PropertyIDs.SI_BASE_ISNEW;
    private static final Integer SI_BASE_ISUPDATE = PropertyIDs.SI_BASE_ISUPDATE;
    private static final Integer SI_BASE_OPTIONS = PropertyIDs.SI_BASE_OPTIONS;
    private static final Integer SI_BASE_LAST_TS = PropertyIDs.SI_BASE_LAST_TS;
    private int m_lastPropertiesSet;
    private SDKPropertyBag m_props;
    protected SDKPropertyBag m_rootBag = new SDKPropertyBag();
    protected PropertyBag m_serBag = new PropertyBag();
    private SecurityInfo m_securityInfo;
    private SecurityInfo2 m_securityInfo2;
    private int m_securitySurrogateID;
    private Files m_fileObjects;
    private boolean m_isNew;
    private boolean m_isUpdate;
    private ISecuritySession m_session;
    private int m_options;
    private int m_uid;
    private int m_parentId;
    private String m_name;
    private short m_objType;
    private int m_lastTimeStamp;
    protected Set m_corporateCategoryIDs;
    protected Set m_personalCategoryIDs;
    protected PropertyBag m_origFilesProps;
    private static final AbstractInfoObjectEventListener s_prepareCopyEventListener = new AbstractInfoObjectEventListener(){

        protected void processEvent(IInfoObjectEvent event) throws SDKException {
            ISecurityInfo2 securityInfo;
            IInternalInfoObject obj = (IInternalInfoObject)event.getInfoObject();
            if (!obj.isNew() && InfoObjects.isCopyNewObject(event.getMode()) && !(securityInfo = obj.getSecurityInfo2()).checkRight(61, null, true)) {
                throw new SecurityInfoException.NoRight(61, obj.getID(), obj.getTitle());
            }
        }
    };
    private static final AbstractInfoObjectEventListener s_prepareSendToEventListener = new AbstractInfoObjectEventListener(){

        protected void processEvent(IInfoObjectEvent event) throws SDKException {
            IInternalInfoObject obj = (IInternalInfoObject)event.getInfoObject();
            if (obj.isNew()) {
                throw new SDKException.InvalidOperation();
            }
            InfoObject.checkSendable(obj, event.getInfoStore());
        }
    };
    private static final AbstractInfoObjectEventListener s_prepareDeliveryToInboxEventListener = new AbstractInfoObjectEventListener(){

        protected void processEvent(IInfoObjectEvent event) throws SDKException {
            IInternalInfoObject obj = (IInternalInfoObject)event.getInfoObject();
            InfoObject.checkSendable(obj, event.getInfoStore());
            if (obj.isNew() && obj instanceof ICategoryContent) {
                ((ICategoryContent)((Object)obj)).getCorporateCategories();
                ((ICategoryContent)((Object)obj)).getPersonalCategories();
            }
        }
    };
    private static final AbstractInfoObjectEventListener s_prepareCommitEventListener = new AbstractInfoObjectEventListener(){

        protected void processEvent(IInfoObjectEvent event) throws SDKException {
            IInternalInfoObject obj = (IInternalInfoObject)event.getInfoObject();
            if (obj.isNew() && obj instanceof ICategoryContent) {
                ((ICategoryContent)((Object)obj)).getCorporateCategories();
                ((ICategoryContent)((Object)obj)).getPersonalCategories();
            }
            Property origEdgeInfo = (Property)obj.properties().getProperty(PropertyIDs.SI_ADM_ORIG_EDGE_INFO);
            PropertyBag origEdgeInfoBag = null;
            if (origEdgeInfo != null && origEdgeInfo.isContainer()) {
                origEdgeInfoBag = origEdgeInfo.getPropertyBag();
                if (obj.getCommitLevel() == 0) {
                    obj.properties().removeLocal(PropertyIDs.SI_ADM_ORIG_EDGE_INFO);
                } else {
                    Iterator iter = origEdgeInfoBag.allIterator();
                    while (iter.hasNext()) {
                        Property origBagProp = (Property)iter.next();
                        Property mainBagProp = (Property)obj.properties().getProperty(origBagProp.getID());
                        if (mainBagProp != null && mainBagProp.isDirty()) continue;
                        origEdgeInfoBag.removeLocal((Object)origBagProp.getID());
                    }
                    if (origEdgeInfoBag.isEmpty()) {
                        obj.properties().removeLocal(PropertyIDs.SI_ADM_ORIG_EDGE_INFO);
                    }
                }
            }
        }
    };
    private static final AbstractInfoObjectEventListener s_prepareImportEventListener = new AbstractInfoObjectEventListener(){

        protected void processEvent(IInfoObjectEvent event) throws SDKException {
            IInternalInfoObject obj = (IInternalInfoObject)event.getInfoObject();
            Integer propid = PropertyIDs.SI_UPDATE_TS;
            Property prop = (Property)obj.properties().getProperty(propid);
            if (prop == null) {
                obj.properties().add(propid, new Long(System.currentTimeMillis()), 0);
            } else {
                prop.setFlag(0x20000000);
            }
        }
    };
    private static final Integer ADM_ADD_CATEGORIES = PropertyIDs.nameToID("SI_ADM_ADD_SI_CATEGORIES");
    private static final Integer ADM_DEL_CATEGORIES = PropertyIDs.nameToID("SI_ADM_DEL_SI_CATEGORIES");
    private boolean m_isUsedAsDelegate = false;

    protected static void checkSendable(IInternalInfoObject obj, IInternalInfoStore infostore) throws SDKException {
        IProperty prop = obj.properties().getProperty(PropertyIDs.SI_SENDABLE);
        if (prop != null) {
            if (!((Boolean)prop.getValue()).booleanValue()) {
                throw new SDKException.InvalidOperation();
            }
        } else {
            IPluginInfo pi;
            if (infostore == null) {
                infostore = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA(obj.getSession().getAPSName(), obj.getSession());
            }
            if ((pi = infostore.getPluginMgr().getPluginInfo(obj.getProgID())) == null || !pi.isSendable()) {
                throw new SDKException.InvalidOperation();
            }
        }
    }

    InfoObject() {
        IPropertyChangeListener mainPropsListener = new IPropertyChangeListener(){

            public void propertyChange(Property p) {
                InfoObject.this.setFlag(524288);
                InfoObject.this.m_rootBag.getItem(PropertyIDs.SI_MAINBAG).propertyChange(p);
                if (p != null) {
                    if (PropertyIDs.SI_PARENTID.equals(p.getID())) {
                        InfoObject.this.clearFlag(0x8000000);
                        InfoObject.this.m_parentId = p.getInt();
                    } else if (PropertyIDs.SI_PARENT_CUID.equals(p.getID())) {
                        InfoObject.this.setProperty((Object)PropertyIDs.SI_PARENTID, new Integer(0));
                        InfoObject.this.setFlag(0x8000000);
                    } else if (PropertyIDs.SI_NAME.equals(p.getID())) {
                        InfoObject.this.m_name = p.getString();
                    }
                }
            }
        };
        this.m_props = (SDKPropertyBag)this.m_rootBag.addPropertyBag(PropertyIDs.SI_MAINBAG, mainPropsListener).getPropertyBag();
        this.m_props.setStringHandler(s_encryptor);
        this.m_isNew = true;
        this.m_isUpdate = false;
    }

    public void cleanupChanges() {
        this.m_props.cleanupChanges();
        this.m_options &= 0xF787FFFF;
    }

    public void copy(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, IInfoObject source, int mode) throws SDKException {
        source = (IInfoObject)InfoObjects.unproxyElement(source);
        int excludeMask = mode == 0 ? 0 : 0x2080000;
        boolean srcIsNew = ((InfoObject)source).isNew();
        info_wire_ob3 packed = ((IPersistInfoObject)((Object)source)).pack(0, excludeMask, 0, 0);
        packed.uid = id.id;
        this.unpack(session, collection, packed);
        if (InfoObjects.isCopyNewObject(mode)) {
            this.setFlag(0x100000);
            this.setProperty((Object)PropertyIDs.SI_ID, new Integer(id.id));
            this.m_isNew = true;
            this.m_isUpdate = false;
            if (id.uid != null) {
                this.setProperty((Object)PropertyIDs.SI_GUID, id.uid);
                boolean isSameDeployment = this.getSession().getClusterName().equalsIgnoreCase(((IInternalInfoObject)source).getSession().getClusterName());
                if (isSameDeployment || this.getProperty(PropertyIDs.SI_CUID) == null) {
                    this.setProperty((Object)PropertyIDs.SI_CUID, id.uid);
                }
                if (isSameDeployment && mode != 3 || this.getProperty(PropertyIDs.SI_RUID) == null) {
                    this.setProperty((Object)PropertyIDs.SI_RUID, id.uid);
                }
            }
            this.copyFiles(source, srcIsNew);
            this.setProperty((Object)CePropertyID.SI_OWNERID, new Integer(this.m_session.getUserInfo().getUserID()));
            if (this.isNew() && this instanceof ICategoryContent) {
                this.m_props.removeLocal(PropertyIDs.SI_CORPORATE_CATEGORIES);
                this.m_props.removeLocal(PropertyIDs.SI_PERSONAL_CATEGORIES);
                this.m_props.removeLocal(ADM_ADD_CATEGORIES);
                this.m_props.removeLocal(ADM_DEL_CATEGORIES);
            }
            this.m_props.removeLocal(PropertyIDs.SI_SHORTCUTS);
            this.m_props.removeLocal(PropertyIDs.SI_ADM_ADD_SI_SHORTCUTS);
            this.m_props.removeLocal(PropertyIDs.SI_ADM_DEL_SI_SHORTCUTS);
            this.m_lastTimeStamp = ((IInternalInfoObject)source).getLastTimeStamp();
        } else if (mode == 0) {
            this.m_fileObjects = (Files)((InfoObject)source).getFileObjects();
            if (this.m_fileObjects != null) {
                IProperties copiedFileBag = this.m_fileObjects.properties();
                this.m_props.setProperty(PropertyIDs.SI_FILES, copiedFileBag);
            }
        }
    }

    public void update(ISecuritySession session, IInfoObject source) throws SDKException {
        source = (IInfoObject)InfoObjects.unproxyElement(source);
        LOG.assertEqual((Object)source.getCUID(), (Object)this.getCUID());
        info_wire_ob3 packed = ((IPersistInfoObject)((Object)source)).pack(false);
        int thisId = this.getID();
        String thisGUID = this.getGUID();
        int thisParentId = this.getParentID();
        int thisObjType = this.getObjType();
        int thisOwnerId = ((Property)this.getProperty(CePropertyID.SI_OWNERID)).getInt();
        boolean preserveFiles = source.properties().getProperty(PropertyIDs.SI_FILES) != null;
        IProperties thisFiles = null;
        if (preserveFiles) {
            try {
                IFiles files = this.getFiles();
                if (files != null) {
                    thisFiles = files.properties();
                }
            }
            catch (SDKException.PropertyNotFound e) {
                // empty catch block
            }
        }
        packed.uid = thisId;
        packed.options &= 0xFFEFFFFF;
        packed.options |= 0x80000;
        this.unpack(session, null, packed);
        this.setProperty((Object)PropertyIDs.SI_ID, new Integer(thisId));
        this.setProperty((Object)PropertyIDs.SI_GUID, thisGUID);
        this.setParentID(thisParentId);
        this.setObjType(thisObjType);
        this.setProperty((Object)CePropertyID.SI_OWNERID, new Integer(thisOwnerId));
        if (preserveFiles) {
            this.setProperty((Object)PropertyIDs.SI_FILES, thisFiles);
        }
        this.overwriteFiles(source);
        this.m_isNew = false;
        this.m_isUpdate = true;
    }

    public void delete() {
        this.m_options |= 0x200000;
    }

    public boolean isDirty() {
        return (this.m_options & 0x780000) != 0;
    }

    public boolean isReadOnly() {
        return (this.m_options & 0x200) != 0;
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        this.m_session = session;
        this.m_uid = id.id;
        this.m_parentId = 0;
        this.m_name = "";
        this.m_objType = type;
        this.m_options = 0x100000;
        this.m_lastTimeStamp = 0;
        this.m_isNew = true;
        this.m_isUpdate = false;
        try {
            this.setProperty((Object)PropertyIDs.SI_ID, new Integer(id.id));
            this.setProperty((Object)PropertyIDs.SI_OBTYPE, new Integer(type));
            this.setProperty((Object)PropertyIDs.SI_DESCRIPTION, "");
            this.setProperty((Object)PropertyIDs.SI_NAME, "");
            this.setProperty((Object)PropertyIDs.SI_PARENTID, new Integer(0));
            Integer userid = new Integer(this.m_session.getUserInfo().getUserID());
            this.setProperty((Object)PropertyIDs.SI_OWNERID, userid);
            this.setProperty((Object)PropertyIDs.SI_OWNER, this.m_session.getUserInfo().getUserName());
            if (id.uid != null) {
                this.setProperty((Object)PropertyIDs.SI_GUID, id.uid);
                this.setProperty((Object)PropertyIDs.SI_CUID, id.uid);
                this.setProperty((Object)PropertyIDs.SI_RUID, id.uid);
            }
        }
        catch (SDKException e) {
            LOG.error((Object)"initialize(): should never happen", (Throwable)((Object)e));
        }
    }

    public info_wire_ob3 pack(boolean dirtyOnly) {
        return this.pack(dirtyOnly, false);
    }

    public info_wire_ob3 pack(boolean dirtyOnly, boolean includeDynamic) {
        int includeMask = dirtyOnly && !this.m_isNew && !this.m_isUpdate ? 0x20000000 : 0;
        int clearMask = dirtyOnly ? 0x20000000 : 0;
        int excludeMask = includeDynamic ? 0 : 0x2000000;
        int setMask = 0;
        return this.pack(includeMask, excludeMask, clearMask, setMask);
    }

    public info_wire_ob3 pack(int includeMask, int excludeMask, int clearMask, int setMask) {
        Property obVersion;
        IBagPacker packer = this.getPacker();
        IProcessingInfo procInfo = this.getProcessingInfo();
        ISchedulingInfo scheInfo = this.getSchedulingInfo();
        char[] packedProcInfo = new char[]{};
        char[] packedSchedInfo = new char[]{};
        if (procInfo != null) {
            packedProcInfo = packer.packToChar((PropertyBag)procInfo.properties(), includeMask, excludeMask, false, clearMask, setMask);
        }
        if (scheInfo != null) {
            packedSchedInfo = packer.packToChar((PropertyBag)scheInfo.properties(), includeMask, excludeMask, false, clearMask, setMask);
        }
        if ((obVersion = (Property)this.properties().getProperty(PropertyIDs.SI_OBJ_VERSION)) == null) {
            obVersion = (Property)this.properties().add(PropertyIDs.SI_OBJ_VERSION, new Integer(0), 0);
        }
        obVersion.setFlag(0x20000000);
        info_wire_ob3 wire = new info_wire_ob3(this.m_uid, this.getParentID(), this.m_name, this.m_objType, this.m_options, this.m_lastTimeStamp, packer.packToChar((PropertyBag)this.m_props, includeMask, excludeMask, false, clearMask, setMask), packedSchedInfo, packedProcInfo);
        this.m_isNew = false;
        this.m_isUpdate = false;
        return wire;
    }

    public void unpack(ISecuritySession session, IInfoObjects collection, info_wire_ob3 obj) {
        this.m_session = session;
        IBagUnpacker unpacker = this.getUnpacker();
        unpacker.initialize((Object)obj.propBag);
        this.m_props.unpack(unpacker);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("unpack(): ID=" + obj.uid + ",name=" + obj.name + ", bag size=" + this.m_props.size()));
        }
        this.m_uid = obj.uid;
        this.m_name = obj.name;
        this.m_parentId = obj.parentId;
        this.m_lastTimeStamp = obj.lastTimeStamp;
        this.m_objType = obj.objType;
        this.m_options = obj.options;
        this.m_isNew = this.isFlagSet(0x100000);
        this.m_isUpdate = false;
        PropertyBag filesProp = this.m_props.getPropertyBag(PropertyIDs.SI_FILES);
        if (filesProp != null) {
            this.m_origFilesProps = filesProp.copy();
        }
    }

    public void useAsDelegate(IInternalInfoObject obj) {
        this.m_session = obj.getSession();
        this.m_props = (SDKPropertyBag)obj.properties();
        this.m_isUpdate = false;
        this.m_isUsedAsDelegate = true;
    }

    public void merge(info_wire_ob3 wireObj) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("merge(): ID=" + this.getID() + ",name=" + this.getTitle() + ",old bag size=" + this.m_props.size()));
        }
        IBagUnpacker unpacker = this.getUnpacker();
        unpacker.initialize((Object)wireObj.propBag);
        this.m_props.merge(unpacker);
        this.m_isNew = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("merge(): new bag size=" + this.m_props.size()));
        }
    }

    public boolean isDeepCopySupported() {
        return false;
    }

    public void setInstanceOperationFlag() {
        this.m_options |= 0x400000;
    }

    public void saveRights(IRightsAdmin rightsAdmin) throws SDKException {
        if (this.m_securityInfo != null) {
            this.m_securityInfo.saveRights(rightsAdmin);
        }
    }

    public void saveRights2(ISecRightsAdmin rightsAdmin) throws SDKException {
        if (this.m_securityInfo != null) {
            this.m_securityInfo.saveRights2(rightsAdmin);
        }
        if (this.m_securityInfo2 != null) {
            this.m_securityInfo2.saveRights2(rightsAdmin);
        }
    }

    public boolean isSecurityDirty() throws SDKException {
        if (this.m_securityInfo != null && ((ObjectPrincipals)this.m_securityInfo.getObjectPrincipals()).isDirty()) {
            return true;
        }
        return this.m_securityInfo2 != null && ((ExplicitPrincipals)this.m_securityInfo2.getExplicitPrincipals()).isDirty();
    }

    public String getDescription() {
        String desc = this.m_props.getString(PropertyIDs.SI_DESCRIPTION);
        return desc == null ? "" : desc;
    }

    public void setDescription(String desc) {
        this.m_props.setProperty(PropertyIDs.SI_DESCRIPTION, desc);
    }

    public int getID() {
        return this.m_uid;
    }

    public boolean isInstance() {
        if (!this.isNew()) {
            return (this.m_objType & 0x8000) != 0;
        }
        IProperty prop = this.getProperty(PropertyIDs.SI_INSTANCE);
        if (prop == null) {
            return false;
        }
        Object value = prop.getValue();
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public int getParentID() {
        IProperty parentProp = this.properties().getProperty(PropertyIDs.SI_PARENTID);
        if (parentProp != null) {
            this.m_parentId = (Integer)parentProp.getValue();
        }
        return this.m_parentId;
    }

    public IProcessingInfo getProcessingInfo() {
        return null;
    }

    public Integer[] propertyIDs() {
        Set keys = this.m_props.keySet();
        Integer[] ids = new Integer[keys.size()];
        return keys.toArray(ids);
    }

    public IProperty getProperty(Object id) {
        return this.m_props.getProperty(id);
    }

    public IProperty addProperty(Object id, Object value, int flags) {
        return this.m_props.add(id, value, flags);
    }

    public IProperties properties() {
        return this.m_props;
    }

    public ISchedulingInfo getSchedulingInfo() {
        return null;
    }

    public ISecurityInfo getSecurityInfo() {
        LOG.assertNotNull((Object)this.m_session, "m_session is null.");
        if (this.m_securityInfo == null) {
            this.m_securityInfo = new SecurityInfo(this, this.m_session);
        }
        return this.m_securityInfo;
    }

    public ISecurityInfo2 getSecurityInfo2() throws SDKException {
        LOG.assertNotNull((Object)this.m_session, "m_session is null.");
        if (this.m_securityInfo2 == null) {
            this.m_securityInfo2 = new SecurityInfo2(this, this.m_session);
        }
        return this.m_securityInfo2;
    }

    public String getTitle() {
        return this.m_name;
    }

    public void setTitle(String title) {
        this.setProperty((Object)PropertyIDs.SI_NAME, title);
        this.m_name = title;
    }

    public String createFrsUrl() {
        FrsURL url = new FrsURL(this.getDefaultFRSFriendlyName(), this.getDefaultDestFRSDirPath());
        return url.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IFiles getFiles() throws SDKException {
        if (this.m_fileObjects != null) return this.m_fileObjects;
        Property filesProp = this.m_props.getItem(PropertyIDs.SI_FILES);
        if (filesProp == null) {
            if (!this.m_isNew) throw new SDKException.PropertyNotFound(PropertyIDs.SI_FILES);
            String pathURL = this.createFrsUrl();
            final SDKPropertyBag filesBag = new SDKPropertyBag();
            Files fileObjects = new Files();
            fileObjects.initialize(filesBag, pathURL, this.m_session, this);
            this.m_fileObjects = fileObjects;
            filesBag.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(Property changed) {
                    filesBag.removePropertyChangeListener((IPropertyChangeListener)this);
                    InfoObject.this.m_props.setProperty(PropertyIDs.SI_FILES, filesBag);
                    InfoObject.this.m_fileObjects.propertyChanged();
                    filesBag.setProperty((Object)changed.getID(), changed.getValue());
                }
            });
            return this.m_fileObjects;
        } else {
            PropertyBag filesBag = (PropertyBag)filesProp.getValue();
            this.m_fileObjects = new Files();
            this.m_fileObjects.readFrom(filesBag, this.m_session, this.getSecurityInfo2(), true, this, null, false);
        }
        return this.m_fileObjects;
    }

    public int hashCode() {
        return this.getID();
    }

    public boolean equals(Object obj) {
        IProperty guidProp;
        IInternalInfoObject infoObject;
        if (this == obj) {
            return true;
        }
        if ((obj = InfoObjects.unproxyElement(obj)) instanceof IInternalInfoObject && (infoObject = (IInternalInfoObject)obj).getID() == this.getID() && (guidProp = this.getProperty(PropertyIDs.SI_GUID)) != null) {
            IProperty otherGuidProp = infoObject.getProperty(PropertyIDs.SI_GUID);
            if (otherGuidProp != null) {
                return guidProp.getValue().equals(otherGuidProp.getValue());
            }
            String cluster = this.getSession().getClusterName();
            String otherCluster = infoObject.getSession().getClusterName();
            return cluster.equalsIgnoreCase(otherCluster);
        }
        return false;
    }

    public void setProperty(Object id, Object value) {
        this.m_props.setProperty(id, value);
    }

    public void setProperty(Object id, boolean value) {
        this.setProperty(id, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setProperty(Object id, int value) {
        this.setProperty(id, IntegerConversion.getDefaultInteger((int)value));
    }

    public void setFlag(int flag) {
        this.m_options |= flag;
    }

    public void clearFlag(int flag) {
        this.m_options &= ~flag;
    }

    public boolean isFlagSet(int flag) {
        return (this.m_options & flag) != 0;
    }

    IBagUnpacker getUnpacker() {
        return new WireOb3Unpacker();
    }

    IBagPacker getPacker() {
        return new WireOb3Packer();
    }

    public void setSecuritySurrogate(int surrogateID) {
        this.m_securitySurrogateID = surrogateID;
    }

    public int getSecuritySurrogate() {
        if (this.m_securitySurrogateID == 0) {
            return this.getParentID();
        }
        return this.m_securitySurrogateID;
    }

    protected String getDefaultDestFRSDirPath() {
        StringBuffer ret = new StringBuffer("a_");
        int idModLevel = 0;
        int sRemainig = this.getID();
        for (int i = 0; i < 3; ++i) {
            idModLevel = sRemainig % 256;
            sRemainig /= 256;
            ret.append(idModLevel < 10 ? "00" : (idModLevel < 100 ? "0" : ""));
            ret.append(idModLevel);
            ret.append("/");
        }
        ret.append(this.getID());
        ret.append("/");
        return ret.toString();
    }

    protected String getDefaultFRSFriendlyName() {
        try {
            if (this.isInstance() && this.getSchedulingInfo().getStatus() == 1) {
                return OUTPUT_FRS_FRIENDLY_NAME;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return INPUT_FRS_FRIENDLY_NAME;
    }

    private void copyFiles(IInfoObject source, boolean srcIsNew) throws SDKException {
        if (((IInternalInfoObject)source).getSession().getClusterName().equalsIgnoreCase(this.getSession().getClusterName())) {
            this.copyFilesWithinDeployment(source, srcIsNew);
        } else {
            this.copyFilesAcrossDeployments(source);
        }
    }

    private void copyFilesWithinDeployment(IInfoObject source, boolean srcIsNew) throws SDKException {
        IProperty srcFilesProp = source.properties().getProperty(PropertyIDs.SI_FILES);
        if (srcFilesProp != null && srcFilesProp.getValue() instanceof PropertyBag) {
            String[] pathTokens;
            int fileDir;
            IFiles sourceFileObjects = source.getFiles();
            String srcFrsPath = sourceFileObjects.getFRSPathURL();
            if (srcFrsPath.charAt(srcFrsPath.length() - 1) != '/') {
                srcFrsPath = srcFrsPath + '/';
            }
            if ((fileDir = Integer.parseInt((pathTokens = srcFrsPath.split("/"))[pathTokens.length - 1])) != source.getID()) {
                ObjectRelatives sharedDocs = new ObjectRelatives();
                sharedDocs.initialize((Object)PropertyIDs.SI_SHARED_DOC, this.m_props, false, true);
                sharedDocs.add(new Integer(fileDir));
            } else {
                String host = null;
                try {
                    FrsURL srcFolderURL = new FrsURL(srcFrsPath);
                    host = srcFolderURL.getHost();
                }
                catch (SILibException e) {
                    throw new SDKException.URIFormat(srcFrsPath, (Exception)((Object)e));
                }
                FrsURL destURL = new FrsURL(host, this.getDefaultDestFRSDirPath());
                this.m_fileObjects = (Files)((Files)sourceFileObjects).copy(destURL.toString(), srcIsNew, this);
                IProperties newFileBag = this.m_fileObjects.properties();
                this.m_props.setProperty(PropertyIDs.SI_FILES, newFileBag);
            }
        }
    }

    private void copyFilesAcrossDeployments(IInfoObject source) throws SDKException {
        IProperty srcFilesProp = source.properties().getProperty(PropertyIDs.SI_FILES);
        if (srcFilesProp != null && srcFilesProp.getValue() instanceof PropertyBag) {
            this.m_props.removeLocal(PropertyIDs.SI_FILES);
            IFiles destFiles = this.getFiles();
            destFiles.clear();
            IFiles sourceFiles = source.getFiles();
            Iterator Iter = sourceFiles.iterator();
            while (Iter.hasNext()) {
                IRemoteFile srcFile = (IRemoteFile)Iter.next();
                byte[] result = new byte[(int)srcFile.getSize()];
                srcFile.download(result);
                srcFile.commit();
                destFiles.addUniqueFile(result);
            }
        }
        this.m_props.removeLocal(PropertyIDs.SI_SHARED_DOC);
        this.m_props.removeLocal(PropertyIDs.SI_ADM_ADD_SI_SHARED_DOC);
        this.m_props.removeLocal(PropertyIDs.SI_ADM_DEL_SI_SHARED_DOC);
    }

    private void overwriteFiles(IInfoObject source) throws SDKException {
        IProperty destFilesProp = this.properties().getProperty(PropertyIDs.SI_FILES);
        if (destFilesProp == null) {
            this.copyFiles(source, false);
        } else {
            IProperty srcFilesProp = source.properties().getProperty(PropertyIDs.SI_FILES);
            if (srcFilesProp != null && srcFilesProp.getValue() instanceof PropertyBag && destFilesProp.getValue() instanceof PropertyBag) {
                String srcLocalFile;
                IFiles sourceFileObjects = source.getFiles();
                IFiles destFileObjects = this.getFiles();
                int i = 0;
                Iterator iter = sourceFileObjects.iterator();
                while (iter.hasNext() && destFileObjects.get(i) != null) {
                    srcLocalFile = this.getFileLocalPath(iter.next());
                    destFileObjects.replaceUnique(i++, srcLocalFile, true);
                }
                while (iter.hasNext()) {
                    srcLocalFile = this.getFileLocalPath(iter.next());
                    destFileObjects.addUniqueFile(srcLocalFile, true);
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFileLocalPath(Object file) throws SDKException {
        String localFileName = null;
        if (file instanceof ILocalFile) {
            ILocalFile localFile = (ILocalFile)file;
            try {
                return localFile.getLocalFile();
            }
            catch (UnsupportedOperationException use) {
                IOException e2;
                InputStream stream;
                FilterOutputStream bf;
                block17: {
                    bf = null;
                    stream = null;
                    stream = localFile.getInputStream();
                    File tempFile = File.createTempFile("crystal", ".tmp");
                    FileCleaner.registerCleanupTarget((String)tempFile.getAbsolutePath());
                    String tempLocalFileName = tempFile.getCanonicalPath();
                    bf = new BufferedOutputStream(new FileOutputStream(tempLocalFileName));
                    int ch = stream.read();
                    while (ch != -1) {
                        ((BufferedOutputStream)bf).write(ch);
                        ch = stream.read();
                    }
                    ((BufferedOutputStream)bf).flush();
                    localFileName = tempLocalFileName;
                    Object var11_15 = null;
                    if (bf == null) break block17;
                    try {
                        bf.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                if (stream == null) return localFileName;
                try {
                    stream.close();
                    return localFileName;
                }
                catch (IOException e2) {}
                return localFileName;
                {
                    catch (IOException e3) {
                        throw new SDKException.Unexpected(e3);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    if (bf != null) {
                        try {
                            bf.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        try {
            File tempFile = File.createTempFile("crystal", ".tmp");
            FileCleaner.registerCleanupTarget((String)tempFile.getAbsolutePath());
            String tempLocalFileName = tempFile.getCanonicalPath();
            IRemoteFile remoteFileObject = (IRemoteFile)file;
            remoteFileObject.download(tempLocalFileName);
            remoteFileObject.commit();
            return tempLocalFileName;
        }
        catch (IOException e) {
            throw new SDKException.Unexpected(e);
        }
    }

    public IFiles getFileObjects() {
        return this.m_fileObjects;
    }

    public String toString() {
        return "(InfoObject:main property bag=" + this.m_props + ",isNew=" + this.m_isNew + ",file objects=" + this.m_fileObjects + ",session=" + this.m_session + ")";
    }

    public ISecuritySession getSession() {
        return this.m_session;
    }

    public boolean isNew() {
        return this.m_isNew;
    }

    public int getObjType() {
        return this.m_objType;
    }

    public int getLastTimeStamp() {
        return this.m_lastTimeStamp;
    }

    public int getNonInstanceObjType() {
        if (this.isInstance()) {
            return this.m_objType & 0xFFFF7FFF & 0xFFFF;
        }
        return this.m_objType;
    }

    public void setObjType(int obType) {
        if (this.m_objType != obType) {
            this.m_objType = (short)obType;
            IProperty prop = this.getProperty(PropertyIDs.SI_OBTYPE);
            if (prop != null) {
                prop.setValue(new Integer(obType));
            }
        }
    }

    SDKPropertyBag getRootBag() {
        return this.m_rootBag;
    }

    public String getGUID() throws SDKException {
        IProperty guidProp = this.getProperty(PropertyIDs.SI_GUID);
        if (guidProp != null) {
            return (String)guidProp.getValue();
        }
        throw new SDKException.PropertyNotFound(PropertyIDs.SI_GUID);
    }

    public String getCUID() throws SDKException {
        IProperty cuidProp = this.getProperty(PropertyIDs.SI_CUID);
        if (cuidProp != null) {
            return (String)cuidProp.getValue();
        }
        throw new SDKException.PropertyNotFound(PropertyIDs.SI_CUID);
    }

    private String getCUIDFromCMS() throws SDKException {
        IProperty cuidProp = this.getProperty(PropertyIDs.SI_CUID);
        if (cuidProp == null) {
            IInternalInfoStore infoStore = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA(this.m_session.getAPSName(), this.m_session);
            IInfoObjects objs = infoStore.query("SELECT SI_CUID FROM CI_INFOOBJECTS,CI_APPOBJECTS,CI_SYSTEMOBJECTS WHERE SI_ID=" + this.getID());
            IInfoObject obj = (IInfoObject)objs.get(0);
            cuidProp = obj.properties().getProperty(PropertyIDs.SI_CUID);
            Property thisCuidProp = (Property)obj.properties().add(PropertyIDs.SI_CUID, cuidProp.getValue(), 0);
            thisCuidProp.setFlags(cuidProp.getFlags());
        }
        return (String)cuidProp.getValue();
    }

    public String getRUID() throws SDKException {
        IProperty ruidProp = this.getProperty(PropertyIDs.SI_RUID);
        if (ruidProp != null) {
            return (String)ruidProp.getValue();
        }
        throw new SDKException.PropertyNotFound(PropertyIDs.SI_RUID);
    }

    public String getParentCUID() throws SDKException {
        IProperty parentCUID = this.getProperty(PropertyIDs.SI_PARENT_CUID);
        if (parentCUID != null) {
            return (String)parentCUID.getValue();
        }
        throw new SDKException.PropertyNotFound(PropertyIDs.SI_PARENT_CUID);
    }

    public void setParentID(int parentId) {
        this.setProperty((Object)PropertyIDs.SI_PARENTID, new Integer(parentId));
        this.m_parentId = parentId;
    }

    public String getProgID() throws SDKException {
        IProperty progID = this.getProperty(PropertyIDs.SI_PROGID);
        if (progID == null) {
            IPluginMgr pluginMgr = (IPluginMgr)PluginMgrFactory.getFactory().makeOCCA("", this.m_session);
            IPluginInfo pluginInfo = pluginMgr.getPluginInfo(new Integer(this.m_objType & 0xFFFF7FFF));
            return pluginInfo.getProgID();
        }
        return (String)progID.getValue();
    }

    protected Set getCorporateCategories() throws SDKException {
        if (this.m_corporateCategoryIDs == null) {
            this.m_corporateCategoryIDs = new ObjectRelatives();
            ((ObjectRelatives)this.m_corporateCategoryIDs).initialize(PropertyIDs.SI_CORPORATE_CATEGORIES, PropertyIDs.idToName(PropertyIDs.SI_CATEGORIES), this.properties(), false, this.isNew());
        }
        return this.m_corporateCategoryIDs;
    }

    protected Set getPersonalCategories() throws SDKException {
        if (this.m_personalCategoryIDs == null) {
            this.m_personalCategoryIDs = new ObjectRelatives();
            ((ObjectRelatives)this.m_personalCategoryIDs).initialize(PropertyIDs.SI_PERSONAL_CATEGORIES, PropertyIDs.idToName(PropertyIDs.SI_CATEGORIES), this.properties(), false, this.isNew());
        }
        return this.m_personalCategoryIDs;
    }

    public void retrievePropertySet(int propertySet) throws SDKException {
        if (this.m_isNew) {
            return;
        }
        if (propertySet != 1 && propertySet != 7 && propertySet != 4 && propertySet != 2) {
            throw new SDKException.InvalidArg(propertySet);
        }
        if (this.m_lastPropertiesSet < propertySet) {
            StringBuffer where = new StringBuffer();
            where.append("SI_ID = ");
            where.append(this.getID());
            IInternalInfoStore infoStore = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA(this.m_session.getAPSName(), this.m_session);
            QuerySettings query = new QuerySettings(infoStore, "CI_INFOOBJECTS, CI_SYSTEMOBJECTS, CI_APPOBJECTS", QuerySettings.ToFields(propertySet), where.toString());
            IInfoObjects objs = query.executeQuery();
            if (objs.size() != 1) {
                throw new SDKException.ObjectNotFound(this.getCUID());
            }
            Object obj = InfoObjects.unproxyElement(objs.get(0));
            if (obj instanceof IInternalInfoObject) {
                IInternalInfoObject obj1 = (IInternalInfoObject)obj;
                this.merge(obj1.pack(false));
                this.m_lastPropertiesSet = propertySet;
            }
        }
    }

    public IInfoObject getParent() throws SDKException {
        return this.getParent(1);
    }

    public IInfoObject getParent(int propertySet) throws SDKException {
        IInternalInfoStore infoStore;
        QuerySettings query;
        IInfoObjects objs;
        long id = this.getParentID();
        if (id == 0L) {
            id = 4L;
        }
        if ((objs = (query = new QuerySettings(infoStore = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA(this.m_session.getAPSName(), this.m_session), "CI_INFOOBJECTS, CI_SYSTEMOBJECTS, CI_APPOBJECTS", QuerySettings.ToFields(propertySet), "SI_ID=" + id)).executeQuery()).size() != 1) {
            return null;
        }
        return (IInfoObject)objs.get(0);
    }

    public void save() throws SDKException {
        IInternalInfoStore infoStore = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA(this.m_session.getAPSName(), this.m_session);
        IInfoObjects objs = infoStore.newInfoObjectCollection();
        objs.add(this);
        infoStore.commit(objs);
    }

    public void deleteNow() throws SDKException {
        IInternalInfoStore infoStore = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA(this.m_session.getAPSName(), this.m_session);
        IInfoObjects objs = infoStore.newInfoObjectCollection();
        ((InfoObjects)objs).add(this);
        objs.delete(this);
        infoStore.commit(objs);
    }

    public void unlockNow() throws SDKException {
        IInternalInfoStore infoStore = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA(this.m_session.getAPSName(), this.m_session);
        IInfoObjects objs = infoStore.newInfoObjectCollection();
        ((InfoObjects)objs).add(this);
        infoStore.unlock(objs);
    }

    public IInfoObjectEventListener getInfoObjectEventListener(int type) {
        if (type == 1) {
            return s_prepareCopyEventListener;
        }
        if (type == 7) {
            return s_prepareSendToEventListener;
        }
        if (type == 2) {
            return s_prepareCommitEventListener;
        }
        if (type == 9) {
            return s_prepareImportEventListener;
        }
        if (type == 10) {
            return s_prepareDeliveryToInboxEventListener;
        }
        return null;
    }

    public String getKeyword() {
        String keyword = this.m_props.getString(PropertyIDs.SI_KEYWORD);
        return keyword == null ? "" : keyword;
    }

    public void setKeyword(String keyword) throws SDKException {
        if (keyword == null) {
            throw new SDKException.InvalidArg();
        }
        this.m_props.setProperty(PropertyIDs.SI_KEYWORD, keyword);
    }

    public String getKind() throws SDKException {
        String kind = this.m_props.getString(PropertyIDs.SI_KIND);
        if (kind != null) {
            return kind;
        }
        IPluginMgr pluginMgr = (IPluginMgr)PluginMgrFactory.getFactory().makeOCCA("", this.m_session);
        IPluginInfo pluginInfo = pluginMgr.getPluginInfo(new Integer(this.m_objType & 0xFFFF7FFF));
        return pluginInfo.getKind();
    }

    public boolean isMarkedAsRead() throws SDKException {
        return this.m_props.getBoolean(PropertyIDs.SI_MARKED_AS_READ);
    }

    public void setMarkedAsRead(boolean value) {
        this.m_props.setProperty(PropertyIDs.SI_MARKED_AS_READ, value);
    }

    protected IInternalInfoStore getInfoStore() throws SDKException {
        return (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA(this.getSession().getAPSName(), this.getSession());
    }

    public String getDelta() throws SDKException {
        return this.getDelta(65535);
    }

    public String getDelta(int deltaFlags) throws SDKException {
        boolean getFileDelta;
        boolean getPropDelta = (deltaFlags & 1) != 0;
        boolean bl = getFileDelta = (deltaFlags & 2) != 0;
        if (!getPropDelta && !getFileDelta) {
            throw new SDKException.InvalidArg(deltaFlags);
        }
        SDKPropertyBag root = this.m_props;
        if (!getPropDelta) {
            root = new SDKPropertyBag();
        }
        boolean filePropWasDirty = false;
        boolean filePropWasRemoved = false;
        Property filesProp = this.m_props.getItem(PropertyIDs.SI_FILES);
        if (filesProp != null && filesProp.isDirty()) {
            filePropWasDirty = true;
            filesProp.cleanFlag(0x20000000);
        }
        if (filePropWasDirty && getFileDelta) {
            SDKPropertyBag fileOpBag = (SDKPropertyBag)root.addPropertyBag(SI_DELTA_FILEOPS, null).getPropertyBag();
            this.m_fileObjects.saveOps(fileOpBag);
        }
        SDKPropertyBag metaInfo = (SDKPropertyBag)root.addPropertyBag(SI_DELTA_METAINFO, null).getPropertyBag();
        metaInfo.addItem(PropertyIDs.SI_CUID, this.getCUIDFromCMS(), 0);
        Integer objVersion = null;
        IProperty objVersionProp = this.getProperty(PropertyIDs.SI_OBJ_VERSION);
        if (objVersionProp != null) {
            objVersion = (Integer)objVersionProp.getValue();
        }
        if (objVersion != null) {
            metaInfo.addItem(PropertyIDs.SI_OBJ_VERSION, objVersion, 0);
        }
        int includeMask = 0;
        if (!this.m_isNew && !this.m_isUpdate) {
            includeMask = 0x20000000;
        } else if (!getFileDelta && root.containsKey(PropertyIDs.SI_FILES)) {
            root.removeLocal(PropertyIDs.SI_FILES);
            filePropWasRemoved = true;
        }
        IBagPacker packer = this.getPacker();
        char[] result1 = packer.packToChar((PropertyBag)root, includeMask, 0, false, 0, 0);
        SDKPropertyBag allroot = new SDKPropertyBag();
        allroot.addItem(PropertyIDs.SI_DELTA, result1, 0);
        IProcessingInfo procInfo = this.getProcessingInfo();
        ISchedulingInfo scheInfo = this.getSchedulingInfo();
        if (procInfo != null) {
            char[] packedProcInfo = packer.packToChar((PropertyBag)procInfo.properties(), includeMask, 0, false, 0, 0);
            allroot.addItem(PropertyIDs.SI_PROCESSINFO, packedProcInfo, 0);
        }
        if (scheInfo != null) {
            char[] packedSchedInfo = packer.packToChar((PropertyBag)scheInfo.properties(), includeMask, 0, false, 0, 0);
            allroot.addItem(PropertyIDs.SI_SCHEDULEINFO, packedSchedInfo, 0);
        }
        String result = this.getPacker().pack((PropertyBag)allroot, 0, 0, false, 0, 0);
        root.removeLocal(SI_DELTA_METAINFO);
        if (filePropWasRemoved) {
            Object value = null;
            if (filesProp != null) {
                value = filesProp.getValue();
            }
            root.addItem(PropertyIDs.SI_FILES, value, 0);
        }
        if (filePropWasDirty) {
            filesProp.setFlag(0x20000000);
            if (getFileDelta) {
                root.removeLocal(SI_DELTA_FILEOPS);
            }
        }
        return result;
    }

    public boolean applyDelta(String delta) throws SDKException {
        return this.applyDelta(delta, 65535);
    }

    public boolean applyDelta(String delta, int deltaFlags) throws SDKException {
        int id;
        Date thisTS;
        SDKException.PropertyNotFound updateTimeStampException;
        boolean applyFileDelta;
        boolean applyPropDelta;
        block21: {
            if (delta == null || delta.length() == 0) {
                return true;
            }
            applyPropDelta = (deltaFlags & 1) != 0;
            boolean bl = applyFileDelta = (deltaFlags & 2) != 0;
            if (!applyPropDelta && !applyFileDelta) {
                throw new SDKException.InvalidArg(deltaFlags);
            }
            updateTimeStampException = null;
            thisTS = null;
            try {
                thisTS = this.getUpdateTimeStamp();
            }
            catch (SDKException.PropertyNotFound e) {
                if (this.m_isNew) break block21;
                updateTimeStampException = e;
            }
        }
        Integer thisObjVersion = null;
        IProperty objVersionProp = this.properties().getProperty(PropertyIDs.SI_OBJ_VERSION);
        if (objVersionProp != null) {
            thisObjVersion = (Integer)objVersionProp.getValue();
        }
        String thisCUID = this.getCUIDFromCMS();
        boolean hasOrigFilesBag = false;
        PropertyBag origFilesBag = this.m_props.getPropertyBag(PropertyIDs.SI_FILES);
        if (origFilesBag != null) {
            hasOrigFilesBag = true;
        }
        IBagUnpacker unpacker = this.getUnpacker();
        unpacker.initialize((Object)delta);
        SDKPropertyBag allroot = new SDKPropertyBag();
        allroot.merge(unpacker);
        String result1 = allroot.getString(PropertyIDs.SI_DELTA);
        IBagUnpacker unpacker1 = this.getUnpacker();
        unpacker1.initialize((Object)result1);
        String processInfo = allroot.getString(PropertyIDs.SI_PROCESSINFO);
        String scheduleInfo = allroot.getString(PropertyIDs.SI_SCHEDULEINFO);
        SDKPropertyBag root = this.m_props;
        if (!applyPropDelta) {
            root = new SDKPropertyBag();
        }
        if (processInfo != null) {
            IBagUnpacker unpackerProcessInfo = this.getUnpacker();
            unpackerProcessInfo.initialize((Object)processInfo);
            ProcessingInfo procInfo = (ProcessingInfo)this.getProcessingInfo();
            procInfo.merge(unpackerProcessInfo, true, true);
        }
        if (scheduleInfo != null) {
            IBagUnpacker unpackerScheduleInfo = this.getUnpacker();
            unpackerScheduleInfo.initialize((Object)scheduleInfo);
            SchedulingInfo scheInfo = (SchedulingInfo)this.getSchedulingInfo();
            scheInfo.merge(unpackerScheduleInfo, true, true);
        }
        root.merge(unpacker1, true, true);
        boolean isIDChanged = false;
        Property idProp = root.getItem(PropertyIDs.SI_ID);
        if (idProp != null && (id = idProp.getInt()) != this.m_uid) {
            isIDChanged = true;
            root.setProperty(PropertyIDs.SI_ID, this.m_uid);
        }
        root.setProperty(PropertyIDs.SI_CUID, thisCUID);
        SDKPropertyBag metaInfo = (SDKPropertyBag)root.getPropertyBag(SI_DELTA_METAINFO);
        if (metaInfo == null) {
            throw new SDKException.PropertyNotFound(SI_DELTA_METAINFO);
        }
        SDKPropertyBag fileOpBag = (SDKPropertyBag)root.getPropertyBag(SI_DELTA_FILEOPS);
        if (applyFileDelta && fileOpBag != null && !fileOpBag.isEmpty()) {
            if (isIDChanged) {
                if (hasOrigFilesBag) {
                    throw new SDKException.OriginalObjectHasChanged(new Integer(this.getID()), this.getTitle(), this.getKind());
                }
                this.m_fileObjects = null;
                this.properties().removeLocal(PropertyIDs.SI_FILES);
            }
            Files files = (Files)this.getFiles();
            files.doOps(fileOpBag);
        }
        root.removeLocal(SI_DELTA_METAINFO);
        root.removeLocal(SI_DELTA_FILEOPS);
        boolean throwException = false;
        Property cuidProp = metaInfo.getItem(PropertyIDs.SI_CUID);
        Property objVersion = metaInfo.getItem(PropertyIDs.SI_OBJ_VERSION);
        Property tsProp = metaInfo.getItem(PropertyIDs.SI_UPDATE_TS);
        if (objVersion != null || objVersion == null && tsProp == null) {
            throwException = !this.deltaVersionsMatch(cuidProp, objVersion, thisCUID, thisObjVersion);
        } else {
            boolean bl = throwException = !this.deltaTimestampsMatch(cuidProp, tsProp, thisCUID, thisTS, updateTimeStampException);
        }
        if (throwException) {
            throw new SDKException.OriginalObjectHasChanged(new Integer(this.getID()), this.getTitle(), this.getKind());
        }
        Property prop = this.m_props.getItem(PropertyIDs.SI_PARENTID);
        if (prop != null) {
            this.m_parentId = prop.getInt();
        } else {
            LOG.warn((Object)"applyDelta(): SI_PARENTID not found.");
        }
        prop = this.m_props.getItem(PropertyIDs.SI_NAME);
        if (prop != null) {
            this.m_name = prop.getString();
        } else {
            LOG.warn((Object)"applyDelta(): SI_NAME not found.");
        }
        return true;
    }

    private boolean deltaTimestampsMatch(Property metaInfoCuidProp, Property metaInfoTsProp, String thisCuid, Date thisTS, SDKException updateTimeStampException) throws SDKException {
        if (metaInfoCuidProp == null) {
            throw new SDKException.PropertyNotFound(SI_DELTA_METAINFO);
        }
        boolean cuidsMatch = metaInfoCuidProp.getString().equals(thisCuid);
        boolean tsMatch = false;
        if (metaInfoTsProp == null && this.m_isNew) {
            tsMatch = true;
        } else {
            if (cuidsMatch && updateTimeStampException != null) {
                throw updateTimeStampException;
            }
            if (cuidsMatch && metaInfoTsProp != null && thisTS != null && metaInfoTsProp.getDate().equals(thisTS)) {
                tsMatch = true;
            }
        }
        return !cuidsMatch || tsMatch;
    }

    private boolean deltaVersionsMatch(Property metaInfoCuidProp, Property metaInfoObjVersion, String thisCuid, Integer thisObjVersion) throws SDKException {
        if (metaInfoCuidProp == null) {
            throw new SDKException.PropertyNotFound(SI_DELTA_METAINFO);
        }
        boolean cuidsMatch = metaInfoCuidProp.getString().equals(thisCuid);
        boolean objVersionsMatch = false;
        if (metaInfoObjVersion == null && this.m_isNew) {
            objVersionsMatch = true;
        } else {
            if (cuidsMatch && thisObjVersion == null && !this.m_isNew) {
                throw new SDKException.PropertyNotFound(PropertyIDs.SI_OBJ_VERSION);
            }
            if (cuidsMatch && metaInfoObjVersion != null && thisObjVersion != null && metaInfoObjVersion.getValue().equals(thisObjVersion)) {
                objVersionsMatch = true;
            }
        }
        return !cuidsMatch || objVersionsMatch;
    }

    public Date getUpdateTimeStamp() throws SDKException {
        IProperty tsProp = this.getProperty(PropertyIDs.SI_UPDATE_TS);
        if (tsProp == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_UPDATE_TS);
        }
        return (Date)tsProp.getValue();
    }

    protected final Object writeReplace() throws ObjectStreamException {
        this.prepareForSerialization();
        Files files = this.m_fileObjects;
        Property filesProp = this.m_props.getItem(PropertyIDs.SI_FILES);
        if (filesProp == null || !filesProp.isDirty()) {
            files = null;
        }
        SDKPropertyBag schedulingInfoBag = null;
        ISchedulingInfo schedulingInfo = this.getSchedulingInfo();
        if (schedulingInfo != null) {
            schedulingInfoBag = ((SchedulingInfo)schedulingInfo).getSchedulingInfoBag();
        }
        SDKPropertyBag processingInfoBag = null;
        IProcessingInfo processingInfo = this.getProcessingInfo();
        if (processingInfo != null) {
            processingInfoBag = ((ProcessingInfo)processingInfo).getProcessingInfoBag();
        }
        return new SerializableInfoObject(this.m_objType & 0xFFFF7FFF, this.m_session, this.m_rootBag, this.m_serBag, schedulingInfoBag, processingInfoBag, files, this.m_securityInfo, this.m_securityInfo2, this.getDefaultFRSFriendlyName(), this.m_origFilesProps);
    }

    protected void prepareForSerialization() {
        this.m_serBag.addItem((Object)PropertyIDs.SI_ID, (Object)new Integer(this.m_uid), 0);
        this.m_serBag.addItem((Object)PropertyIDs.SI_PARENTID, (Object)new Integer(this.m_parentId), 0);
        this.m_serBag.addItem((Object)PropertyIDs.SI_NAME, (Object)this.m_name, 0);
        this.m_serBag.addItem((Object)PropertyIDs.SI_OBTYPE, (Object)new Integer(this.m_objType), 0);
        this.m_serBag.addItem((Object)SI_BASE_LAST_PROPSET, (Object)new Integer(this.m_lastPropertiesSet), 0);
        this.m_serBag.addItem((Object)SI_BASE_ISNEW, (Object)(this.m_isNew ? Boolean.TRUE : Boolean.FALSE), 0);
        this.m_serBag.addItem((Object)SI_BASE_ISUPDATE, (Object)(this.m_isUpdate ? Boolean.TRUE : Boolean.FALSE), 0);
        this.m_serBag.addItem((Object)SI_BASE_OPTIONS, (Object)new Integer(this.m_options), 0);
        this.m_serBag.addItem((Object)SI_BASE_LAST_TS, (Object)new Integer(this.m_lastTimeStamp), 0);
        this.m_serBag.addItem((Object)PropertyIDs.SI_BASE_SEC_SURROGATE, (Object)new Integer(this.m_securitySurrogateID), 0);
    }

    public void initFromSerialization(ISecuritySession session, String packedRootProps, String packedSerProps, IFiles files, ISecurityInfo deltaSecurityInfo, ISecurityInfo2 deltaSecurityInfo2) throws SDKException {
        SecurityInfo2 secInfo2;
        SecurityInfo secInfo;
        this.m_session = session;
        IBagUnpacker unpacker = this.getUnpacker();
        unpacker.initialize((Object)packedRootProps);
        this.m_rootBag.merge(unpacker);
        IBagUnpacker innerUnpacker = this.getUnpacker();
        innerUnpacker.initialize((Object)packedSerProps);
        this.m_serBag.merge(innerUnpacker);
        this.m_uid = this.m_serBag.getItem((Object)PropertyIDs.SI_ID).getInt();
        this.m_parentId = this.m_serBag.getItem((Object)PropertyIDs.SI_PARENTID).getInt();
        this.m_name = this.m_serBag.getItem((Object)PropertyIDs.SI_NAME).getString();
        this.m_objType = (short)this.m_serBag.getItem((Object)PropertyIDs.SI_OBTYPE).getInt();
        this.m_lastPropertiesSet = this.m_serBag.getItem((Object)SI_BASE_LAST_PROPSET).getInt();
        this.m_isNew = this.m_serBag.getItem((Object)SI_BASE_ISNEW).getBoolean();
        this.m_isUpdate = this.m_serBag.getItem((Object)SI_BASE_ISUPDATE).getBoolean();
        this.m_options = this.m_serBag.getItem((Object)SI_BASE_OPTIONS).getInt();
        this.m_lastTimeStamp = this.m_serBag.getItem((Object)SI_BASE_LAST_TS).getInt();
        this.m_securitySurrogateID = this.m_serBag.getInt((Object)PropertyIDs.SI_BASE_SEC_SURROGATE);
        this.m_fileObjects = (Files)files;
        if (this.m_fileObjects != null) {
            Property filesProp = this.m_props.getItem(PropertyIDs.SI_FILES);
            this.m_fileObjects.readFrom(filesProp.getPropertyBag(), this.m_session, this.getSecurityInfo2(), false, this, null, false);
        }
        if (deltaSecurityInfo != null && (secInfo = (SecurityInfo)this.getSecurityInfo()) != null) {
            secInfo.initFromSerialization(deltaSecurityInfo);
        }
        if (deltaSecurityInfo2 != null && (secInfo2 = (SecurityInfo2)this.getSecurityInfo2()) != null) {
            secInfo2.initFromSerialization(deltaSecurityInfo2);
        }
    }

    public void initSecurityInfoFromDeserialization() throws SDKException {
        PropertyBag mainBag = ((Property)this.m_rootBag.get(PropertyIDs.SI_MAINBAG)).getPropertyBag();
        if (mainBag == null) {
            return;
        }
        Object securityinfo = mainBag.get((Object)PropertyIDs.SI_SECURITYINFO);
        if (securityinfo != null) {
            throw new SDKException.NotImplemented("deserialize securityinfo");
        }
        Object principalsProp = mainBag.get((Object)PropertyIDs.SI_SECURITYINFO2);
        mainBag.removeLocal((Object)PropertyIDs.SI_SECURITYINFO2);
        if (principalsProp == null) {
            return;
        }
        PropertyBag principalsBag = ((Property)principalsProp).getPropertyBag();
        if (principalsBag == null) {
            return;
        }
        ISecurityInfo2 secInfo2 = this.getSecurityInfo2();
        IExplicitPrincipals principals = secInfo2.getExplicitPrincipals();
        boolean globalFolderInheritance = principalsBag.getBoolean((Object)PropertyIDs.SI_GLOBALFOLDERINHERITANCE);
        principals.setGlobalInheritFolders(globalFolderInheritance);
        PropertyBag explicitPrincipalsBag = ((Property)principalsBag.get((Object)PropertyIDs.SI_PRINCIPALS)).getPropertyBag();
        PropertyArrayHelper arrayhelper = new PropertyArrayHelper(explicitPrincipalsBag, PropertyIDs.SI_TOTAL);
        int numOfExplicitPrincipals = arrayhelper.size();
        for (int i = 0; i < numOfExplicitPrincipals; ++i) {
            PropertyBag explicitPrincipalBag = (PropertyBag)arrayhelper.get(i);
            int id = explicitPrincipalBag.getInt((Object)PropertyIDs.SI_ID);
            IExplicitPrincipal principal = principals.add(id);
            boolean isInheritFolders = explicitPrincipalBag.getBoolean((Object)PropertyIDs.SI_ISINHERITFOLDERS);
            boolean isInheritGroups = explicitPrincipalBag.getBoolean((Object)PropertyIDs.SI_ISINHERITGROUPS);
            principal.setInheritFolders(isInheritFolders);
            principal.setInheritGroups(isInheritGroups);
            IExplicitRights rights = principal.getRights();
            PropertyBag rightsBag = explicitPrincipalBag.getPropertyBag((Object)PropertyIDs.SI_RIGHTS);
            PropertyArrayHelper rightsHelper = new PropertyArrayHelper(rightsBag, PropertyIDs.SI_TOTAL);
            int numOfRights = rightsHelper.size();
            for (int j = 0; j < numOfRights; ++j) {
                PropertyBag rightBag = (PropertyBag)rightsHelper.get(j);
                int rightid = rightBag.getInt((Object)PropertyIDs.SI_ID);
                String scope = rightBag.getString((Object)PropertyIDs.SI_SCOPE);
                String type = rightBag.getString((Object)PropertyIDs.SI_TYPE);
                boolean isGranted = rightBag.getBoolean((Object)PropertyIDs.SI_VALUE);
                IExplicitRight right = rights.add(new RightDescriptor(rightid, null, false, scope, type));
                right.setGranted(isGranted);
            }
            IExplicitLimits limits = principal.getLimits();
            PropertyBag limitsBag = explicitPrincipalBag.getPropertyBag((Object)PropertyIDs.SI_LIMITS);
            PropertyArrayHelper limitsHelper = new PropertyArrayHelper(limitsBag, PropertyIDs.SI_TOTAL);
            int numOfLimits = limitsHelper.size();
            for (int j = 0; j < numOfLimits; ++j) {
                PropertyBag limitBag = (PropertyBag)limitsHelper.get(j);
                int limitid = limitBag.getInt((Object)PropertyIDs.SI_ID);
                String scope = limitBag.getString((Object)PropertyIDs.SI_SCOPE);
                String type = limitBag.getString((Object)PropertyIDs.SI_TYPE);
                int value = limitBag.getInt((Object)PropertyIDs.SI_VALUE);
                IExplicitLimit limit = limits.add(new RightDescriptor(limitid, null, false, scope, type));
                limit.setValue(value);
            }
            IExplicitRoles roles = principal.getRoles();
            PropertyBag rolesBag = explicitPrincipalBag.getPropertyBag((Object)PropertyIDs.SI_ROLES);
            PropertyArrayHelper rolesHelper = new PropertyArrayHelper(rolesBag, PropertyIDs.SI_TOTAL);
            int numOfRoles = rolesHelper.size();
            for (int j = 0; j < numOfRoles; ++j) {
                PropertyBag roleBag = (PropertyBag)rolesHelper.get(j);
                int roleid = roleBag.getInt((Object)PropertyIDs.SI_ID);
                IExplicitRole role = ((ExplicitRoles)roles).addNew(roleid);
            }
        }
    }

    public void setCommitLevel(int cl) throws SDKException {
        if (cl == 0) {
            this.m_options &= Integer.MAX_VALUE;
        } else if (cl == 1) {
            this.m_options |= Integer.MIN_VALUE;
        } else if (cl == 2) {
            this.m_options |= 0x82000000;
        } else {
            throw new SDKException.InvalidArg();
        }
    }

    public int getCommitLevel() {
        int commitFlags = this.m_options & 0x82000000;
        if (commitFlags == 0) {
            return 0;
        }
        if (commitFlags == -2113929216) {
            return 2;
        }
        return 1;
    }

    public boolean isLockHeld() throws SDKException {
        ILockInfo lockInfo = this.getLockInfo();
        int lockStatus = lockInfo.getLockStatus();
        return lockStatus == 1;
    }

    public void releaseLock() {
        PropertyBag propbag = null;
        Object lockStatus = this.m_props.get(PropertyIDs.SI_LOCK_INFO);
        if (lockStatus == null) {
            IProperty newProp = this.m_props.add(PropertyIDs.SI_LOCK_INFO, null, 0x8000000);
            propbag = (PropertyBag)newProp.getValue();
        } else {
            Property prop = (Property)lockStatus;
            propbag = prop.getPropertyBag();
        }
        propbag.setProperty((Object)PropertyIDs.SI_LOCK_STATUS, 0);
    }

    public void processObjectRelatives(Set objRels) {
        Iterator iter = objRels.iterator();
        while (iter.hasNext()) {
            ObjectRelatives objRel = (ObjectRelatives)iter.next();
            objRel.processUpdateBag();
        }
    }

    public ILockInfo getLockInfo() throws SDKException {
        Object lockStatus = this.m_props.get(PropertyIDs.SI_LOCK_INFO);
        if (lockStatus == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_LOCK_INFO);
        }
        Property prop = (Property)lockStatus;
        SDKPropertyBag bag = (SDKPropertyBag)prop.getPropertyBag();
        return new LockInfo(bag);
    }

    public static IInfoObject getDeserializedInfoObject(ISecuritySession session, String packedInfoObject) throws SDKException {
        WireOb3Unpacker unpacker = new WireOb3Unpacker();
        unpacker.initialize(packedInfoObject);
        SDKPropertyBag objPropBag = new SDKPropertyBag();
        objPropBag.merge(unpacker);
        int obtype = objPropBag.getInt(PropertyIDs.SI_OBTYPE);
        String packedRoot = objPropBag.getString(PropertyIDs.SI_OBJ_PROPS);
        String packedSer = objPropBag.getString(PropertyIDs.SI_EXTRA_PROPS);
        IPersistInfoObject obj = null;
        try {
            IPluginMgr pluginMgr = (IPluginMgr)OCCAMgrFactory.getOCCAMgr().getOCCAFactory("PluginDistribution").makeOCCA("", session);
            obj = (IPersistInfoObject)pluginMgr.getPluginInterface(new Integer(obtype), "desktop");
        }
        catch (SDKException.PluginNotFound ex) {
            obj = null;
        }
        catch (SDKException ex) {
            obj = null;
        }
        if (obj == null) {
            obj = new InfoObject();
        }
        obj.initFromSerialization(session, packedRoot, packedSer, null, null, null);
        obj.initSecurityInfoFromDeserialization();
        return obj;
    }

    public String getSerializedInfoObject() {
        this.prepareForSerialization();
        Files files = this.m_fileObjects;
        Property filesProp = this.m_props.getItem(PropertyIDs.SI_FILES);
        if (filesProp == null || !filesProp.isDirty()) {
            files = null;
        } else if (this.m_origFilesProps != null) {
            this.m_props.setProperty(PropertyIDs.SI_FILES, this.m_origFilesProps);
        } else {
            this.m_props.remove(PropertyIDs.SI_FILES);
        }
        SDKPropertyBag schedulingInfoBag = null;
        ISchedulingInfo schedulingInfo = this.getSchedulingInfo();
        if (schedulingInfo != null) {
            schedulingInfoBag = ((SchedulingInfo)schedulingInfo).getSchedulingInfoBag();
        }
        SDKPropertyBag processingInfoBag = null;
        IProcessingInfo processingInfo = this.getProcessingInfo();
        if (processingInfo != null) {
            processingInfoBag = ((ProcessingInfo)processingInfo).getProcessingInfoBag();
        }
        SerializableInfoObject sobj = new SerializableInfoObject(this.m_objType & 0xFFFF7FFF, this.m_session, this.m_rootBag, this.m_serBag, schedulingInfoBag, processingInfoBag, files, this.m_securityInfo, this.m_securityInfo2, this.getDefaultFRSFriendlyName(), null);
        return sobj.getSerializedInfoObject();
    }

    public void setOriginalFilesProperties(PropertyBag origFilesProps) {
        this.m_origFilesProps = origFilesProps;
    }
}

