/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.exception.UnexpectedPropertyValueRuntimeException;
import com.crystaldecisions.enterprise.ocaframework.AbstractStubHelper;
import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoObjectWireIteratorBatch3Holder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoObjectWireIteratorEx3;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoObjectWireIteratorEx3Holder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoStoreEx3Helper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoStoreEx4Helper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoStoreEx4Operations;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoWireObjectIDExsHolder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoWireObjects3Holder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoWireObjectsBatch3Holder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.UIDsHolder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.info_wire_ob3;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.SeqAnyHolder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuseHelper;
import com.crystaldecisions.sdk.exception.SDKBatchException;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKExceptionsCollector;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.exception.ServerExceptionCode;
import com.crystaldecisions.sdk.exception.internal.ServerExceptionMap;
import com.crystaldecisions.sdk.occa.infostore.CommitMode;
import com.crystaldecisions.sdk.occa.infostore.ICommitErrors;
import com.crystaldecisions.sdk.occa.infostore.ICommitResult;
import com.crystaldecisions.sdk.occa.infostore.ICommitWarnings;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.IPagingQuery;
import com.crystaldecisions.sdk.occa.infostore.internal.CategoryContentInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.CommitError;
import com.crystaldecisions.sdk.occa.infostore.internal.CommitResult;
import com.crystaldecisions.sdk.occa.infostore.internal.CommitWarning;
import com.crystaldecisions.sdk.occa.infostore.internal.ICommitStream;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoStoreSecurity;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.INewID;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRights;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoStoreException;
import com.crystaldecisions.sdk.occa.infostore.internal.PagingQuery;
import com.crystaldecisions.sdk.occa.infostore.internal.SchedulableCategoryContentInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.SchedulableInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal._InfoStoreEx4Proxy;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.pluginmgr.internal.IInternalPluginSecurityInfo;
import com.crystaldecisions.sdk.occa.security.IBatch;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.IRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occamgr.internal.OCCAMgrFactory;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Any;
import com.crystaldecisions.thirdparty.org.omg.CORBA.BAD_PARAM;
import com.crystaldecisions.thirdparty.org.omg.CORBA.BooleanHolder;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Object;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class InternalInfoStore
implements IInternalInfoStore,
IInfoStoreSecurity,
INewID,
Externalizable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStore");
    private static Map s_initialized = new HashMap();
    private static final java.lang.Object s_lock = new java.lang.Object();
    private static final int MAX_NUM_COMMIT_RETRY = 5;
    private IManagedService m_handler;
    private InfoStoreEx4Operations m_stub;
    private ISecuritySession m_session;
    private IPluginMgr m_pluginMgr;
    private static final int s_maxCommitSize = 0x200000;
    private static final ObjectID_Ex[] EMPTY_ID = new ObjectID_Ex[0];
    private static final IManagedService.IHelperFactory s_helperFactory = new InfoStoreHelperFactory();
    private static final int ATOMIC_SHIFT = 2;
    private static final int LENIENCY_SHIFT = 3;
    private static final int BATCH_ID_SHIFT = 25;

    InternalInfoStore(String svr, ISecuritySession session) throws SDKException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((java.lang.Object)("InternalInfoStore(): server=" + svr + ",session=" + session));
            }
            this.init(svr, session);
        }
        catch (OCAFrameworkException e) {
            LOG.warn((java.lang.Object)("server=" + svr + ",session=" + session), (Throwable)((java.lang.Object)e));
            throw SDKException.map(e);
        }
        LOG.debug((java.lang.Object)"InternalInfoStore(): exit");
    }

    public InternalInfoStore() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_session);
        out.writeUTF(this.m_handler.getSvr().getName());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ISecuritySession session = (ISecuritySession)in.readObject();
        String svr = in.readUTF();
        try {
            this.init(svr, session);
        }
        catch (OCAFrameworkException e) {
            throw new SDKException.Serialization(e);
        }
        catch (SDKException e) {
            throw new SDKException.Serialization(e);
        }
    }

    public void commit(IInfoObjects objs) throws SDKException {
        this.commit(objs, false);
    }

    public void commit(IInfoObjects objs, boolean atomic) throws SDKException {
        ICommitResult result = this.commit(objs, atomic, CommitMode.STRICT);
        this.processCommitResult(result);
    }

    public ICommitResult commit(IInfoObjects objs, boolean atomic, CommitMode mode) {
        CommitResult result = null;
        result = this.commitHelper(objs, 0, atomic, mode);
        if (result.getFatalException() != null) {
            return result;
        }
        try {
            if (!this.m_session.getUserURI().equals("osca:iiop://;S2SDSCVRY=true")) {
                this.commitFileAndRightsChanges(objs, 0);
            }
        }
        catch (SDKException e) {
            if (e instanceof SDKBatchException) {
                Iterator iter = ((SDKBatchException)e).getExceptions().iterator();
                while (iter.hasNext()) {
                    this.packageFileRightsException((SDKException)((java.lang.Object)iter.next()), result);
                }
            }
            this.packageFileRightsException(e, result);
        }
        return result;
    }

    public ICommitResult commit(ICommitStream stream, boolean atomic, CommitMode mode) {
        return this.commit(stream, 0, atomic, mode);
    }

    public ICommitResult commit(ICommitStream stream, int flags, boolean atomic, CommitMode mode) {
        int isAtomic = atomic ? 1 : 0;
        int isLenient = mode.toInteger();
        int batchID = 0;
        InfoObjects objs = (InfoObjects)this.newInfoObjectCollection();
        CommitResult result = new CommitResult();
        try {
            while (stream.hasNext()) {
                int commitArg = isAtomic << 2;
                commitArg |= isLenient << 3;
                for (int i = 0; i < 500 && stream.hasNext(); ++i) {
                    objs.add(stream.next());
                }
                SeqAnyHolder errors = new SeqAnyHolder();
                SeqAnyHolder warnings = new SeqAnyHolder();
                info_wire_ob3[] packed = objs.startPack(0x200000, true, flags);
                while (packed != null && packed.length > 0) {
                    int batchState = stream.hasNext() || objs.hasMoreToPack() ? 3 : 1;
                    commitArg |= batchID << 25 | batchState;
                    InfoWireObjects3Holder out = new InfoWireObjects3Holder();
                    try {
                        batchID = this.m_stub.commitEx4(1200, commitArg, packed, out, errors, warnings);
                        this.packageCommitOutParams(errors, warnings, result);
                    }
                    catch (oca_abuse e) {
                        throw InfoStoreException.map(e);
                    }
                    objs.merge(out.value);
                    for (int i = 0; i < objs.size(); ++i) {
                        stream.onUpdate((IInfoObject)objs.get(i));
                    }
                    packed = objs.continuePack(0x200000, true, flags);
                }
                objs.clear();
            }
            stream.reset();
            while (stream.hasNext()) {
                int i;
                for (i = 0; i < 500 && stream.hasNext(); ++i) {
                    objs.add(stream.next());
                }
                try {
                    this.commitFileAndRightsChanges(objs, 0);
                }
                catch (SDKException sdke) {
                    if (sdke instanceof SDKBatchException) {
                        Iterator iter = ((SDKBatchException)sdke).getExceptions().iterator();
                        while (iter.hasNext()) {
                            this.packageFileRightsException((SDKException)((java.lang.Object)iter.next()), result);
                        }
                    }
                    this.packageFileRightsException(sdke, result);
                }
                for (i = 0; i < objs.size(); ++i) {
                    stream.onUpdate((IInfoObject)objs.get(i));
                }
                objs.clear();
            }
        }
        catch (SDKException e) {
            result.getExceptionsCollector().collect(e);
        }
        return result;
    }

    private void commitFileAndRightsChanges(IInfoObjects objs, int flag) throws SDKException {
        InfoObjects infoObjs = (InfoObjects)objs;
        SDKExceptionsCollector collector = null;
        LOG.debug((java.lang.Object)"commit(): Commiting file changes");
        collector = infoObjs.commitFileChanges(null);
        if (collector.size() > 0) {
            infoObjs.abortFileChanges(null);
            Set objIDs = this.securityUpdatesPending(objs, flag);
            if (objIDs != null && objIDs.size() > 0) {
                String ids = "";
                Iterator iter = objIDs.iterator();
                while (iter.hasNext()) {
                    Integer id = (Integer)iter.next();
                    ids = ids.concat(id.toString() + ", ");
                }
                collector.collect(new SDKException.SecurityCommitError(ids.substring(0, ids.length() - 2), objIDs));
                LOG.warn((java.lang.Object)"commit(): skipping security commit");
            }
            SDKException e = collector.getAssembleExceptions();
            LOG.warn((java.lang.Object)("commit(): failed to commit file changes, " + this.m_handler.getSvr() + ", aborting"), (Throwable)((java.lang.Object)e));
            throw e;
        }
        if (flag != 4) {
            IBatch admin;
            if (LOG.isDebugEnabled()) {
                LOG.debug((java.lang.Object)"commit(): commiting right changes");
            }
            try {
                admin = this.m_session.getRightsAdminEx();
                admin.batch();
                try {
                    ((IPersistRights)((java.lang.Object)objs)).saveRights2((ISecRightsAdmin)admin);
                    admin.commit();
                }
                catch (SDKException e) {
                    LOG.warn((java.lang.Object)("commit(): failed to commit right changes, " + this.m_handler.getSvc()), (Throwable)((java.lang.Object)e));
                    admin.rollback();
                    throw e;
                }
                catch (Throwable e) {
                    LOG.warn((java.lang.Object)("commit(): failed to commit right changes, " + this.m_handler.getSvc()), e);
                    admin.rollback();
                    SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
                    throw sdke;
                }
            }
            catch (SDKException.RightsAdmin e) {
                LOG.info((java.lang.Object)"caught SDKException.RightsAdmin");
            }
            try {
                admin = this.m_session.getRightsAdmin();
                admin.batch();
                try {
                    ((IPersistRights)((java.lang.Object)objs)).saveRights((IRightsAdmin)admin);
                    admin.commit();
                }
                catch (SDKException e) {
                    LOG.warn((java.lang.Object)("commit(): failed to commit right changes, " + this.m_handler.getSvc()), (Throwable)((java.lang.Object)e));
                    admin.rollback();
                    throw e;
                }
                catch (Throwable e) {
                    LOG.warn((java.lang.Object)("commit(): failed to commit right changes, " + this.m_handler.getSvc()), e);
                    admin.rollback();
                    SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
                    throw sdke;
                }
            }
            catch (SDKException.RightsAdmin e) {
                LOG.info((java.lang.Object)"caught SDKException.RightsAdmin");
            }
        }
        LOG.debug((java.lang.Object)"commit(): cleaning changes");
        infoObjs.cleanupChanges();
        infoObjs.afterCommit();
        LOG.debug((java.lang.Object)"commit(): exit");
    }

    private Set securityUpdatesPending(IInfoObjects objs, int flag) {
        HashSet<Integer> objIDs = new HashSet<Integer>();
        if (flag != 4) {
            Iterator objIter = objs.iterator();
            while (objIter.hasNext()) {
                java.lang.Object obj = objIter.next();
                if (!(obj instanceof InfoObject)) {
                    obj = InfoObjects.unproxyElement(obj);
                }
                InfoObject infoObj = (InfoObject)obj;
                try {
                    if (!infoObj.isSecurityDirty()) continue;
                    objIDs.add(new Integer(infoObj.getID()));
                }
                catch (SDKException e) {}
            }
        }
        return objIDs;
    }

    private void packageCommitOutParams(SeqAnyHolder errors, SeqAnyHolder warnings, CommitResult result) {
        oca_abuse abuse;
        int i;
        Any[] errs = errors.value;
        Any[] warns = warnings.value;
        if (errs != null) {
            int numErrors = errs.length;
            ICommitErrors ces = result.getErrors();
            for (i = 0; i < numErrors; ++i) {
                Any errAny = errs[i];
                abuse = oca_abuseHelper.extract((Any)errAny);
                CommitError ce = new CommitError(abuse);
                ces.add(ce);
            }
        }
        if (warns != null) {
            int numWarnings = warns.length;
            ICommitWarnings cws = result.getWarnings();
            for (i = 0; i < numWarnings; ++i) {
                Any warnAny = warns[i];
                abuse = oca_abuseHelper.extract((Any)warnAny);
                CommitWarning cw = new CommitWarning(abuse);
                cws.add(cw);
            }
        }
    }

    private void packageFileRightsException(SDKException sdke, CommitResult result) {
        result.getErrors().add(new CommitError(sdke));
    }

    public void unlock(IInfoObjects objs) throws SDKException {
        Iterator iter = objs.iterator();
        while (iter.hasNext()) {
            InfoObject obj = (InfoObject)iter.next();
            obj.cleanupChanges();
            obj.releaseLock();
        }
        CommitResult result = this.commitHelper(objs, 0, false, CommitMode.STRICT);
        this.processCommitResult(result);
    }

    public IInfoObjects newInfoObjectCollection() {
        InfoObjects objects = this.newInfoObjects();
        objects.initialize(this.m_session, this);
        return objects;
    }

    public IProperties newPropertyCollection() {
        return new SDKPropertyBag();
    }

    public IPluginMgr getPluginMgr() {
        return this.m_pluginMgr;
    }

    public IInfoObjects query(String query) throws SDKException {
        return this.queryHelper(query, this.newInfoObjects());
    }

    public IInfoObjects[] query(String[] queries) throws SDKException {
        return this.batchQueryHelper(queries);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IInfoObjects[] batchQueryHelper(String[] queries) throws SDKException {
        if (LOG.isInfoEnabled()) {
            LOG.info((java.lang.Object)("batchQuery(): aps=" + this.m_handler.getAPS()));
        }
        IInfoObjects[] infoObjsSeq = new InfoObjects[queries.length];
        InfoWireObjectsBatch3Holder batchWireObjs = new InfoWireObjectsBatch3Holder();
        InfoObjectWireIteratorBatch3Holder batchItrHolder = new InfoObjectWireIteratorBatch3Holder();
        InfoObjectWireIteratorEx3 itr = null;
        info_wire_ob3[] wireObj = null;
        try {
            this.m_stub.batchQuery(1200, queries, batchWireObjs, batchItrHolder);
        }
        catch (oca_abuse oca_e) {
            LOG.warn((java.lang.Object)("batchQuery(): failed, " + this.m_handler.getSvr()), (Throwable)oca_e);
            throw SDKException.map(oca_e);
        }
        int currQuery = 0;
        while (true) {
            block15: {
                InfoObjectWireIteratorEx3 freeItr;
                int i;
                java.lang.Object var11_12;
                if (currQuery >= queries.length) {
                    LOG.debug((java.lang.Object)"batchQuery(): done");
                    return infoObjsSeq;
                }
                wireObj = batchWireObjs.value[currQuery];
                InfoWireObjects3Holder wireObjs = new InfoWireObjects3Holder(wireObj);
                itr = batchItrHolder.value[currQuery];
                try {
                    try {
                        infoObjsSeq[currQuery] = this.unpack(wireObjs, itr, currQuery);
                    }
                    catch (SDKException sdk_e) {
                        LOG.warn((java.lang.Object)("batchQuery(): unmarshalling failed, query=" + queries[currQuery] + "," + this.m_handler.getSvc()), (Throwable)((java.lang.Object)sdk_e));
                        var11_12 = null;
                        for (i = 0; i < batchItrHolder.value.length; ++i) {
                            freeItr = batchItrHolder.value[i];
                            if (freeItr == null) continue;
                            freeItr.free();
                        }
                        break block15;
                    }
                    catch (oca_abuse oca_e) {
                        LOG.warn((java.lang.Object)("batchQuery(): unmarshalling failed, query=" + queries[currQuery] + "," + this.m_handler.getSvc()), (Throwable)oca_e);
                        throw SDKException.map(oca_e);
                    }
                    var11_12 = null;
                }
                catch (Throwable throwable) {
                    var11_12 = null;
                    i = 0;
                    while (true) {
                        if (i >= batchItrHolder.value.length) {
                            throw throwable;
                        }
                        freeItr = batchItrHolder.value[i];
                        if (freeItr != null) {
                            freeItr.free();
                        }
                        ++i;
                    }
                }
                for (i = 0; i < batchItrHolder.value.length; ++i) {
                    freeItr = batchItrHolder.value[i];
                    if (freeItr == null) continue;
                    freeItr.free();
                }
            }
            ++currQuery;
        }
    }

    private InfoObjects unpack(InfoWireObjects3Holder wireObjs, InfoObjectWireIteratorEx3 itr, int currQuery) throws SDKException, oca_abuse {
        InfoObjects infoObjs = new InfoObjects();
        infoObjs.startUnpack(this.m_session, this, wireObjs.value);
        if (itr != null) {
            LOG.info((java.lang.Object)"batchQuery(): need more data");
            BooleanHolder moreData = new BooleanHolder();
            do {
                itr.getNextBatchEx3(1200, wireObjs, moreData);
                infoObjs.continueUnpack(wireObjs.value);
            } while (moreData.value);
        }
        infoObjs.finishUnpack();
        return infoObjs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IInfoObjects queryHelper(String query, InfoObjects objs) throws SDKException {
        InfoObjects infoObjects;
        block9: {
            if (LOG.isInfoEnabled()) {
                LOG.info((java.lang.Object)("query(): aps=" + this.m_handler.getAPS() + ",query=" + query));
            }
            InfoWireObjects3Holder wireObjs = new InfoWireObjects3Holder();
            InfoObjectWireIteratorEx3Holder itrHolder = new InfoObjectWireIteratorEx3Holder();
            this.m_stub.queryEx3(1200, 0, query, wireObjs, itrHolder);
            InfoObjectWireIteratorEx3 itr = itrHolder.value;
            try {
                objs.startUnpack(this.m_session, this, wireObjs.value);
                if (itr != null) {
                    LOG.info((java.lang.Object)"query(): need more data");
                    BooleanHolder moreData = new BooleanHolder();
                    do {
                        itr.getNextBatchEx3(1200, wireObjs, moreData);
                        objs.continueUnpack(wireObjs.value);
                    } while (moreData.value);
                }
                objs.finishUnpack();
                LOG.debug((java.lang.Object)"query(): exit");
                infoObjects = objs;
                if (itr == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (itr != null) {
                        itr.free();
                    }
                    throw throwable;
                }
                catch (oca_abuse e) {
                    LOG.warn((java.lang.Object)("query(): failed, query=" + query + "," + this.m_handler.getSvr()), (Throwable)e);
                    throw SDKException.map(e);
                }
            }
            itr.free();
        }
        return infoObjects;
    }

    private InfoObjects newInfoObjects() {
        return new InfoObjects();
    }

    public void schedule(IInfoObjects objects) throws SDKException {
        CommitResult result = this.commitHelper(objects, 1, false, CommitMode.STRICT);
        this.processCommitResult(result);
        if (objects instanceof IPersistInfoObjects) {
            IPersistInfoObjects persistInfoObjects = (IPersistInfoObjects)((java.lang.Object)objects);
            persistInfoObjects.cleanupChanges();
        }
    }

    public void schedule(IInfoObjects objects, boolean scheduleOnSelf, boolean atomic) throws SDKException {
        int flag = 1;
        if (scheduleOnSelf) {
            flag = 5;
        }
        CommitResult result = this.commitHelper(objects, flag, atomic, CommitMode.STRICT);
        this.processCommitResult(result);
        if (objects instanceof IPersistInfoObjects) {
            IPersistInfoObjects persistInfoObjects = (IPersistInfoObjects)((java.lang.Object)objects);
            persistInfoObjects.cleanupChanges();
        }
    }

    private CommitResult commitHelper(IInfoObjects objs, int flag, boolean atomic, CommitMode mode) {
        CommitResult result = new CommitResult();
        int numRetries = 0;
        try {
            IPersistInfoObjects infoObjs = (IPersistInfoObjects)((java.lang.Object)objs);
            if (LOG.isDebugEnabled()) {
                LOG.debug((java.lang.Object)("commitHelper(): cms=" + this.m_handler.getAPS() + ", size=" + objs.size() + ", dirty=" + infoObjs.isDirty() + ", flag=" + flag));
            }
            ArrayList<info_wire_ob3[]> recommitList = new ArrayList<info_wire_ob3[]>();
            ArrayList<info_wire_ob3[]> updatesFromCMSList = new ArrayList<info_wire_ob3[]>();
            info_wire_ob3[] packed = infoObjs.startPack(0x200000, true, flag);
            recommitList.add(packed);
            boolean packingMode = true;
            boolean restart = false;
            int isAtomic = atomic ? 1 : 0;
            int isLenient = mode.toInteger();
            int batchID = 0;
            Iterator recommitIter = null;
            while (packed != null && packed.length > 0) {
                int commitArg;
                if (atomic) {
                    int batchState = packingMode ? (infoObjs.hasMoreToPack() ? 3 : 1) : (recommitIter != null && recommitIter.hasNext() || infoObjs.hasMoreToPack() ? 3 : 1);
                    if (restart) {
                        commitArg = batchState;
                        restart = false;
                    } else {
                        commitArg = batchID << 25 | batchState;
                    }
                } else {
                    commitArg = 0;
                }
                commitArg |= isAtomic << 2;
                commitArg |= isLenient << 3;
                InfoWireObjects3Holder out = new InfoWireObjects3Holder();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((java.lang.Object)("commitHelper(): comitting ... , size=" + packed.length));
                }
                SeqAnyHolder errors = new SeqAnyHolder();
                SeqAnyHolder warnings = new SeqAnyHolder();
                try {
                    batchID = this.m_stub.commitEx4(1200, commitArg, packed, out, errors, warnings);
                    this.packageCommitOutParams(errors, warnings, result);
                    if (atomic && result.getErrors().size() > 0) {
                        return result;
                    }
                }
                catch (oca_abuse oca_abuse2) {
                    if (ServerExceptionMap.mapServerExceptionCode(oca_abuse2.errCode) == ServerExceptionCode.ERROR_INFOSTORE_RETRY_OPERATION && 5 > numRetries++) {
                        if (!atomic) continue;
                        recommitIter = recommitList.iterator();
                        if (recommitIter != null && recommitIter.hasNext()) {
                            packed = (info_wire_ob3[])recommitIter.next();
                            packingMode = false;
                            updatesFromCMSList.clear();
                            restart = true;
                            continue;
                        }
                        LOG.assertTrue(false, "Commit - Nothing to retry.  Should not happen");
                        throw oca_abuse2;
                    }
                    throw oca_abuse2;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((java.lang.Object)("commitHelper(): out value size=" + out.value.length));
                }
                updatesFromCMSList.add(out.value);
                if (!packingMode && recommitIter != null && recommitIter.hasNext()) {
                    packed = (info_wire_ob3[])recommitIter.next();
                    continue;
                }
                packingMode = true;
                packed = infoObjs.continuePack(0x200000, true, flag);
                if (!atomic) continue;
                recommitList.add(packed);
            }
            Iterator iter = updatesFromCMSList.iterator();
            while (iter.hasNext()) {
                info_wire_ob3[] updates = (info_wire_ob3[])iter.next();
                infoObjs.merge(updates);
            }
        }
        catch (UnexpectedPropertyValueRuntimeException e) {
            throw new SDKRuntimeException.UnexpectedCause((Exception)((java.lang.Object)e));
        }
        catch (oca_abuse e) {
            LOG.error((java.lang.Object)("commitHelper(): failed, " + this.m_handler.getSvr() + ", numRetries: " + numRetries), (Throwable)e);
            result.getExceptionsCollector().collect(InfoStoreException.map(e));
        }
        catch (SDKException e) {
            LOG.error((java.lang.Object)"commitHelper(): failed", (Throwable)((java.lang.Object)e));
            result.getExceptionsCollector().collect(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((java.lang.Object)"commitHelper(): exit");
        }
        return result;
    }

    public void sendTo(IInfoObjects objs) throws SDKException {
        CommitResult result = this.commitHelper(objs, 2, false, CommitMode.STRICT);
        this.processCommitResult(result);
    }

    public void deliverToInbox(IInfoObjects objs) throws SDKException {
        CommitResult result = this.commitHelper(objs, 4, false, CommitMode.STRICT);
        this.processCommitResult(result);
        this.commitFileAndRightsChanges(objs, 4);
    }

    public void importObjects(IInfoObjects objs) throws SDKException {
        CommitResult result = this.commitHelper(objs, 3, false, CommitMode.STRICT);
        this.processCommitResult(result);
        this.commitFileAndRightsChanges(objs, 3);
    }

    public int getSessionFolderID() throws SDKException {
        if (this.m_session.getSessionFolderID() == 0) {
            IInfoObjects objs = this.newInfoObjectCollection();
            IPluginInfo pluginInfo = this.m_pluginMgr.getPluginInfo("CrystalEnterprise.Folder");
            IInfoObject folder = objs.add(pluginInfo);
            folder.setParentID(49);
            String token = this.m_session.getLogonToken();
            int delim = token.indexOf(64);
            String folderName = token.substring(delim + 1);
            folder.setTitle(folderName);
            try {
                this.commit(objs);
            }
            catch (InfoStoreException e) {
                int[] batchErrorIDs = e.getBatchErrorIDs();
                if (batchErrorIDs.length == 1 && batchErrorIDs[0] == 48167) {
                    objs = this.query("SELECT TOP 1 SI_ID FROM CI_INFOOBJECTS WHERE SI_NAME='" + folderName + "' and SI_PARENTID=" + 49);
                    if (objs.size() > 0) {
                        folder = (IInfoObject)objs.iterator().next();
                    }
                    throw new SDKException.Unexpected((Exception)((java.lang.Object)e));
                }
                throw e;
            }
            this.m_session.setSessionFolderID(folder.getID());
        }
        return this.m_session.getSessionFolderID();
    }

    public IPagingQuery getPagingQuery() throws SDKException {
        PagingQuery pquery = new PagingQuery();
        pquery.initialize(this);
        return pquery;
    }

    public String[] getNewCUIDs(int numToCreate) throws SDKException {
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info((java.lang.Object)("getNewCUIDs(): requesting " + numToCreate));
            }
            UIDsHolder holder = new UIDsHolder();
            this.m_stub.getUIDsEx3(1200, numToCreate, holder);
            return holder.value;
        }
        catch (oca_abuse e) {
            LOG.warn((java.lang.Object)("getNewCUIDs(): failed, " + this.m_handler.getSvr()), (Throwable)e);
            throw InfoStoreException.map(e);
        }
    }

    public IInfoObject newInfoObject(java.lang.Object plgKey, ObjectID_Ex id) throws SDKException {
        IInfoObject obj;
        IPluginInfo info = plgKey instanceof IPluginInfo ? (IPluginInfo)plgKey : this.getPluginMgr().getPluginInfo(plgKey);
        try {
            obj = (IInfoObject)this.getPluginMgr().getPluginInterface(info.getProgID(), "desktop");
        }
        catch (SDKException.PluginNotFound pnf) {
            LOG.warn((java.lang.Object)("Plugin not found: progid=" + info.getProgID() + '.'), (Throwable)((java.lang.Object)pnf));
            if (info.isSchedulable()) {
                obj = info.isSupportCategoryContent() ? new SchedulableCategoryContentInfoObject() : new SchedulableInfoObject();
            }
            obj = info.isSupportCategoryContent() ? new CategoryContentInfoObject() : new InfoObject();
        }
        ((IPersistInfoObject)((java.lang.Object)obj)).initialize(this.m_session, null, id, info.getType());
        return obj;
    }

    public ObjectID_Ex[] getNewIDs(int numIDs) throws SDKException {
        return this.newIDs(numIDs);
    }

    public ObjectID_Ex newID() throws SDKException {
        ObjectID_Ex[] ids = this.newIDs(1);
        return ids[0];
    }

    public ObjectID_Ex[] newIDs(int numIDs) throws SDKException {
        if (numIDs == 0) {
            return EMPTY_ID;
        }
        try {
            InfoWireObjectIDExsHolder out = new InfoWireObjectIDExsHolder();
            this.m_stub.prepare_commitEx3(1200, numIDs, out);
            return out.value;
        }
        catch (oca_abuse e) {
            throw SDKException.map(e);
        }
    }

    public ISecuritySession getSecuritySession() {
        return this.m_session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String svr, ISecuritySession session) throws OCAFrameworkException, SDKException {
        String clusterName = session.getClusterName();
        this.m_handler = ServiceMgrFactory.getServiceMgr().getManagedService("NO_ID", "InfoStore", new ServerSpec(svr, "aps", session.getAPSName(), clusterName), session.getUserURI(), session.getLogonToken(), s_helperFactory);
        LOG.assertNotNull((java.lang.Object)this.m_handler, "m_handler is null.");
        this.m_stub = new _InfoStoreEx4Proxy(this.m_handler);
        this.m_pluginMgr = (IPluginMgr)OCCAMgrFactory.getOCCAMgr().getOCCAFactory("PluginDistribution").makeOCCA(svr, session);
        LOG.assertNotNull((java.lang.Object)this.m_pluginMgr, "m_pluginMgr is null.");
        this.m_session = session;
        java.lang.Object object = s_lock;
        synchronized (object) {
            if (s_initialized.get(clusterName) == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((java.lang.Object)"InternalInfoStore(): start initialization");
                }
                IPluginInfo[] plugins = this.m_pluginMgr.getPlugins("desktop");
                for (int i = 0; i < plugins.length; ++i) {
                    IPluginInfo plugin = plugins[i];
                    IInternalPluginSecurityInfo securityInfo = (IInternalPluginSecurityInfo)((java.lang.Object)plugin.getSecurityInfo());
                    securityInfo.updateRoles();
                }
                IPluginInfo[] metaPlugins = this.m_pluginMgr.getPlugins("meta");
                for (int i = 0; i < metaPlugins.length; ++i) {
                    IPluginInfo plugin = metaPlugins[i];
                    IInternalPluginSecurityInfo securityInfo = (IInternalPluginSecurityInfo)((java.lang.Object)plugin.getSecurityInfo());
                    securityInfo.updateRoles();
                }
                s_initialized.put(clusterName, Boolean.TRUE);
                if (LOG.isInfoEnabled()) {
                    LOG.info((java.lang.Object)"InternalInfoStore(): initialization completed");
                }
            }
        }
    }

    private void processCommitResult(ICommitResult result) throws SDKException {
        SDKExceptionsCollector collector = new SDKExceptionsCollector();
        SDKException e = result.getFatalException();
        if (e != null) {
            collector.collect(e);
        }
        Iterator errIter = result.getErrors().iterator();
        while (errIter.hasNext()) {
            CommitError err = (CommitError)errIter.next();
            collector.collect(err.m_sdke);
        }
        if (collector.size() > 0) {
            collector.close();
        }
    }

    private static class InfoStoreHelperFactory
    implements IManagedService.IHelperFactory {
        private InfoStoreHelperFactory() {
        }

        public IManagedService.IStubHelper makeHelper() {
            return new StubHelper();
        }

        private static class StubHelper
        extends AbstractStubHelper {
            private StubHelper() {
            }

            public java.lang.Object narrow(Object object) {
                try {
                    return InfoStoreEx4Helper.narrow((Object)object);
                }
                catch (BAD_PARAM e) {
                    return InfoStoreEx3Helper.narrow((Object)object);
                }
            }

            public void release(java.lang.Object object) {
            }
        }
    }

    private static class CommitType {
        private static final int NO_BATCH = 0;
        private static final int BATCH_FINAL = 1;
        private static final int BATCH_INPROG = 3;

        private CommitType() {
        }
    }
}

