/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.io.FileCleaner;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.filerepository.internal.BoundFile;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileRepository;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.IPutFileTx;
import com.crystaldecisions.sdk.occa.infostore.ILocalFile;
import com.crystaldecisions.sdk.occa.infostore.internal.FileOpRecord;
import com.crystaldecisions.sdk.occa.infostore.internal.FileOpType;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

class LocalFile
implements ILocalFile,
Externalizable {
    private BoundFile m_file;
    private OutputStream m_out;
    private InputStream m_in;
    private FileOpRecord m_record;
    private IFileRepository m_fileRepository;
    private boolean m_done;
    private IFileTx m_fileTx;
    private String m_name;
    private String m_destSubDir;
    private String m_destPrefix;
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.LocalFile");

    public LocalFile() {
    }

    LocalFile(IFileRepository fileRepository, File file, FileOpRecord rec, boolean bUploadFileAtInit) throws SDKException {
        this.m_fileRepository = fileRepository;
        this.m_file = new BoundFile(file.getAbsolutePath());
        this.m_record = rec;
        this.m_done = false;
        this.m_fileTx = null;
        if (this.m_record.makeUniqueName || bUploadFileAtInit) {
            this.m_fileTx = this.m_record.makeUniqueName ? this.m_fileRepository.putUnique(this.m_file.getPath(), this.m_record.destPath, this.m_record.prefix, this.m_record.ext) : this.m_fileRepository.put(this.m_file.getPath(), this.m_record.destPath);
            if (bUploadFileAtInit && this.m_fileTx instanceof IPutFileTx) {
                ((IPutFileTx)this.m_fileTx).uploadContent();
            }
            this.m_record.destPath = (String)this.m_fileTx.getDestination();
        }
        this.initialize();
        this.m_done = false;
    }

    private void initialize() {
        String shortName;
        this.m_destSubDir = null;
        this.m_destPrefix = null;
        String prefix = this.m_record.prefix;
        String subDir = this.m_record.subDir;
        String destFilePath = this.m_record.destPath;
        int delim = destFilePath.lastIndexOf("/");
        if (delim == -1) {
            this.m_name = shortName = destFilePath;
        } else {
            this.m_name = shortName = destFilePath.substring(delim + 1);
            String dir = destFilePath.substring(0, delim);
            if (subDir != null && subDir.length() != 0 && dir.endsWith(subDir = subDir.toLowerCase())) {
                this.m_destSubDir = subDir;
                this.m_name = subDir + "/" + this.m_name;
            }
        }
        if (prefix != null && prefix.length() != 0 && shortName.startsWith(prefix = prefix.toLowerCase())) {
            this.m_destPrefix = prefix;
        }
    }

    public File getFile() {
        try {
            return this.m_file.getFile();
        }
        catch (SDKException sdke) {
            return null;
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.m_out == null && this.getFile() != null) {
            this.m_out = new FileOutputStream(this.getFile());
        }
        return this.m_out;
    }

    public InputStream getInputStream() throws IOException {
        if (this.m_in == null && this.getFile() != null) {
            this.m_in = new FileInputStream(this.getFile());
        }
        return this.m_in;
    }

    public String getLocalFile() {
        return this.m_file.getPath();
    }

    public String getName() {
        return this.m_name;
    }

    public long getSize() throws SDKException {
        return this.m_file.getSize();
    }

    public void commit() throws SDKException {
        if (this.m_done) {
            return;
        }
        if (this.m_fileTx == null) {
            this.m_fileTx = this.m_fileRepository.put(this.m_file.getFile().getPath(), this.m_record.destPath);
        }
        this.m_fileTx.commit();
        this.m_fileTx = null;
        if (this.m_record.type == FileOpType.REPLACE && this.m_record.oldFileURL != null) {
            this.m_fileRepository.remove(this.m_record.oldFileURL).commit();
        }
        if (this.m_record.deleteLocalFile && this.m_file.isLocal() && this.m_file.getFile().delete()) {
            FileCleaner.unregisterCleanupTarget((String)this.m_file.getPath());
        }
        this.m_done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        if (this.m_fileTx != null) {
            try {
                this.m_fileTx.destroy();
            }
            catch (SDKException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Error when destroying file trasaction.", (Throwable)((Object)ex));
                }
            }
            finally {
                this.m_fileTx = null;
            }
        }
        this.m_done = true;
    }

    String getDestSubDir() {
        return this.m_destSubDir;
    }

    String getDestPrefix() {
        return this.m_destPrefix;
    }

    void initFromSerialization(IFileRepository fileRepository) {
        this.m_fileRepository = fileRepository;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_fileTx);
        out.writeObject(this.m_name);
        out.writeObject(this.m_destSubDir);
        out.writeObject(this.m_destPrefix);
        out.writeBoolean(this.m_done);
        out.writeObject(this.m_file);
        out.writeObject(this.m_record.type.toString());
        out.writeObject(this.m_record.destPath);
        out.writeBoolean(this.m_record.deleteLocalFile);
        out.writeObject(this.m_record.oldFileURL);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_fileTx = (IFileTx)in.readObject();
        this.m_name = (String)in.readObject();
        this.m_destSubDir = (String)in.readObject();
        this.m_destPrefix = (String)in.readObject();
        this.m_done = in.readBoolean();
        this.m_file = (BoundFile)in.readObject();
        FileOpType type = FileOpType.fromString((String)in.readObject());
        String destPath = (String)in.readObject();
        boolean deleteLocalFile = in.readBoolean();
        this.m_record = new FileOpRecord(type, 0, null, null, null, null, null, null, deleteLocalFile, false, destPath);
        this.m_record.oldFileURL = (String)in.readObject();
        this.m_in = null;
        this.m_out = null;
    }
}

