/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileRepository;
import com.crystaldecisions.sdk.occa.filerepository.internal.IPutStreamTx;
import com.crystaldecisions.sdk.occa.infostore.IStreamingUploadFile;
import com.crystaldecisions.sdk.occa.infostore.internal.IFileSizeListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalStreamingUploadFile;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LocalStreamingUploadFile
implements IStreamingUploadFile,
IInternalStreamingUploadFile,
Externalizable {
    private IFileRepository m_fileRepository;
    private long m_fileSize;
    private String m_destFilePath;
    private IFileSizeListener m_listener;
    private int m_index;
    private String m_name;
    private String m_oldFileURL;
    private String m_destSubDir;
    private String m_destPrefix;
    private boolean m_done;
    private IPutStreamTx m_putTx;

    public LocalStreamingUploadFile() {
    }

    LocalStreamingUploadFile(IFileRepository fileRepository, long size, String destPath, String prefix, String ext, String subdir, IFileSizeListener listener, int index, boolean makeUniqueName) throws SDKException {
        this(fileRepository, size, destPath, prefix, ext, subdir, listener, index, makeUniqueName, null);
    }

    LocalStreamingUploadFile(IFileRepository fileRepository, long size, String destPath, String prefix, String ext, String subdir, IFileSizeListener listener, int index, boolean makeUniqueName, String oldFileURL) throws SDKException {
        this.m_fileRepository = fileRepository;
        this.m_fileSize = size;
        this.m_destFilePath = destPath;
        this.m_listener = listener;
        this.m_index = index;
        this.m_oldFileURL = oldFileURL;
        this.m_putTx = null;
        if (makeUniqueName) {
            this.m_putTx = this.m_fileRepository.putUnique(size, destPath, prefix, ext);
            this.m_fileSize = 0L;
            this.m_destFilePath = (String)this.m_putTx.getDestination();
        }
        this.initialize(prefix, subdir);
        this.m_done = false;
    }

    private void initialize(String prefix, String subdir) {
        String shortName;
        this.m_destSubDir = null;
        this.m_destPrefix = null;
        int delim = this.m_destFilePath.lastIndexOf("/");
        if (delim == -1) {
            this.m_name = shortName = this.m_destFilePath;
        } else {
            this.m_name = shortName = this.m_destFilePath.substring(delim + 1);
            String dir = this.m_destFilePath.substring(0, delim);
            if (subdir != null && !subdir.equals("") && dir.endsWith(subdir = subdir.toLowerCase())) {
                this.m_destSubDir = subdir;
                this.m_name = subdir + '/' + this.m_name;
            }
        }
        if (prefix != null && !prefix.equals("") && shortName.startsWith(prefix = prefix.toLowerCase())) {
            this.m_destPrefix = prefix;
        }
    }

    private IPutStreamTx getPutTx() throws SDKException {
        if (this.m_done) {
            return null;
        }
        if (this.m_putTx == null) {
            this.m_putTx = this.m_fileRepository.put(this.m_fileSize, this.m_destFilePath);
            this.m_fileSize = 0L;
        }
        return this.m_putTx;
    }

    public long putContent(InputStream stream) throws SDKException {
        if (stream == null) {
            return 0L;
        }
        IPutStreamTx tx = this.getPutTx();
        if (tx == null) {
            throw new SDKException.InvalidOperation();
        }
        long size = tx.putContent(stream);
        this.m_fileSize += size;
        this.m_index = this.m_listener.updateSize(this.m_index, this, this.m_fileSize);
        return size;
    }

    public boolean putContent(byte[] stream) throws SDKException {
        if (stream == null) {
            return true;
        }
        return this.putContent(stream, 0, stream.length);
    }

    public boolean putContent(byte[] stream, int offset, int length) throws SDKException {
        if (stream == null) {
            return true;
        }
        IPutStreamTx tx = this.getPutTx();
        if (tx == null) {
            return false;
        }
        tx.putContent(stream, offset, length);
        this.m_fileSize += (long)length;
        this.m_index = this.m_listener.updateSize(this.m_index, this, this.m_fileSize);
        return true;
    }

    public String getName() {
        return this.m_name;
    }

    public long getSize() throws SDKException {
        return this.m_fileSize;
    }

    public void commit() throws SDKException {
        IPutStreamTx tx = this.getPutTx();
        if (tx != null) {
            tx.commit();
            if (this.m_oldFileURL != null) {
                this.m_fileRepository.remove(this.m_oldFileURL).commit();
            }
        }
        this.m_done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        if (this.m_putTx != null) {
            try {
                this.m_putTx.destroy();
            }
            catch (SDKException sDKException) {
            }
            finally {
                this.m_putTx = null;
                this.m_oldFileURL = null;
            }
        }
        this.m_done = true;
    }

    String getDestSubDir() {
        return this.m_destSubDir;
    }

    String getDestPrefix() {
        return this.m_destPrefix;
    }

    void initFromSerialization(IFileSizeListener listener, IFileRepository fileRepository) {
        this.m_listener = listener;
        this.m_fileRepository = fileRepository;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.m_fileSize);
        out.writeObject(this.m_destFilePath);
        out.writeInt(this.m_index);
        out.writeObject(this.m_name);
        out.writeObject(this.m_oldFileURL);
        out.writeObject(this.m_destSubDir);
        out.writeObject(this.m_destPrefix);
        out.writeBoolean(this.m_done);
        out.writeObject(this.m_putTx);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_fileSize = in.readLong();
        this.m_destFilePath = (String)in.readObject();
        this.m_index = in.readInt();
        this.m_name = (String)in.readObject();
        this.m_oldFileURL = (String)in.readObject();
        this.m_destSubDir = (String)in.readObject();
        this.m_destPrefix = (String)in.readObject();
        this.m_done = in.readBoolean();
        this.m_putTx = (IPutStreamTx)in.readObject();
    }

    public String serialize() {
        if (this.m_putTx != null && this.m_putTx instanceof IPutStreamTx) {
            return this.m_putTx.serialize();
        }
        return null;
    }
}

