/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.celib.exception.SILibException;
import com.crystaldecisions.celib.uri.FrsURL;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileRepositoryObject;
import com.crystaldecisions.sdk.occa.infostore.IRemoteFile;
import com.crystaldecisions.sdk.occa.infostore.IStreamingDownloadFile;
import com.crystaldecisions.sdk.occa.infostore.IStreamingFile;
import com.crystaldecisions.sdk.occa.infostore.IStreamingUploadFile;
import java.io.InputStream;
import java.io.OutputStream;

class NewRemoteFile
implements IRemoteFile {
    private IFileRepositoryObject m_fileObject;
    private String m_destFilePath;
    private FrsURL m_newFileURL;
    private long m_size;
    private String m_rootPath;
    private boolean m_done;

    NewRemoteFile() {
    }

    void initialize(IFileRepositoryObject fileObject, String destFilePath, long fileSize) throws SDKException {
        try {
            this.m_fileObject = fileObject;
            this.m_destFilePath = destFilePath;
            FrsURL orgURL = new FrsURL(fileObject.getURL());
            this.m_newFileURL = new FrsURL(orgURL.getHost(), destFilePath);
            this.m_size = fileSize;
            this.m_rootPath = fileObject.getRootPath();
        }
        catch (SILibException e) {
            throw new SDKException.URIFormat(destFilePath, (Exception)((Object)e));
        }
        this.m_done = false;
    }

    public boolean download(String localFile) throws SDKException {
        return false;
    }

    public boolean download(byte[] stream) throws SDKException {
        return false;
    }

    public boolean download(OutputStream stream) throws SDKException {
        return false;
    }

    public boolean overwrite(String localFile) throws SDKException {
        return false;
    }

    public boolean overwrite(byte[] stream) throws SDKException {
        return false;
    }

    public boolean overwrite(InputStream stream) throws SDKException {
        return false;
    }

    public boolean append(String localFile) throws SDKException {
        return false;
    }

    public boolean append(byte[] stream) throws SDKException {
        return false;
    }

    public InputStream getInputStream() throws SDKException {
        throw new SDKException.InvalidOperation();
    }

    public String getURL() {
        return this.m_newFileURL.toString();
    }

    public String getFilePath() throws SDKException {
        return this.m_newFileURL.getFilePath();
    }

    public long getSize() throws SDKException {
        if (this.m_size == 0L) {
            this.m_size = this.m_fileObject.getSize();
        }
        return this.m_size;
    }

    public String getRootPath() throws SDKException {
        return this.m_rootPath;
    }

    public String getLocalFilePath() throws SDKException {
        throw new SDKException.InvalidOperation();
    }

    public String getName() {
        String fileURL = this.getURL();
        int delim = fileURL.lastIndexOf("/");
        if (delim == -1) {
            return fileURL;
        }
        return fileURL.substring(delim + 1);
    }

    public void commit() throws SDKException {
        if (!this.m_done) {
            this.m_fileObject.copy(this.m_destFilePath).commit();
            this.m_done = true;
        }
    }

    public void abort() {
        this.m_done = true;
    }

    public IStreamingFile getStreamingFile() throws SDKException {
        throw new SDKException.InvalidOperation();
    }

    public IStreamingDownloadFile getStreamingDownloadFile(int chunkSize) throws SDKException {
        throw new SDKException.InvalidOperation();
    }

    public IStreamingUploadFile getStreamingUploadFile() throws SDKException {
        throw new SDKException.InvalidOperation();
    }

    public IStreamingUploadFile getStreamingUploadFile(long size) throws SDKException {
        throw new SDKException.InvalidOperation();
    }
}

