/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IDestinations;
import com.crystaldecisions.sdk.occa.infostore.INotifications;
import com.crystaldecisions.sdk.occa.infostore.internal.Destinations;
import com.crystaldecisions.sdk.occa.infostore.internal.SchedulingInfo;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;

public class Notifications
implements INotifications {
    private PropertyBag m_bag;
    private IDestinations m_onSuccess;
    private IDestinations m_onFailure;
    private SchedulingInfo m_schedulingInfo;

    public void init(IProperties propBag, SchedulingInfo schedulingInfo) {
        this.m_bag = (PropertyBag)propBag;
        this.m_schedulingInfo = schedulingInfo;
    }

    public void update(IProperties propBag, SchedulingInfo schedulingInfo) {
        this.m_bag = (PropertyBag)propBag;
        this.m_schedulingInfo = schedulingInfo;
    }

    public int getAuditOption() throws SDKException {
        return this.m_bag.getInt((Object)PropertyIDs.SI_AUDIT);
    }

    public void setAuditOption(int option) throws SDKException {
        if (option < 0 || option > 3) {
            throw new SDKException.InvalidArg(option);
        }
        this.m_bag.setProperty((Object)PropertyIDs.SI_AUDIT, option);
    }

    public IDestinations getDestinationsOnSuccess() throws SDKException {
        if (this.m_onSuccess == null) {
            PropertyBag successBag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_DESTINATION_SUCCESS);
            if (successBag == null) {
                successBag = this.m_bag.addArray((Object)PropertyIDs.SI_DESTINATION_SUCCESS).getPropertyBag();
            }
            this.m_onSuccess = new Destinations(successBag, this.m_schedulingInfo);
        }
        return this.m_onSuccess;
    }

    public IDestinations getDestinationsOnFailure() throws SDKException {
        if (this.m_onFailure == null) {
            PropertyBag successBag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_DESTINATION_FAILURE);
            if (successBag == null) {
                successBag = this.m_bag.addArray((Object)PropertyIDs.SI_DESTINATION_FAILURE).getPropertyBag();
            }
            this.m_onFailure = new Destinations(successBag, this.m_schedulingInfo);
        }
        return this.m_onFailure;
    }
}

