/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.occa.infostore.IObjectPrincipal;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRole;
import com.crystaldecisions.sdk.occa.infostore.IRoleID;
import com.crystaldecisions.sdk.occa.infostore.ISecurityLimit;
import com.crystaldecisions.sdk.occa.infostore.ISecurityLimits;
import com.crystaldecisions.sdk.occa.infostore.ISecurityRight;
import com.crystaldecisions.sdk.occa.infostore.ISecurityRights;
import com.crystaldecisions.sdk.occa.infostore.ISecurityRoleAdmin;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractRight;
import com.crystaldecisions.sdk.occa.infostore.internal.Role;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityLimits;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityRights;
import com.crystaldecisions.sdk.occa.security.ISecCacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.ISecurityInfoResult;
import com.crystaldecisions.sdk.occa.security.ISecurityResult;
import com.crystaldecisions.sdk.occa.security.internal.ICacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.internal.IPrincipal;
import com.crystaldecisions.sdk.occa.security.internal.IRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class ObjectPrincipal
implements IObjectPrincipal,
Externalizable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.ObjectPrincipal");
    private int m_id;
    private String m_name;
    private SecurityRights m_rights;
    private SecurityRights m_principal0Rights;
    private SecurityRights m_rightsOnParent;
    private SecurityRights m_effectiveRights;
    private SecurityRights m_inheritedRights;
    private SecurityLimits m_limits;
    private SecurityLimits m_effectiveLimits;
    private boolean m_principalOnParent;
    private Role m_role;
    private IRightID[] m_knownRights;
    private IRightID[] m_knownLimits;
    private HashMap m_knownRoles;
    private ISecurityRight m_NoInheritFoldersRight = null;
    private ISecurityRight m_NoInheritGroupsRight = null;
    private boolean m_isRightsPrincipal = false;
    private boolean m_isLimitsPrincipal = false;
    private ISecuritySession m_session;
    private IRightsHelper m_rightsHelper;
    private int m_loaded;
    private static final int UNLOADED = 0;
    private static final int EXPLICIT_LOADED = 1;
    private static final int EFFECTIVE_LOADED = 2;
    private int m_apsVersion;
    private boolean m_isAnyPrincipal;
    private HashMap m_iRole2CustomRoleMap = null;
    private HashMap m_customRole2IRoleMap = null;
    boolean m_isRoleUpdated;
    private static HashMap s_roleMap = new HashMap(5);

    public ObjectPrincipal() {
    }

    public ObjectPrincipal(int id, String name, IRightID[] knownRights, IRightID[] knownLimits, HashMap knownRoles, ISecuritySession session, IRightsHelper rightsHelper, boolean isAnyPrincipal) {
        this.m_id = id;
        this.m_name = name;
        this.m_session = session;
        this.m_rights = new SecurityRights(this.m_session, knownRights);
        this.m_principal0Rights = new SecurityRights(this.m_session, knownRights);
        this.m_rightsOnParent = new SecurityRights(this.m_session, knownRights);
        this.m_limits = new SecurityLimits(this.m_session, knownLimits);
        this.m_effectiveRights = new SecurityRights(this.m_session, knownRights);
        this.m_effectiveLimits = new SecurityLimits(this.m_session, knownLimits);
        this.m_inheritedRights = new SecurityRights(this.m_session, knownRights);
        this.m_knownRights = knownRights;
        this.m_knownLimits = knownLimits;
        this.m_knownRoles = knownRoles;
        this.m_rightsHelper = rightsHelper;
        this.m_loaded = 0;
        this.m_isAnyPrincipal = isAnyPrincipal;
        try {
            this.m_apsVersion = this.m_session.getAPSVersion();
        }
        catch (SDKException e) {
            this.m_apsVersion = 1200;
        }
    }

    public void setKnownSecurityInfo(IRightID[] knownRights, IRightID[] knownLimits) {
        this.m_knownRights = knownRights;
        this.m_knownLimits = knownLimits;
        this.m_rights.setKnownRights(knownRights);
        this.m_limits.setKnownRights(knownLimits);
    }

    public int getID() {
        return this.m_id;
    }

    public boolean isInherited() {
        return this.m_principalOnParent;
    }

    public void setInherited(boolean value) {
        if (this.m_principalOnParent == value) {
            return;
        }
        if (!this.m_principalOnParent && value) {
            throw new SDKRuntimeException.SetInherited();
        }
        this.m_principalOnParent = false;
    }

    public String getName() {
        return this.m_name;
    }

    public ISecurityRights getRights() {
        return this.m_rights;
    }

    public IRole getRole() {
        if (this.m_role == null) {
            this.m_role = (Role)IRole.ADVANCED;
            if (this.m_rightsHelper != null) {
                try {
                    this.m_rightsHelper.loadRights(this);
                }
                catch (SDKException e) {
                    LOG.warn((Object)"(getRole:167): exception being thrown when loading rights", (Throwable)((Object)e));
                }
            }
        }
        return this.m_role;
    }

    public void setRole(IRole role) {
        this.m_isRoleUpdated = true;
        this.m_role = (Role)this.m_knownRoles.get(role);
        if (this.m_role == null) {
            this.m_role = (Role)IRole.ADVANCED;
            this.m_principalOnParent = false;
            this.m_rights = new SecurityRights(this.m_session, this.m_knownRights);
        } else {
            if (this.m_principalOnParent) {
                this.m_principalOnParent = false;
            } else {
                this.m_rights.removeLocal();
            }
            if (this.m_NoInheritFoldersRight == null) {
                this.m_NoInheritFoldersRight = new SecurityRights.SecurityRight(64, null, null, 0);
            }
            this.m_NoInheritFoldersRight.setGranted(true);
            if (this.m_NoInheritGroupsRight == null) {
                this.m_NoInheritGroupsRight = new SecurityRights.SecurityRight(63, null, null, 0);
            }
            this.m_NoInheritGroupsRight.setGranted(true);
        }
    }

    public ISecurityRights getInheritedRights() {
        return this.m_inheritedRights;
    }

    public boolean isAdvancedInheritGroups() {
        return this.m_NoInheritGroupsRight == null || !this.m_NoInheritGroupsRight.isGranted();
    }

    public void setAdvancedInheritGroups(boolean inherit) {
        if (this.m_principalOnParent) {
            return;
        }
        if (inherit) {
            if (this.m_NoInheritGroupsRight != null) {
                this.m_NoInheritGroupsRight = null;
            }
        } else {
            if (this.m_NoInheritGroupsRight == null) {
                this.m_NoInheritGroupsRight = new SecurityRights.SecurityRight(63, null, null, 0);
            }
            this.m_NoInheritGroupsRight.setGranted(true);
        }
    }

    public boolean isAdvancedInheritFolders() {
        return this.m_NoInheritFoldersRight == null || !this.m_NoInheritFoldersRight.isGranted();
    }

    public void setAdvancedInheritFolders(boolean inherit) {
        if (this.m_principalOnParent) {
            return;
        }
        if (inherit) {
            if (this.m_NoInheritFoldersRight != null) {
                this.m_NoInheritFoldersRight = null;
            }
        } else {
            if (this.m_NoInheritFoldersRight == null) {
                this.m_NoInheritFoldersRight = new SecurityRights.SecurityRight(64, null, null, 0);
            }
            this.m_NoInheritFoldersRight.setGranted(true);
        }
    }

    public int getAttributesSet() {
        return (this.m_isRightsPrincipal ? 1 : 0) | (this.m_isLimitsPrincipal ? 2 : 0);
    }

    public ISecurityLimits getLimits() {
        return this.m_limits;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        sb.append(this.m_name);
        sb.append(' ');
        sb.append(this.m_id);
        sb.append(')');
        return sb.toString();
    }

    public void preloadRights(ICacheControllerAdmin cacheAdmin, int objectID, String type) throws SDKException {
        IRightID right;
        if (this.isEffectiveRightsLoaded()) {
            return;
        }
        for (int i = 0; i < this.m_knownRights.length; ++i) {
            right = this.m_knownRights[i];
            this.m_rights.importRight(right.getID());
            this.m_rightsOnParent.importRight(right.getID());
            this.m_effectiveRights.importRight(right.getID());
            this.m_inheritedRights.importRight(right.getID());
        }
        this.m_rights.importHiddenRight(64);
        this.m_rights.importHiddenRight(63);
        if (this.m_apsVersion > 1100) {
            this.m_principal0Rights.importHiddenRight(64);
        }
        this.m_rightsOnParent.importHiddenRight(64);
        this.m_rightsOnParent.importHiddenRight(63);
        this.m_effectiveRights.importHiddenRight(64);
        this.m_effectiveRights.importHiddenRight(63);
        for (int j = 0; j < this.m_knownLimits.length; ++j) {
            right = this.m_knownLimits[j];
            this.m_limits.importLimit(right.getID());
            this.m_effectiveLimits.importLimit(right.getID());
        }
        this.m_rights.preloadRights(cacheAdmin, objectID, this.m_id, type);
        if (this.m_apsVersion > 1100) {
            this.m_principal0Rights.preloadRights(cacheAdmin, objectID, 0, type);
        }
        this.m_rightsOnParent.preloadRights(cacheAdmin, objectID, this.m_id, type);
        this.m_effectiveRights.preloadRights(cacheAdmin, objectID, this.m_id, type);
        this.m_limits.preloadRights(cacheAdmin, objectID, this.m_id, type);
        this.m_effectiveLimits.preloadRights(cacheAdmin, objectID, this.m_id, type);
    }

    public void preloadRights2(ISecCacheControllerAdmin cacheAdmin, int objectID) throws SDKException {
        cacheAdmin.cacheSecurityInfo(objectID, this.m_id);
        cacheAdmin.cacheExplicitPrincipals(objectID);
    }

    boolean isEffectiveRightsLoaded() {
        return this.m_loaded == 2;
    }

    public void loadExplicitRights(IPrincipal principal) throws SDKException {
        ISecurityLimit[] limitsID;
        ISecurityRight[] rightsID = principal.getExplicitRights();
        if (rightsID != null) {
            for (int i = 0; i < rightsID.length; ++i) {
                ISecurityRight right = rightsID[i];
                this.m_rights.importExplicitRight(right);
            }
        }
        if ((limitsID = principal.getExplicitLimits()) != null) {
            for (int i = 0; i < limitsID.length; ++i) {
                ISecurityLimit limit = limitsID[i];
                this.m_limits.importExplicitLimit(limit);
            }
        }
        this.m_NoInheritFoldersRight = this.m_rights.get(64);
        this.m_NoInheritGroupsRight = this.m_rights.get(63);
        this.m_rights.remove(64);
        this.m_rights.remove(63);
        this.m_loaded = 1;
    }

    public void loadRights(IRightsAdmin rightsAdmin, int objectID, String type) throws SDKException {
        if (this.m_apsVersion > 1100) {
            this.m_principal0Rights.loadRights(rightsAdmin, objectID, 0, type, 1);
        }
        this.m_rights.loadRights(rightsAdmin, objectID, this.m_id, type, 1);
        this.m_NoInheritFoldersRight = this.m_rights.get(64);
        boolean isAdvancedInheritFolders = this.isAdvancedInheritFolders();
        boolean principal0IsAdvancedIF = true;
        if (this.m_apsVersion > 1100) {
            ISecurityRight principal0NIF = this.m_principal0Rights.get(64);
            principal0IsAdvancedIF = principal0NIF == null || !principal0NIF.isGranted();
        }
        isAdvancedInheritFolders = isAdvancedInheritFolders && principal0IsAdvancedIF;
        this.m_NoInheritGroupsRight = this.m_rights.get(63);
        boolean isAdvancedInheritGroups = this.isAdvancedInheritGroups();
        if (this.m_rights.existing() == 0) {
            this.m_rightsOnParent.loadRights(rightsAdmin, objectID, this.m_id, type, 2);
            this.m_principalOnParent = true;
        }
        this.m_effectiveRights.loadRights(rightsAdmin, objectID, this.m_id, type, 31);
        if (this.m_principalOnParent) {
            this.m_inheritedRights.copy(this.m_effectiveRights);
        } else if (isAdvancedInheritFolders && isAdvancedInheritGroups) {
            this.m_inheritedRights.loadRights(rightsAdmin, objectID, this.m_id, type, 14);
        } else if (isAdvancedInheritFolders) {
            this.m_inheritedRights.loadRights(rightsAdmin, objectID, this.m_id, type, 2);
        } else if (isAdvancedInheritGroups) {
            this.m_inheritedRights.loadRights(rightsAdmin, objectID, this.m_id, type, 4);
        }
        this.m_limits.loadRights(rightsAdmin, objectID, this.m_id, type, 1);
        if (this.m_limits.existing() == 0) {
            this.m_limits.loadRights(rightsAdmin, objectID, this.m_id, type, 2);
        }
        this.m_effectiveLimits.loadRights(rightsAdmin, objectID, this.m_id, type, 31);
        this.m_rights.removeNonExistent();
        this.m_rightsOnParent.removeNonExistent();
        this.m_effectiveRights.removeNonExistent();
        this.m_limits.removeNonExistent();
        this.m_effectiveLimits.removeNonExistent();
        this.m_inheritedRights.removeNonExistent();
        if (this.m_rights.size() != 0 || this.m_rightsOnParent.size() != 0) {
            this.m_isRightsPrincipal = true;
        }
        if (this.m_limits.size() != 0) {
            this.m_isLimitsPrincipal = true;
        }
        if (this.m_isAnyPrincipal) {
            this.m_limits.copy(this.m_effectiveLimits);
        }
        this.m_rights.remove(64);
        this.m_rights.remove(63);
        this.m_inheritedRights.remove(64);
        this.m_inheritedRights.remove(63);
        this.m_loaded = 2;
    }

    public void loadRights2(ISecRightsAdmin rightsAdmin, int objectID) throws SDKException {
        ISecurityResult result = rightsAdmin.getSecurityInfo(objectID, this.m_id);
        ISecurityInfoResult infoResult = (ISecurityInfoResult)result.getResult();
        ISecurityRoleAdmin[] efRoles = infoResult.getRoles();
        if (efRoles.length <= 0 && (this.m_rights.size() <= 0 || this.m_rights.existing() <= 0)) {
            this.m_role = (Role)IRole.NO_ACCESS;
        } else {
            Set efRoleSet = this.getCustomRoleSet(efRoles);
            this.m_role = (Role)IRole.ADVANCED;
            if (efRoleSet.size() == 1) {
                int roleID = (Integer)efRoleSet.iterator().next();
                this.m_role = (Role)this.mapCustomRoleToIRole(roleID);
            }
        }
    }

    private Set getCustomRoleSet(ISecurityRoleAdmin[] inRoles) {
        HashSet<Integer> roles = new HashSet<Integer>();
        for (int i = 0; i < inRoles.length; ++i) {
            ISecurityRoleAdmin role = inRoles[i];
            if (role.getPrincipalID() != this.m_id) continue;
            roles.add(new Integer(role.getID()));
        }
        return roles;
    }

    public void saveRights(IRightsAdmin rightsAdmin, int objectID, String type) throws SDKException {
        if (this.m_NoInheritFoldersRight != null) {
            this.m_rights.addHidden((AbstractRight)((Object)this.m_NoInheritFoldersRight));
        } else {
            this.m_rights.remove(64);
        }
        if (this.m_NoInheritGroupsRight != null) {
            this.m_rights.addHidden((AbstractRight)((Object)this.m_NoInheritGroupsRight));
        } else {
            this.m_rights.remove(63);
        }
        this.m_rights.saveRights(rightsAdmin, objectID, this.m_id, type);
        this.m_limits.saveRights(rightsAdmin, objectID, this.m_id, type);
    }

    public void saveRights2(ISecRightsAdmin rightsAdmin, int objectID, String type) throws SDKException {
        boolean rightsCleared = false;
        if (this.m_loaded == 0) {
            this.clearRightsAndRoles(rightsAdmin, objectID, true);
            rightsCleared = true;
        }
        if (this.m_isRoleUpdated && !IRole.ADVANCED.equals(this.m_role)) {
            if (!rightsCleared) {
                this.clearRightsAndRoles(rightsAdmin, objectID, false);
            }
            rightsCleared = true;
            if (!IRole.NO_ACCESS.equals(this.m_role)) {
                int roleID = this.mapIRoleToCustomRole(this.m_role);
                rightsAdmin.setRole(roleID, this.m_id, objectID);
            }
        }
    }

    public boolean isDirty() {
        Iterator rightsIter = this.getRights().iterator();
        while (rightsIter.hasNext()) {
            SecurityRights.SecurityRight sr = (SecurityRights.SecurityRight)rightsIter.next();
            if (!sr.isDirty()) continue;
            return true;
        }
        Iterator limitsIter = this.getLimits().iterator();
        while (limitsIter.hasNext()) {
            SecurityLimits.SecurityLimit sl = (SecurityLimits.SecurityLimit)limitsIter.next();
            if (!sl.isDirty()) continue;
            return true;
        }
        if (this.m_loaded == 0) {
            return true;
        }
        return this.m_isRoleUpdated && !IRole.ADVANCED.equals(this.m_role);
    }

    private void clearRightsAndRoles(ISecRightsAdmin rightsAdmin, int objectID, boolean bClearLimits) throws SDKException {
        rightsAdmin.removeRights(this.m_id, objectID);
        if (bClearLimits) {
            rightsAdmin.removeLimits(this.m_id, objectID);
        }
        rightsAdmin.removeRoles(this.m_id, objectID);
    }

    void setRemoved() {
        this.m_rights.removeLocal();
        this.m_limits.removeLocal();
        this.m_NoInheritFoldersRight = null;
        this.m_NoInheritGroupsRight = null;
    }

    void initFromSerialization(ObjectPrincipal deltaPrincipal) {
        this.m_isRoleUpdated = deltaPrincipal.m_isRoleUpdated;
        if (this.m_isRoleUpdated && deltaPrincipal.m_role != null) {
            this.setRole(deltaPrincipal.m_role);
        }
        this.m_principalOnParent = deltaPrincipal.m_principalOnParent;
        if (deltaPrincipal.m_isAnyPrincipal != this.m_isAnyPrincipal) {
            this.m_isAnyPrincipal = deltaPrincipal.m_isAnyPrincipal;
        }
        if (deltaPrincipal.isAdvancedInheritFolders() != this.isAdvancedInheritFolders()) {
            this.setAdvancedInheritFolders(deltaPrincipal.isAdvancedInheritFolders());
        }
        if (deltaPrincipal.isAdvancedInheritGroups() != this.isAdvancedInheritGroups()) {
            this.setAdvancedInheritGroups(deltaPrincipal.isAdvancedInheritGroups());
        }
        if (deltaPrincipal.m_rights != null) {
            this.m_rights.initFromSerialization(deltaPrincipal.m_rights);
        }
        if (deltaPrincipal.m_limits != null) {
            this.m_limits.initFromSerialization(deltaPrincipal.m_limits);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.m_id);
        out.writeBoolean(this.m_principalOnParent);
        out.writeBoolean(this.m_isAnyPrincipal);
        out.writeObject(this.m_name);
        out.writeObject(this.m_rights);
        out.writeObject(this.m_limits);
        out.writeBoolean(this.isAdvancedInheritFolders());
        out.writeBoolean(this.isAdvancedInheritGroups());
        out.writeBoolean(this.m_isRoleUpdated);
        if (this.m_isRoleUpdated) {
            out.writeInt(this.m_role.getID());
            out.writeObject(this.m_role.getDescriptionID());
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_id = in.readInt();
        this.m_principalOnParent = in.readBoolean();
        this.m_isAnyPrincipal = in.readBoolean();
        this.m_name = (String)in.readObject();
        this.m_rights = (SecurityRights)in.readObject();
        this.m_limits = (SecurityLimits)in.readObject();
        boolean isInheritFolders = in.readBoolean();
        this.setAdvancedInheritFolders(isInheritFolders);
        boolean isInheritGroups = in.readBoolean();
        this.setAdvancedInheritGroups(isInheritGroups);
        this.m_isRoleUpdated = in.readBoolean();
        if (this.m_isRoleUpdated) {
            this.m_role = new Role(in.readInt(), (String)in.readObject(), new int[0]);
        }
    }

    private int mapIRoleToCustomRole(IRole iRole) throws SDKException {
        this.initCustomRoleMap();
        Integer customRoleID = (Integer)this.m_iRole2CustomRoleMap.get(iRole);
        if (customRoleID == null) {
            throw new SDKException.InvalidObjectID((String)s_roleMap.get(iRole));
        }
        return customRoleID;
    }

    private IRole mapCustomRoleToIRole(int customRoleID) throws SDKException {
        this.initCustomRoleMap();
        IRole role = (IRole)this.m_customRole2IRoleMap.get(new Integer(customRoleID));
        if (role == null) {
            return IRole.ADVANCED;
        }
        return role;
    }

    private void initCustomRoleMap() throws SDKException {
        ISecurityResult result;
        if (this.m_iRole2CustomRoleMap == null && (result = this.m_session.getSecurityInfoMgr().getRightsAdmin().getKnownRoles()) != null) {
            IRoleID[] roleIDs = (IRoleID[])result.getResult();
            this.m_iRole2CustomRoleMap = new HashMap(5);
            this.m_customRole2IRoleMap = new HashMap(5);
            for (int i = 0; i < roleIDs.length; ++i) {
                IRoleID roleID = roleIDs[i];
                IRole iRole = null;
                if ("ARyVDaEmPM5BiH1em9k6utc".equals(roleID.getCUID())) {
                    iRole = IRole.SCHEDULE;
                } else if ("AVog52Tl72ZGvIReeqKndUA".equals(roleID.getCUID())) {
                    iRole = IRole.FULL_CONTROL;
                } else if ("Acagufm667pEuwpfj0zYpaQ".equals(roleID.getCUID())) {
                    iRole = IRole.VIEW;
                } else if ("AeiidL1fVJRMnQDqyKYJjC8".equals(roleID.getCUID())) {
                    iRole = IRole.VIEW_ON_DEMAND;
                }
                if (iRole == null) continue;
                Integer customRoleID = new Integer(roleID.getID());
                IRole actualIRole = (IRole)this.m_knownRoles.get(iRole);
                this.m_iRole2CustomRoleMap.put(actualIRole, customRoleID);
                this.m_customRole2IRoleMap.put(customRoleID, actualIRole);
            }
        }
    }

    public void serializeHelper(PropertyBag bag) {
        bag.addItem((Object)PropertyIDs.SI_ID, (Object)new Integer(this.m_id), 0);
        if (this.m_NoInheritFoldersRight == null || !this.m_NoInheritFoldersRight.isGranted()) {
            bag.addItem((Object)PropertyIDs.SI_ISINHERITFOLDERS, (Object)new Boolean(true), 0);
        } else {
            bag.addItem((Object)PropertyIDs.SI_ISINHERITFOLDERS, (Object)new Boolean(false), 0);
        }
        if (this.m_NoInheritGroupsRight == null || !this.m_NoInheritGroupsRight.isGranted()) {
            bag.addItem((Object)PropertyIDs.SI_ISINHERITGROUPS, (Object)new Boolean(true), 0);
        } else {
            bag.addItem((Object)PropertyIDs.SI_ISINHERITGROUPS, (Object)new Boolean(false), 0);
        }
        if (this.m_role != null) {
            int roleID = this.m_role.getID();
            bag.addItem((Object)PropertyIDs.SI_ROLE, (Object)new Integer(roleID), 0);
        }
        PropertyBag rightsBag = bag.addItem((Object)PropertyIDs.SI_RIGHTS, null, 0x8000000).getPropertyBag();
        PropertyArrayHelper rightsHelper = new PropertyArrayHelper(rightsBag, PropertyIDs.SI_TOTAL);
        this.m_rights.serializeHelper(rightsHelper);
        PropertyBag limitsBag = bag.addItem((Object)PropertyIDs.SI_LIMITS, null, 0x8000000).getPropertyBag();
        PropertyArrayHelper limitsHelper = new PropertyArrayHelper(limitsBag, PropertyIDs.SI_TOTAL);
        this.m_limits.serializeHelper(limitsHelper);
    }

    static {
        s_roleMap.put(IRole.FULL_CONTROL, "AVog52Tl72ZGvIReeqKndUA");
        s_roleMap.put(IRole.VIEW, "Acagufm667pEuwpfj0zYpaQ");
        s_roleMap.put(IRole.VIEW_ON_DEMAND, "AeiidL1fVJRMnQDqyKYJjC8");
        s_roleMap.put(IRole.SCHEDULE, "ARyVDaEmPM5BiH1em9k6utc");
    }

    static interface IRightsHelper {
        public void loadRights(ObjectPrincipal var1) throws SDKException;
    }
}

