/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.holder.internal.ArrayHolder;
import com.crystaldecisions.sdk.occa.infostore.IObjectPrincipal;
import com.crystaldecisions.sdk.occa.infostore.IObjectPrincipals;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRole;
import com.crystaldecisions.sdk.occa.infostore.ISecurityRoleAdmin;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractRight;
import com.crystaldecisions.sdk.occa.infostore.internal.ObjectPrincipal;
import com.crystaldecisions.sdk.occa.security.ISecCacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.ISecurityResult;
import com.crystaldecisions.sdk.occa.security.internal.ICacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.internal.IPrincipal;
import com.crystaldecisions.sdk.occa.security.internal.IRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ObjectPrincipals
implements IObjectPrincipals,
Externalizable {
    private static final int PRINCIPAL_COMMIT_LIMIT = 100;
    private Map m_principals;
    private Map m_removed;
    private IRightID[] m_knownRights;
    private IRightID[] m_knownLimits;
    private HashMap m_knownRoles;
    private ISecuritySession m_session;
    private int m_type;
    private boolean m_isNew;
    private ObjectPrincipal.IRightsHelper m_rightsHelper;

    int getType() {
        return this.m_type;
    }

    void setType(int type) {
        this.m_type = type;
    }

    public ObjectPrincipals() {
    }

    public ObjectPrincipals(IRightID[] knownRights, IRightID[] knownLimits, HashMap knownRoles, ISecuritySession session, int type, ObjectPrincipal.IRightsHelper rightsHelper, boolean isNew) {
        this.m_principals = new HashMap();
        this.m_removed = new HashMap();
        this.m_knownRights = knownRights;
        this.m_knownLimits = knownLimits;
        this.m_knownRoles = knownRoles;
        this.m_session = session;
        this.m_type = type;
        this.m_rightsHelper = rightsHelper;
        this.m_isNew = isNew;
    }

    public IObjectPrincipal add(int id) {
        Integer key = new Integer(id);
        ObjectPrincipal op = (ObjectPrincipal)this.m_principals.get(key);
        if (op == null) {
            op = new ObjectPrincipal(id, "", this.m_knownRights, this.m_knownLimits, this.m_knownRoles, this.m_session, this.m_rightsHelper, false);
            this.m_principals.put(new Integer(id), op);
            op.setAdvancedInheritGroups(true);
            op.setAdvancedInheritFolders(true);
            op.setRole(IRole.ADVANCED);
            op.setInherited(false);
        }
        return op;
    }

    public IObjectPrincipal get(int id) {
        return (IObjectPrincipal)this.m_principals.get(new Integer(id));
    }

    public Iterator iterator() {
        return this.m_principals.values().iterator();
    }

    public void remove(int id) {
        Integer key = new Integer(id);
        ObjectPrincipal op = (ObjectPrincipal)this.m_principals.get(key);
        op.setRemoved();
        this.m_removed.put(key, op);
    }

    public int size() {
        return this.m_principals.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        Iterator iter = this.m_principals.values().iterator();
        while (iter.hasNext()) {
            ObjectPrincipal principal = (ObjectPrincipal)iter.next();
            sb.append(principal.toString());
        }
        sb.append(')');
        return sb.toString();
    }

    ObjectPrincipal add(int id, String name) {
        ObjectPrincipal op = (ObjectPrincipal)this.get(id);
        if (op == null) {
            op = new ObjectPrincipal(id, name, this.m_knownRights, this.m_knownLimits, this.m_knownRoles, this.m_session, this.m_rightsHelper, false);
            this.m_principals.put(new Integer(id), op);
        }
        return op;
    }

    void preloadRights(ICacheControllerAdmin cache, IRightsAdmin rightsAdmin, int objectID, String type) throws SDKException {
        ArrayHolder out = new ArrayHolder();
        cache.cachePrincipals("#" + objectID, type);
        rightsAdmin.getPrincipals("#" + objectID, type, out);
        IPrincipal[] principals = (IPrincipal[])out.get();
        for (int i = 0; i < principals.length; ++i) {
            IPrincipal principal = principals[i];
            int principalID = principal.getID();
            this.add(principalID, principal.getName());
        }
        int batches = this.m_principals.size() / 100;
        if (this.m_principals.size() % 100 != 0) {
            ++batches;
        }
        int i = 0;
        Iterator iter = this.m_principals.values().iterator();
        for (int batch = 0; batch < batches; ++batch) {
            cache.batch();
            try {
                while (iter.hasNext() && i < (batch + 1) * 100) {
                    ObjectPrincipal op = (ObjectPrincipal)iter.next();
                    op.preloadRights(cache, objectID, type);
                    ++i;
                }
                cache.commit();
                continue;
            }
            catch (SDKException e) {
                cache.rollback();
                throw e;
            }
            catch (Throwable e) {
                cache.rollback();
                SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
                throw sdke;
            }
        }
    }

    void loadExplicitRights(ICacheControllerAdmin cache, IRightsAdmin rightsAdmin, int objectID) throws SDKException {
        ArrayHolder out = new ArrayHolder();
        cache.batch();
        try {
            cache.cacheExplicitPrincipalsAndRights("#" + objectID);
            cache.commit();
            rightsAdmin.getExplicitPrincipals("#" + objectID, out);
            IPrincipal[] principals = (IPrincipal[])out.get();
            for (int i = 0; i < principals.length; ++i) {
                IPrincipal principal = principals[i];
                int principalID = principal.getID();
                ObjectPrincipal op = this.add(principalID, principal.getName());
                op.loadExplicitRights(principal);
            }
        }
        catch (SDKException e) {
            cache.rollback();
            throw e;
        }
        catch (Throwable e) {
            cache.rollback();
            SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
            throw sdke;
        }
    }

    void loadExplicitCALs(ISecCacheControllerAdmin cache, ISecRightsAdmin rightsAdmin, int objectID) throws SDKException {
        cache.batch();
        try {
            cache.cacheExplicitRoles(objectID);
            cache.commit();
            ISecurityResult result = rightsAdmin.getExplicitRoles(objectID);
            ISecurityRoleAdmin[] roles = (ISecurityRoleAdmin[])result.getResult();
            for (int i = 0; i < roles.length; ++i) {
                ISecurityRoleAdmin role = roles[i];
                int principalID = role.getPrincipalID();
                this.add(principalID, role.getPrincipalName());
            }
        }
        catch (SDKException e) {
            cache.rollback();
            throw e;
        }
        catch (Throwable e) {
            cache.rollback();
            SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
            throw sdke;
        }
    }

    void loadRights(IRightsAdmin source, int objectID, String type) throws SDKException {
        Iterator iter = this.m_principals.values().iterator();
        while (iter.hasNext()) {
            ObjectPrincipal op = (ObjectPrincipal)iter.next();
            op.loadRights(source, objectID, type);
        }
    }

    void saveRights(IRightsAdmin dest, int objectID, String type) throws SDKException {
        Iterator iter = this.m_principals.values().iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            ObjectPrincipal principal = (ObjectPrincipal)next;
            principal.saveRights(dest, objectID, type);
        }
    }

    void saveRights2(ISecRightsAdmin dest, int objectID, String type) throws SDKException {
        ObjectPrincipal principal;
        Object next;
        Iterator iter = this.m_removed.values().iterator();
        while (iter.hasNext()) {
            next = iter.next();
            principal = (ObjectPrincipal)next;
            dest.removeRights(principal.getID(), objectID);
            dest.removeLimits(principal.getID(), objectID);
            dest.removeRoles(principal.getID(), objectID);
        }
        iter = this.m_principals.values().iterator();
        while (iter.hasNext()) {
            next = iter.next();
            principal = (ObjectPrincipal)next;
            principal.saveRights2(dest, objectID, type);
        }
    }

    void initFromSerialization(ObjectPrincipals deltaPrincipals, IRightID[] knownRights, IRightID[] knownLimits) {
        Iterator iter = deltaPrincipals.m_principals.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ObjectPrincipal deltaPrincipal = (ObjectPrincipal)entry.getValue();
            ObjectPrincipal existingPrincipal = (ObjectPrincipal)this.m_principals.get(new Integer(deltaPrincipal.getID()));
            if (existingPrincipal == null) {
                existingPrincipal = this.add(deltaPrincipal.getID(), deltaPrincipal.getName());
            }
            existingPrincipal.initFromSerialization(deltaPrincipal);
            existingPrincipal.setKnownSecurityInfo(knownRights, knownLimits);
        }
        iter = deltaPrincipals.m_removed.keySet().iterator();
        while (iter.hasNext()) {
            Integer removedId = (Integer)((Object)iter.next());
            this.remove(removedId);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.m_type);
        out.writeObject(this.m_principals);
        out.writeObject(new HashSet(this.m_removed.keySet()));
        out.writeBoolean(this.m_isNew);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_type = in.readInt();
        this.m_principals = (Map)in.readObject();
        Set removed = (Set)in.readObject();
        this.m_removed = new HashMap(removed == null ? 0 : removed.size());
        Iterator iter = removed.iterator();
        while (iter.hasNext()) {
            Integer removedPrinc = (Integer)iter.next();
            this.m_removed.put(removedPrinc, null);
        }
        this.m_isNew = in.readBoolean();
    }

    public void serializeHelper(PropertyBag bag) {
        PropertyBag principalsPropBag = bag.addPropertyBag((Object)PropertyIDs.SI_PRINCIPALS, null).getPropertyBag();
        PropertyArrayHelper arrayhelper = new PropertyArrayHelper(principalsPropBag, PropertyIDs.SI_TOTAL);
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            ObjectPrincipal principal = (ObjectPrincipal)itr.next();
            if (principal.isInherited()) continue;
            PropertyBag principalbag = arrayhelper.add(null, 0x8000000).getPropertyBag();
            principal.serializeHelper(principalbag);
        }
    }

    public boolean isNewObjectPrincipals() {
        return this.m_isNew;
    }

    public boolean isDirty() {
        if (this.m_removed.size() > 0) {
            return true;
        }
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ObjectPrincipal op = (ObjectPrincipal)iter.next();
            if (!op.isDirty()) continue;
            return true;
        }
        return false;
    }

    class SecuritySetIterator
    implements Iterator {
        Iterator m_internal;
        AbstractRight m_last;

        public SecuritySetIterator() {
            this.m_internal = ObjectPrincipals.this.m_principals.values().iterator();
        }

        public boolean hasNext() {
            return this.m_internal.hasNext();
        }

        public Object next() {
            this.m_last = (AbstractRight)this.m_internal.next();
            return this.m_last;
        }

        public void remove() {
            this.m_internal.remove();
            int id = this.m_last.getID();
            ObjectPrincipals.this.m_removed.put(new Integer(id), this.m_last);
        }
    }
}

