/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import java.util.ArrayList;
import java.util.List;

public class PageIndex {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.PageIndex");
    private int m_firstItemID;
    private int m_lastItemID;
    private List m_queryFilter;

    private void initialize(int firstItemID, int lastItemID, List queryFilter, boolean forceFilter) {
        this.m_firstItemID = firstItemID;
        this.m_lastItemID = lastItemID;
        this.m_queryFilter = queryFilter;
        if (queryFilter == null && forceFilter) {
            this.m_queryFilter = new ArrayList();
            this.m_queryFilter.add("SI_ID");
        }
    }

    public PageIndex(int firstItemID, int lastItemID, List queryFilter) {
        LOG.assertTrue(firstItemID >= 0, "First item ID must be non-negative.");
        LOG.assertTrue(lastItemID >= 0, "Last item ID must be non-negative.");
        this.initialize(firstItemID, lastItemID, queryFilter, true);
    }

    public PageIndex(int firstItemID, int lastItemID) {
        LOG.assertTrue(firstItemID >= 0, "First item ID must be non-negative.");
        LOG.assertTrue(lastItemID >= 0, "Last item ID must be non-negative.");
        this.initialize(firstItemID, lastItemID, null, false);
    }

    public PageIndex(int firstItemID, List queryFilter) {
        LOG.assertTrue(firstItemID >= 0, "First item ID must be non-negative.");
        this.initialize(firstItemID, -1, queryFilter, true);
    }

    public PageIndex(int firstItemID) {
        LOG.assertTrue(firstItemID >= 0, "First item ID must be non-negative.");
        this.initialize(firstItemID, -1, null, false);
    }

    public boolean isValid(IInfoObjects items, int numItemsPerPage) {
        LOG.assertTrue(items != null, "Items must be present.");
        if (items == null) {
            return false;
        }
        int count = items.size();
        if (count == 0 || count > numItemsPerPage) {
            return false;
        }
        IInfoObject firstItem = (IInfoObject)items.get(0);
        if (firstItem.getID() != this.m_firstItemID) {
            return false;
        }
        if (numItemsPerPage > 1) {
            if (this.m_lastItemID < 0) {
                if (count >= numItemsPerPage) {
                    return false;
                }
            } else {
                if (count < numItemsPerPage) {
                    return false;
                }
                IInfoObject lastItem = (IInfoObject)items.get(numItemsPerPage - 1);
                if (lastItem.getID() != this.m_lastItemID) {
                    return false;
                }
            }
        }
        return true;
    }

    public List getQueryFilter() {
        return this.m_queryFilter;
    }
}

