/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.conversion.DateConversion;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.CePropertyID;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.IPagingQueryBase;
import com.crystaldecisions.sdk.occa.infostore.SearchPattern;
import com.crystaldecisions.sdk.occa.infostore.SortType;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.PageIndex;
import com.crystaldecisions.sdk.occa.infostore.internal.PagingState;
import com.crystaldecisions.sdk.occa.infostore.internal.QuerySettings;
import com.crystaldecisions.sdk.occa.infostore.internal.SortByInfo;
import com.crystaldecisions.sdk.occa.infostore.internal.SortDimension;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class QueryBaseImpl
implements IPagingQueryBase {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.QueryBaseImpl");
    protected static final String DEFAULT_TABLE = "";
    protected static final String DEFAULT_FIELDS = "";
    protected static final int INVALID_PAGE_NUMBER = -1;
    protected static final int DEFAULT_ITEMS_PER_PAGE = 1000;
    protected static final int DEFAULT_PAGES_PER_RANGE = 1;
    protected static final int MAX_RELOAD_RETRY = 2;
    protected static final String FIELD_DELIM = ",";
    protected int m_itemsPerPage;
    protected int m_pagesPerRange;
    protected String m_tables;
    protected String m_fields;
    protected boolean m_count;
    protected SearchPattern m_searchPattern;
    protected SortType m_sortBy;
    protected PagingState m_loadedPagingState;
    protected IInternalInfoStore m_infoStore;

    QueryBaseImpl() {
    }

    public void initialize(IInternalInfoStore infostore, String tables, int propSet, SearchPattern pattern, SortType sortBy) throws SDKException {
        this.m_infoStore = infostore;
        if (propSet != 7 && propSet != 1 && propSet != 4 && propSet != 2) {
            throw new SDKException.InvalidArg();
        }
        this.m_tables = tables;
        if (this.m_tables.length() == 0) {
            throw new SDKException.InvalidArg();
        }
        this.m_fields = QuerySettings.ToFields(propSet);
        this.m_searchPattern = new SearchPattern(pattern);
        this.m_sortBy = new SortType(sortBy);
        this.m_itemsPerPage = 1000;
        this.m_pagesPerRange = 1;
        this.m_loadedPagingState = new PagingState(this);
    }

    public void initialize(IInternalInfoStore store) {
        this.m_infoStore = store;
        this.m_tables = "";
        this.m_fields = "";
        this.m_itemsPerPage = 1000;
        this.m_pagesPerRange = 1;
        this.m_loadedPagingState = new PagingState(this);
    }

    public String getOrderByFields() {
        String orderByFields = "";
        List sortByInfos = this.getOrderByInfos();
        int size = sortByInfos.size();
        for (int i = 0; i < size; ++i) {
            SortByInfo sort = (SortByInfo)sortByInfos.get(i);
            if (orderByFields.length() > 0) {
                orderByFields = orderByFields + FIELD_DELIM;
            }
            orderByFields = orderByFields + sort.getPropertyName();
        }
        return orderByFields;
    }

    public String getOrderByClause() {
        String sortClause = "";
        if (this.m_sortBy != null) {
            sortClause = QuerySettings.getOrderClause(this.m_sortBy);
        }
        if (sortClause.length() == 0) {
            sortClause = sortClause + "SI_ID";
        } else {
            sortClause = sortClause + FIELD_DELIM;
            sortClause = sortClause + "SI_ID";
        }
        return sortClause;
    }

    public String getWhereClause() {
        if (this.m_searchPattern == null) {
            return "";
        }
        return QuerySettings.generateWhereClause(this.m_searchPattern);
    }

    public void populatePageIndices(IInfoObjects items, List pageIndices) throws SDKException {
        LOG.assertTrue(items != null, "Items must be present");
        int count = items.size();
        LOG.assertTrue(count > 0, "Items must be present");
        LOG.assertTrue(this.m_itemsPerPage != 0, "m_itemsPerPage cannot be zero");
        int numPages = count / 2;
        if (this.m_itemsPerPage == 1) {
            numPages = count;
        } else if (count % 2 > 0) {
            ++numPages;
        }
        LOG.assertTrue(numPages != 0, "Results must have at least one page");
        for (int i = 0; i < numPages; ++i) {
            IInfoObject startItem = this.m_itemsPerPage != 1 ? (IInfoObject)items.get(2 * i) : (IInfoObject)items.get(i);
            int startID = startItem.getID();
            IInfoObject endItem = null;
            if (2 * i + 1 < count && this.m_itemsPerPage != 1) {
                endItem = (IInfoObject)items.get(2 * i + 1);
            }
            if (i == 0 && pageIndices.size() == 0) {
                PageIndex pindex = endItem != null ? new PageIndex(startID, endItem.getID()) : new PageIndex(startID);
                pageIndices.add(pindex);
                continue;
            }
            List filter = this.populatePageIndexFilter(startItem);
            int filterSize = filter.size();
            LOG.assertTrue(filterSize > 0, "Start page-index filter must have at least one value");
            String filterStartID = (String)filter.get(filterSize - 1);
            LOG.assertTrue(filterStartID.equals("" + startID), "Last value in start page index filter must be item ID");
            PageIndex pindex = endItem != null ? new PageIndex(startID, endItem.getID(), filter) : new PageIndex(startID, filter);
            pageIndices.add(pindex);
        }
    }

    public List populatePageIndexFilter(IInfoObject item) throws SDKException {
        LOG.assertTrue(item != null, "Items must be present");
        ArrayList<String> pageIndexFilter = new ArrayList<String>();
        List orderByInfos = this.getOrderByInfos();
        int size = orderByInfos.size();
        for (int i = 0; i < size; ++i) {
            SortByInfo pSortByInfo = (SortByInfo)orderByInfos.get(i);
            String propStr = "";
            propStr = pSortByInfo.isDate() ? this.getPropDate(item, pSortByInfo.getPropertyName()) : this.getPropStr(item, pSortByInfo.getPropertyName());
            pageIndexFilter.add(propStr);
        }
        return pageIndexFilter;
    }

    public String getImposePagingFilter(List pageIndexFilter, boolean lastInclusive) {
        SortByInfo pOrderByInfo;
        LOG.assertTrue(pageIndexFilter != null && pageIndexFilter.size() > 0, "Page index filter must be present");
        String currentWhereClause = this.getWhereClause();
        String newWhereClause = "";
        if (currentWhereClause.length() != 0) {
            newWhereClause = newWhereClause + currentWhereClause;
            newWhereClause = newWhereClause + "AND";
        }
        newWhereClause = newWhereClause + "(";
        String closingBrackets = ")";
        List orderByInfos = this.getOrderByInfos();
        int size = orderByInfos.size();
        LOG.assertTrue(size != 0, "Orderby info must be present");
        for (int i = 0; i < size - 1; ++i) {
            String filterValue;
            pOrderByInfo = (SortByInfo)orderByInfos.get(i);
            if (i > 0) {
                newWhereClause = newWhereClause + " AND (";
                closingBrackets = closingBrackets + ")";
            }
            if ((filterValue = (String)pageIndexFilter.get(i)).length() == 0) {
                filterValue = pOrderByInfo.isString() ? "" : "0";
            }
            String orderByValue = "'";
            orderByValue = orderByValue + this.valueEscape(filterValue);
            orderByValue = orderByValue + "'";
            newWhereClause = newWhereClause + pOrderByInfo.getPropertyName();
            newWhereClause = newWhereClause + pOrderByInfo.compOp();
            newWhereClause = newWhereClause + orderByValue;
            newWhereClause = newWhereClause + " OR (";
            closingBrackets = closingBrackets + ")";
            newWhereClause = newWhereClause + pOrderByInfo.getPropertyName();
            newWhereClause = newWhereClause + "=";
            newWhereClause = newWhereClause + orderByValue;
        }
        int idIndex = size - 1;
        pOrderByInfo = (SortByInfo)orderByInfos.get(idIndex);
        LOG.assertTrue(pOrderByInfo.getPropertyName().compareToIgnoreCase("SI_ID") == 0, "Last orderby info must be SI_ID");
        if (idIndex > 0) {
            newWhereClause = newWhereClause + " AND ";
        }
        newWhereClause = newWhereClause + pOrderByInfo.getPropertyName();
        newWhereClause = newWhereClause + pOrderByInfo.compOp();
        if (lastInclusive) {
            newWhereClause = newWhereClause + "=";
        }
        newWhereClause = newWhereClause + pageIndexFilter.get(idIndex);
        newWhereClause = newWhereClause + closingBrackets;
        return newWhereClause;
    }

    public IInternalInfoStore getInfoStore() {
        return this.m_infoStore;
    }

    public String getTables() {
        return this.m_tables;
    }

    public int getItemsPerPage() {
        return this.m_itemsPerPage;
    }

    public void setItemsPerPage(int lNum) throws SDKException {
        if (lNum <= 0) {
            throw new SDKException.InvalidArg();
        }
        this.m_itemsPerPage = lNum;
    }

    public int getPagesPerRange() {
        return this.m_pagesPerRange;
    }

    public void setPagesPerRange(int lNum) throws SDKException {
        if (lNum <= 0) {
            throw new SDKException.InvalidArg();
        }
        this.m_pagesPerRange = lNum;
    }

    public int getCurrPageNumber() throws SDKException {
        boolean ret = this.m_loadedPagingState.ensureCurrPage();
        if (!ret) {
            return -1;
        }
        return this.m_loadedPagingState.getCurrPageNumber();
    }

    public void setCurrPageNumber(int val) throws SDKException {
        if (val <= 0) {
            throw new SDKException.InvalidArg();
        }
        this.m_loadedPagingState.setCurrPageNumber(val);
    }

    public boolean hasPrevPage() throws SDKException {
        if (!this.m_loadedPagingState.ensureCurrPage()) {
            return false;
        }
        return this.m_loadedPagingState.hasPrevPage();
    }

    public boolean hasNextPage() throws SDKException {
        if (!this.m_loadedPagingState.ensureCurrPage()) {
            return false;
        }
        return this.m_loadedPagingState.hasNextPage();
    }

    public boolean hasPrevRange() throws SDKException {
        if (!this.m_loadedPagingState.ensureCurrRange()) {
            return false;
        }
        return this.m_loadedPagingState.hasPrevRange();
    }

    public boolean hasNextRange() throws SDKException {
        if (!this.m_loadedPagingState.ensureCurrRange()) {
            return false;
        }
        return this.m_loadedPagingState.hasNextRange();
    }

    public int getRangeFirstPageNumber() throws SDKException {
        if (!this.m_loadedPagingState.ensureCurrRange()) {
            return -1;
        }
        return this.m_loadedPagingState.getRangeFirstPageNumber();
    }

    public int getRangeLastPageNumber() throws SDKException {
        if (!this.m_loadedPagingState.ensureCurrRange()) {
            return -1;
        }
        return this.m_loadedPagingState.getRangeLastPageNumber();
    }

    public void moveToFirstPage() throws SDKException {
        if (!this.m_loadedPagingState.moveFirstPage()) {
            throw new SDKException.InvalidOperation();
        }
    }

    public void moveToLastPage() throws SDKException {
        if (!this.m_loadedPagingState.moveLastPage()) {
            throw new SDKException.InvalidOperation();
        }
    }

    public void moveToPreviousPage() throws SDKException {
        if (!this.m_loadedPagingState.movePreviousPage()) {
            throw new SDKException.InvalidOperation();
        }
    }

    public void moveToNextPage() throws SDKException {
        if (!this.m_loadedPagingState.moveNextPage()) {
            throw new SDKException.InvalidOperation();
        }
    }

    public void moveToPreviousRange() throws SDKException {
        if (!this.m_loadedPagingState.movePreviousRange()) {
            throw new SDKException.InvalidOperation();
        }
    }

    public void moveToNextRange() throws SDKException {
        if (!this.m_loadedPagingState.moveNextRange()) {
            throw new SDKException.InvalidOperation();
        }
    }

    IInfoObjects getPage(AbstractInfoObjects outObjs) throws SDKException {
        LOG.assertTrue(this.m_loadedPagingState == null, "Pagging state must exist.");
        int retries = 0;
        boolean emptyPage = false;
        while (true) {
            QuerySettings querySettings;
            if (emptyPage || !this.m_loadedPagingState.ensureCurrPage()) {
                outObjs.initialize(((InternalInfoStore)this.m_infoStore).getSecuritySession(), this.m_infoStore);
                return outObjs;
            }
            String whereClause = new String();
            PageIndex currPageIndex = this.m_loadedPagingState.getCurrPageIndex();
            whereClause = this.m_loadedPagingState.getCurrPageNumber() > 1 ? this.getImposePagingFilter(currPageIndex.getQueryFilter(), true) : this.getWhereClause();
            String orderClause = this.getOrderByClause();
            int numToRetrieve = this.m_itemsPerPage;
            if (!this.m_loadedPagingState.hasNextPage()) {
                ++numToRetrieve;
            }
            if ((querySettings = new QuerySettings(this.m_infoStore, this.m_tables, this.m_fields, whereClause, orderClause, numToRetrieve)) == null) {
                throw new SDKException.Unexpected();
            }
            IInfoObjects results = querySettings.executeQuery(outObjs);
            if (currPageIndex.isValid(results, this.m_itemsPerPage)) {
                return results;
            }
            if (retries >= 2) break;
            ++retries;
            int currPageNumber = this.m_loadedPagingState.getCurrPageNumber();
            this.m_loadedPagingState.reset();
            this.m_loadedPagingState.setCurrPageNumber(currPageNumber);
            if (results.size() != 0) continue;
            emptyPage = true;
        }
        LOG.error((Object)"Could not reload valid page indices after 2");
        throw new SDKException.InvalidPagingIndex();
    }

    private List getOrderByInfos() {
        ArrayList<SortByInfo> sortByInfos = new ArrayList<SortByInfo>();
        if (this.m_sortBy != null) {
            this.getSortByInfos(this.m_sortBy, sortByInfos);
        }
        SortByInfo sortByInfo = new SortByInfo("SI_ID", true);
        sortByInfos.add(sortByInfo);
        return sortByInfos;
    }

    private boolean getSortByInfos(SortType sortType, List sortByInfos) {
        if (sortByInfos == null) {
            return false;
        }
        Iterator iter = sortType.iterator();
        while (iter.hasNext()) {
            SortDimension tempDimension = (SortDimension)iter.next();
            int prop = tempDimension.getPropertyId();
            int direction = tempDimension.getDirection();
            SortByInfo item = new SortByInfo(CePropertyID.idToName(new Integer(prop)), direction == 0);
            sortByInfos.add(item);
        }
        return true;
    }

    private String valueEscape(String valueStr) {
        StringCharacterIterator iter = new StringCharacterIterator(valueStr);
        String newstr = "";
        char ch = iter.first();
        while (ch != '\uffff') {
            newstr = ch == '\'' ? newstr + "''" : newstr + ch;
            ch = iter.next();
        }
        return newstr;
    }

    private String getPropDate(IInfoObject item, String propertyName) {
        LOG.assertTrue(item != null, "item should be present.");
        IProperties props = item.properties();
        Date date = ((PropertyBag)props).getDate((Object)propertyName);
        return DateConversion.convertToQueryString((Date)date, null);
    }

    private String getPropStr(IInfoObject item, String propertyName) {
        LOG.assertTrue(item != null, "item should be present.");
        IProperties props = item.properties();
        IProperty prop = props.getProperty(propertyName);
        return prop.getValue().toString();
    }
}

