/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.filerepository.internal.BoundFile;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileRepository;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileRepositoryObject;
import com.crystaldecisions.sdk.occa.filerepository.internal.IFileTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.IPutFileTx;
import com.crystaldecisions.sdk.occa.filerepository.internal.IPutStreamTx;
import com.crystaldecisions.sdk.occa.infostore.IFiles;
import com.crystaldecisions.sdk.occa.infostore.IRemoteFile;
import com.crystaldecisions.sdk.occa.infostore.IStreamingDownloadFile;
import com.crystaldecisions.sdk.occa.infostore.IStreamingFile;
import com.crystaldecisions.sdk.occa.infostore.IStreamingUploadFile;
import com.crystaldecisions.sdk.occa.infostore.internal.FRSInputStream;
import com.crystaldecisions.sdk.occa.infostore.internal.IFileSizeListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalStreamingUploadFile;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecurityFiles;
import com.crystaldecisions.sdk.occa.infostore.internal.StreamingDownloadFile;
import com.crystaldecisions.sdk.occa.infostore.internal.StreamingFile;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;

class RemoteFile
implements IRemoteFile,
IStreamingUploadFile,
IInternalStreamingUploadFile,
Externalizable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.RemoteFile");
    private IFileTx m_fileTx;
    private String m_fileURL;
    private IFileRepository m_fileRepository;
    private IFileRepositoryObject m_fileObject;
    private long m_fileSize;
    private int m_index;
    private boolean m_bUploadContentDuringOverwrite;
    private IFileSizeListener m_sizeListener;
    private static final int MAXIMUM_CHUNK_SIZE = 65535;
    private IFiles m_container;
    private boolean m_shared;
    private ISecurityFiles m_securityFiles;

    public RemoteFile() {
    }

    RemoteFile(IFileRepository fileRepository, String fileURL, IFileSizeListener listener, ISecurityFiles support, long size, int index, boolean bUploadContentDuringOverwrite, IFiles container, boolean shared) {
        this.m_fileRepository = fileRepository;
        this.m_fileURL = fileURL;
        this.m_fileSize = size;
        this.m_sizeListener = listener;
        this.m_securityFiles = support;
        this.m_index = index;
        this.m_bUploadContentDuringOverwrite = bUploadContentDuringOverwrite;
        this.m_container = container;
        this.m_shared = shared;
    }

    void initFromSerialization(IFileSizeListener listener, IFiles container, ISecurityFiles securityFiles, IFileRepository fileRepository) {
        this.m_sizeListener = listener;
        this.m_container = container;
        this.m_fileRepository = fileRepository;
        this.m_securityFiles = securityFiles;
    }

    public boolean download(String localFile) throws SDKException {
        this.m_securityFiles.checkDownloadRight();
        if (this.m_fileTx == null) {
            this.getFileObject(false);
            this.m_fileTx = this.m_fileObject.download(localFile);
            return true;
        }
        return false;
    }

    public boolean download(byte[] stream) throws SDKException {
        this.m_securityFiles.checkDownloadRight();
        if (this.m_fileTx == null) {
            this.getFileObject(false);
            this.m_fileTx = this.m_fileObject.download(stream);
            return true;
        }
        return false;
    }

    public boolean download(OutputStream stream) throws SDKException {
        this.m_securityFiles.checkDownloadRight();
        if (this.m_fileTx == null) {
            this.getFileObject(false);
            this.m_fileTx = this.m_fileObject.download(stream);
            return true;
        }
        return false;
    }

    public boolean overwrite(String localFile) throws SDKException {
        if (this.m_shared) {
            this.m_container.replace(this.m_index, localFile);
            this.m_shared = false;
            return true;
        }
        return this.overwriteHelper(localFile);
    }

    protected boolean overwriteHelper(String localFile) throws SDKException {
        this.m_securityFiles.checkRight(6);
        if (this.m_fileTx == null) {
            if (this.m_bUploadContentDuringOverwrite) {
                this.getFileObject(true);
                this.m_fileTx = this.m_fileObject.overwrite(localFile);
                if (this.m_fileTx instanceof IPutFileTx) {
                    ((IPutFileTx)this.m_fileTx).uploadContent();
                }
            } else {
                this.m_fileTx = new OverwriteProxyTx(localFile);
            }
            File file = new File(localFile);
            this.m_fileSize = file.length();
            this.updateSize();
            return true;
        }
        return false;
    }

    public boolean overwrite(byte[] stream) throws SDKException {
        if (this.m_shared) {
            String filename = this.m_fileURL.substring(this.m_fileURL.lastIndexOf("/") + 1, this.m_fileURL.length());
            this.m_container.replace(this.m_index, stream, null, null, filename, null);
            this.m_shared = false;
            return true;
        }
        return this.overwriteHelper(stream);
    }

    protected boolean overwriteHelper(byte[] stream) throws SDKException {
        this.m_securityFiles.checkRight(6);
        if (this.m_fileTx == null) {
            this.getFileObject(true);
            this.m_fileTx = this.m_fileObject.overwrite(stream);
            if (this.m_bUploadContentDuringOverwrite && this.m_fileTx instanceof IPutFileTx) {
                ((IPutFileTx)this.m_fileTx).uploadContent();
            }
            this.m_fileSize = stream.length;
            this.updateSize();
            return true;
        }
        return false;
    }

    public boolean append(String localFile) throws SDKException {
        this.m_securityFiles.checkRight(6);
        if (this.m_fileTx == null) {
            if (this.m_shared) {
                this.m_container.append(this.m_index, localFile, false);
                this.m_shared = false;
            } else {
                this.getFileObject(true);
                this.m_fileTx = this.m_fileObject.append(localFile);
                if (this.m_bUploadContentDuringOverwrite && this.m_fileTx instanceof IPutFileTx) {
                    ((IPutFileTx)this.m_fileTx).uploadContent();
                }
                File file = new File(localFile);
                this.m_fileSize += file.length();
                this.updateSize();
            }
            return true;
        }
        return false;
    }

    public boolean append(byte[] stream) throws SDKException {
        this.m_securityFiles.checkRight(6);
        if (this.m_fileTx == null) {
            if (this.m_shared) {
                this.m_container.append(this.m_index, stream);
                this.m_shared = false;
            } else {
                this.getFileObject(true);
                this.m_fileTx = this.m_fileObject.append(stream);
                if (this.m_bUploadContentDuringOverwrite && this.m_fileTx instanceof IPutFileTx) {
                    ((IPutFileTx)this.m_fileTx).uploadContent();
                }
                this.m_fileSize += (long)stream.length;
                this.updateSize();
            }
            return true;
        }
        return false;
    }

    public String getURL() {
        return this.m_fileURL;
    }

    public String getFilePath() throws SDKException {
        this.getFileObject(false);
        return this.m_fileObject.getRemoteFilePath();
    }

    public long getSize() throws SDKException {
        if (this.m_fileSize == 0L) {
            this.getFileObject(false);
            this.m_fileSize = this.m_fileObject.getSize();
        }
        return this.m_fileSize;
    }

    public String getRootPath() throws SDKException {
        this.getFileObject(false);
        return this.m_fileObject.getRootPath();
    }

    public String getLocalFilePath() throws SDKException {
        this.getFileObject(false);
        return this.m_fileObject.getLocalFilePath();
    }

    public String getName() {
        int delim = this.m_fileURL.lastIndexOf("/");
        if (delim == -1) {
            return this.m_fileURL;
        }
        return this.m_fileURL.substring(delim + 1);
    }

    public void commit() throws SDKException {
        if (this.m_fileTx != null) {
            this.m_fileTx.commit();
            this.m_fileTx = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        if (this.m_fileTx != null) {
            try {
                this.m_fileTx.destroy();
            }
            catch (SDKException sDKException) {
            }
            finally {
                this.m_fileTx = null;
            }
        }
    }

    public IStreamingFile getStreamingFile() throws SDKException {
        this.m_securityFiles.checkDownloadRight();
        this.getFileObject(false);
        return new StreamingFile(this.m_fileObject);
    }

    public IStreamingDownloadFile getStreamingDownloadFile(int chunkSize) throws SDKException {
        this.m_securityFiles.checkDownloadRight();
        if (chunkSize < 0) {
            throw new SDKException.OutOfRange(chunkSize, 0, 65535);
        }
        if (chunkSize > 65535) {
            chunkSize = 65535;
        }
        this.getFileObject(false);
        return new StreamingDownloadFile(this.m_fileObject, chunkSize);
    }

    public IStreamingUploadFile getStreamingUploadFile() throws SDKException {
        return this.getStreamingUploadFile(0L);
    }

    public IStreamingUploadFile getStreamingUploadFile(long size) throws SDKException {
        if (size < 0L) {
            throw new SDKException.InvalidArg();
        }
        this.m_securityFiles.checkRight(6);
        if (this.m_fileTx == null) {
            this.getFileObject(true);
            this.m_fileTx = this.m_fileObject.overwrite(size);
            this.m_fileSize = 0L;
        } else if (!(this.m_fileTx instanceof IPutStreamTx)) {
            throw new SDKException.InvalidOperation();
        }
        return this;
    }

    public InputStream getInputStream() throws SDKException {
        IStreamingDownloadFile streamingDownloadFile = this.getStreamingDownloadFile(0);
        streamingDownloadFile.openFile();
        return new FRSInputStream(streamingDownloadFile);
    }

    private void getFileObject(boolean isWritable) throws SDKException {
        if (isWritable) {
            if (this.m_fileObject == null || !this.m_fileObject.isWritable()) {
                this.m_fileObject = this.m_fileRepository.checkout(this.m_fileURL);
            }
        } else if (this.m_fileObject == null) {
            this.m_fileObject = this.m_fileRepository.get(this.m_fileURL);
        }
    }

    protected int updateSize() {
        this.m_index = this.m_sizeListener.updateSize(this.m_index, this, this.m_fileSize);
        return this.m_index;
    }

    public boolean putContent(byte[] stream) throws SDKException {
        if (stream == null) {
            return true;
        }
        return this.putContent(stream, 0, stream.length);
    }

    public boolean putContent(byte[] stream, int offset, int length) throws SDKException {
        if (stream == null) {
            return true;
        }
        if (!(this.m_fileTx instanceof IPutStreamTx)) {
            return false;
        }
        ((IPutStreamTx)this.m_fileTx).putContent(stream, offset, length);
        this.m_fileSize += (long)length;
        this.updateSize();
        return true;
    }

    public long putContent(InputStream stream) throws SDKException {
        if (stream == null) {
            return 0L;
        }
        if (!(this.m_fileTx instanceof IPutStreamTx)) {
            throw new SDKException.InvalidOperation();
        }
        long size = ((IPutStreamTx)this.m_fileTx).putContent(stream);
        this.m_fileSize += size;
        this.updateSize();
        return size;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.m_fileTx instanceof IPutFileTx || this.m_fileTx instanceof IPutStreamTx || this.m_fileTx instanceof OverwriteProxyTx) {
            out.writeBoolean(true);
            out.writeObject(this.m_fileTx);
        } else {
            out.writeBoolean(false);
        }
        out.writeObject(this.m_fileURL);
        out.writeLong(this.m_fileSize);
        out.writeInt(this.m_index);
        out.writeBoolean(this.m_bUploadContentDuringOverwrite);
        out.writeBoolean(this.m_shared);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean hasFileTx = in.readBoolean();
        if (hasFileTx) {
            this.m_fileTx = (IFileTx)in.readObject();
        }
        this.m_fileURL = (String)in.readObject();
        this.m_fileSize = in.readLong();
        this.m_index = in.readInt();
        this.m_bUploadContentDuringOverwrite = in.readBoolean();
        this.m_shared = in.readBoolean();
    }

    public String serialize() {
        if (this.m_fileTx != null && this.m_fileTx instanceof IPutStreamTx) {
            return ((IPutStreamTx)this.m_fileTx).serialize();
        }
        return null;
    }

    private class OverwriteProxyTx
    implements IFileTx,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final String m_destPath;
        private final BoundFile m_localFile;
        private transient IFileTx m_target;
        private boolean m_done;

        public OverwriteProxyTx(String localFile) throws SDKException {
            this.m_localFile = new BoundFile(localFile);
            RemoteFile.this.getFileObject(true);
            this.m_destPath = RemoteFile.this.m_fileObject.getURL();
        }

        public Object commit() throws SDKException {
            if (!this.m_done) {
                this.getTarget().commit();
            }
            return this.m_destPath;
        }

        public void destroy() throws SDKException {
            if (!this.m_done) {
                this.getTarget().destroy();
                this.m_done = true;
            }
        }

        public Object getDestination() {
            return this.m_destPath;
        }

        public Object getSource() {
            return this.m_localFile;
        }

        private IFileTx getTarget() throws SDKException {
            if (this.m_target == null) {
                RemoteFile.this.getFileObject(true);
                this.m_target = RemoteFile.this.m_fileObject.overwrite(this.m_localFile.getFile().getPath());
            }
            return this.m_target;
        }
    }
}

